/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.MapFileConfiguration;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.AudiosFeed;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.DVDISOFile;
import net.pms.dlna.DVDISOTitle;
import net.pms.dlna.ImagesFeed;
import net.pms.dlna.MapFile;
import net.pms.dlna.RealFile;
import net.pms.dlna.VideosFeed;
import net.pms.dlna.WebAudioStream;
import net.pms.dlna.WebVideoStream;
import net.pms.dlna.virtual.MediaLibrary;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.dlna.virtual.VirtualVideoAction;
import net.pms.external.AdditionalFolderAtRoot;
import net.pms.external.AdditionalFoldersAtRoot;
import net.pms.external.ExternalFactory;
import net.pms.external.ExternalListener;
import net.pms.newgui.IFrame;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class RootFolder
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(RootFolder.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private boolean running;

    public RootFolder() {
        this.setIndexId(0);
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void discoverChildren() {
        DLNAResource videoSettingsFolder;
        MediaLibrary libraryRes;
        DLNAResource iTunesRes;
        DLNAResource apertureRes;
        DLNAResource iPhotoRes;
        if (this.isDiscovered()) {
            return;
        }
        for (DLNAResource dLNAResource : this.getConfiguredFolders()) {
            this.addChild(dLNAResource);
        }
        for (DLNAResource dLNAResource : this.getVirtualFolders()) {
            this.addChild(dLNAResource);
        }
        String webConfPath = configuration.getWebConfPath();
        File file = new File(webConfPath);
        if (file.exists()) {
            this.addWebFolder(file);
        }
        if (Platform.isMac() && configuration.isShowIphotoLibrary() && (iPhotoRes = this.getiPhotoFolder()) != null) {
            this.addChild(iPhotoRes);
        }
        if (Platform.isMac() && configuration.isShowApertureLibrary() && (apertureRes = this.getApertureFolder()) != null) {
            this.addChild(apertureRes);
        }
        if ((Platform.isMac() || Platform.isWindows()) && configuration.isShowItunesLibrary() && (iTunesRes = this.getiTunesFolder()) != null) {
            this.addChild(iTunesRes);
        }
        if (!configuration.isHideMediaLibraryFolder() && (libraryRes = PMS.get().getLibrary()) != null) {
            this.addChild(libraryRes);
        }
        for (DLNAResource r : this.getAdditionalFoldersAtRoot()) {
            this.addChild(r);
        }
        if (!configuration.getHideVideoSettings() && (videoSettingsFolder = this.getVideoSettingsFolder()) != null) {
            this.addChild(videoSettingsFolder);
        }
        this.setDiscovered(true);
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public void scan() {
        this.setRunning(true);
        if (!this.isDiscovered()) {
            this.discoverChildren();
        }
        this.setDefaultRenderer(RendererConfiguration.getDefaultConf());
        this.scan(this);
        IFrame frame = PMS.get().getFrame();
        frame.setScanLibraryEnabled(true);
        PMS.get().getDatabase().cleanup();
        frame.setStatusLine(null);
    }

    @Deprecated
    public void stopscan() {
        this.stopScan();
    }

    public void stopScan() {
        this.setRunning(false);
    }

    private synchronized void scan(DLNAResource resource) {
        if (this.isRunning()) {
            for (DLNAResource child : resource.getChildren()) {
                if (!this.isRunning() || !child.allowScan()) continue;
                child.setDefaultRenderer(resource.getDefaultRenderer());
                String trace = null;
                if (child instanceof RealFile) {
                    trace = Messages.getString("DLNAMediaDatabase.4") + " " + child.getName();
                }
                if (trace != null) {
                    logger.debug(trace);
                    PMS.get().getFrame().setStatusLine(trace);
                }
                if (child.isDiscovered()) {
                    child.refreshChildren();
                } else {
                    if (child instanceof DVDISOFile || child instanceof DVDISOTitle) {
                        child.resolve();
                    }
                    child.discoverChildren();
                    child.analyzeChildren(-1);
                    child.setDiscovered(true);
                }
                int count = child.getChildren().size();
                if (count == 0) continue;
                this.scan(child);
                child.getChildren().clear();
            }
        }
    }

    private List<RealFile> getConfiguredFolders() {
        ArrayList<RealFile> res = new ArrayList<RealFile>();
        File[] files = PMS.get().getFoldersConf();
        if (files == null || files.length == 0) {
            files = File.listRoots();
        }
        for (File f : files) {
            res.add(new RealFile(f));
        }
        return res;
    }

    private List<DLNAResource> getVirtualFolders() {
        ArrayList<DLNAResource> res = new ArrayList<DLNAResource>();
        List<MapFileConfiguration> mapFileConfs = MapFileConfiguration.parse(configuration.getVirtualFolders());
        if (mapFileConfs != null) {
            for (MapFileConfiguration f : mapFileConfs) {
                res.add(new MapFile(f));
            }
        }
        return res;
    }

    private void addWebFolder(File webConf) {
        if (webConf.exists()) {
            try {
                String line;
                LineNumberReader br = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(webConf), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.indexOf("=") <= -1) continue;
                    String key = line.substring(0, line.indexOf("="));
                    String value = line.substring(line.indexOf("=") + 1);
                    String[] keys = this.parseFeedKey(key);
                    try {
                        if (!keys[0].equals("imagefeed") && !keys[0].equals("audiofeed") && !keys[0].equals("videofeed") && !keys[0].equals("audiostream") && !keys[0].equals("videostream")) continue;
                        String[] values = this.parseFeedValue(value);
                        DLNAResource parent = null;
                        if (keys[1] != null) {
                            StringTokenizer st = new StringTokenizer(keys[1], ",");
                            RootFolder currentRoot = this;
                            while (st.hasMoreTokens()) {
                                String folder = st.nextToken();
                                parent = currentRoot.searchByName(folder);
                                if (parent == null) {
                                    parent = new VirtualFolder(folder, "");
                                    currentRoot.addChild(parent);
                                }
                                currentRoot = parent;
                            }
                        }
                        if (parent == null) {
                            parent = this;
                        }
                        if (keys[0].equals("imagefeed")) {
                            parent.addChild(new ImagesFeed(values[0]));
                            continue;
                        }
                        if (keys[0].equals("videofeed")) {
                            parent.addChild(new VideosFeed(values[0]));
                            continue;
                        }
                        if (keys[0].equals("audiofeed")) {
                            parent.addChild(new AudiosFeed(values[0]));
                            continue;
                        }
                        if (keys[0].equals("audiostream")) {
                            parent.addChild(new WebAudioStream(values[0], values[1], values[2]));
                            continue;
                        }
                        if (!keys[0].equals("videostream")) continue;
                        parent.addChild(new WebVideoStream(values[0], values[1], values[2]));
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.info("Error at line " + br.getLineNumber() + " of WEB.conf: " + e.getMessage());
                        logger.debug(null, e);
                    }
                }
                br.close();
            }
            catch (IOException e) {
                logger.info("Unexpected error in WEB.conf" + e.getMessage());
                logger.debug(null, e);
            }
        }
    }

    private String[] parseFeedKey(String spec) {
        String[] pair = StringUtils.split(spec, ".", 2);
        if (pair == null || pair.length < 2) {
            pair = new String[2];
        }
        if (pair[0] == null) {
            pair[0] = "";
        }
        return pair;
    }

    private String[] parseFeedValue(String spec) {
        StringTokenizer st = new StringTokenizer(spec, ",");
        String[] triple = new String[3];
        int i = 0;
        while (st.hasMoreTokens()) {
            triple[i++] = st.nextToken();
        }
        return triple;
    }

    /*
     * Exception decompiling
     */
    private DLNAResource getiPhotoFolder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DLNAResource getApertureFolder() {
        VirtualFolder res = null;
        if (Platform.isMac()) {
            Process process = null;
            try {
                String line;
                process = Runtime.getRuntime().exec("defaults read com.apple.iApps ApertureLibraries");
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                res = new VirtualFolder("Aperture libraries", null);
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("(") || line.startsWith(")")) continue;
                    line = line.trim();
                    VirtualFolder apertureLibrary = this.createApertureDlnaLibrary(line = line.substring(1, line.lastIndexOf("\"")));
                    if (apertureLibrary == null) continue;
                    res.addChild(apertureLibrary);
                }
                in.close();
            }
            catch (Exception e) {
                logger.error("Something went wrong with the aperture library scan: ", e);
            }
            finally {
                if (process != null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        logger.warn("Interrupted while waiting for stream for process" + e.getMessage());
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (Exception e) {
                        logger.warn("Could not close stream for output process", e);
                    }
                    try {
                        process.getInputStream().close();
                    }
                    catch (Exception e) {
                        logger.warn("Could not close stream for output process", e);
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (Exception e) {
                        logger.warn("Could not close stream for output process", e);
                    }
                }
            }
        }
        return res;
    }

    private VirtualFolder createApertureDlnaLibrary(String url) throws UnsupportedEncodingException, MalformedURLException, XmlParseException, IOException, URISyntaxException {
        VirtualFolder res = null;
        if (url != null) {
            String mediaName;
            URI tURI = new URI(url);
            Map<String, Object> iPhotoLib = Plist.load(URLDecoder.decode(tURI.toURL().getFile(), System.getProperty("file.encoding")));
            Map photoList = (Map)iPhotoLib.get("Master Image List");
            Object mediaPath = iPhotoLib.get("Archive Path");
            mediaName = mediaPath != null ? ((mediaName = mediaPath.toString()) != null && mediaName.lastIndexOf("/") != -1 && mediaName.lastIndexOf(".aplibrary") != -1 ? mediaName.substring(mediaName.lastIndexOf("/"), mediaName.lastIndexOf(".aplibrary")) : "unknown library") : "unknown library";
            logger.info("Going to parse aperture library: " + mediaName);
            res = new VirtualFolder(mediaName, null);
            List listOfAlbums = (List)iPhotoLib.get("List of Albums");
            for (Object item : listOfAlbums) {
                Map album = (Map)item;
                if (album.get("Parent") != null) continue;
                VirtualFolder vAlbum = this.createApertureAlbum(photoList, album, listOfAlbums);
                res.addChild(vAlbum);
            }
        } else {
            logger.info("No Aperture library found.");
        }
        return res;
    }

    private VirtualFolder createApertureAlbum(Map<?, ?> photoList, Map<?, ?> album, List<?> listOfAlbums) {
        int albumId = (Integer)album.get("AlbumId");
        VirtualFolder vAlbum = new VirtualFolder(album.get("AlbumName").toString(), null);
        for (Object item : listOfAlbums) {
            int parent;
            Map sub = (Map)item;
            if (sub.get("Parent") == null || (parent = ((Integer)sub.get("Parent")).intValue()) != albumId) continue;
            VirtualFolder subAlbum = this.createApertureAlbum(photoList, sub, listOfAlbums);
            vAlbum.addChild(subAlbum);
        }
        List albumPhotos = (List)album.get("KeyList");
        if (albumPhotos == null) {
            return vAlbum;
        }
        boolean firstPhoto = true;
        for (Object photoKey : albumPhotos) {
            Map photo = (Map)photoList.get(photoKey);
            if (firstPhoto) {
                Object x = photoList.get("ThumbPath");
                if (x != null) {
                    vAlbum.setThumbnail(x.toString());
                }
                firstPhoto = false;
            }
            RealFile file = new RealFile(new File(photo.get("ImagePath").toString()));
            vAlbum.addChild(file);
        }
        return vAlbum;
    }

    private String getiTunesFile() throws Exception {
        String iTunesFile = null;
        if (Platform.isMac()) {
            Process process = Runtime.getRuntime().exec("defaults read com.apple.iApps iTunesRecentDatabases");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = in.readLine();
            if (line != null && (line = in.readLine()) != null) {
                line = line.trim();
                line = line.substring(1, line.length() - 1);
                URI tURI = new URI(line);
                iTunesFile = URLDecoder.decode(tURI.toURL().getFile(), "UTF8");
            }
            if (in != null) {
                in.close();
            }
        } else if (Platform.isWindows()) {
            String line;
            Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v \"My Music\"");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String location = null;
            while ((line = in.readLine()) != null) {
                String LOOK_FOR = "REG_SZ";
                if (!line.contains("REG_SZ")) continue;
                location = line.substring(line.indexOf("REG_SZ") + "REG_SZ".length()).trim();
            }
            if (in != null) {
                in.close();
            }
            if (location != null) {
                iTunesFile = location = location + "\\iTunes\\iTunes Music Library.xml";
            } else {
                logger.info("Could not find the My Music folder");
            }
        }
        return iTunesFile;
    }

    private static boolean areNamesEqual(String aThis, String aThat) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(0);
        int comparison = collator.compare(aThis, aThat);
        return comparison == 0;
    }

    private DLNAResource getiTunesFolder() {
        VirtualFolder res = null;
        logger.info("Start building iTunes folder...");
        if (Platform.isMac() || Platform.isWindows()) {
            try {
                String iTunesFile = this.getiTunesFile();
                if (iTunesFile != null && new File(iTunesFile).exists()) {
                    Map<String, Object> iTunesLib = Plist.load(URLDecoder.decode(iTunesFile, System.getProperty("file.encoding")));
                    Map Tracks = (Map)iTunesLib.get("Tracks");
                    List Playlists = (List)iTunesLib.get("Playlists");
                    res = new VirtualFolder("iTunes Library", null);
                    DLNAResource playlistsFolder = null;
                    for (Object item : Playlists) {
                        int kind;
                        Map track;
                        List PlaylistTracks;
                        Map Playlist = (Map)item;
                        if (Playlist.containsKey("Visible") && Playlist.get("Visible").equals(Boolean.FALSE)) continue;
                        if (Playlist.containsKey("Music") && Playlist.get("Music").equals(Boolean.TRUE)) {
                            VirtualFolder musicFolder = new VirtualFolder(Playlist.get("Name").toString(), null);
                            res.addChild(musicFolder);
                            VirtualFolder virtualFolderArtists = new VirtualFolder(Messages.getString("PMS.13"), null);
                            VirtualFolder virtualFolderAlbums = new VirtualFolder(Messages.getString("PMS.16"), null);
                            VirtualFolder virtualFolderGenres = new VirtualFolder(Messages.getString("PMS.19"), null);
                            VirtualFolder virtualFolderAllTracks = new VirtualFolder(Messages.getString("PMS.11"), null);
                            PlaylistTracks = (List)Playlist.get("Playlist Items");
                            if (PlaylistTracks != null) {
                                for (Object t : PlaylistTracks) {
                                    boolean isCompilation;
                                    Map td = (Map)t;
                                    track = (Map)Tracks.get(td.get("Track ID").toString());
                                    if (track == null || track.get("Location") == null || !track.get("Location").toString().startsWith("file://")) continue;
                                    String name = Normalizer.normalize((String)track.get("Name"), Normalizer.Form.NFC);
                                    name = name.replace('.', '-');
                                    if (track.containsKey("Protected") && track.get("Protected").equals(Boolean.TRUE)) {
                                        name = String.format(Messages.getString("RootFolder.1"), name);
                                    }
                                    boolean bl = isCompilation = track.containsKey("Compilation") && track.get("Compilation").equals(Boolean.TRUE);
                                    String artistName = isCompilation ? "Compilation" : (track.containsKey("Album Artist") ? track.get("Album Artist") : track.get("Artist"));
                                    String albumName = (String)track.get("Album");
                                    String genreName = (String)track.get("Genre");
                                    artistName = artistName == null ? "Unknown Artist" : Normalizer.normalize(artistName, Normalizer.Form.NFC);
                                    albumName = albumName == null ? "Unknown Album" : Normalizer.normalize(albumName, Normalizer.Form.NFC);
                                    genreName = genreName == null ? "Unknown Genre" : ("".equals(genreName.replaceAll("[^a-zA-Z]", "")) ? "Unknown Genre" : Normalizer.normalize(genreName, Normalizer.Form.NFC));
                                    artistName = artistName.replace('\u0160', ' ').trim();
                                    albumName = albumName.replace('\u0160', ' ').trim();
                                    genreName = genreName.replace('\u0160', ' ').trim();
                                    URI tURI2 = new URI(track.get("Location").toString());
                                    File refFile = new File(URLDecoder.decode(tURI2.toURL().getFile(), "UTF-8"));
                                    RealFile file = new RealFile(refFile, name);
                                    DLNAResource individualArtistFolder = null;
                                    VirtualFolder individualArtistAllTracksFolder = null;
                                    DLNAResource individualArtistAlbumFolder = null;
                                    for (DLNAResource artist : virtualFolderArtists.getChildren()) {
                                        if (!RootFolder.areNamesEqual(artist.getName(), artistName)) continue;
                                        individualArtistFolder = (VirtualFolder)artist;
                                        for (DLNAResource album : individualArtistFolder.getChildren()) {
                                            if (!RootFolder.areNamesEqual(album.getName(), albumName)) continue;
                                            individualArtistAlbumFolder = (VirtualFolder)album;
                                        }
                                    }
                                    if (individualArtistFolder == null) {
                                        individualArtistFolder = new VirtualFolder(artistName, null);
                                        virtualFolderArtists.addChild(individualArtistFolder);
                                        individualArtistAllTracksFolder = new VirtualFolder(Messages.getString("PMS.11"), null);
                                        individualArtistFolder.addChild(individualArtistAllTracksFolder);
                                    } else {
                                        individualArtistAllTracksFolder = (VirtualFolder)individualArtistFolder.getChildren().get(0);
                                    }
                                    if (individualArtistAlbumFolder == null) {
                                        individualArtistAlbumFolder = new VirtualFolder(albumName, null);
                                        individualArtistFolder.addChild(individualArtistAlbumFolder);
                                    }
                                    individualArtistAlbumFolder.addChild(file.clone());
                                    individualArtistAllTracksFolder.addChild(file);
                                    if (!isCompilation) {
                                        albumName = albumName + " \u2013 " + artistName;
                                    }
                                    DLNAResource individualAlbumFolder = null;
                                    for (DLNAResource album : virtualFolderAlbums.getChildren()) {
                                        if (!RootFolder.areNamesEqual(album.getName(), albumName)) continue;
                                        individualAlbumFolder = (VirtualFolder)album;
                                        break;
                                    }
                                    if (individualAlbumFolder == null) {
                                        individualAlbumFolder = new VirtualFolder(albumName, null);
                                        virtualFolderAlbums.addChild(individualAlbumFolder);
                                    }
                                    individualAlbumFolder.addChild(file.clone());
                                    DLNAResource individualGenreFolder = null;
                                    for (DLNAResource genre : virtualFolderGenres.getChildren()) {
                                        if (!RootFolder.areNamesEqual(genre.getName(), genreName)) continue;
                                        individualGenreFolder = (VirtualFolder)genre;
                                        break;
                                    }
                                    if (individualGenreFolder == null) {
                                        individualGenreFolder = new VirtualFolder(genreName, null);
                                        virtualFolderGenres.addChild(individualGenreFolder);
                                    }
                                    individualGenreFolder.addChild(file.clone());
                                    virtualFolderAllTracks.addChild(file.clone());
                                }
                            }
                            musicFolder.addChild(virtualFolderArtists);
                            musicFolder.addChild(virtualFolderAlbums);
                            musicFolder.addChild(virtualFolderGenres);
                            musicFolder.addChild(virtualFolderAllTracks);
                            Collections.sort(virtualFolderArtists.getChildren(), new Comparator<DLNAResource>(){

                                @Override
                                public int compare(DLNAResource o1, DLNAResource o2) {
                                    VirtualFolder a = (VirtualFolder)o1;
                                    VirtualFolder b = (VirtualFolder)o2;
                                    return a.getName().compareToIgnoreCase(b.getName());
                                }
                            });
                            Collections.sort(virtualFolderAlbums.getChildren(), new Comparator<DLNAResource>(){

                                @Override
                                public int compare(DLNAResource o1, DLNAResource o2) {
                                    VirtualFolder a = (VirtualFolder)o1;
                                    VirtualFolder b = (VirtualFolder)o2;
                                    return a.getName().compareToIgnoreCase(b.getName());
                                }
                            });
                            Collections.sort(virtualFolderGenres.getChildren(), new Comparator<DLNAResource>(){

                                @Override
                                public int compare(DLNAResource o1, DLNAResource o2) {
                                    VirtualFolder a = (VirtualFolder)o1;
                                    VirtualFolder b = (VirtualFolder)o2;
                                    return a.getName().compareToIgnoreCase(b.getName());
                                }
                            });
                            continue;
                        }
                        VirtualFolder pf = new VirtualFolder(Playlist.get("Name").toString(), null);
                        PlaylistTracks = (List)Playlist.get("Playlist Items");
                        if (PlaylistTracks != null) {
                            for (Object t : PlaylistTracks) {
                                Map td = (Map)t;
                                track = (Map)Tracks.get(td.get("Track ID").toString());
                                if (track == null || track.get("Location") == null || !track.get("Location").toString().startsWith("file://")) continue;
                                String name = Normalizer.normalize(track.get("Name").toString(), Normalizer.Form.NFC);
                                name = name.replace('.', '-');
                                if (track.containsKey("Protected") && track.get("Protected").equals(Boolean.TRUE)) {
                                    name = String.format(Messages.getString("RootFolder.1"), name);
                                }
                                URI tURI2 = new URI(track.get("Location").toString());
                                RealFile file = new RealFile(new File(URLDecoder.decode(tURI2.toURL().getFile(), "UTF-8")), name);
                                pf.addChild(file);
                            }
                        }
                        int n = kind = Playlist.containsKey("Distinguished Kind") ? ((Number)Playlist.get("Distinguished Kind")).intValue() : -1;
                        if (kind >= 0 && kind != 17 && kind != 19 && kind != 20) {
                            res.addChild(pf);
                            continue;
                        }
                        if (playlistsFolder == null) {
                            playlistsFolder = new VirtualFolder("Playlists", null);
                            res.addChild(playlistsFolder);
                        }
                        playlistsFolder.addChild(pf);
                    }
                } else {
                    logger.info("Could not find the iTunes file");
                }
            }
            catch (Exception e) {
                logger.error("Something went wrong with the iTunes Library scan: ", e);
            }
        }
        logger.info("Done building iTunes folder.");
        return res;
    }

    private DLNAResource getVideoSettingsFolder() {
        VirtualFolder res = null;
        if (!configuration.getHideVideoSettings()) {
            res = new VirtualFolder(Messages.getString("PMS.37"), null);
            VirtualFolder vfSub = new VirtualFolder(Messages.getString("PMS.8"), null);
            res.addChild(vfSub);
            res.addChild(new VirtualVideoAction(Messages.getString("PMS.3"), configuration.isMencoderNoOutOfSync()){

                @Override
                public boolean enable() {
                    configuration.setMencoderNoOutOfSync(!configuration.isMencoderNoOutOfSync());
                    return configuration.isMencoderNoOutOfSync();
                }
            });
            res.addChild(new VirtualVideoAction("  !!-- Fix 23.976/25fps A/V Mismatch --!!", configuration.isFix25FPSAvMismatch()){

                @Override
                public boolean enable() {
                    configuration.setMencoderForceFps(!configuration.isFix25FPSAvMismatch());
                    configuration.setFix25FPSAvMismatch(!configuration.isFix25FPSAvMismatch());
                    return configuration.isFix25FPSAvMismatch();
                }
            });
            res.addChild(new VirtualVideoAction(Messages.getString("PMS.4"), configuration.isMencoderYadif()){

                @Override
                public boolean enable() {
                    configuration.setMencoderYadif(!configuration.isMencoderYadif());
                    return configuration.isMencoderYadif();
                }
            });
            vfSub.addChild(new VirtualVideoAction(Messages.getString("TrTab2.51"), configuration.isDisableSubtitles()){

                @Override
                public boolean enable() {
                    boolean oldValue = configuration.isDisableSubtitles();
                    boolean newValue = !oldValue;
                    configuration.setDisableSubtitles(newValue);
                    return newValue;
                }
            });
            vfSub.addChild(new VirtualVideoAction(Messages.getString("PMS.6"), configuration.isAutoloadExternalSubtitles()){

                @Override
                public boolean enable() {
                    boolean oldValue = configuration.isAutoloadExternalSubtitles();
                    boolean newValue = !oldValue;
                    configuration.setAutoloadExternalSubtitles(newValue);
                    return newValue;
                }
            });
            vfSub.addChild(new VirtualVideoAction(Messages.getString("MEncoderVideo.36"), configuration.isMencoderAssDefaultStyle()){

                @Override
                public boolean enable() {
                    boolean oldValue = configuration.isMencoderAssDefaultStyle();
                    boolean newValue = !oldValue;
                    configuration.setMencoderAssDefaultStyle(newValue);
                    return newValue;
                }
            });
            res.addChild(new VirtualVideoAction(Messages.getString("PMS.7"), configuration.getSkipLoopFilterEnabled()){

                @Override
                public boolean enable() {
                    configuration.setSkipLoopFilterEnabled(!configuration.getSkipLoopFilterEnabled());
                    return configuration.getSkipLoopFilterEnabled();
                }
            });
            res.addChild(new VirtualVideoAction(Messages.getString("TrTab2.28"), configuration.isAudioEmbedDtsInPcm()){

                @Override
                public boolean enable() {
                    configuration.setAudioEmbedDtsInPcm(!configuration.isAudioEmbedDtsInPcm());
                    return configuration.isAudioEmbedDtsInPcm();
                }
            });
            res.addChild(new VirtualVideoAction(Messages.getString("PMS.27"), true){

                @Override
                public boolean enable() {
                    try {
                        configuration.save();
                    }
                    catch (ConfigurationException e) {
                        logger.debug("Caught exception", e);
                    }
                    return true;
                }
            });
            res.addChild(new VirtualVideoAction(Messages.getString("LooksFrame.12"), true){

                @Override
                public boolean enable() {
                    PMS.get().reset();
                    return true;
                }
            });
        }
        return res;
    }

    private List<DLNAResource> getAdditionalFoldersAtRoot() {
        ArrayList<DLNAResource> res = new ArrayList<DLNAResource>();
        for (ExternalListener listener : ExternalFactory.getExternalListeners()) {
            if (listener instanceof AdditionalFolderAtRoot) {
                AdditionalFolderAtRoot afar = (AdditionalFolderAtRoot)listener;
                try {
                    res.add(afar.getChild());
                }
                catch (Throwable t) {
                    logger.error(String.format("Failed to append AdditionalFolderAtRoot with name=%s, class=%s", afar.name(), afar.getClass()), t);
                }
                continue;
            }
            if (!(listener instanceof AdditionalFoldersAtRoot)) continue;
            Iterator<DLNAResource> folders = ((AdditionalFoldersAtRoot)listener).getChildren();
            while (folders.hasNext()) {
                DLNAResource resource = folders.next();
                try {
                    res.add(resource);
                }
                catch (Throwable t) {
                    logger.error(String.format("Failed to append AdditionalFolderAtRoots with class=%s for DLNAResource=%s", listener.getClass(), resource.getClass()), t);
                }
            }
        }
        return res;
    }

    @Override
    public String toString() {
        return "RootFolder[" + this.getChildren() + "]";
    }
}

