/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.RarredEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarredFile
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(RarredFile.class);
    private File f;
    private Archive rarFile;

    public RarredFile(File f) {
        this.f = f;
        this.setLastModified(f.lastModified());
        try {
            this.rarFile = new Archive(f);
            List<FileHeader> headers = this.rarFile.getFileHeaders();
            for (FileHeader fh : headers) {
                this.addChild(new RarredEntry(fh.getFileNameString(), f, fh.getFileNameString(), fh.getFullUnpackSize()));
            }
            this.rarFile.close();
        }
        catch (RarException e) {
            logger.error(null, e);
        }
        catch (IOException e) {
            logger.error(null, e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.f);
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public long length() {
        return this.f.length();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.f.getAbsolutePath();
    }

    @Override
    public boolean isValid() {
        boolean t = false;
        try {
            t = this.f.exists() && !this.rarFile.isEncrypted();
        }
        catch (Throwable th) {
            logger.debug("Caught exception", th);
        }
        return t;
    }
}

