/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

public abstract class Range
implements Cloneable {
    public abstract void limit(Range var1);

    public abstract boolean isByteRange();

    public boolean isTimeRange() {
        return !this.isByteRange();
    }

    public abstract boolean isStartOffsetAvailable();

    public abstract boolean isEndLimitAvailable();

    public double getDuration() {
        return 0.0;
    }

    public Byte asByteRange() {
        throw new RuntimeException("Unable to convert to ByteRange:" + this);
    }

    public Time createTimeRange() {
        return new Time(null, null);
    }

    public static Range create(long lowRange, long highRange, Double timeseek, Double timeRangeEnd) {
        if (lowRange > 0L || highRange > 0L) {
            return new Byte(lowRange, highRange);
        }
        return new Time(timeseek, timeRangeEnd);
    }

    public static class Byte
    extends Range
    implements Cloneable {
        private Long start;
        private Long end;

        public Byte() {
        }

        public Byte(Long start, Long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void limit(Range range) {
            this.limitTime((Byte)range);
        }

        @Override
        public boolean isByteRange() {
            return true;
        }

        public Long getStart() {
            return this.start;
        }

        public Byte setStart(Long start) {
            this.start = start;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Byte setEnd(Long end) {
            this.end = end;
            return this;
        }

        private void limitTime(Byte range) {
            if (range.start != null) {
                if (this.start != null) {
                    this.start = Math.max(this.start, range.start);
                }
                if (this.end != null) {
                    this.end = Math.max(this.end, range.start);
                }
            }
            if (range.end != null) {
                if (this.start != null) {
                    this.start = Math.min(this.start, range.end);
                }
                if (this.end != null) {
                    this.end = Math.min(this.end, range.end);
                }
            }
        }

        public String toString() {
            return "ByteRange [start=" + this.start + ", end=" + this.end + "]";
        }

        @Override
        public boolean isStartOffsetAvailable() {
            return this.start != null;
        }

        @Override
        public boolean isEndLimitAvailable() {
            return this.end != null;
        }

        @Override
        public Byte asByteRange() {
            return this;
        }
    }

    public static class Time
    extends Range
    implements Cloneable {
        private Double start;
        private Double end;

        public Time() {
        }

        public Time(Double start, Double end) {
            this.start = start;
            this.end = end;
        }

        public Double getStart() {
            return this.start;
        }

        public double getStartOrZero() {
            return this.start != null ? this.start : 0.0;
        }

        public Time setStart(Double start) {
            this.start = start;
            return this;
        }

        public void rewindStart(double amount) {
            if (this.start != null) {
                this.start = this.start > amount ? Double.valueOf(this.start - amount) : Double.valueOf(0.0);
            }
        }

        public Double getEnd() {
            return this.end;
        }

        public double getEndOrZero() {
            return this.end != null ? this.end : 0.0;
        }

        public Time setEnd(Double end) {
            this.end = end;
            return this;
        }

        @Override
        public void limit(Range range) {
            this.limitTime((Time)range);
        }

        @Override
        public boolean isByteRange() {
            return false;
        }

        private void limitTime(Time range) {
            if (range.start != null) {
                if (this.start != null) {
                    this.start = Math.max(this.start, range.start);
                }
                if (this.end != null) {
                    this.end = Math.max(this.end, range.start);
                }
            }
            if (range.end != null) {
                if (this.start != null) {
                    this.start = Math.min(this.start, range.end);
                }
                if (this.end != null) {
                    this.end = Math.min(this.end, range.end);
                }
            }
        }

        public String toString() {
            return "TimeRange [start=" + this.start + ", end=" + this.end + "]";
        }

        @Override
        public boolean isStartOffsetAvailable() {
            return this.start != null;
        }

        @Override
        public boolean isEndLimitAvailable() {
            return this.end != null;
        }

        @Override
        public double getDuration() {
            return this.start != null ? this.end - this.start : (this.end != null ? this.end : 0.0);
        }

        @Override
        public Time createTimeRange() {
            return new Time(this.start, this.end);
        }

        public Byte createScaledRange(long scale) {
            return new Byte(this.start != null ? Long.valueOf((long)((double)scale * this.start)) : null, this.end != null ? Long.valueOf((long)((double)scale * this.end)) : null);
        }
    }
}

