/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;

public class FeedItem
extends DLNAResource {
    private String title;
    private String itemURL;
    private String thumbURL;
    private long length;

    @Override
    protected String getThumbnailURL() {
        if (this.thumbURL == null) {
            return null;
        }
        return super.getThumbnailURL();
    }

    @Override
    public String getThumbnailContentType() {
        if (this.thumbURL != null && this.thumbURL.toLowerCase().endsWith(".jpg")) {
            return "image/jpeg";
        }
        return super.getThumbnailContentType();
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        return FeedItem.downloadAndSend(this.thumbURL, true);
    }

    public FeedItem(String title, String itemURL, String thumbURL, DLNAMediaInfo media, int type) {
        super(type);
        this.title = title;
        this.itemURL = itemURL;
        this.thumbURL = thumbURL;
        this.setMedia(media);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream i = FeedItem.downloadAndSend(this.itemURL, true);
        if (i != null) {
            this.length = i.available();
        }
        return i;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public void discoverChildren() {
    }

    @Override
    public String getSystemName() {
        return this.itemURL;
    }

    public void parse(String content) {
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        return this.getFormat() != null;
    }
}

