/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.jna.Platform;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.InputFile;
import net.pms.formats.AudioAsVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.network.HTTPResource;
import net.pms.util.CoverUtil;
import net.pms.util.FileUtil;
import net.pms.util.MpegUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAMediaInfo
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DLNAMediaInfo.class);
    private static final String THUMBNAIL_DIRECTORY_NAME = "thumbs";
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    public static final long ENDFILE_POS = 99999475712L;
    public static final long TRANS_SIZE = 0x7FFFFFFF7FFFFFFFL;
    private Double durationSec;
    private static final Map<String, Integer> audioChannelLayout = new HashMap<String, Integer>();
    @Deprecated
    public int bitrate;
    @Deprecated
    public int width;
    @Deprecated
    public int height;
    @Deprecated
    public long size;
    @Deprecated
    public String codecV;
    @Deprecated
    public String frameRate;
    private String frameRateMode;
    @Deprecated
    public String aspect;
    public String aspectRatioContainer;
    public String aspectRatioVideoTrack;
    @Deprecated
    public byte[] thumb;
    @Deprecated
    public String mimeType;
    @Deprecated
    public int bitsPerPixel;
    private byte referenceFrameCount = (byte)-1;
    private String avcLevel = null;
    private List<DLNAMediaAudio> audioTracks = new ArrayList<DLNAMediaAudio>();
    private List<DLNAMediaSubtitle> subtitleTracks = new ArrayList<DLNAMediaSubtitle>();
    @Deprecated
    public String model;
    @Deprecated
    public int exposure;
    @Deprecated
    public int orientation;
    @Deprecated
    public int iso;
    @Deprecated
    public String muxingMode;
    @Deprecated
    public String muxingModeAudio;
    @Deprecated
    public String container;
    @Deprecated
    public byte[] h264_annexB;
    @Deprecated
    public boolean mediaparsed;
    @Deprecated
    public boolean thumbready;
    @Deprecated
    public int dvdtrack;
    @Deprecated
    public boolean secondaryFormatValid = true;
    @Deprecated
    public boolean parsing = false;
    private boolean ffmpeg_failure;
    private boolean ffmpeg_annexb_failure;
    private Map<String, String> extras;
    @Deprecated
    public boolean encrypted;

    public boolean isMuxable(RendererConfiguration mediaRenderer) {
        String codecA;
        boolean muxable = false;
        if (this.getContainer() != null && (this.getContainer().equals("mkv") || this.getContainer().equals("mp4") || this.getContainer().equals("mov") || this.getContainer().equals("ts") || this.getContainer().equals("m2ts")) && this.getCodecV() != null && (this.getCodecV().equals("h264") || this.getCodecV().equals("vc1") || this.getCodecV().equals("mpeg2")) && this.getFirstAudioTrack() != null && (codecA = this.getFirstAudioTrack().getCodecA()) != null && (codecA.equals("aac") || codecA.equals("ac3") || codecA.equals("dca") || codecA.equals("dts") || codecA.equals("eac3"))) {
            muxable = true;
        }
        if (mediaRenderer.isBRAVIA() && this.getHeight() < 288) {
            muxable = false;
        }
        return muxable;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void putExtra(String key, String value) {
        if (this.extras == null) {
            this.extras = new HashMap<String, String>();
        }
        this.extras.put(key, value);
    }

    public String getExtrasAsString() {
        if (this.extras == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.extras.entrySet()) {
            sb.append(entry.getKey());
            sb.append("|");
            sb.append(entry.getValue());
            sb.append("|");
        }
        return sb.toString();
    }

    public void setExtrasAsString(String value) {
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, "|");
            while (st.hasMoreTokens()) {
                try {
                    this.putExtra(st.nextToken(), st.nextToken());
                }
                catch (NoSuchElementException nsee) {
                    logger.debug("Caught exception", nsee);
                }
            }
        }
    }

    public DLNAMediaInfo() {
        this.setThumbready(true);
    }

    public void generateThumbnail(InputFile input, Format ext, int type) {
        DLNAMediaInfo forThumbnail = new DLNAMediaInfo();
        forThumbnail.durationSec = this.durationSec;
        forThumbnail.parse(input, ext, type, true);
        this.setThumb(forThumbnail.getThumb());
    }

    private ProcessWrapperImpl getFFmpegThumbnail(InputFile media) {
        boolean dvrms;
        String[] args = new String[14];
        args[0] = this.getFfmpegPath();
        boolean bl = dvrms = media.getFile() != null && media.getFile().getAbsolutePath().toLowerCase().endsWith("dvr-ms");
        if (dvrms && StringUtils.isNotBlank(configuration.getFfmpegAlternativePath())) {
            args[0] = configuration.getFfmpegAlternativePath();
        }
        args[1] = "-ss";
        args[2] = "" + configuration.getThumbnailSeekPos();
        args[3] = "-i";
        args[4] = media.getFile() != null ? ProcessUtil.getShortFileNameIfWideChars(media.getFile().getAbsolutePath()) : "-";
        args[5] = "-an";
        args[6] = "-an";
        args[7] = "-s";
        args[8] = "320x180";
        args[9] = "-vframes";
        args[10] = "1";
        args[11] = "-f";
        args[12] = "image2";
        args[13] = "pipe:";
        if (!configuration.isThumbnailGenerationEnabled() || configuration.isUseMplayerForVideoThumbs() && !dvrms) {
            args[2] = "0";
            for (int i = 5; i <= 13; ++i) {
                args[i] = "-an";
            }
        }
        OutputParams params = new OutputParams(configuration);
        params.maxBufferSize = 1.0;
        params.stdin = media.getPush();
        params.noexitcheck = true;
        final ProcessWrapperImpl pw = new ProcessWrapperImpl(args, params, false, true);
        this.setParsing(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    DLNAMediaInfo.this.ffmpeg_failure = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pw.stopProcess();
                DLNAMediaInfo.this.setParsing(false);
            }
        };
        Thread failsafe = new Thread(r, "FFmpeg Thumbnail Failsafe");
        failsafe.start();
        pw.runInSameThread();
        this.setParsing(false);
        return pw;
    }

    private ProcessWrapperImpl getMplayerThumbnail(InputFile media) throws IOException {
        String[] args = new String[14];
        args[0] = configuration.getMplayerPath();
        args[1] = "-ss";
        boolean toolong = this.getDurationInSeconds() < (double)configuration.getThumbnailSeekPos();
        args[2] = "" + (toolong ? this.getDurationInSeconds() / 2.0 : (double)configuration.getThumbnailSeekPos());
        args[3] = "-quiet";
        args[4] = media.getFile() != null ? ProcessUtil.getShortFileNameIfWideChars(media.getFile().getAbsolutePath()) : "-";
        args[5] = "-msglevel";
        args[6] = "all=4";
        args[7] = "-vf";
        args[8] = "scale=320:-2,expand=:180";
        args[9] = "-frames";
        args[10] = "1";
        args[11] = "-vo";
        String frameName = "" + media.hashCode();
        frameName = "mplayer_thumbs:subdirs=\"" + frameName + "\"";
        frameName = frameName.replace(',', '_');
        args[12] = "jpeg:outdir=" + frameName;
        args[13] = "-nosound";
        OutputParams params = new OutputParams(configuration);
        params.workDir = configuration.getTempFolder();
        params.maxBufferSize = 1.0;
        params.stdin = media.getPush();
        params.log = true;
        params.noexitcheck = true;
        final ProcessWrapperImpl pw = new ProcessWrapperImpl(args, params);
        this.setParsing(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pw.stopProcess();
                DLNAMediaInfo.this.setParsing(false);
            }
        };
        Thread failsafe = new Thread(r, "MPlayer Thumbnail Failsafe");
        failsafe.start();
        pw.runInSameThread();
        this.setParsing(false);
        return pw;
    }

    private String getFfmpegPath() {
        String value = configuration.getFfmpegPath();
        if (value == null) {
            logger.info("No FFmpeg - unable to thumbnail");
            throw new RuntimeException("No FFmpeg - unable to thumbnail");
        }
        return value;
    }

    public void parse(InputFile inputFile, Format ext, int type, boolean thumbOnly) {
        int i = 0;
        while (this.isParsing()) {
            if (i == 5) {
                this.setMediaparsed(true);
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        if (this.isMediaparsed()) {
            return;
        }
        if (inputFile != null) {
            boolean ffmpeg_parsing;
            ProcessWrapperImpl pw;
            block126: {
                if (inputFile.getFile() != null) {
                    this.setSize(inputFile.getFile().length());
                } else {
                    this.setSize(inputFile.getSize());
                }
                pw = null;
                ffmpeg_parsing = true;
                if (type == 1 || ext instanceof AudioAsVideo) {
                    ffmpeg_parsing = false;
                    DLNAMediaAudio audio = new DLNAMediaAudio();
                    if (inputFile.getFile() != null) {
                        try {
                            Tag t;
                            AudioFile af = AudioFileIO.read(inputFile.getFile());
                            AudioHeader ah = af.getAudioHeader();
                            if (ah != null && !thumbOnly) {
                                int length = ah.getTrackLength();
                                int rate = ah.getSampleRateAsNumber();
                                if (ah.getEncodingType().toLowerCase().contains("flac 24")) {
                                    audio.setBitsperSample(24);
                                }
                                audio.setSampleFrequency("" + rate);
                                this.setDuration(Double.valueOf(length));
                                this.setBitrate((int)ah.getBitRateAsNumber());
                                audio.getAudioProperties().setNumberOfChannels(2);
                                if (ah.getChannels() != null && ah.getChannels().toLowerCase().contains("mono")) {
                                    audio.getAudioProperties().setNumberOfChannels(1);
                                } else if (ah.getChannels() != null && ah.getChannels().toLowerCase().contains("stereo")) {
                                    audio.getAudioProperties().setNumberOfChannels(2);
                                } else if (ah.getChannels() != null) {
                                    audio.getAudioProperties().setNumberOfChannels(Integer.parseInt(ah.getChannels()));
                                }
                                audio.setCodecA(ah.getEncodingType().toLowerCase());
                                if (audio.getCodecA().contains("(windows media")) {
                                    audio.setCodecA(audio.getCodecA().substring(0, audio.getCodecA().indexOf("(windows media")).trim());
                                }
                            }
                            if ((t = af.getTag()) != null) {
                                if (t.getArtworkList().size() > 0) {
                                    this.setThumb(t.getArtworkList().get(0).getBinaryData());
                                } else if (configuration.getAudioThumbnailMethod() > 0) {
                                    this.setThumb(CoverUtil.get().getThumbnailFromArtistAlbum(configuration.getAudioThumbnailMethod() == 1 ? 1 : 0, audio.getArtist(), audio.getAlbum()));
                                }
                                if (!thumbOnly) {
                                    audio.setAlbum(t.getFirst(FieldKey.ALBUM));
                                    audio.setArtist(t.getFirst(FieldKey.ARTIST));
                                    audio.setSongname(t.getFirst(FieldKey.TITLE));
                                    String y = t.getFirst(FieldKey.YEAR);
                                    try {
                                        if (y.length() > 4) {
                                            y = y.substring(0, 4);
                                        }
                                        audio.setYear(Integer.parseInt(y != null && y.length() > 0 ? y : "0"));
                                        y = t.getFirst(FieldKey.TRACK);
                                        audio.setTrack(Integer.parseInt(y != null && y.length() > 0 ? y : "1"));
                                        audio.setGenre(t.getFirst(FieldKey.GENRE));
                                    }
                                    catch (Throwable e) {
                                        logger.debug("Error parsing unimportant metadata: " + e.getMessage());
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            logger.debug("Error parsing audio file: {} - {}", (Object)e.getMessage(), (Object)(e.getCause() != null ? e.getCause().getMessage() : ""));
                            ffmpeg_parsing = false;
                        }
                        if (audio.getSongname() == null || audio.getSongname().length() == 0) {
                            audio.setSongname(inputFile.getFile().getName());
                        }
                        if (!ffmpeg_parsing) {
                            this.getAudioTracksList().add(audio);
                        }
                    }
                }
                if (type == 2 && inputFile.getFile() != null) {
                    try {
                        ffmpeg_parsing = false;
                        ImageInfo info = Sanselan.getImageInfo(inputFile.getFile());
                        this.setWidth(info.getWidth());
                        this.setHeight(info.getHeight());
                        this.setBitsPerPixel(info.getBitsPerPixel());
                        String formatName = info.getFormatName();
                        if (formatName.startsWith("JPEG")) {
                            this.setCodecV("jpg");
                            IImageMetadata meta = Sanselan.getMetadata(inputFile.getFile());
                            if (meta != null && meta instanceof JpegImageMetadata) {
                                JpegImageMetadata jpegmeta = (JpegImageMetadata)meta;
                                TiffField tf = jpegmeta.findEXIFValue(TiffConstants.EXIF_TAG_MODEL);
                                if (tf != null) {
                                    this.setModel(tf.getStringValue().trim());
                                }
                                if ((tf = jpegmeta.findEXIFValue(TiffConstants.EXIF_TAG_EXPOSURE_TIME)) != null) {
                                    this.setExposure((int)(1000.0 * tf.getDoubleValue()));
                                }
                                if ((tf = jpegmeta.findEXIFValue(TiffConstants.EXIF_TAG_ORIENTATION)) != null) {
                                    this.setOrientation(tf.getIntValue());
                                }
                                if ((tf = jpegmeta.findEXIFValue(TiffConstants.EXIF_TAG_ISO)) != null) {
                                    int[] isoValues = tf.getIntArrayValue();
                                    this.setIso(isoValues[0]);
                                }
                            }
                        } else if (formatName.startsWith("PNG")) {
                            this.setCodecV("png");
                        } else if (formatName.startsWith("GIF")) {
                            this.setCodecV("gif");
                        } else if (formatName.startsWith("TIF")) {
                            this.setCodecV("tiff");
                        }
                        this.setContainer(this.getCodecV());
                    }
                    catch (Throwable e) {
                        logger.info("Error parsing image ({}) with Sanselan, switching to FFmpeg.", (Object)inputFile.getFile().getAbsolutePath());
                    }
                }
                if (configuration.getImageThumbnailsEnabled() && type != 4 && type != 1) {
                    try {
                        File thumbDir = new File(configuration.getTempFolder(), THUMBNAIL_DIRECTORY_NAME);
                        logger.trace("Generating thumbnail for: {}", (Object)inputFile.getFile().getAbsolutePath());
                        if (!thumbDir.exists() && !thumbDir.mkdirs()) {
                            logger.warn("Could not create thumbnail directory: {}", (Object)thumbDir.getAbsolutePath());
                            break block126;
                        }
                        File thumbFile = new File(thumbDir, inputFile.getFile().getName() + ".jpg");
                        String thumbFilename = thumbFile.getAbsolutePath();
                        logger.trace("Creating (temporary) thumbnail: {}", (Object)thumbFilename);
                        Thumbnails.Builder<File> thumbnail = Thumbnails.of(inputFile.getFile());
                        thumbnail.size(320, 180);
                        thumbnail.outputFormat("jpg");
                        thumbnail.outputQuality(1.0f);
                        try {
                            thumbnail.toFile(thumbFilename);
                        }
                        catch (IIOException e) {
                            logger.debug("Error generating thumbnail for: " + inputFile.getFile().getName());
                            logger.debug("The full error was: " + e);
                        }
                        File jpg = new File(thumbFilename);
                        if (jpg.exists()) {
                            FileInputStream is = new FileInputStream(jpg);
                            int sz = ((InputStream)is).available();
                            if (sz > 0) {
                                this.setThumb(new byte[sz]);
                                ((InputStream)is).read(this.getThumb());
                            }
                            ((InputStream)is).close();
                            if (!jpg.delete()) {
                                jpg.deleteOnExit();
                            }
                        }
                    }
                    catch (UnsupportedFormatException ufe) {
                        logger.debug("Thumbnailator does not support the format of {}: {}", (Object)inputFile.getFile().getAbsolutePath(), (Object)ufe.getMessage());
                    }
                    catch (Exception e) {
                        logger.debug("Thumbnailator could not generate a thumbnail for: {}", (Object)inputFile.getFile().getAbsolutePath(), (Object)e);
                    }
                }
            }
            if (ffmpeg_parsing) {
                if (!thumbOnly || !configuration.isUseMplayerForVideoThumbs()) {
                    pw = this.getFFmpegThumbnail(inputFile);
                }
                String input = "-";
                boolean dvrms = false;
                if (inputFile.getFile() != null) {
                    input = ProcessUtil.getShortFileNameIfWideChars(inputFile.getFile().getAbsolutePath());
                    dvrms = inputFile.getFile().getAbsolutePath().toLowerCase().endsWith("dvr-ms");
                }
                if (!this.ffmpeg_failure && !thumbOnly) {
                    if (input.equals("-")) {
                        input = "pipe:";
                    }
                    boolean matchs = false;
                    ArrayList lines = (ArrayList)pw.getResults();
                    int langId = 0;
                    int subId = 0;
                    ListIterator FFmpegMetaData = lines.listIterator();
                    for (String line : lines) {
                        int b;
                        int a;
                        StringTokenizer st;
                        FFmpegMetaData.next();
                        line = line.trim();
                        if (line.startsWith("Output")) {
                            matchs = false;
                            continue;
                        }
                        if (line.startsWith("Input")) {
                            if (line.indexOf(input) > -1) {
                                matchs = true;
                                this.setContainer(line.substring(10, line.indexOf(",", 11)).trim());
                                continue;
                            }
                            matchs = false;
                            continue;
                        }
                        if (!matchs) continue;
                        if (line.indexOf("Duration") > -1) {
                            st = new StringTokenizer(line, ",");
                            while (st.hasMoreTokens()) {
                                String bitr;
                                int spacepos;
                                String token = st.nextToken().trim();
                                if (token.startsWith("Duration: ")) {
                                    String durationStr = token.substring(10);
                                    int l = durationStr.substring(durationStr.indexOf(".") + 1).length();
                                    if (l < 4) {
                                        durationStr = durationStr + "00".substring(0, 3 - l);
                                    }
                                    if (durationStr.indexOf("N/A") > -1) {
                                        this.setDuration(null);
                                        continue;
                                    }
                                    this.setDuration(DLNAMediaInfo.parseDurationString(durationStr));
                                    continue;
                                }
                                if (!token.startsWith("bitrate: ") || (spacepos = (bitr = token.substring(9)).indexOf(" ")) <= -1) continue;
                                String value = bitr.substring(0, spacepos);
                                String unit = bitr.substring(spacepos + 1);
                                this.setBitrate(Integer.parseInt(value));
                                if (unit.equals("kb/s")) {
                                    this.setBitrate(1024 * this.getBitrate());
                                }
                                if (!unit.equals("mb/s")) continue;
                                this.setBitrate(0x100000 * this.getBitrate());
                            }
                            continue;
                        }
                        if (line.indexOf("Audio:") > -1) {
                            st = new StringTokenizer(line, ",");
                            a = line.indexOf("(");
                            b = line.indexOf("):", a);
                            DLNAMediaAudio audio = new DLNAMediaAudio();
                            audio.setId(langId++);
                            if (a > -1 && b > a) {
                                audio.setLang(line.substring(a + 1, b));
                            } else {
                                audio.setLang("und");
                            }
                            a = line.indexOf("[0x");
                            b = line.indexOf("]", a);
                            if (a > -1 && b > a + 3) {
                                String idString = line.substring(a + 3, b);
                                try {
                                    audio.setId(Integer.parseInt(idString, 16));
                                }
                                catch (NumberFormatException nfe) {
                                    logger.debug("Error parsing Stream ID: " + idString);
                                }
                            }
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken().trim();
                                if (token.startsWith("Stream")) {
                                    audio.setCodecA(token.substring(token.indexOf("Audio: ") + 7));
                                    continue;
                                }
                                if (token.endsWith("Hz")) {
                                    audio.setSampleFrequency(token.substring(0, token.indexOf("Hz")).trim());
                                    continue;
                                }
                                Integer nChannels = audioChannelLayout.get(token);
                                if (nChannels != null) {
                                    audio.getAudioProperties().setNumberOfChannels(nChannels);
                                    continue;
                                }
                                if (token.matches("\\d+(?:\\s+channels?)")) {
                                    audio.getAudioProperties().setNumberOfChannels(token);
                                    continue;
                                }
                                if (token.equals("s32")) {
                                    audio.setBitsperSample(32);
                                    continue;
                                }
                                if (token.equals("s24")) {
                                    audio.setBitsperSample(24);
                                    continue;
                                }
                                if (!token.equals("s16")) continue;
                                audio.setBitsperSample(16);
                            }
                            int FFmpegMetaDataNr = FFmpegMetaData.nextIndex();
                            if (FFmpegMetaDataNr > -1) {
                                line = (String)lines.get(FFmpegMetaDataNr);
                            }
                            if (line.indexOf("Metadata:") > -1) {
                                line = (String)lines.get(++FFmpegMetaDataNr);
                                while (line.indexOf("      ") == 0) {
                                    if (line.toLowerCase().indexOf("title           :") > -1) {
                                        int aa = line.indexOf(": ");
                                        int bb = line.length();
                                        if (aa <= -1 || bb <= aa) continue;
                                        audio.setFlavor(line.substring(aa + 2, bb));
                                        break;
                                    }
                                    line = (String)lines.get(++FFmpegMetaDataNr);
                                }
                            }
                            this.getAudioTracksList().add(audio);
                            continue;
                        }
                        if (line.indexOf("Video:") > -1) {
                            st = new StringTokenizer(line, ",");
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken().trim();
                                if (token.startsWith("Stream")) {
                                    this.setCodecV(token.substring(token.indexOf("Video: ") + 7));
                                    continue;
                                }
                                if (token.indexOf("tbc") > -1 || token.indexOf("tb(c)") > -1) {
                                    String frameRateDoubleString = token.substring(0, token.indexOf("tb")).trim();
                                    try {
                                        if (frameRateDoubleString.equals(this.getFrameRate())) continue;
                                        Double frameRateDouble = Double.parseDouble(frameRateDoubleString);
                                        this.setFrameRate(String.format(Locale.ENGLISH, "%.2f", frameRateDouble / 2.0));
                                    }
                                    catch (NumberFormatException nfe) {
                                        logger.debug("Could not parse frame rate \"" + frameRateDoubleString + "\"");
                                    }
                                    continue;
                                }
                                if ((token.indexOf("tbr") > -1 || token.indexOf("tb(r)") > -1) && this.getFrameRate() == null) {
                                    this.setFrameRate(token.substring(0, token.indexOf("tb")).trim());
                                    continue;
                                }
                                if ((token.indexOf("fps") > -1 || token.indexOf("fps(r)") > -1) && this.getFrameRate() == null) {
                                    this.setFrameRate(token.substring(0, token.indexOf("fps")).trim());
                                    continue;
                                }
                                if (token.indexOf("x") <= -1) continue;
                                String resolution = token.trim();
                                if (resolution.indexOf(" [") > -1) {
                                    resolution = resolution.substring(0, resolution.indexOf(" ["));
                                }
                                try {
                                    this.setWidth(Integer.parseInt(resolution.substring(0, resolution.indexOf("x"))));
                                }
                                catch (NumberFormatException nfe) {
                                    logger.debug("Could not parse width from \"" + resolution.substring(0, resolution.indexOf("x")) + "\"");
                                }
                                try {
                                    this.setHeight(Integer.parseInt(resolution.substring(resolution.indexOf("x") + 1)));
                                }
                                catch (NumberFormatException nfe) {
                                    logger.debug("Could not parse height from \"" + resolution.substring(resolution.indexOf("x") + 1) + "\"");
                                }
                            }
                            continue;
                        }
                        if (line.indexOf("Subtitle:") <= -1 || line.contains("tx3g")) continue;
                        DLNAMediaSubtitle lang = new DLNAMediaSubtitle();
                        lang.setType(line.contains("dvdsub") && Platform.isWindows() ? SubtitleType.VOBSUB : SubtitleType.UNKNOWN);
                        a = line.indexOf("(");
                        b = line.indexOf("):", a);
                        if (a > -1 && b > a) {
                            lang.setLang(line.substring(a + 1, b));
                        } else {
                            lang.setLang("und");
                        }
                        lang.setId(subId++);
                        int FFmpegMetaDataNr = FFmpegMetaData.nextIndex();
                        if (FFmpegMetaDataNr > -1) {
                            line = (String)lines.get(FFmpegMetaDataNr);
                        }
                        if (line.indexOf("Metadata:") > -1) {
                            line = (String)lines.get(++FFmpegMetaDataNr);
                            while (line.indexOf("      ") == 0) {
                                if (line.toLowerCase().indexOf("title           :") > -1) {
                                    int aa = line.indexOf(": ");
                                    int bb = line.length();
                                    if (aa <= -1 || bb <= aa) continue;
                                    lang.setFlavor(line.substring(aa + 2, bb));
                                    break;
                                }
                                line = (String)lines.get(++FFmpegMetaDataNr);
                            }
                        }
                        this.getSubtitleTracksList().add(lang);
                    }
                }
                if (!thumbOnly && this.getContainer() != null && inputFile.getFile() != null && this.getContainer().equals("mpegts") && this.isH264() && this.getDurationInSeconds() == 0.0) {
                    try {
                        int length = MpegUtil.getDurationFromMpeg(inputFile.getFile());
                        if (length > 0) {
                            this.setDuration(Double.valueOf(length));
                        }
                    }
                    catch (IOException e) {
                        logger.trace("Error retrieving length: " + e.getMessage());
                    }
                }
                if (configuration.isUseMplayerForVideoThumbs() && type == 4 && !dvrms) {
                    try {
                        this.getMplayerThumbnail(inputFile);
                        String frameName = "" + inputFile.hashCode();
                        frameName = configuration.getTempFolder() + "/mplayer_thumbs/" + frameName + "00000001/00000001.jpg";
                        frameName = frameName.replace(',', '_');
                        File jpg = new File(frameName);
                        if (jpg.exists()) {
                            FileInputStream is = new FileInputStream(jpg);
                            int sz = ((InputStream)is).available();
                            if (sz > 0) {
                                this.setThumb(new byte[sz]);
                                ((InputStream)is).read(this.getThumb());
                            }
                            ((InputStream)is).close();
                            if (!jpg.delete()) {
                                jpg.deleteOnExit();
                            }
                            if (!jpg.getParentFile().delete() && !jpg.getParentFile().delete()) {
                                logger.debug("Failed to delete \"" + jpg.getParentFile().getAbsolutePath() + "\"");
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.debug("Caught exception", e);
                    }
                }
                if (type == 4 && pw != null && this.getThumb() == null) {
                    try {
                        BufferedImage image;
                        InputStream is = pw.getInputStream(0L);
                        int sz = is.available();
                        if (sz > 0) {
                            this.setThumb(new byte[sz]);
                            is.read(this.getThumb());
                        }
                        is.close();
                        if (sz > 0 && !PMS.isHeadless() && (image = ImageIO.read(new ByteArrayInputStream(this.getThumb()))) != null) {
                            Graphics g = image.getGraphics();
                            g.setColor(Color.WHITE);
                            g.setFont(new Font("Arial", 0, 14));
                            int low = 0;
                            if (this.getWidth() > 0) {
                                if (this.getWidth() == 1920 || this.getWidth() == 1440) {
                                    g.drawString("1080p", 0, low += 18);
                                } else if (this.getWidth() == 1280) {
                                    g.drawString("720p", 0, low += 18);
                                }
                            }
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)image, "jpeg", out);
                            this.setThumb(out.toByteArray());
                        }
                    }
                    catch (IOException e) {
                        logger.debug("Error while decoding thumbnail: " + e.getMessage());
                    }
                }
            }
            this.finalize(type, inputFile);
            this.setMediaparsed(true);
        }
    }

    public boolean isH264() {
        return this.getCodecV() != null && this.getCodecV().contains("264");
    }

    public int getFrameNumbers() {
        double fr = Double.parseDouble(this.getFrameRate());
        return (int)(this.getDurationInSeconds() * fr);
    }

    public void setDuration(Double d) {
        this.durationSec = d;
    }

    public Double getDuration() {
        return this.durationSec;
    }

    public double getDurationInSeconds() {
        return this.durationSec != null ? this.durationSec : 0.0;
    }

    public String getDurationString() {
        return this.durationSec != null ? DLNAMediaInfo.getDurationString(this.durationSec) : null;
    }

    public static String getDurationString(double d) {
        int s = (int)d % 60;
        int h = (int)(d / 3600.0);
        int m = (int)(d / 60.0) % 60;
        return String.format("%02d:%02d:%02d.00", h, m, s);
    }

    public static Double parseDurationString(String duration) {
        if (duration == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(duration, ":");
        try {
            int h = Integer.parseInt(st.nextToken());
            int m = Integer.parseInt(st.nextToken());
            double s = Double.parseDouble(st.nextToken());
            return (double)(h * 3600 + m * 60) + s;
        }
        catch (NumberFormatException nfe) {
            logger.debug("Failed to parse duration \"" + duration + "\"");
            return null;
        }
    }

    public void finalize(int type, InputFile f) {
        String codecA = null;
        if (this.getFirstAudioTrack() != null) {
            codecA = this.getFirstAudioTrack().getCodecA();
        }
        if (this.getContainer() != null && this.getContainer().equals("avi")) {
            this.setMimeType("video/avi");
        } else if (this.getContainer() != null && (this.getContainer().equals("asf") || this.getContainer().equals("wmv"))) {
            this.setMimeType("video/x-ms-wmv");
        } else if (this.getContainer() != null && (this.getContainer().equals("matroska") || this.getContainer().equals("mkv"))) {
            this.setMimeType("video/x-matroska");
        } else if (this.getCodecV() != null && this.getCodecV().equals("mjpeg")) {
            this.setMimeType("image/jpeg");
        } else if ("png".equals(this.getCodecV()) || "png".equals(this.getContainer())) {
            this.setMimeType("image/png");
        } else if ("gif".equals(this.getCodecV()) || "gif".equals(this.getContainer())) {
            this.setMimeType("image/gif");
        } else if (this.getCodecV() != null && (this.getCodecV().equals("h264") || this.getCodecV().equals("h263") || this.getCodecV().toLowerCase().equals("mpeg4") || this.getCodecV().toLowerCase().equals("mp4"))) {
            this.setMimeType("video/mp4");
        } else if (this.getCodecV() != null && (this.getCodecV().indexOf("mpeg") > -1 || this.getCodecV().indexOf("mpg") > -1)) {
            this.setMimeType("video/mpeg");
        } else if (this.getCodecV() == null && codecA != null && codecA.contains("mp3")) {
            this.setMimeType("audio/mpeg");
        } else if (this.getCodecV() == null && StringUtils.contains((CharSequence)codecA, "aac")) {
            this.setMimeType("audio/x-m4a");
        } else if (this.getCodecV() == null && StringUtils.contains((CharSequence)codecA, "flac")) {
            this.setMimeType("audio/x-flac");
        } else if (this.getCodecV() == null && StringUtils.contains((CharSequence)codecA, "vorbis")) {
            this.setMimeType("audio/x-ogg");
        } else if (this.getCodecV() == null && (StringUtils.contains((CharSequence)codecA, "asf") || StringUtils.startsWith(codecA, "wm"))) {
            this.setMimeType("audio/x-ms-wma");
        } else if (this.getCodecV() == null && (StringUtils.contains((CharSequence)codecA, "wav") || StringUtils.startsWith(codecA, "pcm"))) {
            this.setMimeType("audio/wav");
        } else {
            this.setMimeType(HTTPResource.getDefaultMimeType(type));
        }
        if (this.getFirstAudioTrack() == null || type != 1 || this.getFirstAudioTrack().getBitsperSample() != 24 || this.getFirstAudioTrack().getSampleRate() <= 48000) {
            this.setSecondaryFormatValid(false);
        }
        if (f.getFile() != null && type == 4 && configuration.isAutoloadExternalSubtitles()) {
            FileUtil.isSubtitlesExists(f.getFile(), this);
        }
    }

    public synchronized boolean isVideoWithinH264LevelLimits(InputFile f, RendererConfiguration mediaRenderer) {
        if ("h264".equals(this.getCodecV())) {
            if (this.getReferenceFrameCount() > -1) {
                logger.debug("H.264 file: {} level {} / ref frames {}", f.getFilename(), StringUtils.defaultString(this.getAvcLevel(), "N/A"), this.getReferenceFrameCount());
                byte[][] headers = this.getAnnexBFrameHeader(f);
                if (this.ffmpeg_annexb_failure) {
                    logger.info("Error parsing information from the file: " + f.getFilename());
                } else {
                    this.setH264AnnexB(headers[1]);
                }
                if (("4.1".equals(this.getAvcLevel()) || "4.2".equals(this.getAvcLevel()) || "5".equals(this.getAvcLevel()) || "5.0".equals(this.getAvcLevel()) || "5.1".equals(this.getAvcLevel()) || "5.2".equals(this.getAvcLevel())) && this.getWidth() > 0 && this.getHeight() > 0) {
                    int maxref = mediaRenderer == null || mediaRenderer.isPS3() ? (int)Math.floor(10252743 / (this.getWidth() * this.getHeight())) : (int)Math.floor(0x800000 / (this.getWidth() * this.getHeight()));
                    if (this.getReferenceFrameCount() > maxref) {
                        logger.info("H.264 file ({}) is not compatible with this renderer because it can only take {} reference frames at this resolution while this file has {} reference frames.", f.getFilename(), maxref, this.getReferenceFrameCount());
                        return false;
                    }
                }
                return true;
            }
            logger.warn("H.264 file ({}): Unparsed reference frame count. Remuxing may not work.", (Object)f.getFilename());
            return true;
        }
        logger.debug("Non-H.264 file ({}): Do not check ref limits.", (Object)f.getFilename());
        return true;
    }

    public boolean isMuxable(String filename, String codecA) {
        return codecA != null && (codecA.startsWith("dts") || codecA.equals("dca"));
    }

    public boolean isLossless(String codecA) {
        return codecA != null && (codecA.contains("pcm") || codecA.startsWith("dts") || codecA.equals("dca") || codecA.contains("flac")) && !codecA.contains("pcm_u8") && !codecA.contains("pcm_s8");
    }

    public String toString() {
        String s = "container: " + this.getContainer() + " / bitrate: " + this.getBitrate() + " / size: " + this.getSize() + " / codecV: " + this.getCodecV() + " / duration: " + this.getDurationString() + " / width: " + this.getWidth() + " / height: " + this.getHeight() + " / frameRate: " + this.getFrameRate() + " / thumb size : " + (this.getThumb() != null ? this.getThumb().length : 0) + " / muxingMode: " + this.getMuxingMode();
        for (DLNAMediaAudio audio : this.getAudioTracksList()) {
            s = s + "\n\taudio: id=" + audio.getId() + " / lang: " + audio.getLang() + " / flavor: " + audio.getFlavor() + " / codec: " + audio.getCodecA() + " / sf:" + audio.getSampleFrequency() + " / na: " + (audio.getAudioProperties() != null ? Integer.valueOf(audio.getAudioProperties().getNumberOfChannels()) : "-") + " / bs: " + audio.getBitsperSample();
            if (audio.getArtist() == null) continue;
            s = s + " / " + audio.getArtist() + "|" + audio.getAlbum() + "|" + audio.getSongname() + "|" + audio.getYear() + "|" + audio.getTrack();
        }
        for (DLNAMediaSubtitle sub : this.getSubtitleTracksList()) {
            s = s + "\n\tsub: id=" + sub.getId() + " / lang: " + sub.getLang() + " / flavor: " + sub.getFlavor() + " / type: " + (sub.getType() != null ? sub.getType().toString() : "null");
        }
        return s;
    }

    public InputStream getThumbnailInputStream() {
        return new ByteArrayInputStream(this.getThumb());
    }

    public String getValidFps(boolean ratios) {
        String validFrameRate = null;
        if (this.getFrameRate() != null && this.getFrameRate().length() > 0) {
            try {
                double fr = Double.parseDouble(this.getFrameRate().replace(',', '.'));
                if (fr >= 14.99 && fr < 15.1) {
                    validFrameRate = "15";
                } else if (fr > 23.9 && fr < 23.99) {
                    validFrameRate = ratios ? "24000/1001" : "23.976";
                } else if (fr > 23.99 && fr < 24.1) {
                    validFrameRate = "24";
                } else if (fr >= 24.99 && fr < 25.1) {
                    validFrameRate = "25";
                } else if (fr > 29.9 && fr < 29.99) {
                    validFrameRate = ratios ? "30000/1001" : "29.97";
                } else if (fr >= 29.99 && fr < 30.1) {
                    validFrameRate = "30";
                } else if (fr > 47.9 && fr < 47.99) {
                    validFrameRate = ratios ? "48000/1001" : "47.952";
                } else if (fr > 49.9 && fr < 50.1) {
                    validFrameRate = "50";
                } else if (fr > 59.8 && fr < 59.99) {
                    validFrameRate = ratios ? "60000/1001" : "59.94";
                } else if (fr >= 59.99 && fr < 60.1) {
                    validFrameRate = "60";
                }
            }
            catch (NumberFormatException nfe) {
                logger.error(null, nfe);
            }
        }
        return validFrameRate;
    }

    public DLNAMediaAudio getFirstAudioTrack() {
        if (this.getAudioTracksList().size() > 0) {
            return this.getAudioTracksList().get(0);
        }
        return null;
    }

    public String getValidAspect(boolean ratios) {
        String a = null;
        if (this.getAspect() != null) {
            double ar = Double.parseDouble(this.getAspect());
            if (ar > 1.7 && ar < 1.8) {
                String string = a = ratios ? "16/9" : "1.777777777777777";
            }
            if (ar > 1.3 && ar < 1.4) {
                a = ratios ? "4/3" : "1.333333333333333";
            }
        }
        return a;
    }

    public String getResolution() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            return this.getWidth() + "x" + this.getHeight();
        }
        return null;
    }

    public int getRealVideoBitrate() {
        if (this.getBitrate() > 0) {
            return this.getBitrate() / 8;
        }
        int realBitrate = 10000000;
        if (this.getDurationInSeconds() != 0.0) {
            realBitrate = (int)((double)this.getSize() / this.getDurationInSeconds());
        }
        return realBitrate;
    }

    public boolean isHDVideo() {
        return this.getWidth() > 1200 || this.getHeight() > 700;
    }

    public boolean isMpegTS() {
        return this.getContainer() != null && this.getContainer().equals("mpegts");
    }

    public byte[][] getAnnexBFrameHeader(InputFile f) {
        String[] cmdArray = new String[]{configuration.getFfmpegPath(), "-i", f.getPush() == null && f.getFilename() != null ? f.getFilename() : "-", "-vframes", "1", "-vcodec", "copy", "-f", "h264", "-vbsf", "h264_mp4toannexb", "-an", "-y", "pipe:"};
        byte[][] returnData = new byte[2][];
        OutputParams params = new OutputParams(configuration);
        params.maxBufferSize = 1.0;
        params.stdin = f.getPush();
        final ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    DLNAMediaInfo.this.ffmpeg_annexb_failure = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pw.stopProcess();
            }
        };
        Thread failsafe = new Thread(r, "FFmpeg AnnexB Frame Header Failsafe");
        failsafe.start();
        pw.runInSameThread();
        if (this.ffmpeg_annexb_failure) {
            return null;
        }
        ByteArrayOutputStream baot = new ByteArrayOutputStream();
        try {
            int n;
            InputStream is = pw.getInputStream(0L);
            byte[] b = new byte[4096];
            while ((n = is.read(b)) > 0) {
                baot.write(b, 0, n);
            }
            byte[] data = baot.toByteArray();
            baot.close();
            returnData[0] = data;
            is.close();
            int kf = 0;
            for (int i = 3; i < data.length; ++i) {
                if (data[i - 3] != 1 || (data[i - 2] & 0x25) != 37 || (data[i - 1] & 0xFFFFFF88) != -120) continue;
                kf = i - 2;
                break;
            }
            int st = 0;
            boolean found = false;
            if (kf > 0) {
                for (int i = kf; i >= 5; --i) {
                    if (data[i - 5] != 0 || data[i - 4] != 0 || data[i - 3] != 0 || (data[i - 2] & 1) != 1 || (data[i - 1] & 0x27) != 39) continue;
                    st = i - 5;
                    found = true;
                    break;
                }
            }
            if (found) {
                byte[] header = new byte[kf - st];
                System.arraycopy(data, st, header, 0, kf - st);
                returnData[1] = header;
            }
        }
        catch (IOException e) {
            logger.debug("Caught exception", e);
        }
        return returnData;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object cloned = super.clone();
        if (cloned instanceof DLNAMediaInfo) {
            DLNAMediaInfo mediaCloned = (DLNAMediaInfo)cloned;
            mediaCloned.setAudioTracksList(new ArrayList<DLNAMediaAudio>());
            for (DLNAMediaAudio audio : this.getAudioTracksList()) {
                mediaCloned.getAudioTracksList().add((DLNAMediaAudio)audio.clone());
            }
            mediaCloned.setSubtitleTracksList(new ArrayList<DLNAMediaSubtitle>());
            for (DLNAMediaSubtitle sub : this.getSubtitleTracksList()) {
                mediaCloned.getSubtitleTracksList().add((DLNAMediaSubtitle)sub.clone());
            }
        }
        return cloned;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getCodecV() {
        return this.codecV;
    }

    public void setCodecV(String codecV) {
        this.codecV = codecV;
    }

    public String getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(String frameRate) {
        this.frameRate = frameRate;
    }

    public String getFrameRateMode() {
        return this.frameRateMode;
    }

    public void setFrameRateMode(String frameRateMode) {
        this.frameRateMode = frameRateMode;
    }

    public String getAspect() {
        return this.aspect;
    }

    public void setAspect(String aspect) {
        this.aspect = aspect;
    }

    public String getAspectRatioContainer() {
        return this.aspectRatioContainer;
    }

    public void setAspectRatioContainer(String aspect) {
        this.aspectRatioContainer = aspect;
    }

    public String getAspectRatioVideoTrack() {
        return this.aspectRatioVideoTrack;
    }

    public void setAspectRatioVideoTrack(String aspect) {
        this.aspectRatioVideoTrack = aspect;
    }

    public boolean isAspectRatioMismatch() {
        return StringUtils.isNotBlank(this.getAspectRatioContainer()) && !StringUtils.equalsIgnoreCase(this.getAspectRatioContainer(), this.getAspectRatioVideoTrack());
    }

    public byte[] getThumb() {
        return this.thumb;
    }

    public void setThumb(byte[] thumb) {
        this.thumb = thumb;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
    }

    public synchronized byte getReferenceFrameCount() {
        return this.referenceFrameCount;
    }

    public synchronized void setReferenceFrameCount(byte referenceFrameCount) {
        if (referenceFrameCount < -1) {
            throw new IllegalArgumentException("referenceFrameCount should be >= -1.");
        }
        this.referenceFrameCount = referenceFrameCount;
    }

    public synchronized String getAvcLevel() {
        return this.avcLevel;
    }

    public synchronized void setAvcLevel(String avcLevel) {
        this.avcLevel = avcLevel;
    }

    public List<DLNAMediaAudio> getAudioTracksList() {
        return this.audioTracks;
    }

    @Deprecated
    public ArrayList<DLNAMediaAudio> getAudioCodes() {
        if (this.audioTracks instanceof ArrayList) {
            return (ArrayList)this.audioTracks;
        }
        return new ArrayList<DLNAMediaAudio>();
    }

    public void setAudioTracksList(List<DLNAMediaAudio> audioTracks) {
        this.audioTracks = audioTracks;
    }

    @Deprecated
    public void setAudioCodes(List<DLNAMediaAudio> audioTracks) {
        this.setAudioTracksList(audioTracks);
    }

    public List<DLNAMediaSubtitle> getSubtitleTracksList() {
        return this.subtitleTracks;
    }

    @Deprecated
    public ArrayList<DLNAMediaSubtitle> getSubtitlesCodes() {
        if (this.subtitleTracks instanceof ArrayList) {
            return (ArrayList)this.subtitleTracks;
        }
        return new ArrayList<DLNAMediaSubtitle>();
    }

    public void setSubtitleTracksList(List<DLNAMediaSubtitle> subtitleTracks) {
        this.subtitleTracks = subtitleTracks;
    }

    @Deprecated
    public void setSubtitlesCodes(List<DLNAMediaSubtitle> subtitleTracks) {
        this.setSubtitleTracksList(subtitleTracks);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getExposure() {
        return this.exposure;
    }

    public void setExposure(int exposure) {
        this.exposure = exposure;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getIso() {
        return this.iso;
    }

    public void setIso(int iso) {
        this.iso = iso;
    }

    public String getMuxingMode() {
        return this.muxingMode;
    }

    public void setMuxingMode(String muxingMode) {
        this.muxingMode = muxingMode;
    }

    public String getMuxingModeAudio() {
        return this.muxingModeAudio;
    }

    public void setMuxingModeAudio(String muxingModeAudio) {
        this.muxingModeAudio = muxingModeAudio;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public byte[] getH264AnnexB() {
        return this.h264_annexB;
    }

    public void setH264AnnexB(byte[] h264AnnexB) {
        this.h264_annexB = h264AnnexB;
    }

    public boolean isMediaparsed() {
        return this.mediaparsed;
    }

    public void setMediaparsed(boolean mediaparsed) {
        this.mediaparsed = mediaparsed;
    }

    public boolean isThumbready() {
        return this.thumbready;
    }

    public void setThumbready(boolean thumbready) {
        this.thumbready = thumbready;
    }

    public int getDvdtrack() {
        return this.dvdtrack;
    }

    public void setDvdtrack(int dvdtrack) {
        this.dvdtrack = dvdtrack;
    }

    public boolean isSecondaryFormatValid() {
        return this.secondaryFormatValid;
    }

    public void setSecondaryFormatValid(boolean secondaryFormatValid) {
        this.secondaryFormatValid = secondaryFormatValid;
    }

    public boolean isParsing() {
        return this.parsing;
    }

    public void setParsing(boolean parsing) {
        this.parsing = parsing;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    static {
        audioChannelLayout.put("mono", 1);
        audioChannelLayout.put("downmix", 2);
        audioChannelLayout.put("stereo", 2);
        audioChannelLayout.put("2.1", 3);
        audioChannelLayout.put("3.0", 3);
        audioChannelLayout.put("3.0(back)", 3);
        audioChannelLayout.put("4.0", 4);
        audioChannelLayout.put("quad", 4);
        audioChannelLayout.put("quad(side)", 4);
        audioChannelLayout.put("3.1", 4);
        audioChannelLayout.put("5.0", 5);
        audioChannelLayout.put("5.0(side)", 5);
        audioChannelLayout.put("4.1", 5);
        audioChannelLayout.put("5:1", 6);
        audioChannelLayout.put("5.1", 6);
        audioChannelLayout.put("5.1(side)", 6);
        audioChannelLayout.put("6.0", 6);
        audioChannelLayout.put("6.0(front)", 6);
        audioChannelLayout.put("hexagonal", 6);
        audioChannelLayout.put("6.1", 7);
        audioChannelLayout.put("6.1(front)", 7);
        audioChannelLayout.put("7.0", 7);
        audioChannelLayout.put("7.0(front)", 7);
        audioChannelLayout.put("7.1", 8);
        audioChannelLayout.put("7.1(wide)", 8);
        audioChannelLayout.put("octagonal", 8);
    }
}

