/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mediautil.gen.BasicIo;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.ProgressCallback;
import mediautil.gen.directio.IterativeReader;
import mediautil.gen.directio.IterativeWriter;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.BasicJpegIo;
import mediautil.image.jpeg.CIFF;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.Flashpix;
import mediautil.image.jpeg.IterativeReadVars;
import mediautil.image.jpeg.IterativeWriteVars;
import mediautil.image.jpeg.JFXX;
import mediautil.image.jpeg.JPEG;
import mediautil.image.jpeg.LLJTranException;
import mediautil.image.jpeg.TiffExif;

public class LLJTran
extends BasicJpegIo
implements IterativeReader,
IterativeWriter {
    public static final String JFIF = "JFIF";
    public static final String FPXR = "FPXR";
    public static final String JPEG = "JPEG";
    public static final int NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int TRANSPOSE = 3;
    public static final int TRANSVERSE = 4;
    public static final int ROT_90 = 5;
    public static final int ROT_180 = 6;
    public static final int ROT_270 = 7;
    public static final int CROP = 8;
    public static final int COMMENT = 9;
    protected static final int DCTSIZE2 = 64;
    protected static final int DCTSIZE = 8;
    protected static final int BYTE_SIZE = 8;
    private static final int HUFF_LOOKAHEAD = 8;
    public static final int READ_NONE = 0;
    public static final int READ_INFO = 1;
    public static final int READ_HEADER = 2;
    public static final int READ_ALL = 3;
    public static final int OPT_XFORM_APPX = 1;
    public static final int OPT_XFORM_THUMBNAIL = 2;
    public static final int OPT_XFORM_TRIM = 4;
    public static final int OPT_XFORM_ADJUST_EDGES = 8;
    public static final int OPT_XFORM_ORIENTATION = 16;
    public static final int OPT_WRITE_APPXS = 256;
    public static final int OPT_WRITE_COMMENTS = 512;
    public static final int OPT_WRITE_ALL = 768;
    public static final int OPT_WRITE_OPTIMIZE_HUFF = 1024;
    public static final int OPT_DEFAULTS = 777;
    public static final int REPLACE = 0;
    public static final int RETAIN = 1;
    public static final int REMOVE = 2;
    public static final int IMPERFECT_X = 1;
    public static final int IMPERFECT_Y = 2;
    protected static final int HEADER_SECTION = 2;
    protected static final int BODY_SECTION = 4;
    protected static final int INFO_SECTION = 1;
    protected static final int ALL_SECTIONS = 7;
    private static final int MAX_CLEN = 32;
    private static final int MAX_APPXS_BLOCKLEN = 1024;
    protected static final int[] jpegzigzagorder = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    protected static final int[] jpegnaturalorder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static final byte[] stdHuffTables = new byte[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    protected String artist;
    private String enc;
    private boolean partialYMCU;
    private boolean partialXMCU;
    private static final int APPXS_NONE = 0;
    private static final int APPXS_JFIF = 1;
    private static final int APPXS_JFXX = 2;
    private static final int APPXS_EXIF = 3;
    private static final int APPXS_CIFF = 4;
    private static final int APPXS_FPXR = 4;
    private int restarts_to_go;
    private HuffDecoder decoder;
    private HuffEncoder encoder;
    protected int writecounter;
    protected int readcounter;
    private boolean gatheringStats;
    private int[][] app_store;
    private int components_in_scan;
    private int components_in_frame;
    private int frm_precision;
    private int[] comp_ids;
    private int[] dc_table;
    private int[] ac_table;
    private int _Ss;
    private int _Se;
    private int _Ah;
    private int _Al;
    private int frm_x;
    private int frm_y;
    private int[] V;
    private int[] H;
    private int[] QT;
    private int[] ID;
    private int maxHi;
    private int maxVi;
    private int widthMCU;
    private int heightMCU;
    private int mcusize;
    protected int restart_interval;
    private int[][] dc_valoffset;
    private int[][] dc_maxcode;
    private int[][] dc_huffval;
    private int[] dc_ix;
    private int[][] ac_valoffset;
    private int[][] ac_maxcode;
    private int[][] ac_huffval;
    private int[][] dc_huffbits;
    private int[][] ac_huffbits;
    private int[] ac_ix;
    private int[][] q_table;
    private int[] q_ix;
    private int[] q_prec;
    private int[][][][][] dct_coefs;
    protected int[][] tmp_dct = new int[2][64];
    private Rectangle cropBounds = new Rectangle();
    private int[][][] enc_ac_matrix;
    private int[][][] enc_dc_matrix;
    private HuffGenerator huffGen;
    private ProgressCallback readProgressCallback;
    private ProgressCallback writeProgressCallback;
    protected int unprocessed_marker;
    private String unprocessedError;
    private boolean xferDone = false;
    protected boolean valid;
    protected boolean canBeProcessed;
    protected int readUpto;
    protected File file;
    protected InputStream inStream;
    protected InputStream currentStream;
    protected byte[] markerid;
    protected AbstractImageInfo imageinfo;
    protected byte[][] appxs;
    private int appHdrIndex = -1;
    protected String out_comment;
    protected boolean appxs_read;
    protected boolean retainDct;
    private byte prevHuffOption;
    private IterativeReadVars iReadVars;
    private IterativeWriteVars iWriteVars;
    private Exception lljtError;
    private String errorMsg;
    private static final String[] uptoName = new String[]{"None", "Info", "Header", "Body"};
    public static final byte[] dummyExifHeader = new byte[]{-1, -31, 3, 55, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 9, 0, 40, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 18, 1, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 50, 1, 2, 0, 20, 0, 0, 0, 122, 0, 0, 0, 27, 1, 5, 0, 1, 0, 0, 0, -114, 0, 0, 0, 16, 1, 2, 0, 21, 0, 0, 0, -106, 0, 0, 0, 26, 1, 5, 0, 1, 0, 0, 0, -85, 0, 0, 0, 15, 1, 2, 0, 8, 0, 0, 0, -77, 0, 0, 0, 19, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 105, -121, 4, 0, 1, 0, 0, 0, -69, 0, 0, 0, -23, 2, 0, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, -76, 0, 0, 0, 1, 0, 0, 0, 85, 110, 107, 110, 111, 119, 110, 32, 102, 114, 111, 109, 32, 76, 76, 74, 84, 114, 97, 110, 0, -76, 0, 0, 0, 1, 0, 0, 0, 85, 110, 107, 110, 111, 119, 110, 0, 30, 0, 23, -94, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, -93, 7, 0, 1, 0, 0, 0, 3, 0, 0, 0, 2, -111, 5, 0, 1, 0, 0, 0, 41, 2, 0, 0, 1, -111, 7, 0, 4, 0, 0, 0, 1, 2, 3, 0, 16, -94, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 15, -94, 5, 0, 1, 0, 0, 0, 49, 2, 0, 0, 14, -94, 5, 0, 1, 0, 0, 0, 57, 2, 0, 0, 3, -96, 3, 0, 1, 0, 0, 0, -80, 4, 0, 0, 2, -96, 3, 0, 1, 0, 0, 0, 64, 6, 0, 0, 1, -96, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, -96, 7, 0, 4, 0, 0, 0, 48, 49, 48, 48, 10, -110, 5, 0, 1, 0, 0, 0, 65, 2, 0, 0, 9, -110, 3, 0, 1, 0, 0, 0, 16, 0, 0, 0, -99, -126, 5, 0, 1, 0, 0, 0, 73, 2, 0, 0, 4, -112, 2, 0, 20, 0, 0, 0, 81, 2, 0, 0, 6, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, -112, 2, 0, 20, 0, 0, 0, 101, 2, 0, 0, 7, -110, 3, 0, 1, 0, 0, 0, 5, 0, 0, 0, 4, -92, 5, 0, 1, 0, 0, 0, 121, 2, 0, 0, -102, 82, 5, 0, 1, 0, 0, 0, -127, 2, 0, 0, 3, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, -110, 5, 0, 1, 0, 0, 0, -119, 2, 0, 0, 0, -112, 7, 0, 4, 0, 0, 0, 48, 50, 50, 48, 2, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 4, -110, 10, 0, 1, 0, 0, 0, -111, 2, 0, 0, 1, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, -110, 5, 0, 1, 0, 0, 0, -103, 2, 0, 0, 1, -110, 10, 0, 1, 0, 0, 0, -95, 2, 0, 0, -122, -110, 7, 0, 10, 0, 0, 0, -87, 2, 0, 0, 5, -96, 4, 0, 1, 0, 0, 0, -77, 2, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, -128, 79, 18, 0, -101, 0, 0, 0, 0, 106, 24, 0, -50, 0, 0, 0, 6, 2, 0, 0, 32, 0, 0, 0, -116, 0, 0, 0, 10, 0, 0, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, 64, 6, 0, 0, 64, 6, 0, 0, 1, 0, 0, 0, 100, 0, 0, 0, -118, -8, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 94, -99, 7, 0, 0, 0, 1, 0, -43, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 2, 16, 3, 0, 1, 0, 0, 0, -80, 4, 0, 0, 1, 16, 3, 0, 1, 0, 0, 0, 64, 6, 0, 0, 2, 0, 7, 0, 4, 0, 0, 0, 48, 49, 48, 48, 1, 0, 2, 0, 4, 0, 0, 0, 82, 57, 56, 0, 0, 0, 0, 0, 4, 0, 40, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 27, 1, 5, 0, 1, 0, 0, 0, 31, 3, 0, 0, 26, 1, 5, 0, 1, 0, 0, 0, 39, 3, 0, 0, 3, 1, 3, 0, 1, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, -76, 0, 0, 0, 1, 0, 0, 0, -76, 0, 0, 0, 1, 0, 0, 0};
    public static final String PROGRAMNAME = "LLJTran";

    private void commonInit() {
        this.iWriteVars = new IterativeWriteVars();
        this.iReadVars = new IterativeReadVars();
    }

    public LLJTran(File file) {
        this.commonInit();
        this.file = file;
        this.markerid = new byte[2];
        this.prevHuffOption = (byte)-1;
        this.readProgressCallback = null;
        this.writeProgressCallback = null;
    }

    public LLJTran(InputStream inputStream) {
        this.commonInit();
        this.markerid = new byte[2];
        this.inStream = inputStream;
        this.prevHuffOption = (byte)-1;
        this.readProgressCallback = null;
        this.writeProgressCallback = null;
    }

    public void resetInput(InputStream inputStream) {
        if (this.readUpto > 1) {
            throw new RuntimeException("Restting Input not allowed if current input read beyond READ_INFO");
        }
        if (inputStream == null) {
            if (this.file == null) {
                throw new RuntimeException("inStream null and no existing file to read from");
            }
        } else {
            this.file = null;
        }
        this.closeInternalInputStream();
        this.inStream = inputStream;
        this.readUpto = 0;
        this.unprocessed_marker = 0;
    }

    public void resetInput(File file) {
        if (this.readUpto > 1) {
            throw new RuntimeException("Restting Input not allowed if current input read beyond READ_INFO");
        }
        this.closeInternalInputStream();
        this.file = file;
        this.inStream = null;
        this.readUpto = 0;
        this.unprocessed_marker = 0;
    }

    public void setEncoding(String string) {
        this.enc = string;
    }

    public String getEncoding() {
        return this.enc;
    }

    public String getName() {
        if (this.file == null) {
            return "Unknown/Stream";
        }
        return this.file.getName();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object object) {
        return object instanceof LLJTran && ((LLJTran)object).getFile().equals(this.file);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getPendingErrorMsg() {
        return this.unprocessedError;
    }

    protected void setErrorMsg(String string) {
        this.errorMsg = string;
    }

    public Exception getException() {
        return this.lljtError;
    }

    protected void setException(Exception exception) {
        this.lljtError = exception;
    }

    protected InputStream createInputStream() {
        block4: {
            try {
                if (!this.valid) break block4;
                this.readcounter = 0;
                this.writecounter = 0;
                if (this.file == null) {
                    if (this.inStream != null) {
                        return this.inStream;
                    }
                    this.valid = false;
                    break block4;
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.valid = false;
            }
        }
        return null;
    }

    public AbstractImageInfo getImageInfo() {
        return this.imageinfo;
    }

    public String getComment() {
        return this.out_comment;
    }

    public void setComment(String string) {
        this.out_comment = string;
    }

    public String getLocationName() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public void setReadProgressCallback(ProgressCallback progressCallback) {
        this.readProgressCallback = progressCallback;
    }

    public void setWriteProgressCallback(ProgressCallback progressCallback) {
        this.writeProgressCallback = progressCallback;
    }

    public ProgressCallback getReadProgressCallback() {
        return this.readProgressCallback;
    }

    public ProgressCallback getWriteProgressCallback() {
        return this.writeProgressCallback;
    }

    protected boolean transformAppHeader(int n, int n2, boolean bl) {
        boolean bl2 = false;
        if (this.imageinfo != null && this.appxs != null && this.appHdrIndex >= 0) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
                byteArrayOutputStream.write(this.markerid);
                byteArrayOutputStream.write(this.markerid);
                this.imageinfo.writeInfo(this.appxs[this.appHdrIndex], byteArrayOutputStream, n, n2, bl, this.frm_x, this.frm_y);
                int n3 = byteArrayOutputStream.size() - 4;
                if (n3 > 0) {
                    byte by = this.appxs[this.appHdrIndex][1];
                    this.appxs[this.appHdrIndex] = byteArrayOutputStream.toByteArray();
                    this.appxs[this.appHdrIndex][0] = -1;
                    this.appxs[this.appHdrIndex][1] = by;
                    LLJTran.bn2s(this.appxs[this.appHdrIndex], 2, n3 + 2, 2);
                    bl2 = true;
                } else if (Log.debugLevel >= 2) {
                    System.err.println("Warning: transform: Unable to transform App Hdr possibly because the format is not fully supported");
                }
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
            catch (Exception exception) {
                if (Log.debugLevel >= 1) {
                    exception.printStackTrace(System.err);
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        return bl2;
    }

    private void validateCropBounds(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0 || rectangle.x < 0 || rectangle.x >= this.frm_x || rectangle.y < 0 || rectangle.y >= this.frm_y) {
            throw new ArrayIndexOutOfBoundsException("Invalid Crop Request");
        }
        int n = this.getMCUWidth();
        int n2 = this.getMCUHeight();
        int n3 = rectangle.x % n;
        this.cropBounds.x = rectangle.x - n3;
        if (n3 > n / 2 && this.cropBounds.x + n < this.frm_x) {
            this.cropBounds.x += n;
        }
        n3 = rectangle.y % n2;
        this.cropBounds.y = rectangle.y - n3;
        if (n3 > n2 / 2 && this.cropBounds.y + n2 < this.frm_y) {
            this.cropBounds.y += n2;
        }
        this.cropBounds.width = this.cropBounds.x + rectangle.width > this.frm_x ? this.frm_x - this.cropBounds.x : rectangle.width;
        this.cropBounds.height = this.cropBounds.y + rectangle.height > this.frm_y ? this.frm_y - this.cropBounds.y : rectangle.height;
    }

    public int checkPerfect(int n, Rectangle rectangle) {
        int n2 = 0;
        int n3 = this.getMCUWidth();
        int n4 = this.getMCUHeight();
        if (n == 8) {
            if (rectangle.x % n3 != 0) {
                n2 |= 1;
            }
            if (rectangle.y % n4 != 0) {
                n2 |= 2;
            }
        }
        if ((n == 7 || n == 4 || n == 6 || n == 1) && this.frm_x % n3 != 0) {
            n2 |= 1;
        }
        if ((n == 5 || n == 4 || n == 6 || n == 2) && this.frm_y % n4 != 0) {
            n2 |= 2;
        }
        return n2;
    }

    public void transform(int n) {
        this.transform(n, 777);
    }

    public void transform(int n, int n2) {
        if (n == 8) {
            n = 0;
        }
        this.transform(n, n2, null);
    }

    public void transform(int n, int n2, Rectangle rectangle) {
        block10: {
            this.prevHuffOption = (byte)-1;
            if (this.readUpto < 3) {
                throw new RuntimeException("Transform cannot be performed since No Jpeg has been successfully Read");
            }
            if ((n2 & 1) == 0) {
                n2 &= 0xFFFFFFFD;
            }
            if ((n2 & 2) != 0 && !this.appxs_read && Log.debugLevel >= 2) {
                System.err.println("Warning: Thumbnail transformation cannot be performed since keep_appxs was passed as false while reading");
            }
            if (n == 8) {
                this.validateCropBounds(rectangle);
            }
            this.adjustImageParameters(n, n2);
            switch (n) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.transposeImageParameters();
                    this.transposeQTable();
                    break;
                }
            }
            try {
                if ((n2 & 1) != 0) {
                    this.transformAppHeader(n, n2, true);
                }
                this.writeDCT(null, n, n2, 0, true);
            }
            catch (IOException iOException) {
                if (Log.debugLevel < 1) break block10;
                System.err.println("Warning:transform: Exception while transforming Thumbnail: " + iOException.getMessage());
                iOException.printStackTrace(System.err);
            }
        }
    }

    public void transform(OutputStream outputStream, int n) throws IOException {
        this.transform(outputStream, n, 777);
    }

    public void transform(OutputStream outputStream, int n, int n2) throws IOException {
        if (n == 8) {
            n = 0;
        }
        this.transform(outputStream, n, n2, null);
    }

    public void transform(OutputStream outputStream, int n, int n2, Rectangle rectangle) throws IOException {
        this.transform(outputStream, n, n2, rectangle, 0);
    }

    public void transform(OutputStream outputStream, int n, int n2, Rectangle rectangle, int n3) throws IOException {
        this.transform(outputStream, n, n2, rectangle, n3, null);
    }

    public IterativeWriter initWrite(OutputStream outputStream, int n, int n2, Rectangle rectangle, int n3) throws IOException {
        return this.initWrite(outputStream, n, n2, rectangle, n3, false);
    }

    public IterativeWriter initWrite(OutputStream outputStream, int n, int n2, Rectangle rectangle, int n3, boolean bl) throws IOException {
        return this.initWrite(outputStream, n, n2, rectangle, n3, bl, null);
    }

    protected IterativeWriter initWrite(OutputStream outputStream, int n, int n2, Rectangle rectangle, int n3, boolean bl, Class clazz) throws IOException {
        boolean bl2;
        this.prevHuffOption = (byte)-1;
        this.iWriteVars.maxWriteRequest = 0;
        this.iWriteVars.minWriteRequest = 100000000;
        this.iWriteVars.restoreVars = true;
        this.iWriteVars.saveAppxs = null;
        boolean bl3 = bl2 = (n2 & 0x100) != 0;
        if (n == 0 || !bl2) {
            n2 &= 0xFFFFFFFE;
        }
        if ((n2 & 1) == 0) {
            n2 &= 0xFFFFFFFD;
        }
        if (this.readUpto < 3) {
            throw new RuntimeException("Transform cannot be performed since No Jpeg has been successfully Read");
        }
        if (n == 8) {
            this.validateCropBounds(rectangle);
        }
        if (!this.appxs_read) {
            if ((n2 & 2) != 0 && Log.debugLevel >= 2) {
                System.err.println("Warning:transform: Thumbnail transformation cannot be performed since keep_appxs was passed as false while reading");
            }
            if (bl2 && Log.debugLevel >= 2) {
                System.err.println("Warning:transform: Cannote write APPXS since keep_appxs was passed as false while reading");
            }
        }
        if (n != 0) {
            this.iWriteVars.svX = this.frm_x;
            this.iWriteVars.svY = this.frm_y;
            this.iWriteVars.svWidthMCU = this.widthMCU;
            this.iWriteVars.svHeightMCU = this.heightMCU;
            this.adjustImageParameters(n, n2);
            switch (n) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.transposeImageParameters();
                    this.transposeQTable();
                    break;
                }
            }
            if ((n2 & 1) != 0 && this.appxs != null && this.appHdrIndex >= 0) {
                this.iWriteVars.saveAppxs = this.appxs[this.appHdrIndex];
                this.transformAppHeader(n, n2, false);
            }
        }
        return this.initWriteJpeg(outputStream, n, null, n2, clazz, n3, bl);
    }

    public void wrapupIterativeWrite(IterativeWriter iterativeWriter) {
        if (this.iWriteVars.state != 7) {
            if (this.iWriteVars.restoreVars && this.iWriteVars.op != 0) {
                switch (this.iWriteVars.op) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        this.transposeImageParameters();
                        this.transposeQTable();
                        break;
                    }
                }
                if (this.iWriteVars.saveAppxs != null) {
                    this.appxs[this.appHdrIndex] = this.iWriteVars.saveAppxs;
                }
                this.frm_x = this.iWriteVars.svX;
                this.frm_y = this.iWriteVars.svY;
                this.widthMCU = this.iWriteVars.svWidthMCU;
                this.heightMCU = this.iWriteVars.svHeightMCU;
            }
            this.iWriteVars.freeMemory();
            this.iWriteVars.state = 7;
        }
    }

    protected void transform(OutputStream outputStream, int n, int n2, Rectangle rectangle, int n3, Class clazz) throws IOException {
        this.initWrite(outputStream, n, n2, rectangle, n3, false, clazz);
        while (this.nextWrite(10000000) == 0) {
        }
    }

    private byte[] generateHuffTables(HuffGenerator huffGenerator) throws IOException {
        if (huffGenerator != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            huffGenerator.writeHuffTables(byteArrayOutputStream);
            this.data = byteArrayOutputStream.toByteArray();
        } else {
            this.data = stdHuffTables;
        }
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.readDHT(null, this.data.length);
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, 777, 0);
    }

    public void save(OutputStream outputStream, int n) throws IOException {
        this.save(outputStream, n, 0);
    }

    public void save(OutputStream outputStream, int n, int n2) throws IOException {
        boolean bl;
        boolean bl2 = bl = (n & 0x100) != 0;
        if (this.readUpto < 3) {
            throw new RuntimeException("Jpeg cannot be written since No Jpeg has been successfully Read");
        }
        if (bl && !this.appxs_read && Log.debugLevel >= 2) {
            System.err.println("Warning:save: Cannote write APPXS since keep_appxs was passed as false while reading");
        }
        IterativeWriter iterativeWriter = this.initWrite(outputStream, 0, n, null, n2);
        while (iterativeWriter.nextWrite(10000000) == 0) {
        }
    }

    public int writeThumbnail(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null && (n2 = this.imageinfo.getThumbnailOffset()) > 0 && (n = this.imageinfo.getThumbnailLength()) > 0) {
            outputStream.write(this.appxs[this.appHdrIndex], n2 + 4, n);
            n3 = n;
        }
        return n3;
    }

    public InputStream getThumbnailAsStream() {
        int n;
        int n2;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null && (n2 = this.imageinfo.getThumbnailOffset()) > 0 && (n = this.imageinfo.getThumbnailLength()) > 0) {
            byteArrayInputStream = new ByteArrayInputStream(this.appxs[this.appHdrIndex], n2 + 4, n);
        }
        return byteArrayInputStream;
    }

    public boolean setThumbnail(byte[] byArray, int n, int n2, String string) throws IOException {
        boolean bl = false;
        if (n2 > 45000) {
            throw new IOException("Size of Thumbnail is greater than 45000 bytes");
        }
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byteArrayOutputStream.write(this.markerid);
            byteArrayOutputStream.write(this.markerid);
            this.imageinfo.setThumbnail(byArray, n, n2, string, byteArrayOutputStream);
            int n3 = byteArrayOutputStream.size() - 4;
            if (n3 > 0) {
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                byArray2[0] = -1;
                byArray2[1] = this.appxs[this.appHdrIndex][1];
                LLJTran.bn2s(byArray2, 2, byArray2.length - 2, 2);
                this.appxs[this.appHdrIndex] = byArray2;
                bl = true;
            }
        }
        return bl;
    }

    public boolean refreshAppx() {
        boolean bl = false;
        if (this.imageinfo != null) {
            bl = this.transformAppHeader(0, 0, true);
        }
        return bl;
    }

    public boolean removeThumbnail() {
        boolean bl = false;
        if (this.imageinfo != null && this.imageinfo.removeThumbnailTags()) {
            bl = this.transformAppHeader(0, 0, true);
        }
        return bl;
    }

    private void adjustImageParameters(int n, int n2) {
        int n3 = this.getMCUWidth();
        int n4 = this.getMCUHeight();
        if (n == 8) {
            this.frm_x = this.cropBounds.width;
            this.frm_y = this.cropBounds.height;
            this.widthMCU = (this.frm_x + n3 - 1) / n3;
            this.heightMCU = (this.frm_y + n4 - 1) / n4;
        }
        int n5 = this.frm_y % n4;
        int n6 = this.frm_x % n3;
        this.partialYMCU = n5 != 0;
        boolean bl = this.partialXMCU = n6 != 0;
        if ((n2 & 4) != 0) {
            if (this.partialYMCU && (n == 5 || n == 4 || n == 6 || n == 2) && this.heightMCU > 1) {
                this.partialYMCU = false;
                this.frm_y -= n5;
                --this.heightMCU;
            }
            if (this.partialXMCU && (n == 7 || n == 4 || n == 6 || n == 1) && this.widthMCU > 1) {
                this.partialXMCU = false;
                this.frm_x -= n6;
                --this.widthMCU;
            }
        }
    }

    protected void writeJpeg(OutputStream outputStream, int n, String string, int n2, Rectangle rectangle, Class clazz, int n3, boolean bl) throws IOException {
        if (n == 8) {
            this.validateCropBounds(rectangle);
        }
        this.initWriteJpeg(outputStream, n, string, n2, clazz, n3, bl);
        this.iWriteVars.restoreVars = false;
        while (this.nextWrite(10000000) == 0) {
        }
        if (Log.debugLevel >= 3) {
            System.out.println("0x" + Integer.toHexString(this.writecounter) + "(" + this.writecounter + ") byte(s) Written Successfully");
        }
    }

    private IterativeWriter initWriteJpeg(OutputStream outputStream, int n, String string, int n2, Class clazz, int n3, boolean bl) throws IOException {
        if (bl && (n == 5 || n == 7 || n == 3 || n == 4)) {
            throw new RuntimeException("PullDownMode not allowed for Vertical<->Horizontal transform: " + n);
        }
        this.writecounter = 0;
        HuffGenerator huffGenerator = null;
        byte by = (byte)((n2 & 0x400) != 0 ? 1 : 0);
        byte[] byArray = null;
        this.iWriteVars.os = outputStream;
        this.iWriteVars.op = n;
        this.iWriteVars.comment = string;
        this.iWriteVars.options = n2;
        this.iWriteVars.custom_appx = clazz;
        this.iWriteVars.restart_interval = n3;
        this.iWriteVars.pullDownMode = bl;
        if (this.canBeProcessed && this.prevHuffOption != by) {
            this.prevHuffOption = by;
            if (by != 0) {
                block7: {
                    if (this.huffGen == null) {
                        this.huffGen = new HuffGenerator();
                    }
                    this.huffGen.init();
                    this.gatheringStats = true;
                    try {
                        this.writeDCT(null, n, n2, 0, false);
                    }
                    catch (IOException iOException) {
                        if (Log.debugLevel < 1) break block7;
                        System.err.println("Totally Unexpected IOException: " + iOException.getMessage());
                        iOException.printStackTrace(System.err);
                    }
                }
                this.gatheringStats = false;
                huffGenerator = this.huffGen;
            }
            byArray = this.generateHuffTables(huffGenerator);
            if (huffGenerator != null) {
                huffGenerator.freeMemory();
            }
        }
        this.iWriteVars.huffTables = byArray;
        this.iWriteVars.state = 0;
        return this;
    }

    public int nextWrite(int n) throws IOException {
        if (this.iWriteVars.state == 7) {
            throw new IllegalStateException("nextWrite Called without initialization or after write completion");
        }
        if (n > this.iWriteVars.maxWriteRequest) {
            this.iWriteVars.maxWriteRequest = n;
        }
        if (n < this.iWriteVars.minWriteRequest) {
            this.iWriteVars.minWriteRequest = n;
        }
        OutputStream outputStream = this.iWriteVars.os;
        int n2 = this.iWriteVars.op;
        String string = this.iWriteVars.comment;
        int n3 = this.iWriteVars.options;
        int n4 = this.iWriteVars.restart_interval;
        int n5 = this.iWriteVars.state;
        int n6 = this.writecounter;
        int n7 = n;
        do {
            switch (n5) {
                case 0: {
                    this.writeMarkerSOI(outputStream);
                    n5 = 1;
                    if ((n3 & 0x100) == 0) break;
                    n5 = 2;
                    this.writeNewMarker(outputStream, this.iWriteVars.custom_appx);
                    this.initWriteMarkerAppXs();
                    break;
                }
                case 2: {
                    if (this.writeNextMarkerAppXs(n7)) break;
                    n5 = 1;
                    break;
                }
                case 1: {
                    n5 = 3;
                    if ((n3 & 0x200) != 0) {
                        if (string == null || string.length() == 0) {
                            this.writeMarkerComment(outputStream, this.out_comment, this.enc);
                            break;
                        }
                        this.writeMarkerComment(outputStream, string, this.enc);
                        break;
                    }
                }
                case 3: {
                    this.writeMarkerDQT(outputStream);
                    n5 = 4;
                    break;
                }
                case 4: {
                    this.writeMarkerDHT(outputStream, this.iWriteVars.huffTables);
                    this.writeMarkerDRI(outputStream, n4);
                    n5 = this.canBeProcessed ? 5 : 7;
                    break;
                }
                case 5: {
                    this.writeMarkerSOF0(outputStream);
                    this.writeMarkerSOS(outputStream);
                    this.initWriteDCT(outputStream, n2, n3, n4, false);
                    n5 = 6;
                    break;
                }
                case 6: {
                    if (this.writeNextDCT(n7)) break;
                    this.writeMarkerEOI(outputStream);
                    n5 = 7;
                }
            }
        } while ((n7 = n - (this.writecounter - n6)) > 0 && n5 != 7);
        int n8 = 0;
        if (n5 == 7) {
            if (this.iWriteVars.pullDownMode) {
                this.freeMemory();
            } else {
                this.wrapupIterativeWrite(this);
            }
            n8 = 1;
        }
        this.iWriteVars.state = n5;
        return n8;
    }

    public void freeMemory() {
        this.dct_coefs = null;
        this.dc_valoffset = null;
        this.dc_maxcode = null;
        this.dc_huffval = null;
        this.enc_dc_matrix = null;
        this.dc_huffbits = null;
        this.dc_ix = null;
        this.ac_valoffset = null;
        this.ac_maxcode = null;
        this.ac_huffval = null;
        this.enc_ac_matrix = null;
        this.ac_huffbits = null;
        this.ac_ix = null;
        this.q_table = null;
        this.q_ix = null;
        this.q_prec = null;
        this.appxs = null;
        this.appHdrIndex = -1;
        this.encoder = null;
        this.closeInternalInputStream();
    }

    private void allocateTables() {
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.q_table = new int[0][0];
        this.q_ix = new int[0];
        this.q_prec = new int[0];
    }

    public void read(boolean bl) throws LLJTranException {
        this.read(3, bl);
    }

    private int processAppMarker(byte[] byArray, int n, AbstractImageInfo[] abstractImageInfoArray, boolean[] blArray) throws FileFormatException {
        boolean bl = false;
        int n2 = 0;
        if (LLJTran.isSignature(byArray, n, JFIF)) {
            n2 = 1;
            int n3 = this.bs2i(5, 2);
            int n4 = this.bs2i(7, 1);
            int n5 = this.bs2i(8, 2);
            int n6 = this.bs2i(10, 2);
            int n7 = this.bs2i(12, 1);
            int n8 = this.bs2i(13, 1);
            int n9 = 3 * n7 * n8;
            if (n7 > 0 && n8 > 0 && Log.debugLevel >= 3) {
                System.out.println("Thumbnail " + n7 + "x" + n8 + " in APP0");
            }
        } else if (LLJTran.isSignature(byArray, n, "JFXX")) {
            n2 = 2;
            bl = true;
        } else if (LLJTran.isSignature(byArray, n, "Exif")) {
            n2 = 3;
            bl = true;
        } else if ((LLJTran.isSignature(byArray, n, "II") || LLJTran.isSignature(byArray, n, "MM")) && LLJTran.isSignature(byArray, n + 6, "HEAP")) {
            n2 = 4;
            bl = true;
        } else if (LLJTran.isSignature(byArray, n, FPXR)) {
            n2 = 4;
        }
        if (blArray != null) {
            blArray[0] = bl;
        }
        if (abstractImageInfoArray != null && bl) {
            if (n != 0) {
                byte[] byArray2 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
                byArray = byArray2;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            switch (n2) {
                case 2: {
                    abstractImageInfoArray[0] = new JFXX((InputStream)byteArrayInputStream, byArray, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
                case 3: {
                    abstractImageInfoArray[0] = new Exif((InputStream)byteArrayInputStream, byArray, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
                case 4: {
                    abstractImageInfoArray[0] = new CIFF((InputStream)byteArrayInputStream, byArray, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
            }
        }
        return n2;
    }

    private String initReadInternal(int n, boolean bl, boolean bl2) {
        String string = null;
        this.iReadVars.maxReadRequest = 0;
        this.iReadVars.minReadRequest = 100000000;
        this.iReadVars.sections = n &= 7;
        this.iReadVars.keep_appxs = bl;
        this.iReadVars.throwException = bl2;
        if (this.unprocessed_marker == 0 && (n & 2) == 0 && (n & 4) != 0) {
            string = "Attempt to Read only the Body section when Header has not been successfully read";
        }
        this.out_comment = "";
        if (this.file != null) {
            this.valid = this.file.isFile();
        } else {
            boolean bl3 = this.valid = this.inStream != null;
        }
        if (string == null && !this.valid) {
            string = "Invalid input: " + this.getName();
        }
        if (this.xferDone) {
            string = "Cannot Read Further, Input has been Transferred using xferInfo()";
        }
        if (string == null) {
            InputStream inputStream = this.currentStream;
            if (inputStream == null) {
                inputStream = this.createInputStream();
            }
            this.iReadVars.is = inputStream;
            if (this.valid) {
                this.currentStream = inputStream;
                this.valid = false;
                this.canBeProcessed = true;
            } else {
                string = "Unable to Read from input: " + this.getName();
            }
        }
        this.iReadVars.stage = 1;
        return string;
    }

    public void initRead(int n, boolean bl, boolean bl2) throws LLJTranException {
        String string = null;
        if (n < 1 || n > 3) {
            string = "Error:read: Invalid value " + n + " for parameter readUpto";
        } else if (n <= this.readUpto) {
            if (Log.debugLevel >= 2) {
                System.err.println("Warning:initRead: Have already read " + uptoName[this.readUpto] + ", Exitting without doing anything");
            }
        } else if (this.unprocessedError != null) {
            string = this.unprocessedError;
        } else {
            int n2 = 0;
            if (this.readUpto < 1) {
                n2 = 1;
            }
            if (n >= 2) {
                if (this.readUpto < 2) {
                    n2 |= 2;
                }
                if (n >= 3) {
                    n2 |= 4;
                }
            }
            this.iReadVars.readUpto = n;
            string = this.initReadInternal(n2, bl, bl2);
            if (string != null) {
                string = "Error:initRead: " + string;
            }
        }
        if (string != null) {
            throw new LLJTranException(string);
        }
    }

    private void wrapupIterativeRead() {
        this.readUpto = this.iReadVars.readUpto;
    }

    public void read(int n, boolean bl) throws LLJTranException {
        this.initRead(n, bl, false);
        try {
            while (this.nextRead(10000000) == 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = this.getErrorMsg();
        if (string != null) {
            throw new LLJTranException(string);
        }
    }

    public int getReadUpto() {
        return this.readUpto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int nextRead(int n) throws IOException {
        int n2;
        block103: {
            int n3;
            String string;
            int n4;
            block97: {
                block96: {
                    InputStream inputStream = this.iReadVars.is;
                    boolean bl = this.iReadVars.keep_appxs;
                    n4 = this.iReadVars.sections;
                    string = null;
                    n2 = 0;
                    int n5 = n;
                    n3 = this.iReadVars.stage;
                    if (n > this.iReadVars.maxReadRequest) {
                        this.iReadVars.maxReadRequest = n;
                    }
                    if (n < this.iReadVars.minReadRequest) {
                        this.iReadVars.minReadRequest = n;
                    }
                    int n6 = this.readcounter;
                    block27: while (n4 != 0) {
                        block101: {
                            int n7;
                            Object[] objectArray;
                            block102: {
                                block100: {
                                    if (this.unprocessedError != null) {
                                        string = this.unprocessedError;
                                        break;
                                    }
                                    if (n3 < 1 || n3 >= 5) {
                                        string = "read: nextRead called without initRead or called after completion of read";
                                        break;
                                    }
                                    if (n3 != 2) break block100;
                                    if (this.readNextDCT(n5)) break block101;
                                    n3 = 4;
                                }
                                if (n3 != 3) break block102;
                                if (this.readNextAppx(n5)) break block101;
                                n3 = 1;
                                if (bl) {
                                    int n8;
                                    this.addAppx();
                                    this.appxs_read = true;
                                    boolean[] blArray = new boolean[1];
                                    if (n4 == 1) {
                                        this.valid = true;
                                    }
                                    if (Log.debugLevel >= 4) {
                                        System.out.println("Signature " + new String(this.data, 0, 4));
                                    }
                                    objectArray = null;
                                    if ((n4 & 1) != 0) {
                                        objectArray = new AbstractImageInfo[1];
                                    }
                                    if ((n8 = this.processAppMarker(this.data, 4, (AbstractImageInfo[])objectArray, blArray)) == 0 && this.imageinfo == null) {
                                        n7 = this.data.length;
                                        if (Log.debugLevel >= 4) {
                                            System.out.println("unhandled APP marker " + Integer.toHexString(this.markerid[1]) + " length " + n7 + " data " + new String(this.data, 0, n7));
                                        }
                                    }
                                    if (objectArray != null && objectArray[0] != null) {
                                        this.imageinfo = objectArray[0];
                                    }
                                    if (blArray[0] && this.imageinfo != null && bl) {
                                        this.appHdrIndex = this.appxs.length - 1;
                                    }
                                    if (Log.debugLevel >= 4) {
                                        System.out.println("Image info " + this.imageinfo);
                                    }
                                }
                            }
                            if (this.unprocessed_marker == 0) {
                                if (inputStream.read(this.markerid) != this.markerid.length) {
                                    string = "Unexpected End Of Input";
                                    break;
                                }
                                this.readcounter += this.markerid.length;
                            } else {
                                this.markerid[0] = -1;
                                this.markerid[1] = (byte)this.unprocessed_marker;
                                this.unprocessed_marker = 0;
                            }
                            if (n3 == 4 && (this.markerid[0] != -1 || this.markerid[1] != -39)) {
                                this.valid = true;
                                n3 = 5;
                                if (Log.debugLevel < 2) break;
                                System.err.println("Warning:read: Found Bytes 0x" + Integer.toHexString(this.markerid[0]) + ", 0x" + Integer.toHexString(this.markerid[1]) + " instead of EOI, Ignoring remaining input");
                                break;
                            }
                            if (this.markerid[0] != -1) {
                                if (this.readcounter == this.markerid.length) {
                                    this.intel = this.markerid[0] == 73 && this.markerid[1] == 73;
                                    boolean bl2 = this.motorola = this.markerid[0] == 77 && this.markerid[1] == 77;
                                    if (this.intel || this.motorola) {
                                        this.data = new byte[6];
                                        if (inputStream.read(this.data) == this.data.length && (this.intel && this.data[0] == 42 && this.data[1] == 0 || this.motorola && this.data[1] == 42 && this.data[0] == 0)) {
                                            this.readcounter += this.data.length;
                                            this.imageinfo = new TiffExif(inputStream, this.data, this.readcounter, this.getName(), this.intel, this);
                                        }
                                    } else if (this.markerid[0] == Flashpix.SIGNATURE[0] && this.markerid[1] == Flashpix.SIGNATURE[1]) {
                                        this.data = new byte[6];
                                        if (inputStream.read(this.data) == this.data.length && this.data[0] == Flashpix.SIGNATURE[2] && this.data[1] == Flashpix.SIGNATURE[3] && this.data[2] == Flashpix.SIGNATURE[4] && this.data[3] == Flashpix.SIGNATURE[5] && this.data[4] == Flashpix.SIGNATURE[6] && this.data[5] == Flashpix.SIGNATURE[7]) {
                                            this.readcounter += this.data.length;
                                        }
                                    }
                                }
                                this.valid = this.imageinfo != null;
                                this.canBeProcessed = false;
                                string = "Not a Jpeg File";
                                break;
                            }
                            byte by = this.markerid[1];
                            switch (by) {
                                case -40: {
                                    this.allocateTables();
                                    break;
                                }
                                case -32: 
                                case -31: 
                                case -30: 
                                case -29: 
                                case -28: 
                                case -27: 
                                case -26: 
                                case -25: 
                                case -24: 
                                case -23: 
                                case -22: 
                                case -21: 
                                case -20: 
                                case -19: 
                                case -18: 
                                case -17: {
                                    this.initReadAppx(by);
                                    n3 = 3;
                                    break;
                                }
                                case -37: {
                                    int n9;
                                    if (n4 == 1) {
                                        this.valid = true;
                                        this.data = this.markerid;
                                        this.unprocessed_marker = by;
                                        n3 = 5;
                                        break block27;
                                    }
                                    n7 = this.readMarker(inputStream);
                                    int n10 = 0;
                                    while (n10 < n7) {
                                        n9 = this.q_prec.length;
                                        objectArray = new int[n9 + 1];
                                        System.arraycopy(this.q_ix, 0, objectArray, 0, n9);
                                        this.q_ix = (int[])objectArray;
                                        this.q_ix[n9] = this.data[n10] & 0xF;
                                        objectArray = new int[n9 + 1];
                                        System.arraycopy(this.q_prec, 0, objectArray, 0, n9);
                                        this.q_prec = (int[])objectArray;
                                        this.q_prec[n9] = (this.data[n10++] >> 4 & 0xF) == 0 ? 8 : 16;
                                        int[][] nArray = new int[n9 + 1][64];
                                        System.arraycopy(this.q_table, 0, nArray, 0, n9);
                                        this.q_table = nArray;
                                        int n11 = n10 + 64;
                                        if (n11 > n7) {
                                            n11 = n7;
                                        }
                                        int n12 = 0;
                                        while (n10 < n11) {
                                            this.q_table[n9][n12] = this.data[n10++] & 0xFF;
                                            ++n12;
                                        }
                                    }
                                    break;
                                }
                                case -60: {
                                    if (n4 == 1) {
                                        this.valid = true;
                                        this.data = this.markerid;
                                        this.unprocessed_marker = by;
                                        n3 = 5;
                                        break block27;
                                    }
                                    n7 = this.readDHT(inputStream, 0);
                                    break;
                                }
                                case -64: 
                                case -63: {
                                    if (n4 == 1) {
                                        this.valid = true;
                                        this.data = this.markerid;
                                        if (Log.debugLevel >= 3) {
                                            System.out.println("Abandoned M_SOF0 -64   " + this.markerid[1]);
                                        }
                                        this.unprocessed_marker = by;
                                        n3 = 5;
                                        break block27;
                                    }
                                    n7 = this.readMarker(inputStream);
                                    this.frm_precision = this.data[0] & 0xFF;
                                    this.frm_x = this.bs2i(3, 2);
                                    this.frm_y = this.bs2i(1, 2);
                                    this.components_in_frame = this.data[5] & 0xFF;
                                    if (Log.debugLevel >= 3) {
                                        System.out.println("Frame, precision " + this.frm_precision);
                                        System.out.println("X= " + this.frm_x + ", Y= " + this.frm_y);
                                        System.out.println("Components " + this.components_in_frame + " (" + this.getLocationName() + ")");
                                    }
                                    this.V = new int[this.components_in_frame];
                                    this.H = new int[this.components_in_frame];
                                    this.QT = new int[this.components_in_frame];
                                    this.ID = new int[this.components_in_frame];
                                    int n10 = 6;
                                    this.maxVi = 0;
                                    this.maxHi = 0;
                                    int n9 = 0;
                                    this.mcusize = 0;
                                    for (int i = 0; i < this.components_in_frame; ++i) {
                                        this.ID[i] = this.data[n10++] & 0xFF;
                                        n9 = (n9 << 8) + (this.data[n10] & 0xFF);
                                        this.H[i] = this.data[n10] >> 4 & 0xF;
                                        if (this.H[i] > this.maxHi) {
                                            this.maxHi = this.H[i];
                                        }
                                        this.V[i] = this.data[n10++] & 0xF;
                                        if (this.V[i] > this.maxVi) {
                                            this.maxVi = this.V[i];
                                        }
                                        this.mcusize += this.H[i] * this.V[i];
                                        this.QT[i] = this.data[n10++] & 0xFF;
                                    }
                                    this.widthMCU = (this.frm_x + 8 * this.maxHi - 1) / (8 * this.maxHi);
                                    this.heightMCU = (this.frm_y + 8 * this.maxVi - 1) / (8 * this.maxVi);
                                    if (Log.debugLevel < 3) break;
                                    System.out.println("Size in MCU " + this.widthMCU + "x" + this.heightMCU);
                                    break;
                                }
                                case -62: {
                                    n7 = this.readMarker(inputStream);
                                    if (Log.debugLevel >= 1) {
                                        System.err.println("Progressive, Huffman not supported in  (" + this.getLocationName() + ")");
                                    }
                                    this.canBeProcessed = false;
                                    string = "Progressive, Huffman not supported";
                                    if ((n4 & 4) == 0) break;
                                    this.addMarker(n7, by);
                                    break;
                                }
                                case -55: {
                                    n7 = this.readMarker(inputStream);
                                    if (Log.debugLevel >= 1) {
                                        System.err.println("Extended sequential, arithmetic not supported (" + this.getLocationName() + ")");
                                    }
                                    this.canBeProcessed = false;
                                    string = "Extended sequential, arithmetic not supported";
                                    if ((n4 & 4) == 0) break;
                                    this.addMarker(n7, by);
                                    break;
                                }
                                case -54: {
                                    n7 = this.readMarker(inputStream);
                                    if (Log.debugLevel >= 1) {
                                        System.err.println("Progressive, arithmetic not supported (" + this.getLocationName() + ")");
                                    }
                                    this.canBeProcessed = false;
                                    string = "Progressive, arithmetic not supported";
                                    if ((n4 & 4) == 0) break;
                                    this.addMarker(n7, by);
                                    break;
                                }
                                case -61: 
                                case -59: 
                                case -58: 
                                case -57: 
                                case -56: 
                                case -53: 
                                case -51: 
                                case -50: 
                                case -49: {
                                    n7 = this.readMarker(inputStream);
                                    if (Log.debugLevel >= 1) {
                                        System.err.println("One of the unsupported SOF markers:\nLossless, Huffman\nDifferential sequential, Huffman\nDifferential progressive, Huffman\nDifferential lossless, Huffman\nReserved for JPEG extensions\nLossless, arithmetic\nDifferential sequential, arithmetic\nDifferential progressive, arithmetic\nDifferential lossless, arithmetic (" + this.getLocationName() + ")");
                                    }
                                    this.canBeProcessed = false;
                                    string = "Unsupported SOF marker";
                                    if ((n4 & 4) == 0) break;
                                    this.addMarker(n7, by);
                                    break;
                                }
                                case -38: {
                                    int n10;
                                    if ((n4 & 4) == 0) {
                                        this.valid = true;
                                        this.unprocessed_marker = by;
                                        n3 = 5;
                                        break block27;
                                    }
                                    n7 = this.readMarker(inputStream);
                                    if (this.canBeProcessed) {
                                        this.components_in_scan = this.data[0] & 0xFF;
                                        n10 = 1;
                                        this.comp_ids = new int[this.components_in_scan];
                                        this.dc_table = new int[this.components_in_scan];
                                        this.ac_table = new int[this.components_in_scan];
                                        for (int i = 0; i < this.components_in_scan; ++i) {
                                            this.comp_ids[i] = this.data[n10++] & 0xFF;
                                            this.dc_table[i] = this.data[n10] >> 4 & 0xF;
                                            this.ac_table[i] = this.data[n10++] & 0xF;
                                        }
                                        this._Ss = this.data[n10++] & 0xFF;
                                        this._Se = this.data[n10++] & 0xFF;
                                        this._Ah = this.data[n10] >> 4 & 0xF;
                                        this._Al = this.data[n10] & 0xF;
                                        this.initReadDCT();
                                        n3 = 2;
                                        break;
                                    }
                                    this.addMarker(n7, by);
                                    if (Log.debugLevel >= 2) {
                                        System.err.println("Warning: Read raw dct");
                                    }
                                    this.readRawDCT(inputStream);
                                    this.valid = true;
                                    break block27;
                                }
                                case -2: {
                                    n7 = this.readMarker(inputStream);
                                    if (this.out_comment.length() > 0) {
                                        this.out_comment = this.out_comment + '\n';
                                    }
                                    try {
                                        this.out_comment = this.out_comment + new String(this.data, 0, n7, this.enc);
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        this.out_comment = this.out_comment + new String(this.data, 0, n7);
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        this.out_comment = this.out_comment + new String(this.data, 0, n7);
                                    }
                                    break;
                                }
                                case -39: {
                                    this.valid = true;
                                    n3 = 5;
                                    break block27;
                                }
                                case -35: {
                                    if (n4 == 1) {
                                        this.valid = true;
                                        this.data = this.markerid;
                                        this.unprocessed_marker = by;
                                        n3 = 5;
                                        break block27;
                                    }
                                    n7 = this.readMarker(inputStream);
                                    if (n7 != 2) {
                                        throw new IOException("Wrong length of DRI marker " + n7 + " (" + this.getLocationName() + ")");
                                    }
                                    this.restart_interval = this.bs2i(0, 2);
                                    if (Log.debugLevel < 3) break;
                                    System.out.println("Restart interval " + this.restart_interval);
                                    break;
                                }
                                case -1: {
                                    break;
                                }
                                default: {
                                    n7 = this.readMarker(inputStream);
                                    if ((0xFFFFFFF0 & by) == -16) break block27;
                                    if (Log.debugLevel < 2) break;
                                    System.err.println("Unsupported marker " + Integer.toHexString(by) + " length " + n7 + " (" + this.getLocationName() + ")");
                                }
                            }
                            if (by >= -62 && by <= -49 && by != -60 && by != -56) {
                                this.frm_precision = this.data[0] & 0xFF;
                                this.frm_x = this.bs2i(3, 2);
                                this.frm_y = this.bs2i(1, 2);
                                this.components_in_frame = this.data[5] & 0xFF;
                            }
                        }
                        if ((n5 = n - (this.readcounter - n6)) > 0) continue;
                    }
                    if ((n4 & 1) != 0 && this.imageinfo == null) {
                        this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                    }
                    if (!this.valid) break block96;
                    if ((n4 & 4) == 0) {
                        this.unprocessedError = string;
                        string = null;
                        break block96;
                    }
                    if (Log.debugLevel < 3) break block96;
                    System.out.println("0x" + Integer.toHexString(this.readcounter) + "(" + this.readcounter + ") byte(s) read in " + this.getName());
                }
                Object var19_25 = null;
                this.iReadVars.stage = n3;
                if (string != null && (this.unprocessedError == null || this.unprocessedError.indexOf("Previous Error") != 0)) {
                    this.unprocessedError = "Previous Error: " + string;
                }
                if (string != null || n3 == 5) {
                    n2 = 1;
                }
                if (n2 != true || this.currentStream == null || (n4 & 4) == 0 && string == null || this.currentStream == this.inStream) break block97;
                try {
                    this.currentStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentStream = null;
            }
            if (n3 == 5) {
                this.wrapupIterativeRead();
            }
            this.setErrorMsg(string);
            if (string != null && this.iReadVars.throwException) {
                throw new IOException("Image Read Error In LLJTran:: " + string);
            }
            break block103;
            {
                catch (Exception exception) {
                    this.valid = false;
                    string = "Unexpected Error encountered during Read";
                    this.setException(exception);
                    if (Log.debugLevel >= 1) {
                        exception.printStackTrace(System.err);
                    }
                    Object var19_26 = null;
                    this.iReadVars.stage = n3;
                    if (string != null && (this.unprocessedError == null || this.unprocessedError.indexOf("Previous Error") != 0)) {
                        this.unprocessedError = "Previous Error: " + string;
                    }
                    if (string != null || n3 == 5) {
                        n2 = 1;
                    }
                    if (n2 == 1 && this.currentStream != null && ((n4 & 4) != 0 || string != null) && this.currentStream != this.inStream) {
                        try {
                            this.currentStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.currentStream = null;
                    }
                    if (n3 == 5) {
                        this.wrapupIterativeRead();
                    }
                    this.setErrorMsg(string);
                    if (string != null && this.iReadVars.throwException) {
                        throw new IOException("Image Read Error In LLJTran:: " + string);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_27 = null;
                this.iReadVars.stage = n3;
                if (string != null && (this.unprocessedError == null || this.unprocessedError.indexOf("Previous Error") != 0)) {
                    this.unprocessedError = "Previous Error: " + string;
                }
                if (string != null || n3 == 5) {
                    n2 = 1;
                }
                if (n2 == 1 && this.currentStream != null && ((n4 & 4) != 0 || string != null) && this.currentStream != this.inStream) {
                    try {
                        this.currentStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.currentStream = null;
                }
                if (n3 == 5) {
                    this.wrapupIterativeRead();
                }
                this.setErrorMsg(string);
                if (string != null && this.iReadVars.throwException) {
                    throw new IOException("Image Read Error In LLJTran:: " + string);
                }
                throw throwable;
            }
        }
        return n2;
    }

    protected String readInternal(int n, boolean bl) {
        String string = this.initReadInternal(n, bl, false);
        if (string == null) {
            String string2 = this.getErrorMsg();
            this.setErrorMsg(null);
            try {
                while (this.nextRead(10000000) == 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = this.getErrorMsg();
            this.setErrorMsg(string2);
        }
        return string;
    }

    public void xferInfo(InputStream inputStream, OutputStream outputStream, int n, int n2) throws LLJTranException {
        boolean bl;
        String string;
        block31: {
            string = null;
            int n3 = 0;
            int n4 = 0;
            bl = false;
            if (inputStream == null) {
                n3 = this.unprocessed_marker;
                if (this.readUpto == 1) {
                    if (this.xferDone) {
                        string = "Cannot Read Further, Input has been Transferred using xferInfo()";
                    }
                    if (n == 1 || n2 == 1) {
                        string = "Cannot Retain appxs or comments when tranferring from internal stream";
                    }
                    inputStream = this.iReadVars.is;
                } else {
                    string = "Can transfer from internal stream only if previously read upto READ_INFO";
                }
            }
            if (inputStream == this.iReadVars.is) {
                this.xferDone = true;
                bl = true;
            }
            if (string == null) {
                try {
                    this.writeMarkerSOI(outputStream);
                    if (n == 0) {
                        this.writeMarkerAppXs(outputStream);
                    }
                    if (n2 == 0) {
                        this.writeMarkerComment(outputStream, this.out_comment, this.enc);
                    }
                    if (this.data.length < 1024) {
                        this.data = new byte[1024];
                    }
                    do {
                        if (n3 == 0) {
                            if (inputStream.read(this.markerid) != this.markerid.length) {
                                string = "Unexpected End Of Input";
                                break;
                            }
                            if (this.markerid[0] != -1) {
                                string = "Invalid Marker found";
                                break;
                            }
                        } else {
                            this.markerid[0] = -1;
                            this.markerid[1] = (byte)n3;
                            n3 = 0;
                        }
                        byte by = this.markerid[1];
                        switch (by) {
                            case -40: {
                                break;
                            }
                            case -32: 
                            case -31: 
                            case -30: 
                            case -29: 
                            case -28: 
                            case -27: 
                            case -26: 
                            case -25: 
                            case -24: 
                            case -23: 
                            case -22: 
                            case -21: 
                            case -20: 
                            case -19: 
                            case -18: 
                            case -17: {
                                this.xferMarker(inputStream, outputStream, by, n != 1 && (n == 2 || !bl));
                                break;
                            }
                            case -2: {
                                this.xferMarker(inputStream, outputStream, by, n2 != 1 && (n2 == 2 || !bl));
                                break;
                            }
                            case -35: {
                                this.xferMarker(inputStream, outputStream, by, false);
                                break;
                            }
                            case -1: {
                                break;
                            }
                            case -64: 
                            case -63: 
                            case -62: 
                            case -61: 
                            case -60: 
                            case -59: 
                            case -58: 
                            case -57: 
                            case -56: 
                            case -55: 
                            case -54: 
                            case -53: 
                            case -51: 
                            case -50: 
                            case -49: 
                            case -37: {
                                ++n4;
                                this.xferMarker(inputStream, outputStream, by, false);
                                break;
                            }
                            case -38: {
                                if (n4 >= 3) {
                                    this.xferMarker(inputStream, outputStream, by, false);
                                    this.xferData(inputStream, outputStream, -1);
                                    outputStream.flush();
                                    break block31;
                                }
                                string = "All Jpeg Markers not Encountered. A likely error";
                                break;
                            }
                            case -39: {
                                string = "Unexpected EOI marker found";
                                break;
                            }
                            default: {
                                if (Log.debugLevel >= 2) {
                                    System.err.println("Warning: xferAppxs(): Unhandled Marker " + Integer.toHexString(by));
                                }
                                this.xferMarker(inputStream, outputStream, by, false);
                            }
                        }
                    } while (string == null);
                }
                catch (Exception exception) {
                    string = "Unexpected Error encountered during Read";
                    if (Log.debugLevel < 1) break block31;
                    exception.printStackTrace(System.err);
                }
            }
        }
        if (bl) {
            this.closeInternalInputStream();
        }
        if (string != null) {
            throw new LLJTranException(string);
        }
    }

    public void closeInternalInputStream() {
        if (this.inStream == null && this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentStream = null;
            this.unprocessed_marker = 0;
        }
    }

    public int getWidth() {
        return this.frm_x;
    }

    public int getHeight() {
        return this.frm_y;
    }

    public int getWidthInMCU() {
        return this.widthMCU;
    }

    public int getHeightInMCU() {
        return this.heightMCU;
    }

    public int getMaxHSamplingFactor() {
        return this.maxHi;
    }

    public int getMaxVSamplingFactor() {
        return this.maxVi;
    }

    public int getMCUWidth() {
        return 8 * this.maxHi;
    }

    public int getMCUHeight() {
        return 8 * this.maxVi;
    }

    public int getNumComponents() {
        return this.components_in_frame;
    }

    public int getHSamplingFactor(int n) {
        return this.H[n];
    }

    public int getVSamplingFactor(int n) {
        return this.V[n];
    }

    public int getRestartInterval() {
        return this.restart_interval;
    }

    public int getNumQTables() {
        return this.q_table.length;
    }

    public int[] getQTable(int n) {
        int[] nArray = this.q_table[n];
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[jpegzigzagorder[i]];
        }
        return nArray2;
    }

    public int getQTableIndexForComponent(int n) {
        int n2;
        int n3 = -1;
        int n4 = this.QT[n];
        for (n2 = 0; n2 < this.q_ix.length && this.q_ix[n2] != n4; ++n2) {
        }
        if (n2 < this.q_ix.length) {
            n3 = n2;
        }
        return n3;
    }

    public int getNumAppxs() {
        int n = 0;
        if (this.appxs != null) {
            n = this.appxs.length;
        }
        return n;
    }

    public int getAppxMarker(int n) {
        return 0xFF & this.appxs[n][1];
    }

    public int getAppxLen(int n) {
        return this.appxs[n].length;
    }

    public int getAppx(int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = null;
        byArray2 = this.appxs[n];
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return byArray2.length;
    }

    public int getImageInfoAppxIndex() {
        return this.appHdrIndex;
    }

    public void setAppx(int n, byte[] byArray, int n2, int n3, boolean bl) {
        block10: {
            this.validateAppxs(byArray, n2, n3);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            this.appxs[n] = byArray2;
            if (bl) {
                AbstractImageInfo[] abstractImageInfoArray = new AbstractImageInfo[1];
                try {
                    this.processAppMarker(byArray2, 4, abstractImageInfoArray, null);
                }
                catch (Exception exception) {
                    if (Log.debugLevel >= 1) {
                        System.err.println("Error Parsing ImageInfo:");
                        exception.printStackTrace(System.err);
                    }
                    abstractImageInfoArray[0] = null;
                }
                this.imageinfo = abstractImageInfoArray[0];
                this.appHdrIndex = n;
            } else if (n == this.appHdrIndex) {
                this.imageinfo = null;
            }
            if (this.imageinfo == null) {
                this.appHdrIndex = -1;
                if (this.frm_x != 0 && this.frm_y != 0) {
                    try {
                        this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                    }
                    catch (Exception exception) {
                        if (Log.debugLevel < 1) break block10;
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public void insertAppx(int n, byte[] byArray, int n2, int n3, boolean bl) {
        this.validateAppxs(byArray, n2, n3);
        if (n == 0 && this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] byArrayArray = new byte[this.appxs.length + 1][];
        byte[] byArray2 = byArrayArray[n];
        if (n > 0) {
            System.arraycopy(this.appxs, 0, byArrayArray, 0, n);
        }
        if (n < this.appxs.length) {
            System.arraycopy(this.appxs, n, byArrayArray, n + 1, this.appxs.length - n);
        }
        this.appxs = byArrayArray;
        if (n <= this.appHdrIndex) {
            ++this.appHdrIndex;
        }
        this.setAppx(n, byArray, n2, n3, bl);
    }

    public void addAppx(byte[] byArray, int n, int n2, boolean bl) {
        this.insertAppx(this.getNumAppxs(), byArray, n, n2, bl);
    }

    public void removeAppx(int n) {
        block7: {
            byte[][] byArrayArray = new byte[this.appxs.length - 1][];
            if (n > 0) {
                System.arraycopy(this.appxs, 0, byArrayArray, 0, n);
            }
            if (n < this.appxs.length - 1) {
                System.arraycopy(this.appxs, n + 1, byArrayArray, n, this.appxs.length - n - 1);
            }
            this.appxs = byArrayArray;
            if (n == this.appHdrIndex) {
                this.imageinfo = null;
                if (this.frm_x != 0 && this.frm_y != 0) {
                    try {
                        this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                    }
                    catch (Exception exception) {
                        if (Log.debugLevel < 1) break block7;
                        exception.printStackTrace(System.err);
                    }
                }
            }
        }
        if (n > this.appHdrIndex) {
            --this.appHdrIndex;
        }
    }

    private void validateAppxs(byte[] byArray, int n, int n2) {
        int n3;
        RuntimeException runtimeException = null;
        byte by = byArray[0];
        byte by2 = byArray[1];
        if (by != -1 || by2 < -31 || by2 > -17) {
            runtimeException = new RuntimeException("validateAppxs: Incorrect 1st two bytes for App marker: 0x" + Integer.toHexString(by) + ":0x" + Integer.toHexString(by2));
        }
        if (runtimeException == null) {
            this.data = byArray;
            n3 = this.bs2i(n + 2, 2) + 2;
            if (n2 != n3) {
                runtimeException = new RuntimeException("validateAppxs: Incorrect Length " + (n3 - 2) + " in 3rd and 4th bytes. " + " expected = " + (n2 - 2));
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        n3 = byArray[n + n2 - 1];
    }

    protected void addMarker(int n, byte by) {
    }

    private void initReadAppx(byte by) throws IOException {
        if (this.iReadVars.is.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int n = this.bs2i(0, 2);
        if (this.iReadVars.keep_appxs) {
            this.appxs = null;
            this.imageinfo = null;
            this.data = new byte[n + 2];
            this.data[0] = -1;
            this.data[1] = by;
            System.arraycopy(this.markerid, 0, this.data, 2, 2);
        }
        this.iReadVars.appxLen = n + 2;
        this.iReadVars.appxPos = 4;
    }

    private boolean readNextAppx(int n) throws IOException {
        boolean bl;
        InputStream inputStream = this.iReadVars.is;
        int n2 = this.iReadVars.appxLen - this.iReadVars.appxPos;
        if (n2 > n) {
            bl = true;
            n2 = n;
        } else {
            bl = false;
        }
        int n3 = this.iReadVars.keep_appxs ? BasicIo.read(inputStream, this.data, this.iReadVars.appxPos, n2, n2) : (int)BasicIo.skip(inputStream, n2);
        this.iReadVars.appxPos += n3;
        this.readcounter += n3;
        if (n3 < n2) {
            bl = false;
        }
        return bl;
    }

    private void addAppx() {
        if (this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] byArrayArray = new byte[this.appxs.length + 1][];
        System.arraycopy(this.appxs, 0, byArrayArray, 0, this.appxs.length);
        this.appxs = byArrayArray;
        this.appxs[this.appxs.length - 1] = this.data;
    }

    private int xferData(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = 0;
        int n3 = n;
        int n4 = this.data.length;
        if (n == -1) {
            n3 = n4;
        }
        while (n3 > 0) {
            int n5;
            if (n4 > n3) {
                n4 = n3;
            }
            if ((n5 = inputStream.read(this.data, 0, n4)) < 0) break;
            if (n5 <= 0) continue;
            outputStream.write(this.data, 0, n5);
            n2 += n5;
            if (n == -1) continue;
            n3 -= n5;
        }
        return n2;
    }

    private void xferMarker(InputStream inputStream, OutputStream outputStream, int n, boolean bl) throws IOException {
        if (!bl) {
            outputStream.write(-1);
            outputStream.write(n);
        }
        if (inputStream.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        byte[] byArray = this.data;
        this.data = this.markerid;
        int n2 = this.bs2i(0, 2) - 2;
        this.data = byArray;
        if (bl) {
            LLJTran.skip(inputStream, n2);
        } else {
            outputStream.write(this.markerid);
            this.xferData(inputStream, outputStream, n2);
        }
    }

    private int readMarker(InputStream inputStream) throws IOException, FileFormatException {
        if (inputStream.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int n = this.bs2i(0, 2) - 2;
        this.data = new byte[n];
        LLJTran.read(inputStream, this.data);
        this.readcounter += n;
        return n;
    }

    private void initWriteMarkerAppXs() throws IOException {
        this.iWriteVars.currentAppx = 0;
        this.iWriteVars.currentAppxPos = 0;
    }

    private boolean writeNextMarkerAppXs(int n) throws IOException {
        int n2 = this.iWriteVars.currentAppx;
        OutputStream outputStream = this.iWriteVars.os;
        int n3 = this.iWriteVars.currentAppxPos;
        boolean bl = false;
        int n4 = n;
        if (this.appxs != null) {
            bl = true;
            while (true) {
                int n5;
                if (n2 >= this.appxs.length) {
                    bl = false;
                    break;
                }
                if (n4 <= 0) break;
                byte[] byArray = this.appxs[n2];
                int n6 = byArray.length - n3;
                if (n6 > n4) {
                    n6 = n4;
                    n5 = n3 + n4;
                } else {
                    ++n2;
                    n5 = 0;
                }
                outputStream.write(byArray, n3, n6);
                n3 = n5;
                n4 -= n6;
                this.writecounter += n6;
            }
        }
        this.iWriteVars.currentAppx = n2;
        this.iWriteVars.currentAppxPos = n3;
        if (n2 >= this.appxs.length) {
            bl = false;
        }
        return bl;
    }

    protected void writeMarkerAppXs(OutputStream outputStream) throws IOException {
        if (this.appxs == null) {
            return;
        }
        for (int i = 0; i < this.appxs.length; ++i) {
            outputStream.write(this.appxs[i]);
            ++this.writecounter;
        }
    }

    protected void writeMarkerSOI(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-40);
        this.writecounter += 2;
    }

    protected void writeNewMarker(OutputStream outputStream, Class clazz) throws IOException {
        block9: {
            if (clazz == null) {
                return;
            }
            if (clazz == JFXX.class) {
                byte[] byArray = JFXX.getMarkerData();
                outputStream.write(byArray);
                this.writecounter += byArray.length;
            } else if (clazz == Exif.class) {
                byte[] byArray = Exif.getMarkerData();
                outputStream.write(byArray);
                this.writecounter += byArray.length;
            } else if (clazz == AbstractImageInfo.class) {
                File file;
                String string = this.getName();
                int n = string.lastIndexOf(46);
                string = n > 0 ? string.substring(0, n + 1) : string + '.';
                if (this.file != null && (file = new File(this.file.getParent(), string + "Exif")).exists()) {
                    try {
                        byte[] byArray = new byte[(int)file.length()];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        LLJTran.read(fileInputStream, byArray);
                        outputStream.write(byArray);
                        ++this.writecounter;
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (Log.debugLevel < 1) break block9;
                        System.err.println("Exception in reading exif marker " + iOException);
                    }
                }
            }
        }
    }

    protected void writeMarkerComment(OutputStream outputStream, byte[] byArray) throws IOException {
        if (byArray != null && byArray.length > 0) {
            outputStream.write(-1);
            outputStream.write(-2);
            int n = 2;
            outputStream.write((n += byArray.length) >> 8);
            outputStream.write(n & 0xFF);
            outputStream.write(byArray);
            this.writecounter += n + 2;
        }
    }

    protected void writeMarkerComment(OutputStream outputStream, String string, String string2) throws IOException {
        try {
            this.data = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.data = string.getBytes();
        }
        catch (NullPointerException nullPointerException) {
            this.data = string.getBytes();
        }
        this.writeMarkerComment(outputStream, this.data);
    }

    protected void writeMarkerDHT(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        outputStream.write(-1);
        outputStream.write(-60);
        int n2 = 2;
        if (byArray != null) {
            n2 += byArray.length;
        } else {
            for (n = 0; n < this.ac_ix.length; ++n) {
                n2 += 17 + this.ac_huffval[n].length;
            }
            for (n = 0; n < this.dc_ix.length; ++n) {
                n2 += 17 + this.dc_huffval[n].length;
            }
        }
        outputStream.write(n2 >> 8);
        outputStream.write(n2 & 0xFF);
        if (byArray != null) {
            outputStream.write(byArray);
        } else {
            int n3;
            for (n = 0; n < this.dc_ix.length; ++n) {
                outputStream.write(this.dc_ix[n]);
                for (n3 = 0; n3 < this.dc_huffbits[n].length; ++n3) {
                    outputStream.write(this.dc_huffbits[n][n3]);
                }
                for (n3 = 0; n3 < this.dc_huffval[n].length; ++n3) {
                    outputStream.write(this.dc_huffval[n][n3]);
                }
            }
            for (n = 0; n < this.ac_ix.length; ++n) {
                outputStream.write(this.ac_ix[n] + 16);
                for (n3 = 0; n3 < this.ac_huffbits[n].length; ++n3) {
                    outputStream.write(this.ac_huffbits[n][n3]);
                }
                for (n3 = 0; n3 < this.ac_huffval[n].length; ++n3) {
                    outputStream.write(this.ac_huffval[n][n3]);
                }
            }
        }
        this.writecounter += n2 + 2;
    }

    protected void writeMarkerDQT(OutputStream outputStream) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write marker DQT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        outputStream.write(-1);
        outputStream.write(-37);
        int n = 2 + this.q_ix.length * 65;
        outputStream.write(n >> 8);
        outputStream.write(n & 0xFF);
        for (int i = 0; i < this.q_ix.length; ++i) {
            outputStream.write(this.q_ix[i] + (this.q_prec[i] == 8 ? 0 : 16));
            for (int j = 0; j < 64; ++j) {
                outputStream.write(this.q_table[i][j]);
            }
        }
        this.writecounter += n + 2;
    }

    protected void writeMarkerDRI(OutputStream outputStream, int n) throws IOException {
        if (n > 0) {
            outputStream.write(-1);
            outputStream.write(-35);
            outputStream.write(0);
            outputStream.write(4);
            outputStream.write(n >> 8);
            outputStream.write(n & 0xFF);
            this.writecounter += 6;
        }
    }

    protected void writeMarkerSOF0(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-64);
        int n = 8 + this.components_in_frame * 3;
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        outputStream.write(this.frm_precision);
        outputStream.write(this.frm_y >> 8);
        outputStream.write(this.frm_y & 0xFF);
        outputStream.write(this.frm_x >> 8);
        outputStream.write(this.frm_x & 0xFF);
        outputStream.write(this.components_in_frame);
        for (int i = 0; i < this.components_in_frame; ++i) {
            outputStream.write(this.ID[i]);
            outputStream.write((this.H[i] << 4) + this.V[i]);
            outputStream.write(this.QT[i]);
        }
        this.writecounter += n + 2;
    }

    protected void writeMarkerSOS(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-38);
        int n = 3 + this.components_in_scan * 2 + 1 + 1 + 1;
        outputStream.write(n >> 8);
        outputStream.write(n & 0xFF);
        outputStream.write(this.components_in_scan);
        for (int i = 0; i < this.components_in_scan; ++i) {
            outputStream.write(this.comp_ids[i]);
            outputStream.write((this.dc_table[i] << 4) + this.ac_table[i]);
        }
        outputStream.write(this._Ss);
        outputStream.write(this._Se);
        outputStream.write((this._Ah << 4) + this._Al);
        this.writecounter += n + 2;
    }

    protected void writeMarkerEOI(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-39);
        this.writecounter += 2;
    }

    void readRawDCT(InputStream inputStream) throws IOException {
    }

    protected int readDHT(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3 = n;
        if (n3 <= 0) {
            n3 = this.readMarker(inputStream);
        }
        int n4 = 0;
        do {
            int[] nArray;
            int[][][] nArrayArray;
            int[][] nArrayArray2;
            int[][] nArray2;
            boolean bl = (this.data[n4] & 0xFF) > 15;
            int n5 = bl ? (this.data[n4] & 0xFF) - 16 : this.data[n4] & 0xFF;
            int n6 = 0;
            if (!bl) {
                nArray2 = new int[12][2];
                n6 = this.dc_valoffset.length;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.dc_valoffset, 0, nArrayArray2, 0, n6);
                this.dc_valoffset = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.dc_maxcode, 0, nArrayArray2, 0, n6);
                this.dc_maxcode = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.dc_huffval, 0, nArrayArray2, 0, n6);
                this.dc_huffval = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.dc_huffbits, 0, nArrayArray2, 0, n6);
                this.dc_huffbits = nArrayArray2;
                nArrayArray = new int[n6 + 1][][];
                System.arraycopy(this.enc_dc_matrix, 0, nArrayArray, 0, n6);
                this.enc_dc_matrix = nArrayArray;
                nArray = new int[n6 + 1];
                System.arraycopy(this.dc_ix, 0, nArray, 0, n6);
                this.dc_ix = nArray;
                this.dc_ix[n6] = n5;
            } else {
                nArray2 = new int[255][2];
                n6 = this.ac_valoffset.length;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.ac_valoffset, 0, nArrayArray2, 0, n6);
                this.ac_valoffset = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.ac_maxcode, 0, nArrayArray2, 0, n6);
                this.ac_maxcode = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.ac_huffval, 0, nArrayArray2, 0, n6);
                this.ac_huffval = nArrayArray2;
                nArrayArray2 = new int[n6 + 1][];
                System.arraycopy(this.ac_huffbits, 0, nArrayArray2, 0, n6);
                this.ac_huffbits = nArrayArray2;
                nArrayArray = new int[n6 + 1][][];
                System.arraycopy(this.enc_ac_matrix, 0, nArrayArray, 0, n6);
                this.enc_ac_matrix = nArrayArray;
                nArray = new int[n6 + 1];
                System.arraycopy(this.ac_ix, 0, nArray, 0, n6);
                this.ac_ix = nArray;
                this.ac_ix[n6] = n5;
            }
            int[] nArray3 = new int[257];
            int[] nArray4 = new int[257];
            int[] nArray5 = new int[16];
            int n7 = 0;
            for (n2 = 1; n2 <= 16; ++n2) {
                int n8;
                nArray5[n2 - 1] = n8 = this.data[n4 + n2] & 0xFF;
                while (n8-- > 0) {
                    nArray3[n7++] = n2;
                }
            }
            nArray3[n7] = 0;
            n2 = n7;
            int n9 = 0;
            int n10 = nArray3[0];
            n7 = 0;
            while (nArray3[n7] != 0) {
                while (nArray3[n7] == n10) {
                    nArray4[n7++] = n9++;
                }
                if (n9 >= 1 << n10) {
                    throw new IOException("Bad huffman code table (" + this.getLocationName() + ")");
                }
                n9 <<= 1;
                ++n10;
            }
            int[] nArray6 = new int[17];
            int[] nArray7 = new int[18];
            n7 = 0;
            for (int i = 1; i <= 16; ++i) {
                if (this.data[n4 + i] != 0) {
                    nArray6[i] = n7 - nArray4[n7];
                    nArray7[i] = nArray4[(n7 += this.data[n4 + i] & 0xFF) - 1];
                    continue;
                }
                nArray7[i] = -1;
            }
            nArray7[17] = -1;
            int[] nArray8 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray8[i] = this.data[n4 + i + 17] & 0xFF;
                nArray2[nArray8[i]][0] = nArray4[i];
                nArray2[nArray8[i]][1] = nArray3[i];
            }
            if (!bl) {
                this.dc_valoffset[n6] = nArray6;
                this.dc_maxcode[n6] = nArray7;
                this.dc_huffval[n6] = nArray8;
                this.enc_dc_matrix[n6] = nArray2;
                this.dc_huffbits[n6] = nArray5;
                continue;
            }
            this.ac_valoffset[n6] = nArray6;
            this.ac_maxcode[n6] = nArray7;
            this.ac_huffval[n6] = nArray8;
            this.enc_ac_matrix[n6] = nArray2;
            this.ac_huffbits[n6] = nArray5;
        } while ((n4 += n2 + 17) < n3);
        return n3;
    }

    private void initReadDCT() throws IOException {
        this.iReadVars.currentProgress = 0.01;
        this.iReadVars.callbackProgress = 0.0;
        this.iReadVars.last_dc = new int[this.components_in_scan];
        this.iReadVars.DCT = new int[2][64];
        this.iReadVars.next_restart_num = 0;
        this.restarts_to_go = this.restart_interval;
        if ((this._Ss != 0 || this._Se != 63 || this._Ah != 0 || this._Al != 0) && Log.debugLevel >= 1) {
            System.err.println("Not sequential image, Ss=" + this._Ss + " Se=" + this._Se + " Ah=" + this._Ah + " Al=" + this._Al);
        }
        this.decoder = new HuffDecoder(this.iReadVars.is);
        this.dct_coefs = new int[this.heightMCU][][][][];
        this.iReadVars.progressPerMcu = 0.99 / (double)this.heightMCU / (double)this.widthMCU;
        if (this.readProgressCallback != null && this.iReadVars.currentProgress - this.iReadVars.callbackProgress > this.readProgressCallback.getCallbackInterval()) {
            this.iReadVars.callbackProgress = this.iReadVars.currentProgress;
            this.readProgressCallback.progressHandler(this.iReadVars.callbackProgress, (int)Math.round(this.iReadVars.callbackProgress * 100.0));
        }
        this.iReadVars.ix = 0;
        this.iReadVars.iy = 0;
    }

    private boolean readNextDCT(int n) throws IOException {
        int n2;
        InputStream inputStream = this.iReadVars.is;
        int n3 = this.iReadVars.ix;
        int n4 = this.readcounter;
        int[] nArray = this.iReadVars.last_dc;
        int[][] nArray2 = this.iReadVars.DCT;
        int n5 = this.iReadVars.next_restart_num;
        double d = this.iReadVars.currentProgress;
        double d2 = this.iReadVars.progressPerMcu;
        double d3 = this.iReadVars.callbackProgress;
        boolean bl = true;
        block2: for (n2 = this.iReadVars.iy; n2 < this.heightMCU; ++n2) {
            if (this.dct_coefs[n2] == null) {
                this.dct_coefs[n2] = new int[this.widthMCU][this.mcusize][][];
            }
            while (n3 < this.widthMCU) {
                block24: {
                    if (this.readcounter - n4 >= n) break block2;
                    int n6 = 0;
                    try {
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.components_in_scan; ++n8) {
                            for (n7 = 0; n7 < this.V[n8] * this.H[n8]; ++n7) {
                                this.decoder.setTables(false, this.dc_table[n8]);
                                nArray[n8] = this.decoder.extend(this.decoder.decode(1)) + nArray[n8];
                                int n9 = 0;
                                nArray2[0][n9] = nArray[n8];
                                nArray2[1][n9++] = 0;
                                this.decoder.setTables(true, this.ac_table[n8]);
                                for (int i = 1; i < 64; ++i) {
                                    int n10 = this.decoder.decode(1);
                                    int n11 = n10 >> 4;
                                    if ((n10 &= 0xF) != 0) {
                                        if ((i += n11) > 63) {
                                            if (Log.debugLevel >= 1) {
                                                System.err.println("Error: Invalid AC index " + i);
                                            }
                                            i = 63;
                                        }
                                        nArray2[0][n9] = n10 = this.decoder.extend(n10);
                                        nArray2[1][n9++] = i;
                                        continue;
                                    }
                                    if (n11 != 15) break;
                                    i += n11;
                                }
                                this.dct_coefs[n2][n3][n6] = new int[2][n9];
                                System.arraycopy(nArray2[0], 0, this.dct_coefs[n2][n3][n6][0], 0, n9);
                                System.arraycopy(nArray2[1], 0, this.dct_coefs[n2][n3][n6][1], 0, n9);
                                ++n6;
                            }
                        }
                        --this.restarts_to_go;
                        if (this.restart_interval != 0 && this.restarts_to_go == 0) {
                            n8 = this.unprocessed_marker;
                            this.unprocessed_marker = 0;
                            if (n8 == 0) {
                                n8 = inputStream.read();
                                ++this.readcounter;
                                if (n8 != 255) {
                                    throw new IOException("0x" + Integer.toHexString(n8) + " found instead of restart marker prefix 0xff at 0x" + Integer.toHexString(this.readcounter) + " (" + this.getLocationName() + ")");
                                }
                                do {
                                    n8 = inputStream.read();
                                    ++this.readcounter;
                                } while (n8 == 255);
                            }
                            if (n8 == 208 + n5) {
                                n5 = n5 + 1 & 7;
                            } else if (n2 == this.heightMCU - 1 && n3 == this.widthMCU - 1) {
                                this.unprocessed_marker = n8;
                            } else {
                                throw new IOException("Restart markers are messed up at " + this.readcounter + "(0x" + Integer.toHexString(this.readcounter) + ") (" + this.getLocationName() + ")");
                            }
                            this.restarts_to_go = this.restart_interval;
                            for (n7 = 0; n7 < nArray.length; ++n7) {
                                nArray[n7] = 0;
                            }
                            this.decoder.restart();
                        } else if (this.unprocessed_marker != 0) {
                            throw new IOException("Unexpected Restart marker 0x" + Integer.toHexString(this.unprocessed_marker) + " with restart_interval=" + this.restart_interval + " and restarts_to_go=" + this.restarts_to_go + " at " + Integer.toHexString(this.readcounter) + " (" + this.getLocationName() + ")");
                        }
                    }
                    catch (RestartException restartException) {
                        this.restarts_to_go = 0;
                        if (Log.debugLevel < 3) break block24;
                        System.out.println("Restart exception ");
                    }
                }
                d += d2;
                if (this.readProgressCallback != null && d - d3 > this.readProgressCallback.getCallbackInterval()) {
                    d3 = d;
                    this.readProgressCallback.progressHandler(d3, (int)Math.round(d3 * 100.0));
                }
                ++n3;
            }
            n3 = 0;
        }
        this.iReadVars.ix = n3;
        this.iReadVars.iy = n2;
        this.iReadVars.next_restart_num = n5;
        this.iReadVars.currentProgress = d;
        this.iReadVars.callbackProgress = d3;
        if (n2 >= this.heightMCU) {
            bl = false;
            this.iReadVars.last_dc = null;
            this.iReadVars.DCT = null;
            this.decoder = null;
        }
        return bl;
    }

    protected void readDCT(InputStream inputStream) throws IOException {
        this.iReadVars.is = inputStream;
        this.initReadDCT();
        while (this.readNextDCT(10000000)) {
        }
    }

    private void transposeImageParameters() {
        int n = this.frm_x;
        this.frm_x = this.frm_y;
        this.frm_y = n;
        for (int i = 0; i < this.components_in_scan; ++i) {
            n = this.V[i];
            this.V[i] = this.H[i];
            this.H[i] = n;
        }
        n = this.widthMCU;
        this.widthMCU = this.heightMCU;
        this.heightMCU = n;
        n = this.maxHi;
        this.maxHi = this.maxVi;
        this.maxVi = n;
    }

    private void transposeQTable() {
        for (int i = 0; i < this.q_table.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < j; ++k) {
                    int n = this.q_table[i][jpegzigzagorder[j * 8 + k]];
                    this.q_table[i][LLJTran.jpegzigzagorder[j * 8 + k]] = this.q_table[i][jpegzigzagorder[k * 8 + j]];
                    this.q_table[i][LLJTran.jpegzigzagorder[k * 8 + j]] = n;
                }
            }
        }
    }

    private void initWriteDCT(OutputStream outputStream, int n, int n2, int n3, boolean bl) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write DCT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        this.iWriteVars.os = outputStream;
        this.iWriteVars.op = n;
        this.iWriteVars.options = n2;
        this.iWriteVars.restart_interval = n3;
        this.iWriteVars.transformDct = bl;
        this.iWriteVars.new_dct_coefs = null;
        this.iWriteVars.currentProgress = 0.01;
        this.iWriteVars.callbackProgress = 0.0;
        this.iWriteVars.last_dc = null;
        this.encoder = null;
        this.iWriteVars.restarts_to_go = n3;
        boolean bl2 = (n2 & 8) != 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        if (bl2) {
            bl3 = this.partialXMCU;
            bl4 = this.partialYMCU;
        }
        if (this.widthMCU != this.dct_coefs[0].length || n == 3 || n == 5 || n == 7 || n == 4) {
            bl5 = false;
        }
        this.iWriteVars.handleXEdge = bl3;
        this.iWriteVars.handleYEdge = bl4;
        this.iWriteVars.progressPerMcu = 0.99 / (double)this.dct_coefs.length / (double)this.dct_coefs[0].length;
        if (!bl && this.writeProgressCallback != null && this.iWriteVars.currentProgress - this.iWriteVars.callbackProgress > this.writeProgressCallback.getCallbackInterval()) {
            this.iWriteVars.callbackProgress = this.iWriteVars.currentProgress;
            this.writeProgressCallback.progressHandler(this.iWriteVars.callbackProgress, (int)Math.round(this.iWriteVars.callbackProgress * 100.0));
        }
        if (bl) {
            if (bl5) {
                this.iWriteVars.new_dct_coefs = new int[this.heightMCU][][][][];
                if (this.heightMCU > 0) {
                    this.iWriteVars.new_dct_coefs[0] = new int[this.widthMCU][][][];
                }
            } else {
                this.iWriteVars.new_dct_coefs = new int[this.heightMCU][this.widthMCU][][][];
            }
            if (this.heightMCU > 0 && this.widthMCU > 0) {
                this.iWriteVars.new_dct_coefs[0][0] = new int[this.mcusize][][];
            }
        } else {
            bl5 = false;
            this.iWriteVars.last_dc = new int[this.components_in_scan];
            this.encoder = new HuffEncoder(outputStream);
        }
        this.retainDct = !bl;
        int n4 = 0;
        int n5 = 0;
        if (n == 8) {
            n4 = this.cropBounds.x / this.getMCUWidth();
            n5 = this.cropBounds.y / this.getMCUHeight();
        }
        this.iWriteVars.reuseDctRows = bl5;
        this.iWriteVars.xCropOffsetMCU = n4;
        this.iWriteVars.yCropOffsetMCU = n5;
        this.iWriteVars.new_ix = 0;
        this.iWriteVars.new_iy = 0;
    }

    private boolean writeNextDCT(int n) throws IOException {
        boolean bl = true;
        OutputStream outputStream = this.iWriteVars.os;
        int n2 = this.iWriteVars.op;
        int n3 = this.iWriteVars.options;
        boolean bl2 = this.iWriteVars.transformDct;
        int[][][][][] nArray = this.iWriteVars.new_dct_coefs;
        int[][][] nArray2 = null;
        int[] nArray3 = this.iWriteVars.last_dc;
        boolean bl3 = this.iWriteVars.handleXEdge;
        boolean bl4 = this.iWriteVars.handleYEdge;
        boolean bl5 = this.iWriteVars.reuseDctRows;
        int n4 = this.iWriteVars.xCropOffsetMCU;
        int n5 = this.iWriteVars.yCropOffsetMCU;
        int n6 = 0;
        int n7 = this.iWriteVars.new_ix;
        int n8 = this.iWriteVars.new_iy;
        int[][][][] nArray4 = null;
        int n9 = this.writecounter;
        int n10 = this.iWriteVars.restart_interval;
        int n11 = this.iWriteVars.restarts_to_go;
        double d = this.iWriteVars.currentProgress;
        double d2 = this.iWriteVars.callbackProgress;
        double d3 = this.iWriteVars.progressPerMcu;
        boolean bl6 = this.iWriteVars.pullDownMode;
        if (bl2 && n8 < this.heightMCU) {
            nArray4 = nArray[n8];
            if (n7 < this.widthMCU) {
                nArray2 = nArray[n8][n7];
            }
        }
        block21: while (n8 < this.heightMCU) {
            if (bl5) {
                nArray[n8] = nArray4;
            }
            while (n7 < this.widthMCU) {
                int n12;
                if (bl2) {
                    nArray[n8][n7] = nArray2;
                }
                if (this.writecounter - n9 >= n) break block21;
                int n13 = 0;
                int n14 = 0;
                int n15 = n2;
                switch (n2) {
                    case 3: {
                        n12 = n8;
                        n6 = n7;
                        break;
                    }
                    case 5: {
                        n12 = n8;
                        n6 = this.widthMCU - 1 - n7;
                        if (!bl4) break;
                        if (n6 > 0) {
                            --n6;
                            break;
                        }
                        n6 = this.widthMCU - 1;
                        n15 = 3;
                        break;
                    }
                    case 7: {
                        n12 = this.heightMCU - 1 - n8;
                        n6 = n7;
                        if (!bl3) break;
                        if (n12 > 0) {
                            --n12;
                            break;
                        }
                        n12 = this.heightMCU - 1;
                        n15 = 3;
                        break;
                    }
                    case 4: {
                        n12 = this.heightMCU - 1 - n8;
                        n6 = this.widthMCU - 1 - n7;
                        if (bl3) {
                            if (n12 > 0) {
                                --n12;
                            } else {
                                n12 = this.heightMCU - 1;
                                n15 = 5;
                            }
                        }
                        if (!bl4) break;
                        if (n6 > 0) {
                            --n6;
                            break;
                        }
                        n6 = this.widthMCU - 1;
                        n15 = n15 == 4 ? 7 : 3;
                        break;
                    }
                    case 1: {
                        n12 = this.widthMCU - 1 - n7;
                        n6 = n8;
                        if (!bl3) break;
                        if (n12 > 0) {
                            --n12;
                            break;
                        }
                        n12 = this.widthMCU - 1;
                        n15 = 0;
                        break;
                    }
                    case 2: {
                        n12 = n7;
                        n6 = this.heightMCU - 1 - n8;
                        if (!bl4) break;
                        if (n6 > 0) {
                            --n6;
                            break;
                        }
                        n6 = this.heightMCU - 1;
                        n15 = 0;
                        break;
                    }
                    case 6: {
                        n12 = this.widthMCU - 1 - n7;
                        n6 = this.heightMCU - 1 - n8;
                        if (bl3) {
                            if (n12 > 0) {
                                --n12;
                            } else {
                                n12 = this.widthMCU - 1;
                                n15 = 2;
                            }
                        }
                        if (!bl4) break;
                        if (n6 > 0) {
                            --n6;
                            break;
                        }
                        n6 = this.heightMCU - 1;
                        n15 = n15 == 6 ? 1 : 0;
                        break;
                    }
                    case 8: {
                        n12 = n7 + n4;
                        n6 = n8 + n5;
                        n15 = 0;
                        break;
                    }
                    default: {
                        n12 = n7;
                        n6 = n8;
                    }
                }
                int[][][] nArray5 = this.dct_coefs[n6][n12];
                try {
                    int n16;
                    for (n16 = 0; n16 < this.components_in_scan; ++n16) {
                        if (!bl2) {
                            this.encoder.setTables(this.ac_table[n16], this.dc_table[n16]);
                        }
                        switch (n15) {
                            case 3: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < this.V[n16]; ++n18) {
                                    for (n17 = 0; n17 < this.H[n16]; ++n17) {
                                        nArray7 = nArray5[n13 + n17 * this.V[n16] + n18];
                                        nArray6 = this.transposeDCT(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < this.V[n16]; ++n18) {
                                    for (n17 = this.H[n16] - 1; n17 >= 0; --n17) {
                                        nArray7 = nArray5[n13 + n17 * this.V[n16] + n18];
                                        nArray6 = this.rotate90DCT(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 7: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = this.V[n16] - 1; n18 >= 0; --n18) {
                                    for (n17 = 0; n17 < this.H[n16]; ++n17) {
                                        nArray7 = nArray5[n13 + n17 * this.V[n16] + n18];
                                        nArray6 = this.rotate270DCT(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = this.V[n16] - 1; n18 >= 0; --n18) {
                                    for (n17 = this.H[n16] - 1; n17 >= 0; --n17) {
                                        nArray7 = nArray5[n13 + n17 * this.V[n16] + n18];
                                        nArray6 = this.transverseDCT(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 1: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < this.V[n16]; ++n18) {
                                    for (n17 = this.H[n16] - 1; n17 >= 0; --n17) {
                                        nArray7 = nArray5[n13 + n18 * this.H[n16] + n17];
                                        nArray6 = this.flipHDct(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = this.V[n16] - 1; n18 >= 0; --n18) {
                                    for (n17 = 0; n17 < this.H[n16]; ++n17) {
                                        nArray7 = nArray5[n13 + n18 * this.H[n16] + n17];
                                        nArray6 = this.flipVDct(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int[][] nArray6;
                                int[][] nArray7;
                                int n17;
                                int n18;
                                for (n18 = this.V[n16] - 1; n18 >= 0; --n18) {
                                    for (n17 = this.H[n16] - 1; n17 >= 0; --n17) {
                                        nArray7 = nArray5[n13 + n18 * this.H[n16] + n17];
                                        nArray6 = this.rotate180Dct(nArray7);
                                        if (bl2) {
                                            nArray2[n14++] = nArray6;
                                            continue;
                                        }
                                        nArray3[n16] = this.encoder.encode(nArray6, nArray3[n16], nArray7[0].length);
                                    }
                                }
                                break;
                            }
                            default: {
                                int n18;
                                for (n18 = 0; n18 < this.V[n16] * this.H[n16]; ++n18) {
                                    int[][] nArray8 = nArray5[n13 + n18];
                                    if (bl2) {
                                        nArray2[n14++] = nArray8;
                                        continue;
                                    }
                                    nArray3[n16] = this.encoder.encode(nArray8, nArray3[n16], nArray8[0].length);
                                }
                            }
                        }
                        n13 += this.V[n16] * this.H[n16];
                    }
                    if (bl2) {
                        nArray2 = nArray5;
                    } else {
                        if (n10 != 0 && --n11 == 0) {
                            n11 = n10;
                            if (this._Ss == 0) {
                                for (n16 = 0; n16 < nArray3.length; ++n16) {
                                    nArray3[n16] = 0;
                                }
                            }
                            this.encoder.restart();
                        }
                        d += d3;
                        if (this.writeProgressCallback != null && d - d2 > this.writeProgressCallback.getCallbackInterval()) {
                            d2 = d;
                            this.writeProgressCallback.progressHandler(d2, (int)Math.round(d2 * 100.0));
                        }
                    }
                }
                catch (RestartException restartException) {
                    n11 = 0;
                }
                ++n7;
            }
            n7 = 0;
            nArray4 = this.dct_coefs[n6];
            if (bl6) {
                this.dct_coefs[n6] = null;
            }
            ++n8;
        }
        this.iWriteVars.new_ix = n7;
        this.iWriteVars.new_iy = n8;
        this.iWriteVars.restarts_to_go = n11;
        this.iWriteVars.currentProgress = d;
        this.iWriteVars.callbackProgress = d2;
        if (n8 >= this.heightMCU) {
            bl = false;
            if (bl2) {
                this.dct_coefs = nArray;
            } else {
                this.encoder.flush();
            }
            this.encoder = null;
        }
        return bl;
    }

    private void writeDCT(OutputStream outputStream, int n, int n2, int n3, boolean bl) throws IOException {
        this.initWriteDCT(outputStream, n, n2, n3, bl);
        while (this.writeNextDCT(10000000)) {
        }
    }

    private static void copyDct(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(nArray[i], 0, nArray2[i], 0, nArray[i].length);
        }
    }

    private static void compactDct(int[] nArray, int[][] nArray2) {
        int n = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            nArray2[1][n] = i;
            nArray2[0][n] = nArray[i];
            ++n;
        }
    }

    protected int[][] transposeDCT(int[][] nArray) {
        int n;
        int[] nArray2 = this.tmp_dct[0];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < nArray[0].length; ++n) {
            int n2 = jpegnaturalorder[nArray[1][n]];
            n2 = ((n2 & 7) << 3) + (n2 >> 3);
            nArray2[LLJTran.jpegzigzagorder[n2]] = nArray[0][n];
        }
        int[][] nArray3 = this.retainDct ? this.tmp_dct : nArray;
        LLJTran.compactDct(nArray2, nArray3);
        return nArray3;
    }

    protected int[][] rotate90DCT(int[][] nArray) {
        int n;
        int[] nArray2 = this.tmp_dct[0];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < nArray[0].length; ++n) {
            int n2 = jpegnaturalorder[nArray[1][n]];
            n2 = ((n2 & 7) << 3) + (n2 >> 3);
            nArray2[LLJTran.jpegzigzagorder[n2]] = (n2 & 1) == 1 ? -nArray[0][n] : nArray[0][n];
        }
        int[][] nArray3 = this.retainDct ? this.tmp_dct : nArray;
        LLJTran.compactDct(nArray2, nArray3);
        return nArray3;
    }

    protected int[][] rotate270DCT(int[][] nArray) {
        int n;
        int[] nArray2 = this.tmp_dct[0];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < nArray[0].length; ++n) {
            int n2 = jpegnaturalorder[nArray[1][n]];
            n2 = ((n2 & 7) << 3) + (n2 >> 3);
            nArray2[LLJTran.jpegzigzagorder[n2]] = (n2 & 8) == 8 ? -nArray[0][n] : nArray[0][n];
        }
        int[][] nArray3 = this.retainDct ? this.tmp_dct : nArray;
        LLJTran.compactDct(nArray2, nArray3);
        return nArray3;
    }

    protected int[][] transverseDCT(int[][] nArray) {
        int n;
        int[] nArray2 = this.tmp_dct[0];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < nArray[0].length; ++n) {
            int n2 = jpegnaturalorder[nArray[1][n]];
            boolean bl = (n2 & 1) != 0;
            n2 = ((n2 & 7) << 3) + (n2 >> 3);
            nArray2[LLJTran.jpegzigzagorder[n2]] = (bl ^= (n2 & 1) != 0) ? -nArray[0][n] : nArray[0][n];
        }
        int[][] nArray3 = this.retainDct ? this.tmp_dct : nArray;
        LLJTran.compactDct(nArray2, nArray3);
        return nArray3;
    }

    protected int[][] flipHDct(int[][] nArray) {
        int[][] nArray2 = nArray;
        int n = nArray[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(nArray, this.tmp_dct);
            nArray2 = this.tmp_dct;
        }
        for (int i = 0; i < n; ++i) {
            if ((jpegnaturalorder[nArray2[1][i]] & 1) == 0) continue;
            nArray2[0][i] = -nArray2[0][i];
        }
        return nArray2;
    }

    protected int[][] flipVDct(int[][] nArray) {
        int[][] nArray2 = nArray;
        int n = nArray[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(nArray, this.tmp_dct);
            nArray2 = this.tmp_dct;
        }
        for (int i = 0; i < n; ++i) {
            if ((jpegnaturalorder[nArray2[1][i]] & 8) != 8) continue;
            nArray2[0][i] = -nArray2[0][i];
        }
        return nArray2;
    }

    protected int[][] rotate180Dct(int[][] nArray) {
        int[][] nArray2 = nArray;
        int n = nArray[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(nArray, this.tmp_dct);
            nArray2 = this.tmp_dct;
        }
        for (int i = 0; i < n; ++i) {
            if ((jpegnaturalorder[nArray2[1][i]] & 9) != 1 && (jpegnaturalorder[nArray2[1][i]] & 9) != 8) continue;
            nArray2[0][i] = -nArray2[0][i];
        }
        return nArray2;
    }

    public int getRequestSize(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.iReadVars.minReadRequest;
                break;
            }
            case 1: {
                n2 = this.iReadVars.maxReadRequest;
                break;
            }
            case 2: {
                n2 = this.iWriteVars.minWriteRequest;
                break;
            }
            case 3: {
                n2 = this.iWriteVars.maxWriteRequest;
                break;
            }
        }
        return n2;
    }

    private class RestartException
    extends Exception {
        int scan;

        RestartException(int n) {
            this.scan = n;
        }
    }

    private class HuffGenerator {
        private int[][] dc_count;
        private int[][] ac_count;

        public void init() {
            this.dc_count = new int[LLJTran.this.dc_ix.length][257];
            this.ac_count = new int[LLJTran.this.ac_ix.length][257];
        }

        public void freeMemory() {
            this.dc_count = null;
            this.ac_count = null;
        }

        public void updateDCCount(int n, int n2) {
            int[] nArray = this.dc_count[n];
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }

        public void updateACCount(int n, int n2) {
            int[] nArray = this.ac_count[n];
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }

        private void genOptimalTable(OutputStream outputStream, int[] nArray) throws IOException {
            int n;
            int n2;
            int[] nArray2 = new int[33];
            int[] nArray3 = new int[257];
            int[] nArray4 = new int[257];
            for (n2 = 0; n2 < 257; ++n2) {
                nArray4[n2] = -1;
            }
            nArray[256] = 1;
            block1: while (true) {
                int n3 = -1;
                int n4 = 1000000000;
                for (n2 = 0; n2 <= 256; ++n2) {
                    if (nArray[n2] <= 0 || nArray[n2] > n4) continue;
                    n4 = nArray[n2];
                    n3 = n2;
                }
                int n5 = -1;
                n4 = 1000000000;
                for (n2 = 0; n2 <= 256; ++n2) {
                    if (nArray[n2] <= 0 || nArray[n2] > n4 || n2 == n3) continue;
                    n4 = nArray[n2];
                    n5 = n2;
                }
                if (n5 < 0) break;
                int n6 = n3;
                nArray[n6] = nArray[n6] + nArray[n5];
                nArray[n5] = 0;
                int n7 = n3;
                nArray3[n7] = nArray3[n7] + 1;
                while (nArray4[n3] >= 0) {
                    int n8 = n3 = nArray4[n3];
                    nArray3[n8] = nArray3[n8] + 1;
                }
                nArray4[n3] = n5;
                int n9 = n5;
                nArray3[n9] = nArray3[n9] + 1;
                while (true) {
                    if (nArray4[n5] < 0) continue block1;
                    int n10 = n5 = nArray4[n5];
                    nArray3[n10] = nArray3[n10] + 1;
                }
                break;
            }
            for (n2 = 0; n2 <= 256; ++n2) {
                if (nArray3[n2] <= 0) continue;
                if (nArray3[n2] > 32) {
                    throw new RuntimeException("Internal Error regenerating Huff Tables: Code Length " + nArray3[n2] + " for symbol " + n2 + " > 32");
                }
                int n11 = nArray3[n2];
                nArray2[n11] = nArray2[n11] + 1;
            }
            for (n2 = 32; n2 > 16; --n2) {
                while (nArray2[n2] > 0) {
                    n = n2 - 2;
                    while (nArray2[n] == 0) {
                        --n;
                    }
                    int n12 = n2;
                    nArray2[n12] = nArray2[n12] - 2;
                    int n13 = n2 - 1;
                    nArray2[n13] = nArray2[n13] + 1;
                    int n14 = n + 1;
                    nArray2[n14] = nArray2[n14] + 2;
                    int n15 = n;
                    nArray2[n15] = nArray2[n15] - 1;
                }
            }
            while (nArray2[n2] == 0) {
                --n2;
            }
            int n16 = n2;
            nArray2[n16] = nArray2[n16] - 1;
            for (n2 = 1; n2 <= 16; ++n2) {
                outputStream.write(nArray2[n2]);
            }
            for (n2 = 1; n2 <= 32; ++n2) {
                for (n = 0; n <= 255; ++n) {
                    if (nArray3[n] != n2) continue;
                    outputStream.write(n);
                }
            }
        }

        private void writeHuffTables(OutputStream outputStream) throws IOException {
            int n;
            int n2;
            for (n2 = 0; n2 < LLJTran.this.dc_ix.length; ++n2) {
                n = LLJTran.this.dc_ix[n2];
                outputStream.write(n);
                this.genOptimalTable(outputStream, this.dc_count[n2]);
            }
            for (n2 = 0; n2 < LLJTran.this.ac_ix.length; ++n2) {
                n = 16 + LLJTran.this.ac_ix[n2];
                outputStream.write(n);
                this.genOptimalTable(outputStream, this.ac_count[n2]);
            }
        }
    }

    private class HuffEncoder {
        private int bufferputbits;
        private int bufferputbuffer;
        private OutputStream outputstream;
        private int[][] dc_ecodetable;
        private int[][] ac_ecodetable;
        int next_restart_num;
        int acTblIndex;
        int dcTblIndex;

        public HuffEncoder(OutputStream outputStream) {
            this.outputstream = outputStream;
        }

        void setTables(int n, int n2) {
            int n3;
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = 0; n3 < LLJTran.this.ac_ix.length; ++n3) {
                if (LLJTran.this.ac_ix[n3] != n) continue;
                if (!LLJTran.this.gatheringStats) {
                    this.ac_ecodetable = LLJTran.this.enc_ac_matrix[n3];
                }
                this.acTblIndex = n3;
                bl2 = true;
                break;
            }
            for (n3 = 0; n3 < LLJTran.this.dc_ix.length; ++n3) {
                if (LLJTran.this.dc_ix[n3] != n2) continue;
                if (!LLJTran.this.gatheringStats) {
                    this.dc_ecodetable = LLJTran.this.enc_dc_matrix[n3];
                }
                this.dcTblIndex = n3;
                bl = true;
                break;
            }
            if (!(bl2 && bl || Log.debugLevel < 1)) {
                System.err.println("One of tables not found for a " + n + " " + bl2 + " d " + n2 + " " + bl);
            }
        }

        int encode(int[][] nArray, int n, int n2) throws IOException, RestartException {
            if (nArray == null || nArray[0] == null) {
                throw new RestartException(0);
            }
            int n3 = nArray[0][0] - n;
            int n4 = n3;
            if (n4 < 0) {
                n4 = -n4;
                --n3;
            }
            int n5 = 0;
            while (n4 != 0) {
                ++n5;
                n4 >>= 1;
            }
            if (LLJTran.this.gatheringStats) {
                LLJTran.this.huffGen.updateDCCount(this.dcTblIndex, n5);
            } else {
                this.writeCode(this.dc_ecodetable[n5][0], this.dc_ecodetable[n5][1]);
            }
            if (n5 != 0) {
                this.writeCode(n3, n5);
            }
            for (int i = 1; i < n2; ++i) {
                int n6;
                for (n6 = nArray[1][i] - nArray[1][i - 1] - 1; n6 > 15; n6 -= 16) {
                    if (LLJTran.this.gatheringStats) {
                        LLJTran.this.huffGen.updateACCount(this.acTblIndex, 240);
                        continue;
                    }
                    this.writeCode(this.ac_ecodetable[240][0], this.ac_ecodetable[240][1]);
                }
                n3 = nArray[0][i];
                n4 = n3;
                if (n4 < 0) {
                    n4 = -n4;
                    --n3;
                }
                n5 = 1;
                while ((n4 >>= 1) != 0) {
                    ++n5;
                }
                int n7 = (n6 << 4) + n5;
                if (LLJTran.this.gatheringStats) {
                    LLJTran.this.huffGen.updateACCount(this.acTblIndex, n7);
                } else {
                    this.writeCode(this.ac_ecodetable[n7][0], this.ac_ecodetable[n7][1]);
                }
                this.writeCode(n3, n5);
            }
            if (63 - nArray[1][n2 - 1] > 0) {
                if (LLJTran.this.gatheringStats) {
                    LLJTran.this.huffGen.updateACCount(this.acTblIndex, 0);
                } else {
                    this.writeCode(this.ac_ecodetable[0][0], this.ac_ecodetable[0][1]);
                }
            }
            return nArray[0][0];
        }

        void restart() throws IOException {
            if (LLJTran.this.gatheringStats) {
                return;
            }
            this.flush();
            this.outputstream.write(-1);
            this.outputstream.write(208 + this.next_restart_num);
            LLJTran.this.writecounter += 2;
            this.next_restart_num = this.next_restart_num + 1 & 7;
            this.bufferputbuffer = 0;
            this.bufferputbits = 0;
        }

        void writeCode(int n, int n2) throws IOException {
            if (LLJTran.this.gatheringStats) {
                return;
            }
            if (n2 == 0) {
                throw new RuntimeException("Runtime Error: Missing Huffman Table Entry");
            }
            int n3 = n;
            int n4 = this.bufferputbits;
            n3 &= (1 << n2) - 1;
            n3 <<= 24 - (n4 += n2);
            n3 |= this.bufferputbuffer;
            while (n4 >= 8) {
                int n5 = n3 >> 16 & 0xFF;
                this.outputstream.write(n5);
                ++LLJTran.this.writecounter;
                if (n5 == 255) {
                    this.outputstream.write(0);
                    ++LLJTran.this.writecounter;
                }
                n3 <<= 8;
                n4 -= 8;
            }
            this.bufferputbuffer = n3;
            this.bufferputbits = n4;
        }

        void flush() throws IOException {
            int n;
            int n2;
            if (LLJTran.this.gatheringStats) {
                return;
            }
            int n3 = this.bufferputbuffer;
            for (n2 = this.bufferputbits; n2 >= 8; n2 -= 8) {
                n = n3 >> 16 & 0xFF;
                this.outputstream.write(n);
                ++LLJTran.this.writecounter;
                if (n == 255) {
                    this.outputstream.write(0);
                    ++LLJTran.this.writecounter;
                }
                n3 <<= 8;
            }
            if (n2 > 0) {
                n = n3 >> 16 & 65280 >> n2 & 0xFF;
                this.outputstream.write(n);
                ++LLJTran.this.writecounter;
            }
            this.bufferputbuffer = n3;
            this.bufferputbits = n2;
        }
    }

    private class HuffDecoder {
        private InputStream is;
        int bit_buff;
        int bit_buff_len;
        int marker;
        int next_restart_num;
        int[] cur_maxcode;
        int[] cur_huffval;
        int[] cur_valoffset;

        HuffDecoder(InputStream inputStream) {
            this.is = inputStream;
        }

        void setTables(boolean bl, int n) {
            if (bl) {
                for (int i = 0; i < LLJTran.this.ac_ix.length; ++i) {
                    if (LLJTran.this.ac_ix[i] != n) continue;
                    this.cur_maxcode = LLJTran.this.ac_maxcode[i];
                    this.cur_huffval = LLJTran.this.ac_huffval[i];
                    this.cur_valoffset = LLJTran.this.ac_valoffset[i];
                    break;
                }
            } else {
                for (int i = 0; i < LLJTran.this.dc_ix.length; ++i) {
                    if (LLJTran.this.dc_ix[i] != n) continue;
                    this.cur_maxcode = LLJTran.this.dc_maxcode[i];
                    this.cur_huffval = LLJTran.this.dc_huffval[i];
                    this.cur_valoffset = LLJTran.this.dc_valoffset[i];
                    break;
                }
            }
        }

        void checkBitBuffer(int n) throws IOException, RestartException {
            if (this.bit_buff_len < n) {
                if (n > 16) {
                    throw new IOException("An attempt to read more than 16 bit (inbuff=" + this.bit_buff_len + ", len=" + n + ") (" + LLJTran.this.getLocationName() + ")");
                }
                do {
                    int n2 = this.read();
                    if (LLJTran.this.unprocessed_marker != 0) break;
                    this.bit_buff <<= 8;
                    this.bit_buff |= n2;
                    this.bit_buff_len += 8;
                } while (this.bit_buff_len < n);
            }
        }

        int read() throws IOException, RestartException {
            int n = -1;
            if (LLJTran.this.unprocessed_marker == 0) {
                n = this.is.read();
                ++LLJTran.this.readcounter;
                if (n == -1) {
                    throw new IOException("End of file reached at " + LLJTran.this.readcounter + " (" + LLJTran.this.getLocationName() + ")");
                }
                if (n == 255) {
                    do {
                        n = this.is.read();
                        ++LLJTran.this.readcounter;
                    } while (n == 255);
                    if (n == 0) {
                        n = 255;
                    } else {
                        LLJTran.this.unprocessed_marker = n;
                    }
                }
            }
            return n;
        }

        int getBits(int n) throws IOException, RestartException {
            int n2 = 0;
            this.checkBitBuffer(n);
            if (this.bit_buff_len > 0) {
                if (this.bit_buff_len >= n) {
                    this.bit_buff_len -= n;
                    n2 = this.bit_buff >> this.bit_buff_len & 65535 >> 16 - n;
                } else {
                    int n3 = n - this.bit_buff_len;
                    this.bit_buff_len = 0;
                    n2 = this.bit_buff << n3 & 65535 >> 16 - n;
                }
            }
            return n2;
        }

        int extend(int n) throws IOException, RestartException {
            if (n == 0) {
                return 0;
            }
            int n2 = this.getBits(n);
            return n2 < 1 << n - 1 ? n2 + ((-1 << n) + 1) : n2;
        }

        int decode(int n) throws IOException, RestartException {
            int n2;
            int n3 = n;
            for (n2 = this.getBits(n3); n2 > this.cur_maxcode[n3]; n2 |= this.getBits(1)) {
                if (n2 < 0 && Log.debugLevel >= 1) {
                    System.err.println("Negative code 0x" + Integer.toHexString(n2) + " max 0x" + Integer.toHexString(this.cur_maxcode[n3]));
                }
                n2 <<= 1;
                if (++n3 <= 16) continue;
                throw new IOException("Corrupted JPEG data: bad Huffman code, 0x" + Integer.toHexString(n2) + " max 0x" + Integer.toHexString(this.cur_maxcode[n3]) + " at 0x" + Integer.toHexString(LLJTran.this.readcounter) + " (" + LLJTran.this.getLocationName() + ")");
            }
            return this.cur_huffval[n2 + this.cur_valoffset[n3]];
        }

        void restart() {
            this.bit_buff_len = 0;
            this.bit_buff = 0;
        }
    }
}

