/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.DirectoryEntry;
import mediautil.image.jpeg.Header;
import mediautil.image.jpeg.LLJTran;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flashpix
extends AbstractImageInfo<LLJTran> {
    public static final String FORMAT = "Flashpix";
    static final int HEADER_LENGTH = 512;
    static final byte[] SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    Header header;
    byte[] fat;
    Icon icon;

    public Flashpix() {
    }

    public Flashpix(InputStream inputStream, byte[] byArray, int n, String string, LLJTran lLJTran) throws FileFormatException {
        super(inputStream, byArray, n, string, null, lLJTran);
    }

    @Override
    public void readInfo() throws FileFormatException {
        block10: {
            try {
                this.data = new byte[504];
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                this.header = new Header();
                this.header.fill(this.data, -8);
                this.intel = this.header.intelByteOrder;
                if (Log.debugLevel >= 4) {
                    System.out.println("Header " + this.header.toString() + " of " + this.getName());
                }
                Flashpix.skip(this.is, this.header.fat[0] * this.header.sectorSize);
                this.offset += this.header.fat[0] * this.header.sectorSize;
                this.data = new byte[this.header.sectorSize];
                for (int i = 0; i < this.header.sectsFat; ++i) {
                    if (Log.debugLevel < 4) continue;
                    System.out.println("Fat sector [" + i + "]=" + this.header.fat[i]);
                }
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                if (Log.debugLevel >= 4) {
                    System.out.println("Sector " + this.header.sectDirStart + " marker " + Integer.toHexString(this.s2n(this.header.sectDirStart * 4, 4)));
                }
                this.fat = this.data;
                this.data = new byte[this.header.sectorSize];
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                DirectoryEntry directoryEntry = new DirectoryEntry();
                directoryEntry.fill(this.data, 0);
                if (Log.debugLevel >= 4) {
                    System.out.println("Root " + directoryEntry.toString());
                }
                if (directoryEntry._child < 0) {
                    return;
                }
                DirectoryEntry directoryEntry2 = new DirectoryEntry();
                directoryEntry2.fill(this.data, directoryEntry._child * 128);
                if (Log.debugLevel >= 4) {
                    System.out.println("Child " + directoryEntry2.toString());
                }
                DirectoryEntry directoryEntry3 = new DirectoryEntry();
                if (directoryEntry2._leftSib > 0) {
                    directoryEntry3.fill(this.data, directoryEntry2._leftSib * 128);
                    if (Log.debugLevel >= 4) {
                        System.out.println("Left sib " + directoryEntry3.toString());
                    }
                }
            }
            catch (IOException iOException) {
                if (Log.debugLevel < 1) break block10;
                iOException.printStackTrace(System.err);
            }
        }
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public int getResolutionX() {
        return 0;
    }

    @Override
    public int getResolutionY() {
        return 0;
    }

    @Override
    public String getMake() {
        return null;
    }

    @Override
    public String getModel() {
        return null;
    }

    @Override
    public String getDataTimeOriginalString() {
        return null;
    }

    @Override
    public float getFNumber() {
        return 0.0f;
    }

    @Override
    public Rational getShutter() {
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        return false;
    }

    @Override
    public String getQuality() {
        return null;
    }

    @Override
    public float getFocalLength() {
        return 0.0f;
    }

    @Override
    public int getMetering() {
        return 0;
    }

    @Override
    public int getExpoProgram() {
        return 0;
    }

    @Override
    public String getReport() {
        return null;
    }

    @Override
    public Icon getThumbnailIcon(Dimension dimension) {
        block4: {
            if (this.icon != null) {
                return this.icon;
            }
            if (this.getAdvancedImage() != null) {
                try {
                    this.icon = this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), null);
                    return this.icon;
                }
                catch (Throwable throwable) {
                    if (Log.debugLevel < 1) break block4;
                    System.err.println(throwable);
                }
            }
        }
        return null;
    }
}

