/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib.tools.trackcutter;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import jwbroek.cuelib.CueSheet;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.TrackData;
import jwbroek.cuelib.tools.trackcutter.TrackCutterProcessingAction;
import jwbroek.util.StringReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackCutterConfiguration {
    private File parentDirectory = null;
    private PregapHandling pregapHandling = PregapHandling.DISCARD;
    private long pregapFrameLengthThreshold = 0L;
    private AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
    private boolean redirectErr = false;
    private boolean redirectStdOut = false;
    private boolean doPostProcessing = false;
    private boolean redirectToPostprocessing = false;
    private String cutFileNameTemplate = "<artist>_<album>_<track>_<title>.wav";
    private String postProcessFileNameTemplate = "<artist>/<album>/<track>_<title>.mp3";
    private String postProcessCommandTemplate = "C:\\lame\\lame.exe --vbr-new -V 0 -t --tt \"<title>\" --ta \"<artist>\" --tl \"<album>\" --ty \"<year>\" --tc \"<comment>\" --tn \"<track>\" --tg \"<genre>\" \"<targetFile>\" \"<postProcessFile>\"";
    private String pregapCutFileNameTemplate = "<artist>_<album>_<track>__pre_<title>.wav";
    private String pregapPostProcessFileNameTemplate = "<artist>/<album>/<track>__pre_<title>.mp3";
    private String pregapPostProcessCommandTemplate = "C:\\lame\\lame.exe --vbr-new -V 0 -t --tt \"Pregap of <title>\" --ta \"<artist>\" --tl \"<album>\" --ty \"<year>\" --tc \"Pregap of <title>\" --tn \"<track>\" --tg \"<genre>\" \"<targetFile>\" \"<postProcessFile>\"";
    private static final Logger logger = Logger.getLogger(TrackCutterConfiguration.class.getCanonicalName());
    public static final StringReplacer templateReplacer = new StringReplacer(TrackCutterConfiguration.getHumanReadableToFormatStringReplacements());

    public TrackCutterConfiguration() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "TrackCutterConfiguration()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "TrackCutterConfiguration()");
    }

    private static Map<String, String> getHumanReadableToFormatStringReplacements() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getHumanReadableToFormatStringReplacements()");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<title>", "%1$s");
        hashMap.put("<artist>", "%2$s");
        hashMap.put("<album>", "%3$s");
        hashMap.put("<year>", "%4$s");
        hashMap.put("<comment>", "%5$s");
        hashMap.put("<track>", "%6$s");
        hashMap.put("<genre>", "%7$s");
        hashMap.put("<cutFile>", "%8$s");
        hashMap.put("<postProcessFile>", "%9$s");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getHumanReadableToFormatStringReplacements()", hashMap);
        return hashMap;
    }

    public File getAudioFile(FileData fileData) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getAudioFile(FileData)");
        File file = new File(fileData.getFile());
        if (file.getParent() == null) {
            file = new File(this.getParentDirectory(), fileData.getFile());
        }
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getAudioFile(FileData)", file);
        return file;
    }

    private static String normalizeFileName(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "normalizeFileName(String)", string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuilder.append('_');
                continue;
            }
            switch (c) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '|': {
                    stringBuilder.append('_');
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        String string2 = stringBuilder.toString();
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "normalizeFileName(String)", string2);
        return string2;
    }

    public File getFileFromTemplate(TrackData trackData, String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getFileFromTemplate(TrackData, String)", new Object[]{trackData, string});
        String string2 = this.getExpandedFileName(trackData, string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(this.getParentDirectory(), string2);
        }
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getFileFromTemplate(TrackData, String)", file);
        return file;
    }

    private String getExpandedFileName(TrackData trackData, String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getExpandedFileName(TrackData, String)", new Object[]{trackData, string});
        String string2 = String.format(this.getTemplateReplacer().replace(string), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.TITLE)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.PERFORMER)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.ALBUMTITLE)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.YEAR)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.COMMENT)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.TRACKNUMBER)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.GENRE)));
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getExpandedFileName(TrackData, String)", string2);
        return string2;
    }

    private String getExpandedProcessCommand(TrackData trackData, String string, String string2, String string3) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getExpandedFileName(TrackData, String, String, String)", new Object[]{trackData, string, string2, string3});
        String string4 = String.format(this.getTemplateReplacer().replace(string), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.TITLE)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.PERFORMER)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.ALBUMTITLE)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.YEAR)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.COMMENT)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.TRACKNUMBER)), TrackCutterConfiguration.normalizeFileName(trackData.getMetaData(CueSheet.MetaDataField.GENRE)), string2, string3);
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getExpandedFileName(TrackData, String, String, String)", string4);
        return string4;
    }

    public File getCutFile(TrackCutterProcessingAction trackCutterProcessingAction) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getCutFile(TrackCutterProcessingAction)", trackCutterProcessingAction);
        TrackData trackData = trackCutterProcessingAction.getTrackData();
        String string = trackCutterProcessingAction.getIsPregap() ? this.getPregapCutFileNameTemplate() : this.getCutFileNameTemplate();
        File file = this.getFileFromTemplate(trackData, string);
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getCutFile(TrackCutterProcessingAction)", file);
        return file;
    }

    public File getPostProcessFile(TrackCutterProcessingAction trackCutterProcessingAction) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessFile(TrackCutterProcessingAction)", trackCutterProcessingAction);
        TrackData trackData = trackCutterProcessingAction.getTrackData();
        String string = trackCutterProcessingAction.getIsPregap() ? this.getPregapPostProcessFileNameTemplate() : this.getPostProcessFileNameTemplate();
        File file = this.getFileFromTemplate(trackData, string);
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessFile(TrackCutterProcessingAction)", file);
        return file;
    }

    public String getPostProcessCommand(TrackCutterProcessingAction trackCutterProcessingAction) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessCommand(TrackCutterProcessingAction)", trackCutterProcessingAction);
        TrackData trackData = trackCutterProcessingAction.getTrackData();
        String string = trackCutterProcessingAction.getIsPregap() ? this.getPregapPostProcessCommandTemplate() : this.getPostProcessCommandTemplate();
        String string2 = this.getExpandedProcessCommand(trackData, string, trackCutterProcessingAction.getCutFile().getPath(), trackCutterProcessingAction.getPostProcessFile().getPath());
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessCommand(TrackCutterProcessingAction)", string2);
        return string2;
    }

    private StringReplacer getTemplateReplacer() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getTemplateReplacer()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getTemplateReplacer()", templateReplacer);
        return templateReplacer;
    }

    public File getParentDirectory() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getParentDirectory()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getParentDirectory()", this.parentDirectory);
        return this.parentDirectory;
    }

    public void setParentDirectory(File file) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setParentDirectory(File)", file);
        this.parentDirectory = file;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setParentDirectory(File)");
    }

    public String getCutFileNameTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getCutFileNameTemplate()", this.parentDirectory);
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getCutFileNameTemplate()", this.cutFileNameTemplate);
        return this.cutFileNameTemplate;
    }

    public void setCutFileNameTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setCutFileNameTemplate(String)", string);
        this.cutFileNameTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setCutFileNameTemplate(String)");
    }

    public String getPostProcessFileNameTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessFileNameTemplate()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessFileNameTemplate()", this.postProcessFileNameTemplate);
        return this.postProcessFileNameTemplate;
    }

    public void setPostProcessFileNameTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPostProcessFileNameTemplate(String)", string);
        this.postProcessFileNameTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPostProcessFileNameTemplate(String)");
    }

    public String getPostProcessCommandTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessCommandTemplate()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPostProcessCommandTemplate()", this.postProcessCommandTemplate);
        return this.postProcessCommandTemplate;
    }

    public void setPostProcessCommandTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPostProcessCommandTemplate(String)", string);
        this.postProcessCommandTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPostProcessCommandTemplate(String)");
    }

    public PregapHandling getPregapHandling() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPregapHandling()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPregapHandling()", (Object)this.pregapHandling);
        return this.pregapHandling;
    }

    public void setPregapHandling(PregapHandling pregapHandling) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPregapHandling(PregapHandling)", (Object)pregapHandling);
        this.pregapHandling = pregapHandling;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPregapHandling(PregapHandling)");
    }

    public boolean getRedirectErr() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectErr()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectErr()", this.redirectErr);
        return this.redirectErr;
    }

    public void setRedirectErr(boolean bl) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectErr(boolean)", bl);
        this.redirectErr = bl;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectErr(boolean)");
    }

    public boolean getRedirectStdOut() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectStdOut()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectStdOut()", this.redirectStdOut);
        return this.redirectStdOut;
    }

    public void setRedirectStdOut(boolean bl) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectStdOut(boolean)", bl);
        this.redirectStdOut = bl;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectStdOut(boolean)");
    }

    public AudioFileFormat.Type getTargetType() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getTargetType()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getTargetType()", this.targetType);
        return this.targetType;
    }

    public void setTargetType(AudioFileFormat.Type type) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setTargetType(AudioFileFormat.Type)", type);
        this.targetType = type;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setTargetType(AudioFileFormat.Type)");
    }

    public boolean getDoPostProcessing() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getDoPostProcessing()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getDoPostProcessing()", this.doPostProcessing);
        return this.doPostProcessing;
    }

    public void setDoPostProcessing(boolean bl) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setDoPostProcessing(boolean)", bl);
        this.doPostProcessing = bl;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setDoPostProcessing(boolean)");
    }

    public boolean getRedirectToPostprocessing() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectToPostprocessing()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getRedirectToPostprocessing()", this.redirectToPostprocessing);
        return this.redirectToPostprocessing;
    }

    public void setRedirectToPostprocessing(boolean bl) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectToPostprocessing(boolean)", bl);
        this.redirectToPostprocessing = bl;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setRedirectToPostprocessing(boolean)");
    }

    public String getPregapCutFileNameTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPregapCutFileNameTemplate()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPregapCutFileNameTemplate()", this.pregapCutFileNameTemplate);
        return this.pregapCutFileNameTemplate;
    }

    public void setPregapCutFileNameTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPregapCutFileNameTemplate(String)", string);
        this.pregapCutFileNameTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPregapCutFileNameTemplate(String)");
    }

    public String getPregapPostProcessFileNameTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPregapPostProcessFileNameTemplate()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPregapPostProcessFileNameTemplate()", this.pregapPostProcessFileNameTemplate);
        return this.pregapPostProcessFileNameTemplate;
    }

    public void setPregapPostProcessFileNameTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPregapPostProcessFileNameTemplate(String)", string);
        this.pregapPostProcessFileNameTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPregapPostProcessFileNameTemplate(String)");
    }

    public String getPregapPostProcessCommandTemplate() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPregapPostProcessCommandTemplate()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPregapPostProcessCommandTemplate()", this.pregapPostProcessCommandTemplate);
        return this.pregapPostProcessCommandTemplate;
    }

    public void setPregapPostProcessCommandTemplate(String string) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPregapPostProcessCommandTemplate(String)", string);
        this.pregapPostProcessCommandTemplate = string;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPregapPostProcessCommandTemplate(String)");
    }

    public long getPregapFrameLengthThreshold() {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "getPregapFrameLengthThreshold()");
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "getPregapFrameLengthThreshold()", this.pregapFrameLengthThreshold);
        return this.pregapFrameLengthThreshold;
    }

    public void setPregapFrameLengthThreshold(long l) {
        logger.entering(TrackCutterConfiguration.class.getCanonicalName(), "setPregapFrameLengthThreshold(long)", l);
        this.pregapFrameLengthThreshold = l;
        logger.exiting(TrackCutterConfiguration.class.getCanonicalName(), "setPregapFrameLengthThreshold(long)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PregapHandling {
        PREPEND,
        DISCARD,
        SEPARATE;

    }
}

