// Copyright (C) 2005 - 2021 Settlers Freaks (sf-team at siedler25.org)
//
// SPDX-License-Identifier: GPL-2.0-or-later

#include "mapGenerator/MapSettings.h"
#include "helpers/mathFuncs.h"
#include "gameData/MaxPlayers.h"

namespace rttr { namespace mapGenerator {

    void MapSettings::MakeValid()
    {
        if(name.empty())
            name = "Random";
        if(author.empty())
            author = "AutoGenerated";

        numPlayers = helpers::clamp(numPlayers, 1u, MAX_PLAYERS);
        // Even map size
        size.x &= ~1;
        size.y &= ~1;
        size = elMax(size, MapExtent::all(16));
        if(ratioGold + ratioIron + ratioCoal + ratioGranite == 0)
            ratioCoal = 1;
    }

}} // namespace rttr::mapGenerator
