/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.Set;

public class DebugMethodChecker
extends AbstractCheck {
    public String contains = null;
    public String ignorePackages = null;
    private String packageName;
    private String className;
    private static int[] tokens = new int[]{183, 14, 16, 152, 30, 27, 9, 144};
    private int skipCount = 0;
    private int mode = 0;
    private Set<DetailAST> comments = new HashSet<DetailAST>();

    public int[] getDefaultTokens() {
        return tokens;
    }

    public int[] getAcceptableTokens() {
        return tokens;
    }

    public int[] getRequiredTokens() {
        return tokens;
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 9) {
            super.visitToken(ast);
            if (this.skipCount > 0) {
                this.log(ast.getLineNo(), "Number of squelches ( -DM <...> ) did not match number of method calls found", new Object[0]);
            }
            this.skipCount = 0;
            this.comments.clear();
        }
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            StringBuffer accumulator = new StringBuffer();
            DetailAST p = ast.findFirstToken(59);
            if (p == null) {
                p = ast.findFirstToken(58);
            }
            this.LeftRightParent(p, accumulator);
            this.packageName = accumulator.toString();
        } else if (ast.getType() == 14) {
            StringBuffer accumulator = new StringBuffer();
            DetailAST p = ast.findFirstToken(59);
            if (p == null) {
                p = ast.findFirstToken(58);
            }
            this.LeftRightParent(p, accumulator);
            this.className = accumulator.toString();
        } else if (ast.getType() == 183 && !this.comments.contains(ast)) {
            this.handleComment(ast);
        } else if (ast.getType() == 27 && this.contains != null) {
            StringBuffer accumulator = new StringBuffer();
            DetailAST p = ast.findFirstToken(59);
            if (p == null) {
                p = ast.findFirstToken(58);
            }
            this.LeftRightParent(p, accumulator);
            if (accumulator.toString().matches(this.contains) && !this.onIgnoreList()) {
                if (this.skipCount == 0) {
                    this.log(ast.getLineNo(), String.format("Call matching '%s' found use ' -DM <method name> ' in a nearby comment to squash it.", this.contains), new Object[0]);
                } else {
                    --this.skipCount;
                }
            }
        }
    }

    private void handleComment(DetailAST ast) {
        if (ast == null || this.comments.contains(ast)) {
            return;
        }
        String text = ast.getText();
        int i = 0;
        while ((i = text.indexOf("-DM", i)) >= 0) {
            int delta;
            i += 3;
            StringBuffer number = new StringBuffer();
            while (i < text.length() && (text.charAt(i) >= '0' && text.charAt(i) <= '9' || text.charAt(i) == ' ')) {
                number.append(text.charAt(i));
                ++i;
            }
            try {
                delta = Integer.parseInt(number.toString().trim());
            }
            catch (NumberFormatException nfe) {
                delta = 1;
            }
            if (i >= text.length()) {
                this.log(ast.getLineNo(), "Invalid -DM comment entry", new Object[0]);
            }
            if (!(text = text.substring(i).trim()).matches(this.contains)) continue;
            this.skipCount += delta;
            this.comments.add(ast);
            break;
        }
    }

    private boolean onIgnoreList() {
        if (this.ignorePackages == null || this.ignorePackages.trim().isEmpty()) {
            return false;
        }
        String candidate = (this.packageName + "." + this.className).trim();
        return candidate.matches(this.ignorePackages);
    }

    private void LeftRightParent(DetailAST start, StringBuffer accumulator) {
        DetailAST original = start;
        if (start == null) {
            return;
        }
        while (start != null && start.getType() != 59 && start.getType() != 58) {
            switch (start.getType()) {
                case 144: {
                    this.handleComment(start.getFirstChild());
                    break;
                }
                case 145: {
                    for (DetailAST child = start.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getType() != 183) continue;
                        this.handleComment(child);
                    }
                    break;
                }
            }
            start = start.getNextSibling();
        }
        if (start == null) {
            return;
        }
        if (start.getFirstChild() != null) {
            this.LeftRightParent(start.getFirstChild(), accumulator);
        }
        if (start.getType() == 58 || start.getType() == 59) {
            accumulator.append(start.getText());
        }
        if (start.getLastChild() != null) {
            this.LeftRightParent(start.getLastChild(), accumulator);
        }
    }

    public String getContains() {
        return this.contains;
    }

    public void setContains(String contains) {
        this.contains = contains;
    }

    public String getIgnorePackages() {
        return "";
    }

    public void setIgnorePackages(String ignorePackages) {
        this.ignorePackages = ignorePackages.trim();
    }
}

