// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogTargetDefaultsOKCode is the HTTP code returned for type GetLogTargetDefaultsOK
const GetLogTargetDefaultsOKCode int = 200

/*
GetLogTargetDefaultsOK Successful operation

swagger:response getLogTargetDefaultsOK
*/
type GetLogTargetDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewGetLogTargetDefaultsOK creates GetLogTargetDefaultsOK with default headers values
func NewGetLogTargetDefaultsOK() *GetLogTargetDefaultsOK {

	return &GetLogTargetDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target defaults o k response
func (o *GetLogTargetDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetLogTargetDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target defaults o k response
func (o *GetLogTargetDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target defaults o k response
func (o *GetLogTargetDefaultsOK) WithPayload(payload *models.LogTarget) *GetLogTargetDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target defaults o k response
func (o *GetLogTargetDefaultsOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogTargetDefaultsNotFoundCode is the HTTP code returned for type GetLogTargetDefaultsNotFound
const GetLogTargetDefaultsNotFoundCode int = 404

/*
GetLogTargetDefaultsNotFound The specified resource was not found

swagger:response getLogTargetDefaultsNotFound
*/
type GetLogTargetDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetDefaultsNotFound creates GetLogTargetDefaultsNotFound with default headers values
func NewGetLogTargetDefaultsNotFound() *GetLogTargetDefaultsNotFound {

	return &GetLogTargetDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target defaults not found response
func (o *GetLogTargetDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *GetLogTargetDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target defaults not found response
func (o *GetLogTargetDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target defaults not found response
func (o *GetLogTargetDefaultsNotFound) WithPayload(payload *models.Error) *GetLogTargetDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target defaults not found response
func (o *GetLogTargetDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogTargetDefaultsDefault General Error

swagger:response getLogTargetDefaultsDefault
*/
type GetLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetDefaultsDefault creates GetLogTargetDefaultsDefault with default headers values
func NewGetLogTargetDefaultsDefault(code int) *GetLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) WithStatusCode(code int) *GetLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) WithPayload(payload *models.Error) *GetLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target defaults default response
func (o *GetLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
