// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPErrorRuleDefaultsOKCode is the HTTP code returned for type GetAllHTTPErrorRuleDefaultsOK
const GetAllHTTPErrorRuleDefaultsOKCode int = 200

/*
GetAllHTTPErrorRuleDefaultsOK Successful operation

swagger:response getAllHttpErrorRuleDefaultsOK
*/
type GetAllHTTPErrorRuleDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewGetAllHTTPErrorRuleDefaultsOK creates GetAllHTTPErrorRuleDefaultsOK with default headers values
func NewGetAllHTTPErrorRuleDefaultsOK() *GetAllHTTPErrorRuleDefaultsOK {

	return &GetAllHTTPErrorRuleDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http error rule defaults o k response
func (o *GetAllHTTPErrorRuleDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPErrorRuleDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http error rule defaults o k response
func (o *GetAllHTTPErrorRuleDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http error rule defaults o k response
func (o *GetAllHTTPErrorRuleDefaultsOK) WithPayload(payload models.HTTPErrorRules) *GetAllHTTPErrorRuleDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http error rule defaults o k response
func (o *GetAllHTTPErrorRuleDefaultsOK) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPErrorRuleDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPErrorRuleDefaultsDefault General Error

swagger:response getAllHttpErrorRuleDefaultsDefault
*/
type GetAllHTTPErrorRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPErrorRuleDefaultsDefault creates GetAllHTTPErrorRuleDefaultsDefault with default headers values
func NewGetAllHTTPErrorRuleDefaultsDefault(code int) *GetAllHTTPErrorRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPErrorRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) WithStatusCode(code int) *GetAllHTTPErrorRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPErrorRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) WithPayload(payload *models.Error) *GetAllHTTPErrorRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP error rule defaults default response
func (o *GetAllHTTPErrorRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPErrorRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
