/*
 * Decompiled with CFR 0.152.
 */
package prolog;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import prolog.JavaGeneral;
import prolog.Prolog;

public class JavaTextWindow
extends JFrame {
    private JTextPane editor;
    private String filename;
    private UndoManager undoManager;

    public JavaTextWindow(String string, int n, int n2, int n3, int n4, String[][] stringArray) {
        super(string);
        Object object;
        super.setLocation(n, n2);
        super.setSize(new Dimension(n3, n4));
        super.setDefaultCloseOperation(0);
        JMenuBar jMenuBar = new JMenuBar();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i][0];
            int n5 = ((String)object).indexOf(38);
            if (n5 != -1) {
                object = ((String)object).substring(0, n5) + ((String)object).substring(n5 + 1, ((String)object).length());
            }
            JMenu jMenu = new JMenu((String)object);
            if (n5 != -1) {
                jMenu.setMnemonic(Character.getNumericValue(((String)object).charAt(n5)) + 55);
            }
            for (int j = 1; j < stringArray[i].length; ++j) {
                if (stringArray[i][j].equals("|")) {
                    jMenu.addSeparator();
                    continue;
                }
                String string2 = stringArray[i][j];
                n5 = string2.indexOf(38);
                if (n5 != -1) {
                    string2 = string2.substring(0, n5) + string2.substring(n5 + 1, string2.length());
                }
                final JMenuItem jMenuItem = new JMenuItem(string2);
                if (n5 != -1) {
                    jMenuItem.setMnemonic(Character.getNumericValue(string2.charAt(n5)) + 55);
                }
                final JavaTextWindow javaTextWindow = this;
                jMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = jMenuItem.getText();
                        Prolog.PostEvent("event", javaTextWindow, null, "usermenu", string);
                    }
                });
                jMenu.add(jMenuItem);
            }
            jMenuBar.add(jMenu);
        }
        super.setJMenuBar(jMenuBar);
        this.editor = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        super.add(jScrollPane);
        this.undoManager = new UndoManager();
        this.editor.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                JavaTextWindow.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.editor.setComponentPopupMenu(this.buildPopupMenu());
        object = this;
        super.addWindowListener(new WindowAdapter((JavaTextWindow)object){
            final /* synthetic */ JavaTextWindow val$w;
            {
                this.val$w = javaTextWindow2;
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Prolog.PostEvent("event", this.val$w, null, "close_window");
            }
        });
        super.setVisible(true);
        super.toFront();
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Undo");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupUndo();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Cut");
        jMenuItem2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupCut();
            }
        });
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Copy");
        jMenuItem3.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupCopy();
            }
        });
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Paste");
        jMenuItem4.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupPaste();
            }
        });
        jPopupMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Delete");
        jMenuItem5.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupDelete();
            }
        });
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Select All");
        jMenuItem6.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaTextWindow.this.popupSelectAll();
            }
        });
        jPopupMenu.add(jMenuItem6);
        return jPopupMenu;
    }

    private void popupUndo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            System.err.println("Unable to undo " + cannotUndoException.getMessage());
        }
    }

    private void popupCut() {
        this.editor.cut();
    }

    private void popupCopy() {
        this.editor.copy();
    }

    private void popupPaste() {
        this.editor.paste();
    }

    private void popupDelete() {
        int n = this.editor.getSelectionStart();
        int n2 = this.editor.getSelectionEnd();
        this.txtReplace(n, n2, "");
    }

    private void popupSelectAll() {
        this.editor.selectAll();
    }

    public String txtGetFilePath() {
        if (this.filename == null) {
            return "";
        }
        return this.filename;
    }

    public int txtOpenFile() {
        this.filename = JavaGeneral.fileChooserSimpleMsg("Open");
        if (this.filename == null) {
            return -1;
        }
        try {
            FileReader fileReader = new FileReader(this.filename);
            this.editor.read(fileReader, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't find file " + this.filename + "while opening");
        }
        catch (IOException iOException) {
            System.err.println("Couldn't read file " + this.filename);
        }
        this.undoManager = new UndoManager();
        this.editor.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                JavaTextWindow.this.undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.setTitle("Edit - " + this.filename);
        return 0;
    }

    public int txtSaveFile() {
        if (this.filename == null) {
            return -1;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.filename);
            this.editor.write(fileWriter);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't save file " + this.filename);
        }
        return 0;
    }

    public int txtSaveFileAs() {
        String string = JavaGeneral.fileChooserSimpleMsg("Save");
        if (string == null) {
            return -1;
        }
        this.filename = string;
        this.setTitle("Edit - " + this.filename);
        return this.txtSaveFile();
    }

    public String txtGetText(long l, long l2) {
        String string = null;
        int n = new Long(l).intValue();
        int n2 = new Long(l2).intValue();
        if (n < 0) {
            n = 0;
        }
        if (n > this.editor.getDocument().getLength()) {
            n = this.editor.getDocument().getLength();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.editor.getDocument().getLength()) {
            n2 = this.editor.getDocument().getLength();
        }
        try {
            string = this.editor.getText(n, n2 - n);
        }
        catch (Exception exception) {
            System.err.println("Invalid limits for getText");
        }
        return string;
    }

    public void txtAppend(String string) {
        int n = this.editor.getDocument().getLength();
        try {
            this.editor.getDocument().insertString(n, string, null);
        }
        catch (Exception exception) {
            System.err.println("txtAppend: Invalid position for text insertion");
        }
    }

    public String txtGetSelectedText() {
        String string = null;
        try {
            string = this.editor.getSelectedText();
        }
        catch (Exception exception) {
            System.err.println("Selection doesn't have a valid mapping into the document for some reason");
        }
        return string;
    }

    public void txtReplace(long l, long l2, String string) {
        try {
            this.editor.getDocument().remove(new Long(l).intValue(), new Long(l2).intValue());
            this.editor.getDocument().insertString(new Long(l).intValue(), string, null);
        }
        catch (Exception exception) {
            System.err.println("txtReplace: Invalid limits for text replacement");
        }
    }

    public void txtSetSelection(long l, long l2) {
        this.editor.setCaretPosition(new Long(l).intValue());
        this.editor.moveCaretPosition(new Long(l2).intValue());
    }

    public void txtClose() {
        super.dispose();
    }

    public static void main(String[] stringArray) throws Exception {
        String[][] stringArray2 = new String[][]{{"M&enu1", "&Opcao1 do Menu1", "|", "Opcao2 do &Menu1"}, {"Me&nu2", "Opcao1 do M&enu2", "Op&cao2 do Menu2"}};
        JavaTextWindow javaTextWindow = new JavaTextWindow("ola", 100, 100, 500, 500, stringArray2);
        javaTextWindow.txtOpenFile();
    }
}

