/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Globals
#define GUARD_Globals

#include "Side.h"
#include "SettingsStruct.h"
#include "GlobalConstants.h"
#include "GenWindow.h"
#include "Stuff.h"
#include "RTSStructs.h"
#include "Projectile.h"
#include "Logging.h"

#include <vector>
#include <list>

using std::vector;
using std::list;

class TerrainArea;

extern SettingsStruct globalSettings;
extern SettingsStruct oldGlobalSettings;

extern JamesSDL JSDL;
extern bool skipDisplayFrame;

extern SDL_Rect screenRect;

extern GameStateType gsCurrent;
extern GameStateType gsTo;

extern int windowIDs;
extern bool anInfoString;

extern int now;

extern int worldUpdateInterval;
extern int scrollInterval;

extern FontStruct normalFonts;
extern FontStruct boldFonts;

extern vector<Side> sides;

extern string globalErrorString;

/////

extern int worldWidth;
extern int worldHeight;
extern int viewx;
extern int viewy;

extern int viewSide;
extern int viewGroup;

extern bool paused;

extern unsigned int frameCounter;

extern int lastAITime;
extern int lastScrollTime;

extern bool radarDragging;

extern SDL_Rect topRightBoxRect;
extern SDL_Rect radarRect;
extern SDL_Surface* radarSurface;

extern SDL_Surface* genPictures[nGenPictures];

extern list<GenWindow> myWindows;
extern vector<SDL_Surface*> terrainPictures;
extern std::vector<TerrainArea> terrainTree;
extern list<Projectile> projectiles;

extern map<string, unsigned char> tokenLookup;

extern map<string, WeaponType> weaponLoadLookup;
extern WeaponDesc weaponLookup[nWeapons];
extern map<string, EquipDesc> equipLookup;
extern map<WindowChoice, WeaponType> WCToWTLookup;
extern map<WindowChoice, string> WCToETLookup;

extern map<UnitType, string> uTypeToString;
extern map<CapShipType, string> csTypeToString;
extern map<string, UnitType> stringToUType;
extern map<string, CapShipType> stringToCSType;

///

extern SDL_Rect colorRect;

extern Uint16 gold;
extern Uint16 veryDarkGold;
extern Uint16 veryDarkGreen;
extern Uint16 lightBlue;
extern Uint16 black;
extern Uint16 white;
extern Uint16 laserRed;
extern Uint16 laserGreen;
extern Uint16 laserBlue;
extern Uint16 laserYellow;
extern Uint16 missileGrey;
extern Uint16 torpedoBlue;
extern Uint16 greyText;
extern Uint16 bigRangeBlue;

extern Uint16 sideRed;
extern Uint16 sideGreen;
extern Uint16 sideBlue;
extern Uint16 sideYellow;

extern Uint16 radarRed;
extern Uint16 radarGreen;
extern Uint16 radarBlue;
extern Uint16 radarYellow;

#endif

