unit pentest;

{$mode objfpc}{$H+}

interface

uses
  Classes, Forms, Graphics;

type

  { TfrmPen }

  TfrmPen = class(TForm)
    procedure FormPaint(Sender: TObject);
  private

  public

  end; 

var
  frmPen: TfrmPen;

implementation

{$R *.lfm}

{ TfrmPen }

procedure TfrmPen.FormPaint(Sender: TObject);
var
  MyBitmap: TBitmap;
  MyLine: array[0..2] of TPoint;
begin
  MyBitmap := TBitmap.Create;
  try
    { Set a size for the image }
    MyBitmap.Height := Height;// 150
    MyBitmap.Width := Width;// 400
    { After memory has been reserved by setting the size
      of the image, we can start drawing }
    // Background
    MyBitmap.Canvas.Brush.Color := clWhite;
    MyBitmap.Canvas.Pen.Color := clWhite;
    MyBitmap.Canvas.Rectangle(0, 0, Width, Height);
    // Explaning text
    MyBitmap.Canvas.TextOut(100,  5,
     'Brush: bsClear  Pen: Black');

    // Pen styles

    MyBitmap.Canvas.TextOut(25,  30, 'Pen styles:');

    MyBitmap.Canvas.TextOut(25,  60, 'psSolid');
    MyBitmap.Canvas.TextOut(25,  90, 'psDash');
    MyBitmap.Canvas.TextOut(25, 120, 'psDot');
    MyBitmap.Canvas.TextOut(25, 150, 'psDashDot');
    MyBitmap.Canvas.TextOut(25, 180, 'psDashDotDot');
    MyBitmap.Canvas.TextOut(25, 210, 'psClear');
    MyBitmap.Canvas.TextOut(25, 240, 'psInsideframe');
    MyBitmap.Canvas.TextOut(25, 270, 'psPattern');

    MyBitmap.Canvas.Brush.Style := bsClear;
    MyBitmap.Canvas.Pen.Color := clBlack;

    MyBitmap.Canvas.Pen.Style := psSolid;
    MyBitmap.Canvas.Rectangle(Bounds(125,  60, 50, 25));
    MyBitmap.Canvas.Pen.Style := psDash;
    MyBitmap.Canvas.Rectangle(Bounds(125,  90, 50, 25));
    MyBitmap.Canvas.Pen.Style := psDot;
    MyBitmap.Canvas.Rectangle(Bounds(125, 120, 50, 25));
    MyBitmap.Canvas.Pen.Style := psDashDot;
    MyBitmap.Canvas.Rectangle(Bounds(125, 150, 50, 25));
    MyBitmap.Canvas.Pen.Style := psDashDotDot;
    MyBitmap.Canvas.Rectangle(Bounds(125, 180, 50, 25));
    MyBitmap.Canvas.Pen.Style := psClear;
    MyBitmap.Canvas.Rectangle(Bounds(125, 210, 50, 25));
    MyBitmap.Canvas.Pen.Style := psInsideframe;
    MyBitmap.Canvas.Rectangle(Bounds(125, 240, 50, 25));
    MyBitmap.Canvas.Pen.Style := psPattern;
    MyBitmap.Canvas.Rectangle(Bounds(125, 270, 50, 25));

    // Line widths

    MyBitmap.Canvas.TextOut(200,  30, 'Pen Widths:');

    MyBitmap.Canvas.Pen.Style := psSolid;

    MyBitmap.Canvas.TextOut(200,  55, 'Width = 0');
    MyBitmap.Canvas.Pen.Width := 0;
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280,  75);
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280,  85);
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280,  95);
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280, 105);
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280, 115);
    MyBitmap.Canvas.MoveTo(200,  75);
    MyBitmap.Canvas.LineTo(280, 125);

    MyBitmap.Canvas.TextOut(300,  55, 'Width = 1');
    MyBitmap.Canvas.Pen.Width := 1;
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380,  75);
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380,  85);
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380,  95);
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380, 105);
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380, 115);
    MyBitmap.Canvas.MoveTo(300,  75);
    MyBitmap.Canvas.LineTo(380, 125);

    MyBitmap.Canvas.TextOut(400,  55, 'Width = 2');
    MyBitmap.Canvas.Pen.Width := 2;
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480,  75);
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480,  85);
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480,  95);
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480, 105);
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480, 115);
    MyBitmap.Canvas.MoveTo(400,  75);
    MyBitmap.Canvas.LineTo(480, 125);

    // End Caps

    MyBitmap.Canvas.TextOut(200, 150, 'Pen End Caps:');

    MyBitmap.Canvas.Pen.Width := 10;

    MyBitmap.Canvas.TextOut(200, 175, 'pecRound');
    MyBitmap.Canvas.Pen.EndCap := pecRound;
    MyBitmap.Canvas.MoveTo(200, 200);
    MyBitmap.Canvas.LineTo(280, 200);

    MyBitmap.Canvas.TextOut(300, 175, 'pecSquare');
    MyBitmap.Canvas.Pen.EndCap := pecSquare;
    MyBitmap.Canvas.MoveTo(300, 200);
    MyBitmap.Canvas.LineTo(380, 200);

    MyBitmap.Canvas.TextOut(400, 175, 'pecFlat');
    MyBitmap.Canvas.Pen.EndCap := pecFlat;
    MyBitmap.Canvas.MoveTo(400, 200);
    MyBitmap.Canvas.LineTo(480, 200);

    // Join Style

    MyBitmap.Canvas.TextOut(200, 225, 'Joint Style:');

    MyBitmap.Canvas.Pen.Width := 10;
    MyBitmap.Canvas.Pen.EndCap := pecRound;

    MyBitmap.Canvas.TextOut(200, 250, 'pjsRound');
    MyBitmap.Canvas.Pen.JoinStyle := pjsRound;
    MyLine[0] := Point(200, 275);
    MyLine[1] := Point(250, 275);
    MyLine[2] := Point(250, 325);
    MyBitmap.Canvas.Polyline(MyLine);

    MyBitmap.Canvas.TextOut(300, 250, 'pjsBevel');
    MyBitmap.Canvas.Pen.JoinStyle := pjsBevel;
    MyLine[0] := Point(300, 275);
    MyLine[1] := Point(350, 275);
    MyLine[2] := Point(350, 325);
    MyBitmap.Canvas.Polyline(MyLine);

    MyBitmap.Canvas.TextOut(400, 250, 'pjsMiter');
    MyBitmap.Canvas.Pen.JoinStyle := pjsMiter;
    MyLine[0] := Point(400, 275);
    MyLine[1] := Point(450, 275);
    MyLine[2] := Point(450, 325);
    MyBitmap.Canvas.Polyline(MyLine);

    { Draw the bitmap to the form }
    Canvas.Draw(0, 0, MyBitmap);
  finally
    MyBitmap.Free;
  end;
end;

end.

