/* arm.v4a-wince.pe.h
   created from arm.v4a-wince.pe.bin, 14676 (0x3954) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM_V4A_WINCE_PE_SIZE    14676
#define STUB_ARM_V4A_WINCE_PE_ADLER32 0x3e1886fc
#define STUB_ARM_V4A_WINCE_PE_CRC32   0x3d92a84f

unsigned char stub_arm_v4a_wince_pe[14676] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 156, 15,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,  1,  0, 81,227,  7,  0,  0, 26,255, 79, 45,233,
/* 0x0040 */  32, 48,143,226,  7,  0,179,232, 16, 14,147,232,  2,144,160,225,
/* 0x0050 */  18,  0,  0,235,  4,  0,160,227,  8,  0,  0,235,255, 79,189,232,
/* 0x0060 */  32,240,159,229, 12,240,159,229,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0070 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0080 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 64, 45,233,
/* 0x0090 */   0,128,189,232, 60,  0,159,229,  0, 32,160,227, 56,192,159,229,
/* 0x00a0 */  12,  0, 80,225, 17,  0,  0, 10,  0, 48,144,229, 15, 20,  3,226,
/* 0x00b0 */  11,  4, 81,227, 12,  0,  0, 26,255, 20,  3,226,  2, 48, 67,224,
/* 0x00c0 */ 255, 52,195,227,  1, 48,131,225,  0, 48,128,229,  4,  0,128,226,
/* 0x00d0 */   1, 32,130,226,  1,  0,  0,234,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x00e0 */  84, 16,159,229,  4,  0, 73,226,  1, 48,209,228,  0,  0, 83,227,
/* 0x00f0 */  22,  0,  0, 10,240,  0, 83,227,240,192,195, 35,  1, 48,209, 37,
/* 0x0100 */  12,196,131, 32,  2, 48,209, 36, 12, 52,131, 32,  3,  0,128,224,
/* 0x0110 */   0, 48,208,229, 12,196,131,224,  1, 48,208,229, 12,196,131,224,
/* 0x0120 */   2, 48,208,229, 12,196,131,224,  3, 48,208,229, 12,196,131,224,
/* 0x0130 */   9,192,140,224,  0,192,128,229,  0,  0,  0,234,  0,  0,  0,  0,
/* 0x0140 */   2,219, 77,226,164, 64,159,229,  4,  0,160,225, 33,  0,  0,235,
/* 0x0150 */  44,  0,  0, 10,152, 16,159,229,  1,  0,128,224, 13, 16,160,225,
/* 0x0160 */   1, 32,208,228,178, 32,193,224,  0,  0, 82,227,  6,  0,  0, 26,
/* 0x0170 */  13,  0,160,225, 40,  0,  0,235,  0, 96,160,225,  4,  0,132,226,
/* 0x0180 */  33,  0,  0,235,  0, 80,137,224,  8, 64,132,226,  1,  0,212,228,
/* 0x0190 */   1,  0, 80,227,  0,  0,  0, 74, 26,  0,  0, 26,  4, 16,160,225,
/* 0x01a0 */   1,  0,212,228,  0,  0, 80,227, 22,  0,  0, 26, 29,  0,  0,234,
/* 0x01b0 */   1,  0,212,228,  1, 16,212,228,  1, 20,128,224,  6,  0,160,225,
/* 0x01c0 */  41,  0,  0,235,  4,  0,133,228, 17,  0,  0,234,  3, 32,160,227,
/* 0x01d0 */   2, 48,208,231,  1, 32, 82,226,  1, 20,131,224, 34,  0,  0, 90,
/* 0x01e0 */   1,  0,176,225, 14,240,160,225, 11,240,160,225, 10,240,160,225,
/* 0x01f0 */   0,  0,  0,  0,  0,  0,  0,  0,  2,219,141,226, 85, 80, 88, 33,
/* 0x0200 */ 161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,252, 64, 45,233,
/* 0x0220 */   0,112,129,224,  0, 80,224,227,  2, 65,160,227, 14,  0,  0,234,
/* 0x0230 */  24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,
/* 0x0240 */ 240,128,189,232,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0250 */  14,240,160,225,  1, 48,208,228,  1, 48,194,228,  4, 64,148,224,
/* 0x0260 */   8,  0,  0, 11, 12,  0,  0, 42,  1, 16,160,227, 23,  0,  0,234,
/* 0x0270 */   1, 16, 65,226,  4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,
/* 0x0280 */   4, 64,148,224,  8,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x0290 */   8,  0,  0, 11, 19,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227,
/* 0x02a0 */  39,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x02b0 */   3,  0,  0, 10,197, 80,176,225, 54,  0,  0, 42, 42,  0,  0,234,
/* 0x02c0 */   4, 64,148,224,  8,  0,  0, 11, 54,  0,  0, 42,  1, 16,160,227,
/* 0x02d0 */   4, 64,148,224,  8,  0,  0, 11, 54,  0,  0, 42,  4, 64,148,224,
/* 0x02e0 */   8,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,  8,  0,  0, 11,
/* 0x02f0 */  46,  0,  0, 58,  4, 16,129,226, 58,  0,  0,234,  4, 64,148,224,
/* 0x0300 */   8,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,  5, 12,117,227,
/* 0x0310 */   1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,  5, 48,210,231,
/* 0x0320 */   1, 48,194,228,  1, 16, 81,226, 62,  0,  0, 26, 14,  0,  0,234,
/* 0x0330 */ 254,255,255,235,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0340 */   2, 65,160,227, 14,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x0350 */   3, 32, 66,224,  0, 32,132,229,240,128,189,232,  1, 64,208,228,
/* 0x0360 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 48,208,228,
/* 0x0370 */   1, 48,194,228,  4, 64,148,224,  8,  0,  0, 11, 12,  0,  0, 42,
/* 0x0380 */   1, 16,160,227, 23,  0,  0,234,  1, 16, 65,226,  4, 64,148,224,
/* 0x0390 */   8,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11,
/* 0x03a0 */   1, 16,177,224,  4, 64,148,224,  8,  0,  0, 11, 19,  0,  0, 58,
/* 0x03b0 */   3, 48, 81,226,  0, 16,160,227, 38,  0,  0, 58,  1, 80,208,228,
/* 0x03c0 */   3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,197, 80,176,225,
/* 0x03d0 */  40,  0,  0,234,  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,
/* 0x03e0 */   4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224, 53,  0,  0, 26,
/* 0x03f0 */   1, 16,160,227,  4, 64,148,224,  8,  0,  0, 11,  1, 16,177,224,
/* 0x0400 */   4, 64,148,224,  8,  0,  0, 11, 46,  0,  0, 58,  2, 16,129,226,
/* 0x0410 */   1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,  0, 48,210,229,
/* 0x0420 */   5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 57,  0,  0, 26,
/* 0x0430 */  14,  0,  0,234,254,255,255,235,  0, 16,129,224, 62, 64, 45,233,
/* 0x0440 */   0, 80,224,227,  2, 65,160,227, 23,  0,  0,234, 26,  0,189,232,
/* 0x0450 */   1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229, 48,128,189,232,
/* 0x0460 */   4, 64,148,224, 14,240,160, 17,  1, 64,208,228,  4, 64,164,224,
/* 0x0470 */   4, 76,176,225, 14,240,160,225,  1, 16,160,227, 14,192,160,225,
/* 0x0480 */   8,  0,  0,235,  1, 16,177,224,  8,  0,  0,235, 16,  0,  0, 58,
/* 0x0490 */  12,240,160,225,  1, 48,208,228,  1, 48,194,228,  8,  0,  0,235,
/* 0x04a0 */  21,  0,  0, 42, 14,  0,  0,235,  3, 48, 81,226,  0, 16,160,227,
/* 0x04b0 */  33,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x04c0 */   3,  0,  0, 10,  8,  0,  0,235,  1, 16,177,224,  8,  0,  0,235,
/* 0x04d0 */   1, 16,177,224, 40,  0,  0, 26, 14,  0,  0,235,  2, 16,129,226,
/* 0x04e0 */  13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,
/* 0x04f0 */   1, 48,194,228, 42,  0,  0, 42, 23,  0,  0,234,254,255,255,235,
/* 0x0500 */  60,112,143,226,120,  0,151,232, 13,112,160,225, 13, 64,132,224,
/* 0x0510 */   0,192,160,227,  0, 16, 45,233,  4,  0, 93,225,  3,  0,  0, 26,
/* 0x0520 */  28,  0, 45,233,  4, 48,132,226,  5, 32,160,225,  2, 16,128,226,
/* 0x0530 */   8,  0,132,226,  0, 96,128,229,254,255,255,235,  7,208,160,225,
/* 0x0540 */  19,  0,  0,234,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0550 */   0,  0,  0,  0,240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,
/* 0x0560 */   0, 48,208,229,  2, 80,208,229,  1,224,208,229,  0,192,157,229,
/* 0x0570 */  20, 48,141,229, 92, 48,157,229,  0, 64,160,227,  0, 64,140,229,
/* 0x0580 */   0, 64,131,229, 20,192,157,229,  1, 48,208,229,  3, 48,140,224,
/* 0x0590 */   3,204,160,227, 28,195,160,225,  1, 48,160,227, 19,238,160,225,
/* 0x05a0 */  19, 53,160,225,115,206,140,226,  1, 48, 67,226,  1,224, 78,226,
/* 0x05b0 */   4,  0,128,226,  6,192,140,226,  4, 16,141,229, 12, 48,141,229,
/* 0x05c0 */  16,224,141,229,  8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,
/* 0x05d0 */   1, 27,160,227,176, 16,131,225, 12,  0, 84,225,132, 48,160,225,
/* 0x05e0 */   1, 64,132,226, 28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,
/* 0x05f0 */   2,144,131,224,  3,224,160,225,  6, 32,160,225,  4, 80,157,229,
/* 0x0600 */   9, 48,101,224,  3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,
/* 0x0610 */   5, 48,210,231,  1, 32,130,226,  5,  0, 82,227,  6,100,131,225,
/* 0x0620 */  40,  0,  0, 26,  0,176,160,227,  1,192,160,227, 11,112,160,225,
/* 0x0630 */   0,  0,224,227, 44,192,141,229, 24,176,141,229, 28,192,141,229,
/* 0x0640 */  32,192,141,229, 36,192,141,229, 57,  2,  0,234,255,132,224,227,
/* 0x0650 */   8,  0, 80,225, 68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0660 */   1, 48,222,228,  0,  4,160,225,  6,100,131,225, 12, 16,157,229,
/* 0x0670 */  24, 32,157,229,  1,160, 11,224,  2, 18,160,225,  1, 48,138,224,
/* 0x0680 */ 131, 80,160,225,  8, 48,157,229,181,192,147,225,160, 53,160,225,
/* 0x0690 */ 156,  3,  4,224,  4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,
/* 0x06a0 */   8, 48, 96,226, 87, 51,160,225, 16, 16,157,229,  1, 32, 11,224,
/* 0x06b0 */  18, 48,131,224,  8,  0,157,229,  6, 44,160,227,147,  2, 34,224,
/* 0x06c0 */  24, 16,157,229,  2, 59,108,226,  6,  0, 81,227,195, 50,140,224,
/* 0x06d0 */ 230,142,130,226,181, 48,128,225, 12,128,136,226,  4,  0,160,209,
/* 0x06e0 */   1, 16,160,211,164,  0,  0,218, 44, 32,157,229, 84, 80,157,229,
/* 0x06f0 */  11, 48, 98,224,  3,112,213,231,  4,  0,160,225,  1, 16,160,227,
/* 0x0700 */ 135,112,160,225,  1, 92,  7,226,129,160,160,225,133, 48,136,224,
/* 0x0710 */  10, 48,131,224,  1,  4, 80,227,  2, 76,131,226,  1,192,129,226,
/* 0x0720 */ 119,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0730 */   1, 48,222,228,  6,100,131,225,176, 48,212,225,160, 37,160,225,
/* 0x0740 */  12, 16,129,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x0750 */ 194, 34,131,224,163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227,
/* 0x0760 */  12,  0,160,225,176, 32,196,225, 10, 16,160,225,140,  0,  0, 10,
/* 0x0770 */  12,  0,160,225,164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,
/* 0x0780 */   6, 96,108,224,  0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,
/* 0x0790 */ 168,  0,  0,202,105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,
/* 0x07a0 */ 151,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x07b0 */   1, 48,222,228,  6,100,131,225,180, 48,152,225,160, 37,160,225,
/* 0x07c0 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,
/* 0x07d0 */ 194, 50,131,224,180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,
/* 0x07e0 */   4, 16,160, 49, 12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,
/* 0x07f0 */ 129, 64,160,225,  1, 48,129,226,143,  0,  0,218, 24,192,157,229,
/* 0x0800 */ 255,112,  1,226,  3,  0, 92,227, 84, 16,157,229,  0, 32,160,211,
/* 0x0810 */  11,112,193,231,  1,176,139,226, 24, 32,141,213, 57,  2,  0,218,
/* 0x0820 */  24, 48,157,229,  9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,
/* 0x0830 */   6, 80, 69,194, 24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,
/* 0x0840 */ 172, 50, 76,224,  0, 32,100,224,  8,192,157,229,  8,  0, 82,225,
/* 0x0850 */ 181, 48,140,225,  6, 96,100,224,197,  0,  0,138,  9,  0, 94,225,
/* 0x0860 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0870 */   8,  0,157,229, 24, 48,157,229,131,112,128,224,  6, 13,135,226,
/* 0x0880 */ 176,192,208,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0890 */ 225,  0,  0, 42, 24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,
/* 0x08a0 */   2, 59,108,226,102, 30,133,226,  3, 32,160,195, 32, 80,157,229,
/* 0x08b0 */   0, 32,160,211,195, 50,140,224, 24, 32,141,229, 28,192,157,229,
/* 0x08c0 */  44, 32,157,229, 36, 80,141,229,  4, 16,129,226,  4, 80,160,225,
/* 0x08d0 */  32,192,141,229, 28, 32,141,229,176, 48,192,225, 98,  1,  0,234,
/* 0x08e0 */   2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,
/* 0x08f0 */   6, 96,100,224,236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0900 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225,102, 95,135,226,
/* 0x0910 */ 176,192,213,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0920 */  26,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  8,  0, 84,225,
/* 0x0930 */ 176, 48,197,225,252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0940 */   1, 48,222,228,  4, 68,160,225,  6,100,131,225,  8, 80,157,229,
/* 0x0950 */ 129, 48,133,224,138, 48,131,224, 30, 30,131,226,176,192,209,225,
/* 0x0960 */ 164, 53,160,225,156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,
/* 0x0970 */ 172, 50, 76, 32,  4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,
/* 0x0980 */ 195, 50,140,224,  0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10,
/* 0x0990 */  44,192,157,229, 24, 16,157,229, 84,  0,157,229, 11, 48,108,224,
/* 0x09a0 */   3,112,208,231,  6,  0, 81,227, 11, 16,160,195,  9, 16,160,211,
/* 0x09b0 */  24, 16,141,229, 11,112,192,231,  2,  0,160,225,  1,176,139,226,
/* 0x09c0 */  57,  2,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,
/* 0x09d0 */ 176, 48,197,225,  6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225,
/* 0x09e0 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x09f0 */  27, 30,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x0a00 */   4,  0, 86,225, 52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226,
/* 0x0a10 */  28, 32,157,229,195, 50,140,224, 28, 80,141,229,  4, 80,160,225,
/* 0x0a20 */  44, 32,141,229,176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,
/* 0x0a30 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,193,225,  6, 96,100,224,
/* 0x0a40 */  63,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0a50 */   2, 36,160,225,  6,100,131,225,114, 31,135,226,176,192,209,225,
/* 0x0a60 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,
/* 0x0a70 */   2, 59,108,226, 32, 32,157,229,195, 50,140,224, 44,  0,157,229,
/* 0x0a80 */  28,192,157,229,  4, 80,160,225, 32,192,141,229, 28,  0,141,229,
/* 0x0a90 */  49,  1,  0,234,172, 50, 76,224,176, 48,193,225, 44,192,157,229,
/* 0x0aa0 */  32, 16,141,226, 10,  0,145,232,  2, 80,100,224, 28, 32,157,229,
/* 0x0ab0 */  36, 16,141,229, 32, 32,141,229, 28,192,141,229, 44, 48,141,229,
/* 0x0ac0 */   6, 96,100,224, 24, 32,157,229,  8,  0,157,229,  6,  0, 82,227,
/* 0x0ad0 */  11, 32,160,195,  8, 32,160,211,166, 30,128,226, 24, 32,141,229,
/* 0x0ae0 */   8, 16,129,226,255,116,224,227,  7,  0, 85,225,106,  1,  0,138,
/* 0x0af0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,
/* 0x0b00 */   6,100,131,225,176,192,209,225,165, 53,160,225,156,  3,  4,224,
/* 0x0b10 */   4,  0, 86,225,120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,
/* 0x0b20 */ 195, 50,140,224,  4, 80,130,226,  4,  0,160,225,  3,160,160,227,
/* 0x0b30 */   0,128,160,227,176, 48,193,225,152,  1,  0,234,  5, 32,100,224,
/* 0x0b40 */ 172, 50, 76,224,  7,  0, 82,225,  6, 96,100,224,176, 48,193,225,
/* 0x0b50 */ 131,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0b60 */   2, 36,160,225,  6,100,131,225,178,192,209,225,162, 53,160,225,
/* 0x0b70 */ 156,  3,  4,224,  4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,
/* 0x0b80 */   2, 59,108,226,195, 50,140,224, 65, 95,130,226,  4,  0,160,225,
/* 0x0b90 */   3,160,160,227,  8,128,160,227,178, 48,193,225,152,  1,  0,234,
/* 0x0ba0 */ 172, 50, 76,224,178, 48,193,225,  6, 96,100,224,  2,  0,100,224,
/* 0x0bb0 */ 129, 95,129,226,  8,160,160,227, 16,128,160,227, 10,112,160,225,
/* 0x0bc0 */   1, 16,160,227,  1, 48,129,226,  1,  4, 80,227,129, 64,160,225,
/* 0x0bd0 */   3, 16,129,224,164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x0be0 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,180, 48,149,225,
/* 0x0bf0 */ 160, 37,160,225,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x0c00 */ 194, 34,131,224,163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49,
/* 0x0c10 */  12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,
/* 0x0c20 */   1,112, 87,226,154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224,
/* 0x0c30 */  24, 80,157,229,  8, 48,131,224,  3,  0, 85,227, 40, 48,141,229,
/* 0x0c40 */  36,  2,  0,202,  8,192,157,229,  3,  0, 83,227,  3, 48,160,163,
/* 0x0c50 */ 131, 51,140,224, 54, 94,131,226,  2,112,160,225,  6,128,160,227,
/* 0x0c60 */   1, 48,135,226,  1,  4, 80,227,135, 64,160,225,  3,112,135,224,
/* 0x0c70 */ 203,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0c80 */   1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,
/* 0x0c90 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x0ca0 */ 163, 50, 67,224,  0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,
/* 0x0cb0 */ 180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,
/* 0x0cc0 */ 193,  1,  0, 26, 64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209,
/* 0x0cd0 */  30,  2,  0,218,194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,
/* 0x0ce0 */   1,112, 68,226,  2,192,131,227,  5, 64, 68,194,  8, 32,160,193,
/* 0x0cf0 */ 237,  1,  0,202, 28, 87,160,225,  8, 16,157,229,133, 48,129,224,
/* 0x0d00 */ 130, 48, 67,224, 85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,
/* 0x0d10 */   1,  4, 80,227,  1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,
/* 0x0d20 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0d30 */ 160,  0,160,225,  0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,
/* 0x0d40 */   1,192,140, 35,  4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229,
/* 0x0d50 */  25, 77,130,226,  4, 64,132,226, 12, 82,160,225,  4,112,160,227,
/* 0x0d60 */   1,160,160,227, 10,128,160,225,  1,  4, 80,227,136, 16,160,225,
/* 0x0d70 */   1,192,136,226, 12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x0d80 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,177, 48,148,225,
/* 0x0d90 */ 160, 37,160,225, 12,128,136,224,147,  2, 12,224,  2, 43, 99,226,
/* 0x0da0 */  12,  0, 86,225,194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,
/* 0x0db0 */   1,128,160, 49, 12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,
/* 0x0dc0 */   6, 96,108, 32,  0,  0,108, 32,  1,112, 87,226,138,160,160,225,
/* 0x0dd0 */   3,  2,  0, 26,  1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10,
/* 0x0de0 */  24, 48,157,229,  7, 48,131,226, 24, 48,141,229, 44, 80,157,229,
/* 0x0df0 */  11,  0, 85,225, 73,  2,  0,138, 40,192,157,229, 84, 16,157,229,
/* 0x0e00 */  11, 48,101,224,  2, 32,140,226,  3, 64,129,224, 11,192,129,224,
/* 0x0e10 */   1, 32, 82,226, 88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,
/* 0x0e20 */   1,176,139,226,  5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,
/* 0x0e30 */   1,112,212,228,  0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26,
/* 0x0e40 */  88,192,157,229, 12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227,
/* 0x0e50 */  65,  2,  0, 42,  9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,
/* 0x0e60 */   4,  0,157,229,  0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,
/* 0x0e70 */   0,  0,160,227,  0, 48,129,229,  0,176,130,229, 74,  2,  0,234,
/* 0x0e80 */   1,  0,160,227, 48,208,141,226,240,143,189,232,102,105,108,101,
/* 0x0e90 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,108,105,
/* 0x0ea0 */ 116,116,108,101, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,
/* 0x0eb0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x0ec0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x0ed0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32,
/* 0x0ee0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x0ef0 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 68,108,108,
/* 0x0f00 */  83,116, 97,114,116, 32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48,
/* 0x0f10 */  32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x0f20 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69,120,101,
/* 0x0f30 */  83,116, 97,114,116, 32, 32, 32, 32, 32, 32, 48, 53, 52, 32, 32,
/* 0x0f40 */  48, 32, 32, 48, 32, 32, 48, 51, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x0f50 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 80,114,
/* 0x0f60 */ 111, 99,101,115,115, 69,110,100, 32, 32, 32, 32, 48, 52, 32, 32,
/* 0x0f70 */  48, 32, 32, 48, 32, 32, 48, 57, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x0f80 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 85,110,
/* 0x0f90 */ 102,105,108,116,101,114, 95, 48,120, 53, 48, 32, 48, 52, 99, 32,
/* 0x0fa0 */  32, 48, 32, 32, 48, 32, 32, 48, 57, 52, 32, 32, 50, 42, 42, 48,
/* 0x0fb0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 82,
/* 0x0fc0 */ 101,108,111, 99,115, 32, 32, 32, 32, 32, 32, 32, 32, 48, 54, 48,
/* 0x0fd0 */  32, 32, 48, 32, 32, 48, 32, 32, 48,101, 48, 32, 32, 50, 42, 42,
/* 0x0fe0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x0ff0 */  73,109,112,111,114,116,115, 32, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1000 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 48, 32, 32, 50,
/* 0x1010 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1020 */  54, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32,
/* 0x1030 */  48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102, 99, 32,
/* 0x1040 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1050 */  32, 32, 55, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,
/* 0x1060 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 32, 48, 49, 49, 52,
/* 0x1070 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 49, 99, 32, 32, 50, 42,
/* 0x1080 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56,
/* 0x1090 */  32, 67, 97,108,108, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x10a0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 48, 32, 32, 50,
/* 0x10b0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x10c0 */  57, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x10d0 */ 111,109,112,114,101,115,115, 95, 56, 32, 48, 49, 48, 48, 32, 32,
/* 0x10e0 */  48, 32, 32, 48, 32, 32, 48, 51, 51, 52, 32, 32, 50, 42, 42, 48,
/* 0x10f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 67,
/* 0x1100 */  97,108,108, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x1110 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 51, 52, 32, 32, 50, 42, 42,
/* 0x1120 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x1130 */  46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,
/* 0x1140 */ 112,114,101,115,115, 95, 56, 32, 48, 99, 52, 32, 32, 48, 32, 32,
/* 0x1150 */  48, 32, 32, 48, 52, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1160 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 67, 97,108,108,
/* 0x1170 */  50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x1180 */  32, 48, 32, 32, 48, 52,102, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1190 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 67, 97,108,
/* 0x11a0 */ 108, 76, 90, 77, 65, 32, 32, 32, 32, 32, 32, 48, 53, 52, 32, 32,
/* 0x11b0 */  48, 32, 32, 48, 32, 32, 48, 53, 48, 48, 32, 32, 50, 42, 42, 48,
/* 0x11c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32, 76,
/* 0x11d0 */  90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 32, 32, 32, 48, 32, 32,
/* 0x11e0 */  48, 32, 32, 48, 32, 32, 48, 53, 53, 52, 32, 32, 50, 42, 42, 48,
/* 0x11f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32, 76,
/* 0x1200 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57, 51,
/* 0x1210 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 53, 52, 32, 32, 50,
/* 0x1220 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89,
/* 0x1230 */  77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48,
/* 0x1240 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,120,101,
/* 0x1250 */  83,116, 97,114,116, 32, 48, 32, 69,120,101, 83,116, 97,114,116,
/* 0x1260 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1270 */  32, 32, 85,110,102,105,108,116,101,114, 95, 48,120, 53, 48, 32,
/* 0x1280 */  48, 32, 85,110,102,105,108,116,101,114, 95, 48,120, 53, 48, 10,
/* 0x1290 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x12a0 */  32, 82,101,108,111, 99,115, 32, 48, 32, 82,101,108,111, 99,115,
/* 0x12b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x12c0 */  32, 32, 73,109,112,111,114,116,115, 32, 48, 32, 73,109,112,111,
/* 0x12d0 */ 114,116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x12e0 */  32, 32,100, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,
/* 0x12f0 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 32, 48, 32, 46,
/* 0x1300 */ 117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,
/* 0x1310 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1320 */ 108, 32, 32, 32, 32,100, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x1330 */  50,100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 32,
/* 0x1340 */  48, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x1350 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x1360 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 46,117, 99,108, 95,
/* 0x1370 */ 110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x1380 */  95, 56, 32, 48, 32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,
/* 0x1390 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48,
/* 0x13a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 97,
/* 0x13b0 */ 108,108, 76, 90, 77, 65, 32, 48, 32, 67, 97,108,108, 76, 90, 77,
/* 0x13c0 */  65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x13d0 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 32, 48,
/* 0x13e0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10, 48, 48, 48,
/* 0x13f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x1400 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x1410 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1420 */  32, 32, 32, 32,100, 32, 32, 68,108,108, 83,116, 97,114,116, 32,
/* 0x1430 */  48, 32, 68,108,108, 83,116, 97,114,116, 10, 48, 48, 48, 48, 48,
/* 0x1440 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,114,111, 99,
/* 0x1450 */ 101,115,115, 69,110,100, 32, 48, 32, 80,114,111, 99,101,115,115,
/* 0x1460 */  69,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1470 */  32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 48, 32,
/* 0x1480 */  85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1490 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 97,108,108, 50, 69,
/* 0x14a0 */  32, 48, 32, 67, 97,108,108, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x14b0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 97,108,108, 50,
/* 0x14c0 */  68, 32, 48, 32, 67, 97,108,108, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x14d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 97,108,108,
/* 0x14e0 */  50, 66, 32, 48, 32, 67, 97,108,108, 50, 66, 10, 48, 48, 48, 48,
/* 0x14f0 */  48, 48, 50, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,120,101,
/* 0x1500 */  83,116, 97,114,116, 32, 48, 32, 83, 82, 67, 48, 10, 48, 48, 48,
/* 0x1510 */  48, 48, 48, 51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,120,
/* 0x1520 */ 101, 83,116, 97,114,116, 32, 48, 32, 68, 83, 84, 48, 10, 48, 48,
/* 0x1530 */  48, 48, 48, 48, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1540 */ 120,101, 83,116, 97,114,116, 32, 48, 32, 73, 65, 84, 84, 10, 48,
/* 0x1550 */  48, 48, 48, 48, 48, 52, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1560 */  69,120,101, 83,116, 97,114,116, 32, 48, 32, 69, 78, 84, 82, 10,
/* 0x1570 */  48, 48, 48, 48, 48, 48, 52, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1580 */  32, 85,110,102,105,108,116,101,114, 95, 48,120, 53, 48, 32, 48,
/* 0x1590 */  32, 70, 73, 66, 83, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32,103,
/* 0x15a0 */  32, 32, 32, 32, 32, 32, 32, 85,110,102,105,108,116,101,114, 95,
/* 0x15b0 */  48,120, 53, 48, 32, 48, 32, 70, 73, 66, 69, 10, 48, 48, 48, 48,
/* 0x15c0 */  48, 48, 53, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 82,101,108,
/* 0x15d0 */ 111, 99,115, 32, 48, 32, 66, 82, 69, 76, 10, 48, 48, 48, 48, 48,
/* 0x15e0 */  48, 98, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,
/* 0x15f0 */ 114,116,115, 32, 48, 32, 66, 73, 77, 80, 10, 48, 48, 48, 48, 48,
/* 0x1600 */  48, 98, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,
/* 0x1610 */ 114,116,115, 32, 48, 32, 79, 78, 65, 77, 10, 48, 48, 48, 48, 48,
/* 0x1620 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x1630 */  42, 32, 48, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,109,
/* 0x1640 */ 112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x1660 */  32, 99,111,109,112,114,101,115,115,101,100, 95,108,101,110,103,
/* 0x1670 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1680 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,
/* 0x1690 */ 116, 95,111,102, 95,117,110, 99,111,109,112,114,101,115,115,101,
/* 0x16a0 */ 100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x16b0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,117,110, 99,111,109,
/* 0x16c0 */ 112,114,101,115,115,101,100, 95,108,101,110,103,116,104, 10, 48,
/* 0x16d0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x16e0 */  42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x16f0 */  95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1700 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x1710 */ 102,105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116,
/* 0x1720 */  97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x1730 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,
/* 0x1740 */ 116,101,114, 95, 98,117,102,102,101,114, 95,101,110,100, 10, 48,
/* 0x1750 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1760 */  42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,116, 95,111,102,
/* 0x1770 */  95,114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1780 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x1790 */  32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,116,
/* 0x17a0 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x17b0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,116,
/* 0x17c0 */  95,111,102, 95,100,108,108, 95,110, 97,109,101,115, 10, 48, 48,
/* 0x17d0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,
/* 0x17e0 */ 117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,
/* 0x17f0 */ 114,101,115,115, 95, 56, 32, 48, 49, 49, 52, 32,117, 99,108, 95,
/* 0x1800 */ 110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x1810 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1820 */  32, 32, 70, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,
/* 0x1830 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 32, 48, 49, 48, 48,
/* 0x1840 */  32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,
/* 0x1850 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1860 */  32,103, 32, 32, 32, 32, 32, 70, 32, 46,117, 99,108, 95,110,114,
/* 0x1870 */ 118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x1880 */  32, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,
/* 0x1890 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x18a0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x18b0 */  68, 42, 32, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10,
/* 0x18c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x18d0 */  32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,115,116,
/* 0x18e0 */  97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48,
/* 0x18f0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x1900 */  42, 32, 48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48,
/* 0x1910 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1920 */  42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,
/* 0x1930 */ 112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1940 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1950 */  91, 68,108,108, 83,116, 97,114,116, 93, 58, 10, 79, 70, 70, 83,
/* 0x1960 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1970 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1980 */  48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1990 */  32, 32, 32, 32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116,
/* 0x19a0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x19b0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,120,101, 83,116, 97,
/* 0x19c0 */ 114,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x19d0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x19e0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82,
/* 0x19f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a00 */  32, 69,120,101, 83,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a10 */  49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1a20 */  32, 32, 32, 32, 32, 69,120,101, 83,116, 97,114,116, 10, 48, 48,
/* 0x1a30 */  48, 48, 48, 48, 50, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,
/* 0x1a40 */  51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x1a50 */ 102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48,
/* 0x1a60 */  48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,
/* 0x1a70 */  50, 32, 32, 32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,
/* 0x1a80 */ 101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a90 */  51, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,
/* 0x1aa0 */  32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,110,
/* 0x1ab0 */  99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48,
/* 0x1ac0 */  48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32,
/* 0x1ad0 */  32, 32, 32, 32, 32, 32,117,110, 99,111,109,112,114,101,115,115,
/* 0x1ae0 */ 101,100, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x1af0 */  52, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,
/* 0x1b00 */  32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108, 95,101,110,
/* 0x1b10 */ 116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1b20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85,110,102,
/* 0x1b30 */ 105,108,116,101,114, 95, 48,120, 53, 48, 93, 58, 10, 79, 70, 70,
/* 0x1b40 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1b50 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1b60 */  48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1b70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85,110,102,105,108,116,101,
/* 0x1b80 */ 114, 95, 48,120, 53, 48, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32,
/* 0x1b90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1ba0 */  32, 32, 85,110,102,105,108,116,101,114, 95, 48,120, 53, 48, 10,
/* 0x1bb0 */  48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1bc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,110,102,105,108,
/* 0x1bd0 */ 116,101,114, 95, 48,120, 53, 48, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x1be0 */  52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1bf0 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,
/* 0x1c00 */ 114, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 52, 56,
/* 0x1c10 */  32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32,
/* 0x1c20 */  32, 32, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,114,
/* 0x1c30 */  95,101,110,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1c40 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82,101,
/* 0x1c50 */ 108,111, 99,115, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1c60 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c70 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x1c80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1c90 */  32, 32, 32, 82,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ca0 */  53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1cb0 */  32, 32, 32, 32, 32, 82,101,108,111, 99,115, 10, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,
/* 0x1cd0 */  32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,
/* 0x1ce0 */ 114,101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1cf0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1d00 */  73,109,112,111,114,116,115, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x1d10 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d20 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x1d30 */  48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1d40 */  32, 32, 32, 32, 32, 32, 73,109,112,111,114,116,115, 10, 48, 48,
/* 0x1d50 */  48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1d60 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,114,116,115,
/* 0x1d70 */  10, 48, 48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x1d80 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,
/* 0x1d90 */ 114,116,115, 10, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 65,
/* 0x1da0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 73,
/* 0x1db0 */ 109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,
/* 0x1dc0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1dd0 */  32, 32, 73,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1df0 */  32, 32, 32, 32, 32, 73,109,112,111,114,116,115, 10, 48, 48, 48,
/* 0x1e00 */  48, 48, 48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1e10 */  32, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,114,116,115, 10,
/* 0x1e20 */  48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1e30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 73,109,112,111,114,
/* 0x1e40 */ 116,115, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82,
/* 0x1e50 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 73,109,
/* 0x1e60 */ 112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82,
/* 0x1e70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e80 */  32, 73,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x1e90 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 73,109,112,111,114,116,115, 10, 48, 48, 48, 48,
/* 0x1eb0 */  48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1ec0 */  32, 32, 32, 32, 32, 32, 32, 73,109,112,111,114,116,115, 10, 48,
/* 0x1ed0 */  48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66,
/* 0x1ee0 */  83, 51, 50, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,
/* 0x1ef0 */ 111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48,
/* 0x1f00 */  48, 98, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32,
/* 0x1f10 */  32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,100,
/* 0x1f20 */ 108,108, 95,110, 97,109,101,115, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x1f30 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x1f40 */  32, 91, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,
/* 0x1f50 */ 111,109,112,114,101,115,115, 95, 56, 93, 58, 10, 79, 70, 70, 83,
/* 0x1f60 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f70 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1f80 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1f90 */  32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x1fa0 */  50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,
/* 0x1fb0 */  48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1fc0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,
/* 0x1fd0 */ 110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x1fe0 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82,
/* 0x1ff0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117,
/* 0x2000 */  99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,
/* 0x2010 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82,
/* 0x2020 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2030 */  32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,
/* 0x2040 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x2050 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2060 */  32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,
/* 0x2070 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x2080 */  48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2090 */  32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,
/* 0x20a0 */ 101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x20c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,
/* 0x20d0 */ 114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x20e0 */  56, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x20f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,
/* 0x2100 */ 108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,
/* 0x2110 */ 115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95,
/* 0x2120 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2130 */  46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,
/* 0x2140 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 57, 52,
/* 0x2150 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,101,
/* 0x2170 */  99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48,
/* 0x2180 */  48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2190 */  32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101,
/* 0x21a0 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x21b0 */  48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x21c0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,
/* 0x21d0 */ 118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x21e0 */  10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x21f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108,
/* 0x2200 */  95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2210 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65,
/* 0x2220 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,
/* 0x2230 */ 117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,
/* 0x2240 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32,
/* 0x2250 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2260 */  32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,
/* 0x2270 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x2280 */  98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2290 */  32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,
/* 0x22a0 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48,
/* 0x22b0 */  48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x22c0 */  32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x22d0 */  50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,
/* 0x22e0 */  48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x22f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,
/* 0x2300 */ 110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x2310 */  95, 56, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82,
/* 0x2320 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117,
/* 0x2330 */  99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,
/* 0x2340 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82,
/* 0x2350 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2360 */  32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,
/* 0x2370 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x2380 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,101, 95,100,
/* 0x23a0 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x23b0 */  48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x23c0 */  32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,
/* 0x23d0 */ 101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x23e0 */  48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x23f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,
/* 0x2400 */ 114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x2410 */  56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2420 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 97,108,108, 50,
/* 0x2430 */  69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x2440 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x2450 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95,
/* 0x2460 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2470 */ 117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,
/* 0x2480 */ 114,101,115,115, 95, 56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2490 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x24a0 */  46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,
/* 0x24b0 */ 112,114,101,115,115, 95, 56, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x24c0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24d0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x24e0 */  48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x24f0 */  32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,100,
/* 0x2500 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x2510 */  48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2520 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,
/* 0x2530 */ 118, 50,100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x2540 */  10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2550 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108,
/* 0x2560 */  95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2570 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65,
/* 0x2580 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,
/* 0x2590 */ 117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,
/* 0x25a0 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32,
/* 0x25b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x25c0 */  32, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,
/* 0x25d0 */ 111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,
/* 0x25e0 */  54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x25f0 */  32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,
/* 0x2600 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48,
/* 0x2610 */  48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2620 */  32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x2630 */  50,100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,
/* 0x2640 */  48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2650 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,
/* 0x2660 */ 110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x2670 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82,
/* 0x2680 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117,
/* 0x2690 */  99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,
/* 0x26a0 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x26b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x26c0 */  32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,
/* 0x26d0 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x26e0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x26f0 */  32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,
/* 0x2700 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x2710 */  48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2720 */  32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,
/* 0x2730 */ 100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x2740 */  48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2750 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,
/* 0x2760 */ 114,118, 50,100, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x2770 */  56, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77,
/* 0x2780 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,
/* 0x2790 */ 108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,
/* 0x27a0 */ 115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95,
/* 0x27b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x27c0 */  46,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,
/* 0x27d0 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48,100, 48,
/* 0x27e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x27f0 */  32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,100, 95,100,101,
/* 0x2800 */  99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48,
/* 0x2810 */  48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2820 */  32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,100,
/* 0x2830 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x2840 */  48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2850 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,
/* 0x2860 */ 118, 50,100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x2870 */  10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2880 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108,
/* 0x2890 */  95,110,114,118, 50,100, 95,100,101, 99,111,109,112,114,101,115,
/* 0x28a0 */ 115, 95, 56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x28b0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 97,108,
/* 0x28c0 */ 108, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x28d0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28e0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x28f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2900 */  32, 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,
/* 0x2910 */ 109,112,114,101,115,115, 95, 56, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x2920 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x2930 */  32, 91, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,
/* 0x2940 */ 111,109,112,114,101,115,115, 95, 56, 93, 58, 10, 79, 70, 70, 83,
/* 0x2950 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2960 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2970 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2980 */  32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118,
/* 0x2990 */  50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,
/* 0x29a0 */  48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x29b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,
/* 0x29c0 */ 110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x29d0 */  95, 56, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82,
/* 0x29e0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117,
/* 0x29f0 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x2a00 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82,
/* 0x2a10 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a20 */  32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,
/* 0x2a30 */ 109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 54,
/* 0x2a40 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,
/* 0x2a60 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x2a70 */  48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2a80 */  32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50,
/* 0x2a90 */  98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x2aa0 */  48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2ab0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,
/* 0x2ac0 */ 114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x2ad0 */  56, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x2ae0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,
/* 0x2af0 */ 108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,
/* 0x2b00 */ 115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95,
/* 0x2b10 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b20 */  46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,
/* 0x2b30 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 56, 99,
/* 0x2b40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2b50 */  32, 32, 32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101,
/* 0x2b60 */  99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48,
/* 0x2b70 */  48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2b80 */  32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,118, 50, 98,
/* 0x2b90 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,
/* 0x2ba0 */  48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2bb0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108, 95,110,114,
/* 0x2bc0 */ 118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,
/* 0x2bd0 */  10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2be0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,117, 99,108,
/* 0x2bf0 */  95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2c00 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65,
/* 0x2c10 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 46,
/* 0x2c20 */ 117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,
/* 0x2c30 */ 114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32,
/* 0x2c40 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2c50 */  32, 32, 46,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,
/* 0x2c60 */ 111,109,112,114,101,115,115, 95, 56, 10, 10, 82, 69, 76, 79, 67,
/* 0x2c70 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2c80 */  82, 32, 91, 67, 97,108,108, 50, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x2c90 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ca0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2cb0 */  48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2cc0 */  32, 32, 32, 32, 32, 32, 32, 32,117, 99,108, 95,110,114,118, 50,
/* 0x2cd0 */  98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 10,
/* 0x2ce0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x2cf0 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 97,108,108, 76, 90, 77, 65,
/* 0x2d00 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x2d10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x2d20 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95, 65,
/* 0x2d30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x2d40 */  97,108,108, 76, 90, 77, 65, 10, 48, 48, 48, 48, 48, 48, 51, 56,
/* 0x2d50 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2d60 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 79, 68, 69, 10, 48,
/* 0x2d70 */  48, 48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 67, 97,108,108, 76, 90,
/* 0x2d90 */  77, 65, 10, 48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82,
/* 0x2da0 */  77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32,108,122,
/* 0x2db0 */ 109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x2dc0 */  56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x2dd0 */  32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,
/* 0x2de0 */ 100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82,
/* 0x2df0 */  95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x2e00 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x2e10 */  48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50,
/* 0x2e20 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,
/* 0x2e30 */ 101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2e40 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2e50 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x2e60 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2ea0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x2eb0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2ec0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2ed0 */  98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ee0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x2ef0 */  48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f00 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2f10 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82,
/* 0x2f20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f30 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x2f40 */  48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f50 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2f60 */  48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65, 82, 77,
/* 0x2f70 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2f80 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52,
/* 0x2f90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x2fb0 */  48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2fc0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2fd0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65,
/* 0x2fe0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2ff0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x3000 */ 100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3010 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3020 */  48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3030 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3040 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82,
/* 0x3050 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3060 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3070 */  48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3080 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3090 */  48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82, 77,
/* 0x30a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x30b0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 51, 99,
/* 0x30c0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x30d0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x30e0 */  48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x30f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3100 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65,
/* 0x3110 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3120 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x3130 */  53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3150 */  48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3160 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3170 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82,
/* 0x3180 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3190 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x31a0 */  48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x31b0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x31c0 */  48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x31d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x31e0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99,
/* 0x31f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3200 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3210 */  48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3220 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3230 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82, 95, 65,
/* 0x3240 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3250 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x3260 */  97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3270 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3280 */  48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3290 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x32a0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99, 32, 82,
/* 0x32b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x32c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x32d0 */  48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x32e0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x32f0 */  48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82, 77,
/* 0x3300 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3310 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 50, 52,
/* 0x3320 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3330 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3340 */  48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3350 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3360 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82, 95, 65,
/* 0x3370 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3380 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x3390 */  56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x33a0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x33b0 */  48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x33c0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x33d0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48, 32, 82,
/* 0x33e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x33f0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3400 */  48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3410 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3420 */  48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65, 82, 77,
/* 0x3430 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3440 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,102, 52,
/* 0x3450 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3460 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3470 */  48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3480 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3490 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95, 65,
/* 0x34a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x34b0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53,
/* 0x34c0 */  57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x34d0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x34e0 */  48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x34f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3500 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48, 32, 82,
/* 0x3510 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3520 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3530 */  48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3540 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3550 */  48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x3560 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3570 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 48, 52,
/* 0x3580 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3590 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x35a0 */  48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x35b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x35c0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82, 95, 65,
/* 0x35d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x35e0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x35f0 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3600 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3610 */  48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3620 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3630 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,100, 48, 32, 82,
/* 0x3640 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3650 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3660 */  48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3670 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3680 */  48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65, 82, 77,
/* 0x3690 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x36a0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 50, 56,
/* 0x36b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x36c0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x36d0 */  48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x36e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x36f0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82, 95, 65,
/* 0x3700 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3710 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x3720 */  57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3730 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3740 */  48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3750 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3760 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52, 32, 82,
/* 0x3770 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3780 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3790 */  48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x37a0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x37b0 */  48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65, 82, 77,
/* 0x37c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x37d0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 50, 48,
/* 0x37e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x37f0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3800 */  48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3810 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3820 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82, 95, 65,
/* 0x3830 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3840 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x3850 */  56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3860 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3870 */  48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3880 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3890 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,101, 56, 32, 82,
/* 0x38a0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x38b0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x38c0 */  48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x38d0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x38e0 */  48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x38f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3900 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 57, 48, 52,
/* 0x3910 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3920 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3930 */  48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3940 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3950 */  67, 49, 48, 10
};
