/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlDisplayTextArea
extends JTextPane {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public HtmlDisplayTextArea() {
        this.setEditable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.setRequestFocusEnabled(false);
        this.setMargin(NO_MARGIN);
        this.updateUI();
        this.setOpaque(false);
        this.setEditorKit(new HTMLEditorKit());
        Font font = UIManager.getFont("Label.font");
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        styleSheet.addRule("body {color : #" + this.getHexValue(UIManager.getColor("Label.foreground")) + " }");
        styleSheet.addRule("body {font-size : " + font.getSize() + "pt; }");
        styleSheet.addRule("body {font-family :" + font.getFontName() + "; }");
    }

    public boolean isFocusTraversable() {
        return false;
    }

    private String getHexValue(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendComponent(stringBuffer, color.getRed());
        this.appendComponent(stringBuffer, color.getGreen());
        this.appendComponent(stringBuffer, color.getBlue());
        return stringBuffer.toString();
    }

    private void appendComponent(StringBuffer stringBuffer, int n) {
        stringBuffer.append(StringUtil.padLeft(Integer.toHexString(n), '0', 2));
    }

    public void setText(String string) {
        string = InstallerUtil.sanitizeHTML(string);
        super.setText(string);
    }
}

