/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    private static final byte EQUALS_SIGN = 61;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64() {
    }

    public static String encodeForFiles(byte[] byArray) {
        return Base64.encode(byArray).replace('+', '-').replace('/', '_');
    }

    public static String encodeForFiles(String string) {
        try {
            return Base64.encodeForFiles(string.getBytes(PREFERRED_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static byte[] decodeForFiles(String string) {
        return Base64.decode(string.replace('-', '+').replace('_', '/'));
    }

    public static String decodeAsStringForFiles(String string) {
        try {
            return new String(Base64.decodeForFiles(string), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = n * 4 / 3;
        byte[] byArray2 = new byte[n2 + (n % 3 > 0 ? 4 : 0)];
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 2;
        while (n3 < n5) {
            Base64.encode3to4(byArray, n3, 3, byArray2, n4);
            n3 += 3;
            n4 += 4;
        }
        if (n3 < n) {
            Base64.encode3to4(byArray, n3, n - n3, byArray2, n4);
            n4 += 4;
        }
        try {
            return new String(byArray2, 0, n4, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n4);
        }
    }

    public static byte[] decode(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n = byArray.length;
        int n2 = n * 3 / 4;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        byte[] byArray3 = new byte[4];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(byArray[i] & 0x7F);
            byte by2 = DECODABET[by];
            if (by2 >= -5) {
                if (by2 < -1) continue;
                byArray3[n4++] = by;
                if (n4 <= 3) continue;
                n3 += Base64.decode4to3(byArray3, 0, byArray2, n3);
                n4 = 0;
                if (by != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + byArray[i] + "(decimal)");
            return null;
        }
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        return byArray4;
    }

    private static byte[] encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = ALPHABET[n4 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    private static int decode4to3(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray[n + 2] == 61) {
            int n3 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n3 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n4 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n4 >>> 16);
            byArray2[n2 + 1] = (byte)(n4 >>> 8);
            return 2;
        }
        try {
            int n5 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6 | DECODABET[byArray[n + 3]] & 0xFF;
            byArray2[n2] = (byte)(n5 >> 16);
            byArray2[n2 + 1] = (byte)(n5 >> 8);
            byArray2[n2 + 2] = (byte)n5;
            return 3;
        }
        catch (Exception exception) {
            System.err.println("" + byArray[n] + ": " + DECODABET[byArray[n]]);
            System.err.println("" + byArray[n + 1] + ": " + DECODABET[byArray[n + 1]]);
            System.err.println("" + byArray[n + 2] + ": " + DECODABET[byArray[n + 2]]);
            System.err.println("" + byArray[n + 3] + ": " + DECODABET[byArray[n + 3]]);
            return -1;
        }
    }

    static {
        byte[] byArray;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        try {
            byArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = _NATIVE_ALPHABET;
        }
        ALPHABET = byArray;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    }
}

