/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;

public class CreateSymlinkAction
extends SystemInstallOrUninstallAction {
    private File file;
    private File linkFile;
    private boolean removeOnUninstall = true;

    public File getFile() {
        return CreateSymlinkAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getLinkFile() {
        return CreateSymlinkAction.replaceVariables(this.linkFile);
    }

    public void setLinkFile(File file) {
        this.linkFile = file;
    }

    public boolean isRemoveOnUninstall() {
        return this.removeOnUninstall;
    }

    public void setRemoveOnUninstall(boolean bl) {
        this.removeOnUninstall = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        File file = context.getDestinationFile(this.getFile());
        if (file == null || !file.exists()) {
            return false;
        }
        File file2 = context.getDestinationFile(this.getLinkFile());
        if (file2 == null) {
            return false;
        }
        if (context instanceof InstallerContext) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file2, true, true);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        }
        if (this.removeOnUninstall) {
            FileInstaller.getInstance().registerUninstallFile(file2);
        }
        return UnixFileSystem.createLink(file.getAbsolutePath(), file2);
    }
}

