/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class WaitForHttpPortAction
extends SystemInstallOrUninstallAction {
    private String host = "localhost";
    private int port = 80;
    private String file = "";
    private int timeout = 60;
    private boolean acceptAllResponseCodes;
    private boolean indeterminateProgress = true;

    public String getHost() {
        return WaitForHttpPortAction.replaceVariables(this.host);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getFile() {
        return WaitForHttpPortAction.replaceVariables(this.file);
    }

    public void setFile(String string) {
        this.file = string;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean isAcceptAllResponseCodes() {
        return this.acceptAllResponseCodes;
    }

    public void setAcceptAllResponseCodes(boolean bl) {
        this.acceptAllResponseCodes = bl;
    }

    public boolean isIndeterminateProgress() {
        return this.indeterminateProgress;
    }

    public void setIndeterminateProgress(boolean bl) {
        this.indeterminateProgress = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws UserCanceledException {
        ProgressInterface progressInterface = context.getProgressInterface();
        if (this.indeterminateProgress) {
            progressInterface.setIndeterminateProgress(true);
        }
        try {
            URL uRL = this.getUrl();
            if (uRL == null) {
                boolean bl = false;
                return bl;
            }
            long l = System.currentTimeMillis();
            long l2 = this.timeout > 0 ? l + (long)(this.timeout * 1000) : Long.MAX_VALUE;
            while (System.currentTimeMillis() < l2 && !context.isCancelling()) {
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    VersionSpecificHelper.setConnectionTimeouts(httpURLConnection, Integer.getInteger("install4j.waitConnectTimeout", 2000), Integer.getInteger("install4j.waitReadTimeout", 5000));
                    int n = httpURLConnection.getResponseCode();
                    if (this.acceptAllResponseCodes || n == 200) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.indeterminateProgress) {
                progressInterface.setIndeterminateProgress(false);
            }
        }
    }

    private URL getUrl() {
        try {
            String string = this.getFile();
            return new URL("http", this.getHost(), this.port, (string.startsWith("/") ? "" : "/") + string);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getInstance().log(malformedURLException);
            return null;
        }
    }
}

