# Generated automatically -- do not modify!    -*- buffer-read-only: t -*-
# Spec file for Open vSwitch on Red Hat Enterprise Linux.

# Copyright (C) 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Nicira, Inc.
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.  This file is offered as-is,
# without warranty of any kind.
#
# If tests have to be skipped while building, specify the '--without check'
# option. For example:
#     rpmbuild -bb --without check rhel/openvswitch.spec
#
# Support for executing kernel data path tests under rpmbuild is
# provided, however this is intended for use only in test environments
# and should not be used otherwise (these tests require root privileges).
# These tests can be executed, for example, via:
#    rpmbuild -rb --with check_datapath_kernel openvswitch.src.rpm
#
# These tests will use the currently installed OVS kernel modules, when
# testing out of tree kernel modules the appropriate openvswitch-kmod
# package should be installed first.

%{!?release_number:%define release_number 1}

Name: openvswitch
Summary: Open vSwitch daemon/database/utilities
Group: System Environment/Daemons
URL: http://www.openvswitch.org/
Vendor: Nicira, Inc.
Version: 2.17.8

License: ASL 2.0
Release: %{release_number}%{?dist}
Source: openvswitch-%{version}.tar.gz
Buildroot: /tmp/openvswitch-rpm
Requires: logrotate, hostname, python >= 2.7, python-six
BuildRequires: python-six
BuildRequires: openssl-devel
BuildRequires: checkpolicy, selinux-policy-devel
BuildRequires: autoconf, automake, libtool
BuildRequires: python3-sphinx
BuildRequires: unbound-devel
BuildRequires: libunwind-devel

%bcond_without check
%bcond_with check_datapath_kernel

%description
Open vSwitch provides standard network bridging functions and
support for the OpenFlow protocol for remote per-flow control of
traffic.

%package devel
Summary:        Open vSwitch development package
Group:          Development/Libraries

%description devel
This package provides openvswitch headers and libopenvswitch for developers.

%package selinux-policy
Summary: Open vSwitch SELinux policy
License: ASL 2.0
BuildArch: noarch
Requires: selinux-policy-targeted

%description selinux-policy
Tailored Open vSwitch SELinux policy

%prep
%setup -q

%build
./configure --prefix=/usr --sysconfdir=/etc --localstatedir=%{_localstatedir} \
    --libdir=%{_libdir} --enable-ssl --enable-shared
make %{_smp_mflags}
make selinux-policy

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

rhel_cp() {
 base=$1
 mode=$2
 dst=$RPM_BUILD_ROOT/$(echo $base | sed 's,_,/,g')
 install -D -m $mode rhel/$base $dst
}
rhel_cp etc_init.d_openvswitch 0755
rhel_cp etc_logrotate.d_openvswitch 0644
rhel_cp etc_sysconfig_network-scripts_ifup-ovs 0755
rhel_cp etc_sysconfig_network-scripts_ifdown-ovs 0755
rhel_cp usr_share_openvswitch_scripts_sysconfig.template 0644

install -p -m 644 -D selinux/openvswitch-custom.pp \
    $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}/openvswitch-custom.pp

# Get rid of stuff we don't want to make RPM happy.
rm \
    $RPM_BUILD_ROOT/usr/bin/ovs-testcontroller \
    $RPM_BUILD_ROOT/usr/share/man/man8/ovs-testcontroller.8 \
    $RPM_BUILD_ROOT/usr/bin/ovs-test \
    $RPM_BUILD_ROOT/usr/bin/ovs-l3ping \
    $RPM_BUILD_ROOT/usr/share/man/man8/ovs-test.8 \
    $RPM_BUILD_ROOT/usr/share/man/man8/ovs-l3ping.8
(cd "$RPM_BUILD_ROOT" && rm -rf usr/%{_lib}/*.la)
(cd "$RPM_BUILD_ROOT" && rm -rf usr/include)

install -d -m 0755 $RPM_BUILD_ROOT%{_rundir}/openvswitch
install -d -m 0755 $RPM_BUILD_ROOT%{_localstatedir}/log/openvswitch
install -d -m 0755 $RPM_BUILD_ROOT/var/lib/openvswitch

%check
%if %{with check}
    if make check TESTSUITEFLAGS='%{_smp_mflags}' RECHECK=yes; then :;
    else
        cat tests/testsuite.log
        exit 1
    fi
%endif
%if %{with check_datapath_kernel}
    if make check-kernel RECHECK=yes; then :;
    else
        cat tests/system-kmod-testsuite.log
        exit 1
    fi
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post
# Create default or update existing /etc/sysconfig/openvswitch.
SYSCONFIG=/etc/sysconfig/openvswitch
TEMPLATE=/usr/share/openvswitch/scripts/sysconfig.template
if [ ! -e $SYSCONFIG ]; then
    cp $TEMPLATE $SYSCONFIG
else
    for var in $(awk -F'[ :]' '/^# [_A-Z0-9]+:/{print $2}' $TEMPLATE)
    do
        if ! grep $var $SYSCONFIG >/dev/null 2>&1; then
            echo >> $SYSCONFIG
            sed -n "/$var:/,/$var=/p" $TEMPLATE >> $SYSCONFIG
        fi
    done
fi

# Ensure all required services are set to run
/sbin/chkconfig --add openvswitch
/sbin/chkconfig openvswitch on

%pre selinux-policy
%selinux_relabel_pre -s targeted

%post selinux-policy
%selinux_modules_install -s targeted %{_datadir}/selinux/packages/%{name}/openvswitch-custom.pp

%preun
if [ "$1" = "0" ]; then     # $1 = 0 for uninstall
    /sbin/service openvswitch stop
    /sbin/chkconfig --del openvswitch
fi

%postun
if [ "$1" = "0" ]; then     # $1 = 0 for uninstall
    rm -f /etc/openvswitch/conf.db
    rm -f /etc/sysconfig/openvswitch
    rm -f /etc/openvswitch/vswitchd.cacert
fi

%postun selinux-policy
if [ $1 -eq 0 ] ; then
  %selinux_modules_uninstall -s targeted openvswitch-custom
fi

exit 0

%posttrans selinux-policy
%selinux_relabel_post -s targeted

%files
%defattr(-,root,root)
%dir /etc/openvswitch
/etc/bash_completion.d/ovs-appctl-bashcomp.bash
/etc/bash_completion.d/ovs-vsctl-bashcomp.bash
/etc/init.d/openvswitch
%config(noreplace) /etc/logrotate.d/openvswitch
/etc/sysconfig/network-scripts/ifup-ovs
/etc/sysconfig/network-scripts/ifdown-ovs
/usr/bin/ovs-appctl
/usr/bin/ovs-dpctl
/usr/bin/ovs-dpctl-top
/usr/bin/ovs-docker
/usr/bin/ovs-ofctl
/usr/bin/ovs-parse-backtrace
/usr/bin/ovs-pcap
/usr/bin/ovs-pki
/usr/bin/ovs-tcpdump
/usr/bin/ovs-tcpundump
/usr/bin/ovs-vlan-test
/usr/bin/ovs-vsctl
/usr/bin/ovsdb-client
/usr/bin/ovsdb-tool
/usr/bin/vtep-ctl
%{_libdir}/lib*.so.*
/usr/sbin/ovs-bugtool
/usr/sbin/ovs-vswitchd
/usr/sbin/ovsdb-server
/usr/share/man/man1/ovs-pcap.1.gz
/usr/share/man/man1/ovs-tcpundump.1.gz
/usr/share/man/man1/ovsdb-client.1.gz
/usr/share/man/man1/ovsdb-server.1.gz
/usr/share/man/man1/ovsdb-tool.1.gz
/usr/share/man/man5/ovsdb.local-config.5.gz
/usr/share/man/man5/ovsdb-server.5.gz
/usr/share/man/man5/ovs-vswitchd.conf.db.5.gz
%{_mandir}/man5/ovsdb.5*
/usr/share/man/man5/vtep.5.gz
/usr/share/man/man7/ovs-actions.7.gz
/usr/share/man/man7/ovs-fields.7.gz
%{_mandir}/man7/ovsdb.7*
%{_mandir}/man7/ovsdb-server.7*
/usr/share/man/man8/ovs-appctl.8.gz
/usr/share/man/man8/ovs-bugtool.8.gz
/usr/share/man/man8/ovs-ctl.8.gz
/usr/share/man/man8/ovs-dpctl.8.gz
/usr/share/man/man8/ovs-dpctl-top.8.gz
/usr/share/man/man8/ovs-kmod-ctl.8.gz
/usr/share/man/man8/ovs-ofctl.8.gz
/usr/share/man/man8/ovs-parse-backtrace.8.gz
/usr/share/man/man8/ovs-pki.8.gz
/usr/share/man/man8/ovs-tcpdump.8.gz
/usr/share/man/man8/ovs-vlan-test.8.gz
/usr/share/man/man8/ovs-vsctl.8.gz
/usr/share/man/man8/ovs-vswitchd.8.gz
/usr/share/man/man8/vtep-ctl.8.gz
/usr/share/openvswitch/bugtool-plugins/
/usr/share/openvswitch/python/
/usr/share/openvswitch/scripts/ovs-bugtool-*
/usr/share/openvswitch/scripts/ovs-check-dead-ifs
/usr/share/openvswitch/scripts/ovs-ctl
/usr/share/openvswitch/scripts/ovs-kmod-ctl
/usr/share/openvswitch/scripts/ovs-lib
/usr/share/openvswitch/scripts/ovs-save
/usr/share/openvswitch/scripts/ovs-vtep
/usr/share/openvswitch/scripts/sysconfig.template
/usr/share/openvswitch/scripts/ovs-monitor-ipsec
/usr/share/openvswitch/local-config.ovsschema
/usr/share/openvswitch/vswitch.ovsschema
/usr/share/openvswitch/vtep.ovsschema
%doc NOTICE README.rst NEWS rhel/README.RHEL.rst
/var/lib/openvswitch
/var/log/openvswitch

%files devel
%{_libdir}/lib*.so
%{_libdir}/lib*.a
%{_libdir}/pkgconfig
%{_includedir}/openvswitch/*

%files selinux-policy
%defattr(-,root,root)
%{_datadir}/selinux/packages/%{name}/openvswitch-custom.pp
