#!/bin/sh

# Copyright (C) 2004, 2005 Valery Reznic
# This file is part of the Elf Statifier project
# 
# This project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License.
# See LICENSE file in the doc directory.

# Create %files section for the spec file

[ $# -ne 3 -o "x$1" = "x" -o "x$2" = "x" -o "x$3" = "x" ] && {
	echo "Usage: $0 <other_file> <common_file> <elf_file>" 1>&2
	exit 1 
}

other_file=$1
common_file=$2
elf_file=$3

echo "#"                                                      || exit
echo "# Don't change this file. It was autogenerated by '$0'" || exit
echo "#"                                                      || exit

# sed, invoked as silent AND with comment removal
# if comment is detected, no empty line will be printed
r_c='{s/^#.*$//;t}'

# Output defattr
echo "%defattr(-,root,root)" || exit
echo                         || exit

# Copy other_file, removing comments
echo "# Other files"                || exit
	sed -n -e "$r_c" -e "p" < $other_file || exit
echo                                || exit

# Output common files, which have link, removing comments
echo "# Common files for elf32 and elf64"
	sed -n -e "$r_c" -e "s!@ELF_CLASS@/!!gp" < $common_file || exit
echo

for elf in 32 64; do
	echo "%if %{has_elf_$elf}"                                       || exit
		echo "# Elf$elf	own files"                               || exit
		sed -n -e "$r_c" -e "s/@ELF_CLASS@/$elf/gp" $elf_file    || exit
		echo "# Elf$elf	links"                                   || exit
		sed -n -e "$r_c" -e "s/@ELF_CLASS@/$elf/gp" $common_file || exit
	echo "%endif"                                                    || exit 
done || exit
exit 0
