/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.collect;

import java.util.EnumSet;

public final class Enum2IntMap<E extends Enum<E>> {
    private final int[] mappings;

    private Enum2IntMap(int[] mappings) {
        this.mappings = mappings;
    }

    public int get(E key) {
        return this.mappings[((Enum)key).ordinal()];
    }

    public static class Builder<E extends Enum<E>> {
        private final int[] mappings;
        private final EnumSet<E> populated;
        private int defaultValue = -1;

        public Builder(Class<E> klazz) {
            this.mappings = new int[((Enum[])klazz.getEnumConstants()).length];
            this.populated = EnumSet.noneOf(klazz);
        }

        public Builder<E> put(E key, int value) {
            this.mappings[((Enum)key).ordinal()] = value;
            this.populated.add(key);
            return this;
        }

        public Builder<E> remove(E key) {
            this.populated.remove(key);
            return this;
        }

        public Builder<E> defaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public int get(E key) {
            if (this.populated.contains(key)) {
                return this.mappings[((Enum)key).ordinal()];
            }
            return this.defaultValue;
        }

        public Enum2IntMap<E> build() {
            for (Enum unpopulated : EnumSet.complementOf(this.populated)) {
                this.mappings[unpopulated.ordinal()] = this.defaultValue;
            }
            return new Enum2IntMap((int[])this.mappings.clone());
        }
    }
}

