/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.CommandSource;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BrigadierUtils {
    private static final Splitter SPACE_SPLITTER = Splitter.on(' ');

    public static LiteralCommandNode<CommandSource> buildRedirect(String alias, LiteralCommandNode<CommandSource> destination) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(alias.toLowerCase(Locale.ENGLISH)).requires(destination.getRequirement())).forward(destination.getRedirect(), destination.getRedirectModifier(), destination.isFork())).executes(destination.getCommand());
        for (CommandNode child : destination.getChildren()) {
            builder.then(child);
        }
        return builder.build();
    }

    public static LiteralCommandNode<CommandSource> buildRawArgumentsLiteral(String alias, Command<CommandSource> brigadierCommand, SuggestionProvider<CommandSource> suggestionProvider) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(alias.toLowerCase(Locale.ENGLISH)).then(RequiredArgumentBuilder.argument("arguments", StringArgumentType.greedyString()).suggests(suggestionProvider).executes(brigadierCommand))).executes(brigadierCommand)).build();
    }

    public static String getAlias(CommandContext<CommandSource> context) {
        return context.getNodes().get(0).getNode().getName();
    }

    public static String getRawArguments(CommandContext<CommandSource> context) {
        String cmdLine = context.getInput();
        int firstSpace = cmdLine.indexOf(32);
        if (firstSpace == -1) {
            return "";
        }
        return cmdLine.substring(firstSpace + 1);
    }

    public static String[] getSplitArguments(CommandContext<CommandSource> context) {
        String line = BrigadierUtils.getRawArguments(context);
        if (line.isEmpty()) {
            return new String[0];
        }
        return SPACE_SPLITTER.splitToList(line).toArray(new String[0]);
    }

    public static String normalizeInput(String cmdLine, boolean trim) {
        String command = trim ? cmdLine.trim() : cmdLine;
        int firstSpace = command.indexOf(32);
        if (firstSpace != -1) {
            return command.substring(0, firstSpace).toLowerCase(Locale.ENGLISH) + command.substring(firstSpace);
        }
        return command.toLowerCase(Locale.ENGLISH);
    }

    public static CommandNode<CommandSource> wrapForHinting(CommandNode<CommandSource> node, @Nullable Command<CommandSource> command) {
        Preconditions.checkNotNull(node, "node");
        ArgumentBuilder<CommandSource, ?> builder = node.createBuilder();
        builder.executes(command);
        for (CommandNode<CommandSource> child : node.getChildren()) {
            builder.then(BrigadierUtils.wrapForHinting(child, command));
        }
        return builder.build();
    }

    private BrigadierUtils() {
        throw new AssertionError();
    }
}

