/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.protocol.packet.legacyping.LegacyMinecraftPingVersion;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;

public class LegacyDisconnect {
    private static final ServerPing.Players FAKE_PLAYERS = new ServerPing.Players(0, 0, ImmutableList.of());
    private static final String LEGACY_COLOR_CODE = Character.toString('\u00a7');
    private final String reason;

    private LegacyDisconnect(String reason) {
        this.reason = reason;
    }

    public static LegacyDisconnect fromServerPing(ServerPing response, LegacyMinecraftPingVersion version) {
        ServerPing.Players players = response.getPlayers().orElse(FAKE_PLAYERS);
        switch (version) {
            case MINECRAFT_1_3: {
                return new LegacyDisconnect(String.join((CharSequence)LEGACY_COLOR_CODE, LegacyDisconnect.cleanSectionSymbol(LegacyDisconnect.getFirstLine(PlainComponentSerializer.plain().serialize(response.getDescriptionComponent()))), Integer.toString(players.getOnline()), Integer.toString(players.getMax())));
            }
            case MINECRAFT_1_4: 
            case MINECRAFT_1_6: {
                return new LegacyDisconnect(String.join((CharSequence)"\u0000", LEGACY_COLOR_CODE + "1", Integer.toString(response.getVersion().getProtocol()), response.getVersion().getName(), LegacyDisconnect.getFirstLine(LegacyComponentSerializer.legacySection().serialize(response.getDescriptionComponent())), Integer.toString(players.getOnline()), Integer.toString(players.getMax())));
            }
        }
        throw new IllegalArgumentException("Unknown version " + (Object)((Object)version));
    }

    private static String cleanSectionSymbol(String string) {
        return string.replaceAll(LEGACY_COLOR_CODE, "");
    }

    private static String getFirstLine(String legacyMotd) {
        int newline = legacyMotd.indexOf(10);
        return newline == -1 ? legacyMotd : legacyMotd.substring(0, newline);
    }

    public static LegacyDisconnect from(TextComponent component) {
        String serialized = LegacyComponentSerializer.legacySection().serialize(component);
        return new LegacyDisconnect(serialized);
    }

    public String getReason() {
        return this.reason;
    }
}

