/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.proxy.plugin.PluginClassLoader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.kyori.event.EventSubscriber;
import net.kyori.event.PostResult;
import net.kyori.event.SimpleEventBus;
import net.kyori.event.method.MethodScanner;
import net.kyori.event.method.MethodSubscriptionAdapter;
import net.kyori.event.method.SimpleMethodSubscriptionAdapter;
import net.kyori.event.method.asm.ASMEventExecutorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VelocityEventManager
implements EventManager {
    private static final Logger logger = LogManager.getLogger(VelocityEventManager.class);
    private final ListMultimap<Object, Object> registeredListenersByPlugin = Multimaps.synchronizedListMultimap(Multimaps.newListMultimap(new IdentityHashMap(), ArrayList::new));
    private final ListMultimap<Object, EventHandler<?>> registeredHandlersByPlugin = Multimaps.synchronizedListMultimap(Multimaps.newListMultimap(new IdentityHashMap(), ArrayList::new));
    private final SimpleEventBus<Object> bus;
    private final MethodSubscriptionAdapter<Object> methodAdapter;
    private final ExecutorService service;
    private final PluginManager pluginManager;

    public VelocityEventManager(PluginManager pluginManager) {
        PluginClassLoader cl = AccessController.doPrivileged(() -> new PluginClassLoader(new URL[0]));
        cl.addToClassloaders();
        this.bus = new SimpleEventBus<Object>(Object.class){

            @Override
            protected boolean shouldPost(@NonNull Object event, @NonNull EventSubscriber<?> subscriber) {
                return true;
            }
        };
        this.methodAdapter = new SimpleMethodSubscriptionAdapter<Object, Object>(this.bus, new ASMEventExecutorFactory(cl), new VelocityMethodScanner());
        this.pluginManager = pluginManager;
        this.service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("Velocity Event Executor - #%d").setDaemon(true).build());
    }

    private void ensurePlugin(Object plugin) {
        Preconditions.checkNotNull(plugin, "plugin");
        Preconditions.checkArgument(this.pluginManager.fromInstance(plugin).isPresent(), "Specified plugin is not loaded");
    }

    @Override
    public void register(Object plugin, Object listener) {
        this.ensurePlugin(plugin);
        Preconditions.checkNotNull(listener, "listener");
        if (plugin == listener && this.registeredListenersByPlugin.containsEntry(plugin, plugin)) {
            throw new IllegalArgumentException("The plugin main instance is automatically registered.");
        }
        this.registeredListenersByPlugin.put(plugin, listener);
        this.methodAdapter.register(listener);
    }

    @Override
    public <E> void register(Object plugin, Class<E> eventClass, PostOrder postOrder, EventHandler<E> handler) {
        this.ensurePlugin(plugin);
        Preconditions.checkNotNull(eventClass, "eventClass");
        Preconditions.checkNotNull(postOrder, "postOrder");
        Preconditions.checkNotNull(handler, "listener");
        this.registeredHandlersByPlugin.put(plugin, handler);
        this.bus.register(eventClass, new KyoriToVelocityHandler(handler, postOrder));
    }

    @Override
    public <E> CompletableFuture<E> fire(E event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (!this.bus.hasSubscribers(event.getClass())) {
            return CompletableFuture.completedFuture(event);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.fireEvent(event);
            return event;
        }, this.service);
    }

    @Override
    public void fireAndForget(Object event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (!this.bus.hasSubscribers(event.getClass())) {
            return;
        }
        this.service.execute(() -> this.fireEvent(event));
    }

    private void fireEvent(Object event) {
        PostResult result = this.bus.post(event);
        if (!result.exceptions().isEmpty()) {
            logger.error("Some errors occurred whilst posting event {}.", event);
            int i = 0;
            for (Throwable exception : result.exceptions().values()) {
                logger.error("#{}: \n", (Object)(++i), (Object)exception);
            }
        }
    }

    private void unregisterHandler(EventHandler<?> handler) {
        this.bus.unregister(s -> s instanceof KyoriToVelocityHandler && ((KyoriToVelocityHandler)s).handler == handler);
    }

    @Override
    public void unregisterListeners(Object plugin) {
        this.ensurePlugin(plugin);
        Collection listeners = this.registeredListenersByPlugin.removeAll(plugin);
        listeners.forEach(this.methodAdapter::unregister);
        Collection handlers = this.registeredHandlersByPlugin.removeAll(plugin);
        handlers.forEach(this::unregisterHandler);
    }

    @Override
    public void unregisterListener(Object plugin, Object listener) {
        this.ensurePlugin(plugin);
        Preconditions.checkNotNull(listener, "listener");
        if (this.registeredListenersByPlugin.remove(plugin, listener)) {
            this.methodAdapter.unregister(listener);
        }
    }

    @Override
    public <E> void unregister(Object plugin, EventHandler<E> handler) {
        this.ensurePlugin(plugin);
        Preconditions.checkNotNull(handler, "listener");
        if (this.registeredHandlersByPlugin.remove(plugin, handler)) {
            this.unregisterHandler(handler);
        }
    }

    public boolean shutdown() throws InterruptedException {
        this.service.shutdown();
        return this.service.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public void fireShutdownEvent() {
        this.fireEvent(new ProxyShutdownEvent());
    }

    public ExecutorService getService() {
        return this.service;
    }

    private static class KyoriToVelocityHandler<E>
    implements EventSubscriber<E> {
        private final EventHandler<E> handler;
        private final int postOrder;

        private KyoriToVelocityHandler(EventHandler<E> handler, PostOrder postOrder) {
            this.handler = handler;
            this.postOrder = postOrder.ordinal();
        }

        @Override
        public void invoke(@NonNull E event) {
            this.handler.execute(event);
        }

        @Override
        public int postOrder() {
            return this.postOrder;
        }
    }

    private static class VelocityMethodScanner
    implements MethodScanner<Object> {
        private VelocityMethodScanner() {
        }

        @Override
        public boolean shouldRegister(@NonNull Object listener, @NonNull Method method) {
            return method.isAnnotationPresent(Subscribe.class);
        }

        @Override
        public int postOrder(@NonNull Object listener, @NonNull Method method) {
            return method.getAnnotation(Subscribe.class).order().ordinal();
        }

        @Override
        public boolean consumeCancelledEvents(@NonNull Object listener, @NonNull Method method) {
            return true;
        }
    }
}

