/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.forge.legacy;

import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientConnectionPhase;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.forge.legacy.LegacyForgeUtil;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import java.util.List;
import javax.annotation.Nullable;

public enum LegacyForgeHandshakeClientPhase implements ClientConnectionPhase
{
    NOT_STARTED(1){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return HELLO;
        }

        @Override
        public void onFirstJoin(ConnectedPlayer player) {
            player.setPhase(COMPLETE);
        }

        @Override
        boolean onHandle(ConnectedPlayer player, PluginMessage message, MinecraftConnection backendConn) {
            return false;
        }
    }
    ,
    HELLO(2){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return MOD_LIST;
        }
    }
    ,
    MOD_LIST(-1){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return WAITING_SERVER_DATA;
        }

        @Override
        boolean onHandle(ConnectedPlayer player, PluginMessage message, MinecraftConnection backendConn) {
            List<ModInfo.Mod> mods;
            if (!player.getModInfo().isPresent() && !(mods = LegacyForgeUtil.readModList(message)).isEmpty()) {
                player.setModInfo(new ModInfo("FML", mods));
            }
            return super.onHandle(player, message, backendConn);
        }
    }
    ,
    WAITING_SERVER_DATA(-1){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return WAITING_SERVER_COMPLETE;
        }
    }
    ,
    WAITING_SERVER_COMPLETE(-1){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return PENDING_COMPLETE;
        }
    }
    ,
    PENDING_COMPLETE(-1){

        @Override
        LegacyForgeHandshakeClientPhase nextPhase() {
            return COMPLETE;
        }
    }
    ,
    COMPLETE(null){

        @Override
        public void resetConnectionPhase(ConnectedPlayer player) {
            player.getConnection().write(LegacyForgeUtil.resetPacket());
            player.setPhase(NOT_STARTED);
        }

        @Override
        public boolean consideredComplete() {
            return true;
        }

        @Override
        boolean onHandle(ConnectedPlayer player, PluginMessage message, MinecraftConnection backendConn) {
            super.onHandle(player, message, backendConn);
            player.sendKeepAlive();
            MinecraftSessionHandler handler = backendConn.getSessionHandler();
            if (handler instanceof ClientPlaySessionHandler) {
                ((ClientPlaySessionHandler)handler).flushQueuedMessages();
            }
            return true;
        }
    };

    @Nullable
    private final Integer packetToAdvanceOn;

    private LegacyForgeHandshakeClientPhase(Integer packetToAdvanceOn) {
        this.packetToAdvanceOn = packetToAdvanceOn;
    }

    @Override
    public final boolean handle(ConnectedPlayer player, PluginMessage message, VelocityServerConnection server) {
        MinecraftConnection backendConn;
        if (server != null && (backendConn = server.getConnection()) != null && message.getChannel().equals("FML|HS")) {
            LegacyForgeHandshakeClientPhase newPhase = this.getNewPhase(message);
            player.setPhase(newPhase);
            return newPhase.onHandle(player, message, backendConn);
        }
        return false;
    }

    boolean onHandle(ConnectedPlayer player, PluginMessage message, MinecraftConnection backendConn) {
        backendConn.write(message.retain());
        return true;
    }

    @Override
    public boolean consideredComplete() {
        return false;
    }

    LegacyForgeHandshakeClientPhase nextPhase() {
        return this;
    }

    private LegacyForgeHandshakeClientPhase getNewPhase(PluginMessage packet) {
        if (this.packetToAdvanceOn != null && LegacyForgeUtil.getHandshakePacketDiscriminator(packet) == this.packetToAdvanceOn) {
            return this.nextPhase();
        }
        return this;
    }
}

