declare const rules: {
    'adjacent-overload-signatures': import("@typescript-eslint/utils/ts-eslint").RuleModule<"adjacentSignature", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'array-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./array-type").MessageIds, import("./array-type").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'await-thenable': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./await-thenable").MessageId, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'ban-ts-comment': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./ban-ts-comment").MessageIds, import("./ban-ts-comment").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'ban-tslint-comment': import("@typescript-eslint/utils/ts-eslint").RuleModule<"commentDetected", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'class-literal-property-style': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./class-literal-property-style").MessageIds, import("./class-literal-property-style").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'class-methods-use-this': import("@typescript-eslint/utils/ts-eslint").RuleModule<"missingThis", import("./class-methods-use-this").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-generic-constructors': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./consistent-generic-constructors").MessageIds, import("./consistent-generic-constructors").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-indexed-object-style': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./consistent-indexed-object-style").MessageIds, import("./consistent-indexed-object-style").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-return': import("@typescript-eslint/utils/ts-eslint").RuleModule<"missingReturn" | "missingReturnValue" | "unexpectedReturnValue", [({
        treatUndefinedAsUnspecified?: boolean;
    } | undefined)?], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-type-assertions': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./consistent-type-assertions").MessageIds, import("./consistent-type-assertions").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-type-definitions': import("@typescript-eslint/utils/ts-eslint").RuleModule<"interfaceOverType" | "typeOverInterface", [string], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-type-exports': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./consistent-type-exports").MessageIds, import("./consistent-type-exports").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'consistent-type-imports': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./consistent-type-imports").MessageIds, import("./consistent-type-imports").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'default-param-last': import("@typescript-eslint/utils/ts-eslint").RuleModule<"shouldBeLast", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'dot-notation': import("@typescript-eslint/utils/ts-eslint").RuleModule<"useBrackets" | "useDot", [{
        allowIndexSignaturePropertyAccess?: boolean;
        allowKeywords?: boolean;
        allowPattern?: string;
        allowPrivateClassPropertyAccess?: boolean;
        allowProtectedClassPropertyAccess?: boolean;
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'explicit-function-return-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<"missingReturnType", import("./explicit-function-return-type").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'explicit-member-accessibility': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./explicit-member-accessibility").MessageIds, import("./explicit-member-accessibility").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'explicit-module-boundary-types': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./explicit-module-boundary-types").MessageIds, import("./explicit-module-boundary-types").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'init-declarations': import("@typescript-eslint/utils/ts-eslint").RuleModule<"initialized" | "notInitialized", ["always" | "never", ({
        ignoreForLoopInit?: boolean;
    } | undefined)?], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'max-params': import("@typescript-eslint/utils/ts-eslint").RuleModule<"exceed", ({
        countVoidThis?: boolean;
        max: number;
    } | {
        countVoidThis?: boolean;
        maximum: number;
    })[], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'member-ordering': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./member-ordering").MessageIds, import("./member-ordering").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'method-signature-style': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./method-signature-style").MessageIds, import("./method-signature-style").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'naming-convention': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./naming-convention").MessageIds, import("./naming-convention").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-array-constructor': import("@typescript-eslint/utils/ts-eslint").RuleModule<"useLiteral", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-array-delete': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-array-delete").MessageId, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-base-to-string': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-base-to-string").MessageIds, import("./no-base-to-string").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-confusing-non-null-assertion': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-confusing-non-null-assertion").MessageId, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-confusing-void-expression': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-confusing-void-expression").MessageId, import("./no-confusing-void-expression").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-deprecated': import("@typescript-eslint/utils/ts-eslint").RuleModule<"deprecated" | "deprecatedWithReason", [{
        allow?: import("@typescript-eslint/type-utils").TypeOrValueSpecifier[];
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-dupe-class-members': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unexpected", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-duplicate-enum-values': import("@typescript-eslint/utils/ts-eslint").RuleModule<"duplicateValue", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-duplicate-type-constituents': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-duplicate-type-constituents").MessageIds, import("./no-duplicate-type-constituents").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-dynamic-delete': import("@typescript-eslint/utils/ts-eslint").RuleModule<"dynamicDelete", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-empty-function': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unexpected" | "suggestComment", [{
        allow?: string[];
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-empty-interface': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-empty-interface").MessageIds, import("./no-empty-interface").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-empty-object-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-empty-object-type").MessageIds, import("./no-empty-object-type").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-explicit-any': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-explicit-any").MessageIds, import("./no-explicit-any").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-extra-non-null-assertion': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noExtraNonNullAssertion", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-extraneous-class': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-extraneous-class").MessageIds, import("./no-extraneous-class").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-floating-promises': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-floating-promises").MessageId, import("./no-floating-promises").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-for-in-array': import("@typescript-eslint/utils/ts-eslint").RuleModule<"forInViolation", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-implied-eval': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noFunctionConstructor" | "noImpliedEvalError", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-import-type-side-effects': import("@typescript-eslint/utils/ts-eslint").RuleModule<"useTopLevelQualifier", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-inferrable-types': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noInferrableType", import("./no-inferrable-types").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-invalid-this': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unexpectedThis", [({
        capIsConstructor?: boolean;
    } | undefined)?], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-invalid-void-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-invalid-void-type").MessageIds, [import("./no-invalid-void-type").Options], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-loop-func': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unsafeRefs", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-loss-of-precision': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noLossOfPrecision", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-magic-numbers': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noMagic", [{
        detectObjects?: boolean;
        enforceConst?: boolean;
        ignore?: (number | string)[];
        ignoreArrayIndexes?: boolean;
        ignoreEnums?: boolean;
        ignoreNumericLiteralTypes?: boolean;
        ignoreReadonlyClassProperties?: boolean;
        ignoreTypeIndexes?: boolean;
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-meaningless-void-operator': import("@typescript-eslint/utils/ts-eslint").RuleModule<"meaninglessVoidOperator" | "removeVoid", import("./no-meaningless-void-operator").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-misused-new': import("@typescript-eslint/utils/ts-eslint").RuleModule<"errorMessageClass" | "errorMessageInterface", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-misused-promises': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-misused-promises").MessageId, import("./no-misused-promises").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-misused-spread': import("@typescript-eslint/utils/ts-eslint").RuleModule<"addAwait" | "noArraySpreadInObject" | "noClassDeclarationSpreadInObject" | "noClassInstanceSpreadInObject" | "noFunctionSpreadInObject" | "noIterableSpreadInObject" | "noMapSpreadInObject" | "noPromiseSpreadInObject" | "noStringSpread" | "replaceMapSpreadInObject", [{
        allow?: import("@typescript-eslint/type-utils").TypeOrValueSpecifier[];
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-mixed-enums': import("@typescript-eslint/utils/ts-eslint").RuleModule<"mixed", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-namespace': import("@typescript-eslint/utils/ts-eslint").RuleModule<"moduleSyntaxIsPreferred", import("./no-namespace").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-non-null-asserted-nullish-coalescing': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noNonNullAssertedNullishCoalescing" | "suggestRemovingNonNull", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-non-null-asserted-optional-chain': import("@typescript-eslint/utils/ts-eslint").RuleModule<"suggestRemovingNonNull" | "noNonNullOptionalChain", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-non-null-assertion': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-non-null-assertion").MessageIds, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-redeclare': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-redeclare").MessageIds, import("./no-redeclare").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-redundant-type-constituents': import("@typescript-eslint/utils/ts-eslint").RuleModule<"overrides" | "errorTypeOverrides" | "literalOverridden" | "overridden" | "primitiveOverridden", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-require-imports': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noRequireImports", import("./no-require-imports").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-restricted-imports': import("@typescript-eslint/utils/ts-eslint").RuleModule<"everything" | "everythingWithCustomMessage" | "importName" | "importNameWithCustomMessage" | "path" | "pathWithCustomMessage" | "patterns" | "patternWithCustomMessage", [import("eslint/lib/rules/no-restricted-imports").ObjectOfPathsAndPatterns] | import("eslint/lib/rules/no-restricted-imports").ArrayOfStringOrObject, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-restricted-types': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-restricted-types").MessageIds, import("./no-restricted-types").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-shadow': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-shadow").MessageIds, import("./no-shadow").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-this-alias': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-this-alias").MessageIds, import("./no-this-alias").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-type-alias': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-type-alias").MessageIds, import("./no-type-alias").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-boolean-literal-compare': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unnecessary-boolean-literal-compare").MessageIds, import("./no-unnecessary-boolean-literal-compare").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-condition': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unnecessary-condition").MessageId, import("./no-unnecessary-condition").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-parameter-property-assignment': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unnecessaryAssign", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-qualifier': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unnecessaryQualifier", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-template-expression': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noUnnecessaryTemplateExpression", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-type-arguments': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unnecessaryTypeParameter", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-type-assertion': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unnecessary-type-assertion").MessageIds, import("./no-unnecessary-type-assertion").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-type-constraint': import("@typescript-eslint/utils/ts-eslint").RuleModule<"removeUnnecessaryConstraint" | "unnecessaryConstraint", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-type-conversion': import("@typescript-eslint/utils/ts-eslint").RuleModule<"suggestRemove" | "suggestSatisfies" | "unnecessaryTypeConversion", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unnecessary-type-parameters': import("@typescript-eslint/utils/ts-eslint").RuleModule<"replaceUsagesWithConstraint" | "sole", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-argument': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unsafe-argument").MessageIds, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-assignment': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unsafeArraySpread" | "anyAssignment" | "anyAssignmentThis" | "unsafeArrayPattern" | "unsafeArrayPatternFromTuple" | "unsafeAssignment" | "unsafeObjectPattern", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-call': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unsafe-call").MessageIds, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-declaration-merging': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unsafeMerging", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-enum-comparison': import("@typescript-eslint/utils/ts-eslint").RuleModule<"mismatchedCase" | "mismatchedCondition" | "replaceValueWithEnum", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-function-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<"bannedFunctionType", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-member-access': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unsafe-member-access").MessageIds, import("./no-unsafe-member-access").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-return': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unsafeReturn" | "unsafeReturnAssignment" | "unsafeReturnThis", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-type-assertion': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unsafeOfAnyTypeAssertion" | "unsafeToAnyTypeAssertion" | "unsafeToUnconstrainedTypeAssertion" | "unsafeTypeAssertion" | "unsafeTypeAssertionAssignableToConstraint", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unsafe-unary-minus': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unaryMinus", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unused-expressions': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unusedExpression", [{
        allowShortCircuit?: boolean;
        allowTaggedTemplates?: boolean;
        allowTernary?: boolean;
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unused-private-class-members': import("@typescript-eslint/utils/ts-eslint").RuleModule<"unusedPrivateClassMember", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-unused-vars': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./no-unused-vars").MessageIds, import("./no-unused-vars").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-use-before-define': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noUseBeforeDefine", import("./no-use-before-define").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-useless-constructor': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noUselessConstructor" | "removeConstructor", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-useless-default-assignment': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferOptionalSyntax" | "uselessDefaultAssignment" | "uselessUndefined", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-useless-empty-export': import("@typescript-eslint/utils/ts-eslint").RuleModule<"uselessExport", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-var-requires': import("@typescript-eslint/utils/ts-eslint").RuleModule<"noVarReqs", import("./no-var-requires").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'no-wrapper-object-types': import("@typescript-eslint/utils/ts-eslint").RuleModule<"bannedClassType", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'non-nullable-type-assertion-style': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferNonNullAssertion", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'only-throw-error': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./only-throw-error").MessageIds, import("./only-throw-error").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'parameter-properties': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./parameter-properties").MessageIds, import("./parameter-properties").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-as-const': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferConstAssertion" | "variableConstAssertion" | "variableSuggest", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-destructuring': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferDestructuring", import("./prefer-destructuring").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-enum-initializers': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./prefer-enum-initializers").MessageIds, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-find': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferFind" | "preferFindSuggestion", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-for-of': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferForOf", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-function-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<"functionTypeOverCallableType" | "unexpectedThisOnFunctionOnlyInterface", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-includes': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferIncludes" | "preferStringIncludes", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-literal-enum-member': import("@typescript-eslint/utils/ts-eslint").RuleModule<"notLiteral" | "notLiteralOrBitwiseExpression", [{
        allowBitwiseExpressions: boolean;
    }], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-namespace-keyword': import("@typescript-eslint/utils/ts-eslint").RuleModule<"useNamespace", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-nullish-coalescing': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./prefer-nullish-coalescing").MessageIds, import("./prefer-nullish-coalescing").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-optional-chain': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./prefer-optional-chain-utils/PreferOptionalChainOptions").PreferOptionalChainMessageIds, [import("./prefer-optional-chain-utils/PreferOptionalChainOptions").PreferOptionalChainOptions], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-promise-reject-errors': import("@typescript-eslint/utils/ts-eslint").RuleModule<"rejectAnError", import("./prefer-promise-reject-errors").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-readonly': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferReadonly", import("./prefer-readonly").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-readonly-parameter-types': import("@typescript-eslint/utils/ts-eslint").RuleModule<"shouldBeReadonly", import("./prefer-readonly-parameter-types").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-reduce-type-parameter': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferTypeParameter", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-regexp-exec': import("@typescript-eslint/utils/ts-eslint").RuleModule<"regExpExecOverStringMatch", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-return-this-type': import("@typescript-eslint/utils/ts-eslint").RuleModule<"useThisType", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-string-starts-ends-with': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./prefer-string-starts-ends-with").MessageIds, import("./prefer-string-starts-ends-with").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'prefer-ts-expect-error': import("@typescript-eslint/utils/ts-eslint").RuleModule<"preferExpectErrorComment", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'promise-function-async': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./promise-function-async").MessageIds, import("./promise-function-async").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'related-getter-setter-pairs': import("@typescript-eslint/utils/ts-eslint").RuleModule<"mismatch", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'require-array-sort-compare': import("@typescript-eslint/utils/ts-eslint").RuleModule<"requireCompare", import("./require-array-sort-compare").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'require-await': import("@typescript-eslint/utils/ts-eslint").RuleModule<"missingAwait" | "removeAsync", [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'restrict-plus-operands': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./restrict-plus-operands").MessageIds, import("./restrict-plus-operands").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'restrict-template-expressions': import("@typescript-eslint/utils/ts-eslint").RuleModule<"invalidType", import("./restrict-template-expressions").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'return-await': import("@typescript-eslint/utils/ts-eslint").RuleModule<"disallowedPromiseAwait" | "disallowedPromiseAwaitSuggestion" | "nonPromiseAwait" | "requiredPromiseAwait" | "requiredPromiseAwaitSuggestion", [string], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'sort-type-constituents': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./sort-type-constituents").MessageIds, import("./sort-type-constituents").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'strict-boolean-expressions': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./strict-boolean-expressions").MessageId, import("./strict-boolean-expressions").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'switch-exhaustiveness-check': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./switch-exhaustiveness-check").MessageIds, import("./switch-exhaustiveness-check").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'triple-slash-reference': import("@typescript-eslint/utils/ts-eslint").RuleModule<"tripleSlashReference", import("./triple-slash-reference").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    typedef: import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./typedef").MessageIds, import("./typedef").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'unbound-method': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./unbound-method").MessageIds, import("./unbound-method").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'unified-signatures': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./unified-signatures").MessageIds, import("./unified-signatures").Options, import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
    'use-unknown-in-catch-callback-variable': import("@typescript-eslint/utils/ts-eslint").RuleModule<import("./use-unknown-in-catch-callback-variable").MessageIds, [], import("../../rules").ESLintPluginDocs, import("@typescript-eslint/utils/ts-eslint").RuleListener> & {
        name: string;
    };
};
export = rules;
