/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ElementType, type ReactNode } from 'react';
import type { AlignContent, AlignItems, AutoFlow, BasePrimitiveProps, GapToken, JustifyContent, JustifyItems } from './types';
export type GridProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Flex. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol';
    /**
     * Used to align children along the inline axis.
     */
    justifyContent?: JustifyContent;
    /**
     * Used to align the grid along the inline axis.
     *
     * @deprecated This prop is not hooked up and doesn't nothing!
     */
    justifyItems?: JustifyItems;
    /**
     * Used to align children along the block axis.
     */
    alignItems?: AlignItems;
    /**
     * Used to align the grid along the block axis.
     */
    alignContent?: AlignContent;
    /**
     * Represents the space between each column.
     */
    columnGap?: GapToken;
    /**
     * Represents the space between each child across both axes.
     */
    gap?: GapToken;
    /**
     * Represents the space between each row.
     */
    rowGap?: GapToken;
    /**
     * Specifies how auto-placed items get flowed into the grid. CSS `grid-auto-flow`.
     */
    autoFlow?: AutoFlow;
    /**
     * Elements to be rendered inside the grid. Required as a grid without children should not be a grid.
     */
    children: ReactNode;
    /**
     * HTML id attrubute.
     */
    id?: string;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
declare const Grid: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<GridProps<ElementType>, "ref"> & import("react").RefAttributes<any>>>;
export default Grid;
