/* stack.tsx generated by @compiled/babel-plugin v0.36.1 */
import "./stack.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
import { forwardRef, memo } from 'react';
import { cx } from '@atlaskit/css';
import Flex from './flex';
var styles = {
  hug: "_16jlidpf",
  fill: "_1bsb1osq _16jlkb7n"
};

/**
 * __Stack__
 *
 * Stack is a primitive component based on flexbox that manages the block layout of direct children.
 *
 * @example
 * ```tsx
 *  <Stack>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Stack>
 * ```
 *
 */
var Stack = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignInline,
    _ref$alignBlock = _ref.alignBlock,
    alignBlock = _ref$alignBlock === void 0 ? 'stretch' : _ref$alignBlock,
    spread = _ref.spread,
    grow = _ref.grow,
    space = _ref.space,
    children = _ref.children,
    testId = _ref.testId,
    xcss = _ref.xcss,
    role = _ref.role;
  return /*#__PURE__*/React.createElement(Flex, {
    as: as,
    role: role,
    gap: space,
    direction: "column",
    alignItems: alignItems,
    justifyContent: spread || alignBlock,
    xcss: cx(grow === 'hug' && styles.hug, grow === 'fill' && styles.fill, xcss),
    testId: testId,
    ref: ref
  }, children);
}));
Stack.displayName = 'Stack';
export default Stack;