from libcpp.map cimport map
from libcpp.pair cimport pair
from libcpp.vector cimport vector
from libcpp cimport bool
from libcpp.string cimport string
from libcpp.memory cimport unique_ptr
from cpython.exc cimport PyErr_NewException

ctypedef int PdgId
ctypedef pair[PdgId,PdgId] PdgIdPair

cdef extern from "<sstream>" namespace "std":
    cdef cppclass ostringstream:
        ostringstream()
        string& str()
    cdef cppclass istringstream:
        istringstream()
        string& str(string&)

# Import the error handling C++ routine
cdef extern from "Python.h" nogil:
    ctypedef struct PyObject

cdef extern from "errors.hh" namespace "Rivet":
    cdef PyObject* RivetExc_Error
    cdef PyObject* RivetExc_RangeError
    cdef PyObject* RivetExc_LogicError
    cdef PyObject* RivetExc_PidError
    cdef PyObject* RivetExc_InfoError
    cdef PyObject* RivetExc_BeamError
    cdef PyObject* RivetExc_SmearError
    cdef PyObject* RivetExc_WeightError
    cdef PyObject* RivetExc_UserError
    cdef PyObject* RivetExc_LookupError
    cdef PyObject* RivetExc_DataError
    cdef PyObject* RivetExc_IOError
    cdef PyObject* RivetExc_ReadError
    cdef PyObject* RivetExc_WriteError

    cdef void create_custom_exceptions()

    # Have a look in errors.hh for implementation specifics
    cdef void riveterr "Rivet::translate_rivet_error" ()

cdef extern from "Rivet/AnalysisHandler.hh" namespace "Rivet":
    cdef cppclass AnalysisHandler:
        void setCheckBeams(bool) except +riveterr
        void skipMultiWeights(bool) except +riveterr
        void matchWeightNames(string) except +riveterr
        void unmatchWeightNames(string) except +riveterr
        void setNominalWeightName(string) except +riveterr
        void setBootstrapFilename(string) except +riveterr
        void setNLOSmearing(double) except +riveterr

        AnalysisHandler& addAnalysis(string) except +riveterr
        vector[string] analysisNames() except +riveterr
        vector[string] stdAnalysisNames() except +riveterr
        vector[pair[string,size_t]] fillLayout() except +riveterr
        vector[bool] fillOutcomes() except +riveterr
        vector[double] fillFractions() except +riveterr
        # Analysis* analysis(string) except +riveterr
        void writeData_FILE "writeData" (string&) except +riveterr
        void writeData_OSTR "writeData" (ostringstream&, string&) except +riveterr
        void readData_FILE "readData" (string&, bool) except +riveterr
        void readData_ISTR "readData" (istringstream&, string&, bool) except +riveterr
        void loadAOs(vector[string]&, vector[double]&) except +riveterr
        void setCrossSection(double, double, bool) except +riveterr
        double nominalCrossSection() except +riveterr
        double nominalCrossSectionError() except +riveterr
        void finalize() except +riveterr
        void collapseEventGroup() except +riveterr
        void setFinalizePeriod(string, int) except +riveterr
        void mergeYODAs(vector[string]&, vector[string]&, vector[string]&, vector[string]&, vector[string]&, bool, bool, bool) except +riveterr
        void merge(AnalysisHandler&) except +riveterr
        vector[string] getRawAOPaths() except +riveterr

        # Weight stream related methods
        vector[string] weightNames() except +riveterr
        bool haveNamedWeights() except +riveterr
        size_t numWeights() except +riveterr
        vector[double] weightSumWs() except +riveterr
        void setWeightCap(double) except +riveterr

        # MPI (de-)serialization
        vector[double] serializeContent(bool) except +riveterr
        void deserializeContent(vector[double]&, size_t) except +riveterr

cdef extern from "Rivet/Run.hh" namespace "Rivet":
    cdef cppclass Run:
        Run(AnalysisHandler) except +riveterr
        Run& setCrossSection(double) except +riveterr # For chaining?
        Run& setListAnalyses(bool) except +riveterr
        bool init(string, double) except +riveterr # $2=1.0
        bool openFile(string, double) except +riveterr # $2=1.0
        bool readEvent() except +riveterr
        #bool skipEvent() except +riveterr
        bool processEvent() except +riveterr
        bool finalize() except +riveterr
        size_t numEvents() except +riveterr

cdef extern from "Rivet/Analysis.hh" namespace "Rivet":
    cdef cppclass Analysis:
        vector[PdgIdPair]& requiredBeamIDs() except +riveterr
        vector[pair[double, double]] requiredBeamEnergies() except +riveterr
        vector[string] authors() except +riveterr
        vector[string] references() except +riveterr
        vector[string] keywords() except +riveterr
        vector[string] validation() except +riveterr
        bool reentrant() except +riveterr
        string name() except +riveterr
        string bibTeX() except +riveterr
        string bibKey() except +riveterr
        string collider() except +riveterr
        string description() except +riveterr
        string experiment() except +riveterr
        string inspireID() except +riveterr
        string spiresID() except +riveterr
        string runInfo() except +riveterr
        string status() except +riveterr
        string warning() except +riveterr
        string summary() except +riveterr
        string year() except +riveterr
        double luminosity() except +riveterr
        double luminosityfb() except +riveterr
        string refFile() except +riveterr
        string refMatch() except +riveterr
        string refUnmatch() except +riveterr
        string writerDoublePrecision() except +riveterr

cdef extern from "Rivet/AnalysisLoader.hh":
    vector[string] AnalysisLoader_analysisNames "Rivet::AnalysisLoader::analysisNames" () except +riveterr
    vector[string] AnalysisLoader_allAnalysisNames "Rivet::AnalysisLoader::allAnalysisNames" () except +riveterr
    map[string,string] AnalysisLoader_analysisNameAliases "Rivet::AnalysisLoader::analysisNameAliases" () except +riveterr
    vector[string] AnalysisLoader_stdAnalysisNames "Rivet::AnalysisLoader::stdAnalysisNames" () except +riveterr
    unique_ptr[Analysis] AnalysisLoader_getAnalysis "Rivet::AnalysisLoader::getAnalysis" (string) except +riveterr
    #
    vector[string] AnalysisLoader_analysisPlugins "Rivet::AnalysisLoader::analysisPlugins" () except +riveterr
    vector[string] AnalysisLoader_searchAnalysisPlugins "Rivet::AnalysisLoader::searchAnalysisPlugins" () except +riveterr
    void AnalysisLoader_setAnalysisPlugins "Rivet::AnalysisLoader::setAnalysisPlugins" (vector[string]) except +riveterr
    void AnalysisLoader_loadFromAnalysisPlugins "Rivet::AnalysisLoader::loadFromAnalysisPlugins" () except +riveterr


cdef extern from "Rivet/Tools/RivetPaths.hh" namespace "Rivet":
    vector[string] getAnalysisLibPaths() except +riveterr
    void setAnalysisLibPaths(vector[string]) except +riveterr
    void addAnalysisLibPath(string) except +riveterr

    vector[string] getAnalysisDataPaths() except +riveterr
    void setAnalysisDataPaths(vector[string]) except +riveterr
    void addAnalysisDataPath(string) except +riveterr
    string findAnalysisDataFile(string) except +riveterr

    vector[string] getAnalysisRefPaths() except +riveterr
    string findAnalysisRefFile(string) except +riveterr

    vector[string] getAnalysisInfoPaths() except +riveterr
    string findAnalysisInfoFile(string) except +riveterr

    vector[string] getAnalysisPlotPaths() except +riveterr
    string findAnalysisPlotFile(string) except +riveterr

cdef extern from "Rivet/Rivet.hh" namespace "Rivet":
    string version() except +riveterr

cdef extern from "Rivet/Tools/Logging.hh":
    void setLogLevel "Rivet::Log::setLevel" (string, int) except +riveterr

cdef extern from "Rivet/Tools/ProjectionTreePlotter.hh" namespace "Rivet":
    cdef cppclass ProjectionTreeGenerator:
        void setPath(string&) except +riveterr
        int generateProjTree(vector[string]&) except +riveterr
        int getProjTree(AnalysisHandler&) except +riveterr
        void writeProjTree() except +riveterr
        vector[pair[size_t,size_t]]& getEdges() except +riveterr
        vector[string]& getProjNames() except +riveterr

