// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.openqa.selenium.grid.node.kubernetes;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.node.NodeSessionFactoryProvider;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(NodeSessionFactoryProvider.class)
public class KubernetesSessionFactoryProvider implements NodeSessionFactoryProvider {

  @Override
  public boolean isEnabled(Config config) {
    return config.getAll("kubernetes", "configs").isPresent();
  }

  @Override
  public Map<Capabilities, Collection<SessionFactory>> loadFactories(
      Config config, Tracer tracer, HttpClient.Factory clientFactory) {
    NodeOptions nodeOptions = new NodeOptions(config);
    return new KubernetesOptions(config)
        .getKubernetesSessionFactories(tracer, clientFactory, nodeOptions);
  }
}
