// <copyright file="ILogs.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

using System.Collections.ObjectModel;

namespace OpenQA.Selenium;

/// <summary>
/// Interface allowing handling of driver logs.
/// </summary>
public interface ILogs
{
    /// <summary>
    /// Gets the list of available log types for this driver.
    /// </summary>
    ReadOnlyCollection<string> AvailableLogTypes { get; }

    /// <summary>
    /// Gets the set of <see cref="LogEntry"/> objects for a specified log.
    /// </summary>
    /// <param name="logKind">The log for which to retrieve the log entries.
    /// Log types can be found in the <see cref="LogType"/> class.</param>
    /// <returns>The list of <see cref="LogEntry"/> objects for the specified log.</returns>
    /// <exception cref="ArgumentNullException">If <paramref name="logKind"/> is <see langword="null"/>.</exception>
    ReadOnlyCollection<LogEntry> GetLog(string logKind);
}
