// <copyright file="CallFunctionCommand.cs" company="Selenium Committers">
// Licensed to the Software Freedom Conservancy (SFC) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The SFC licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// </copyright>

using System.Diagnostics.CodeAnalysis;

namespace OpenQA.Selenium.BiDi.Script;

internal sealed class CallFunctionCommand(CallFunctionParameters @params)
    : Command<CallFunctionParameters, EvaluateResult>(@params, "script.callFunction");

internal sealed record CallFunctionParameters([StringSyntax(StringSyntaxConstants.JavaScript)] string FunctionDeclaration, bool AwaitPromise, Target Target, IEnumerable<LocalValue>? Arguments, ResultOwnership? ResultOwnership, SerializationOptions? SerializationOptions, LocalValue? This, bool? UserActivation) : Parameters;

public sealed record CallFunctionOptions : CommandOptions
{
    public IEnumerable<LocalValue>? Arguments { get; init; }

    public ResultOwnership? ResultOwnership { get; init; }

    public SerializationOptions? SerializationOptions { get; init; }

    public LocalValue? This { get; init; }

    public bool? UserActivation { get; init; }
}
