/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class License {
    private static String UNKNOWN_LICENCE_FULL_NAME = "Unknown license";
    private static String UNKNOWN_LICENCE_NAME = "Unknown";
    private List<String> components = new ArrayList<String>();
    private String fullName;
    private String name;
    private List<String> moreInfoUrl = new ArrayList<String>();

    public License() {
        this.fullName = UNKNOWN_LICENCE_FULL_NAME;
        this.name = UNKNOWN_LICENCE_NAME;
    }

    public License(List<String> components, String fullName, String name, List<String> moreInfoUrl) {
        this.components = components;
        this.fullName = StringUtils.trim(fullName);
        this.name = StringUtils.trim(name);
        this.moreInfoUrl = moreInfoUrl;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getMoreInfoUrl() {
        return this.moreInfoUrl;
    }

    @JsonIgnore
    public boolean isFullNameEmpty() {
        return StringUtils.isBlank(this.fullName) || this.fullName.equals(UNKNOWN_LICENCE_FULL_NAME);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        License otherLicense = (License)other;
        return StringUtils.equals(this.fullName, otherLicense.fullName) && StringUtils.equals(this.name, otherLicense.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fullName);
    }

    public String toString() {
        return this.name;
    }
}

