// bbcd.hh for BBCD - a CD player for X11 / BlackBox
// Copyright (c) 2002 Bertrand Duret <bertrand.duret at libertysurf.fr>
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#ifndef __BBCD_HH
#define __BBCD_HH

#include <string>
#include <X11/Xlib.h>
#include <X11/Xresource.h>



enum Layout {
  Horizontal,
  Vertical,
  Box
};

class Option {
public:
  // Command line items
  int argc;
  char** argv;

  // Config or command line options/parameters
  bool help;              // CL-h: display help (and exit)
  bool version;           // CL-v: display version info (and exit)
  // 3 CL options are used to determine the name and the location of config
  // file. Then, other options/parameters are read in this config file (if
  // any), and command line options/parameters supersede them.
  bool withBB;            // CL-b: not running with BB ? (also deduced)
  std::string bbcdrcfile; // CL-rc: alternate config file from command line
  std::string bbrcfile;   // CL-bbrc: alternate BB config file from cmd line
  bool withdrawn;         // CFG/CL-w: withdrawn state
  bool compact;           // CFG/CL-c: compact mode
  bool shape;             // CFG/CL-s: shape mode (fake transparent)
  unsigned int buttonSize;// CFG/CL-z: Size of buttons
  Layout layout;          // CFG/CL-l: Layout
  std::string cdrom_dev;  // CFG/CL-d: device of cdrom
  std::string display;    // CFG/CL-display: X11 display
  std::string geometry;   // CFG/CL-geometry: geometry of window (only pos)

  std::string bbstylefile;// File style of BB currently in use (deduced)
  std::string defaultBbcdrcfile;// Default config file (hardcoded)
                                // Depending on Blackbox support

  Option(int, char**);
  void init(); // Read config files, check command-line parms/args, etc.

private:
  bool hasCmdLineOpt(const std::string &);
  bool hasCmdLineParam(const std::string &, std::string &);
  bool getBBStyleFile();
  bool readBBCDConfig();
  bool readResource(XrmDatabase &, const std::string &, const std::string &,
                   std::string &);
  bool readBoolResource(XrmDatabase &, const std::string &,
                        const std::string &, bool &);
  void parseCmdLineArgs();
  void computePosition();

}; // class Option

#endif // __BBCD_HH
