/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.dependency.PatternResultFileSet;
import org.jfrog.build.api.dependency.PropertySearchResult;
import org.jfrog.build.api.repository.RepositoryConfig;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.build.extractor.clientConfiguration.util.JsonSerializer;

public class ArtifactoryDependenciesClient
extends ArtifactoryBaseClient {
    private static final String LATEST = "LATEST";
    private static final String LAST_RELEASE = "LAST_RELEASE";

    public ArtifactoryDependenciesClient(String artifactoryUrl, String username, String password, String accessToken, Log logger) {
        super(artifactoryUrl, username, password, accessToken, logger);
    }

    public ArtifactoryDependenciesClient(String artifactoryUrl, String username, String password, Log logger) {
        this(artifactoryUrl, username, password, "", logger);
    }

    public ArtifactoryDependenciesClient(String artifactoryUrl, ArtifactoryHttpClient httpClient, Log logger) {
        super(artifactoryUrl, httpClient, logger);
    }

    public List<BuildPatternArtifacts> retrievePatternArtifacts(List<BuildPatternArtifactsRequest> requests) throws IOException {
        String json = new JsonSerializer<List<BuildPatternArtifactsRequest>>().toJSON(requests);
        HttpPost post = new HttpPost(this.artifactoryUrl + "/api/build/patternArtifacts");
        StringEntity stringEntity = new StringEntity(json);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        post.setEntity(stringEntity);
        InputStream responseStream = this.getResponseStream(this.httpClient.getHttpClient().execute(post), "Failed to retrieve build artifacts report");
        return this.readJsonResponse(responseStream, new TypeReference<List<BuildPatternArtifacts>>(){}, false);
    }

    public PatternResultFileSet searchArtifactsByPattern(String pattern) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/search/pattern?pattern=" + pattern;
        InputStream responseStream = this.getResponseStream(client.execute(new HttpGet(url)), "Failed to search artifact by the pattern '" + pattern + "'");
        return this.readJsonResponse(responseStream, new TypeReference<PatternResultFileSet>(){}, false);
    }

    public PropertySearchResult searchArtifactsByProperties(String properties) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String replacedProperties = StringUtils.replaceEach(properties, new String[]{";", "+"}, new String[]{"&", ""});
        String url = this.artifactoryUrl + "/api/search/prop?" + replacedProperties;
        InputStream responseStream = this.getResponseStream(client.execute(new HttpGet(url)), "Failed to search artifact by the properties '" + properties + "'");
        return this.readJsonResponse(responseStream, new TypeReference<PropertySearchResult>(){}, false);
    }

    public AqlSearchResult searchArtifactsByAql(String aql) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/search/aql";
        HttpPost httpPost = new HttpPost(url);
        StringEntity entity = new StringEntity(aql);
        httpPost.setEntity(entity);
        InputStream responseStream = this.getResponseStream(client.execute(httpPost), "Failed to search artifact by the aql '" + aql + "'");
        return this.readJsonResponse(responseStream, new TypeReference<AqlSearchResult>(){}, true);
    }

    public Properties getNpmAuth() throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/npm/auth";
        HttpGet httpGet = new HttpGet(url);
        InputStream responseStream = this.getResponseStream(client.execute(httpGet), "npm Auth request failed");
        return this.readPropertiesResponse(responseStream);
    }

    private InputStream getResponseStream(HttpResponse response, String errorMessage) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        HttpEntity httpEntity = response.getEntity();
        EntityUtils.consume(httpEntity);
        throw new IOException(errorMessage + ": " + response.getStatusLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readJsonResponse(InputStream responseStream, TypeReference<T> valueType, boolean ignoreMissingFields) throws IOException {
        try {
            JsonParser parser = this.httpClient.createJsonParser(responseStream);
            if (ignoreMissingFields) {
                ((ObjectMapper)parser.getCodec()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }
            Object t = parser.readValueAs(valueType);
            return t;
        }
        finally {
            IOUtils.closeQuietly(responseStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesResponse(InputStream responseStream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(responseStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOUtils.closeQuietly(responseStream);
        }
    }

    public HttpResponse downloadArtifact(String downloadUrl) throws IOException {
        return this.executeDownload(downloadUrl, false, null);
    }

    public HttpResponse downloadArtifact(String downloadUrl, Map<String, String> headers) throws IOException {
        return this.executeDownload(downloadUrl, false, headers);
    }

    public HttpResponse getArtifactMetadata(String artifactUrl) throws IOException {
        return this.executeDownload(artifactUrl, true, null);
    }

    public boolean isArtifactoryOSS() throws IOException {
        return !this.httpClient.getVersion().hasAddons();
    }

    public boolean isLocalRepo(String repo) throws IOException {
        return "local".equals(this.getRepoType(repo));
    }

    public boolean isRemoteRepo(String repo) throws IOException {
        return "remote".equals(this.getRepoType(repo));
    }

    private String getRepoType(String repo) throws IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String url = this.artifactoryUrl + "/api/repositories/" + repo;
        HttpGet httpGet = new HttpGet(url);
        InputStream responseStream = this.getResponseStream(client.execute(httpGet), "Failed to retrieve repository configuration '" + repo + "'");
        RepositoryConfig repoDetails = this.readJsonResponse(responseStream, new TypeReference<RepositoryConfig>(){}, true);
        return repoDetails.getRclass();
    }

    private HttpResponse executeDownload(String artifactUrl, boolean isHead, Map<String, String> headers) throws IOException {
        HttpResponse response;
        StatusLine statusLine;
        int statusCode;
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        artifactUrl = ArtifactoryHttpClient.encodeUrl(artifactUrl);
        HttpRequestBase httpRequest = isHead ? new HttpHead(artifactUrl) : new HttpGet(artifactUrl);
        httpRequest.setHeader("Connection", "Keep-Alive");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((statusCode = (statusLine = (response = client.execute(httpRequest)).getStatusLine()).getStatusCode()) == 404) {
            throw new FileNotFoundException("Unable to find " + artifactUrl);
        }
        if (statusCode != 200 && statusCode != 206) {
            EntityUtils.consume(response.getEntity());
            throw new IOException("Error downloading " + artifactUrl + ". Code: " + statusCode + " Message: " + statusLine.getReasonPhrase());
        }
        return response;
    }

    public void setProperties(String urlPath, String props) throws IOException {
        String url = ArtifactoryHttpClient.encodeUrl(urlPath + "?properties=");
        url = url + DeploymentUrlUtils.buildMatrixParamsString(this.mapPropsString(props), true);
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        HttpPut httpPut = new HttpPut(url);
        this.checkNoContent(client.execute(httpPut), "Failed to set properties to '" + urlPath + "'");
    }

    private ArrayListMultimap<String, String> mapPropsString(String props) throws UnsupportedEncodingException {
        ArrayListMultimap<String, String> propsMap = ArrayListMultimap.create();
        List<String> propsList = Arrays.asList(props.split(";"));
        for (String prop : propsList) {
            String[] propParts = prop.split("=");
            propsMap.put((Object)propParts[0], (Object)propParts[1]);
        }
        return propsMap;
    }

    public void deleteProperties(String urlPath, String props) throws IOException {
        String url = ArtifactoryHttpClient.encodeUrl(urlPath + "?properties=" + props);
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(url);
        this.checkNoContent(client.execute(httpDelete), "Failed to delete properties to '" + urlPath + "'");
    }

    private void checkNoContent(HttpResponse response, String errorMessage) throws IOException {
        if (response.getStatusLine().getStatusCode() != 204) {
            HttpEntity httpEntity = response.getEntity();
            EntityUtils.consume(httpEntity);
            throw new IOException(errorMessage + ": " + response.getStatusLine());
        }
    }

    public String getLatestBuildNumberFromArtifactory(String buildName, String buildNumber) throws IOException {
        if (LATEST.equals(buildNumber.trim()) || LAST_RELEASE.equals(buildNumber.trim())) {
            if (this.isArtifactoryOSS()) {
                throw new IllegalArgumentException(String.format("%s is not supported in Artifactory OSS.", buildNumber));
            }
            ArrayList<BuildPatternArtifactsRequest> artifactsRequest = Lists.newArrayList();
            artifactsRequest.add(new BuildPatternArtifactsRequest(buildName, buildNumber));
            List<BuildPatternArtifacts> artifactsResponses = this.retrievePatternArtifacts(artifactsRequest);
            if (artifactsResponses.get(0) != null) {
                buildNumber = artifactsResponses.get(0).getBuildNumber();
            } else {
                return null;
            }
        }
        return buildNumber;
    }
}

