/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <curses.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "interface.h"



static int cur_line = 0;
static int def_background = COLOR_BLACK;
static int use_color = 1;




static void
my_exit (void)
{
  close_screen (0);
}

void
init_screen (void)
{
  /* initialize your non-curses data structures here */

  (void) signal (SIGINT, close_screen);	/* arrange interrupts to terminate */
  atexit (my_exit);


  (void) initscr ();		/* initialize the curses library */
  keypad (stdscr, TRUE);	/* enable keyboard mapping */
  (void) nonl ();		/* tell curses not to do NL->CR/NL on output */
  (void) cbreak ();		/* take input chars one at a time, no wait for \n */
  (void) noecho ();		/* don't echo input */
  curs_set (0);

  if (has_colors () && use_color)
    {
      start_color ();

      /* to have the default background in an xterm, just uncomment the lines above */
#ifdef NCURSES_VERSION
      if (def_background == -1 && use_default_colors () == OK)
	def_background = -1;
#endif


/* Simple color assignment, often all we need. */
      init_pair (COLOR_BLACK, COLOR_BLACK, def_background);
      init_pair (COLOR_GREEN, COLOR_GREEN, def_background);
      init_pair (COLOR_RED, COLOR_RED, def_background);
      init_pair (COLOR_CYAN, COLOR_CYAN, def_background);
      init_pair (COLOR_WHITE, COLOR_WHITE, def_background);
      init_pair (COLOR_MAGENTA, COLOR_MAGENTA, def_background);
      init_pair (COLOR_BLUE, COLOR_BLUE, def_background);
      init_pair (COLOR_YELLOW, COLOR_YELLOW, def_background);
    }

  cls ();
  cur_line = 0;
}

void
close_screen (int sig)
{
  curs_set (1);
  clear ();
  refresh ();

  endwin ();

  /* do your non-curses wrapup here */

  exit (0);
}


void
cls ()
{
  int i, j;

  attrset (COLOR_PAIR (COLOR_WHITE));

  for (i = 0; i < LINES; i++)
    for (j = 0; j < COLS; j++)
      mvaddch (i, j, ' ');

  refresh ();

  move (0, 0);
}

void
cls_line (int line)
{
  int i;

  attrset (COLOR_PAIR (COLOR_WHITE));

  for (i = 0; i < COLS; i++)
    mvaddch (line, i, ' ');

  refresh ();
}


void
set_color (int color)
{
  attrset (COLOR_PAIR (color));
}



void
mvaddstr_center (int line, char *st)
{
  int i;
  char stbis[2];

  stbis[1] = '\0';

  for (i = 0; i < strlen (st); i++)
    {
      stbis[0] = st[i];
      mvaddstr (line, (COLS - strlen (st)) / 2 + i, stbis);
    }
}


void
mvaddstr_vertcenter (int col, char *st)
{
  int i;
  char stbis[2];

  stbis[1] = '\0';

  for (i = 0; i < strlen (st); i++)
    {
      stbis[0] = st[i];
      mvaddstr ((LINES - strlen (st)) / 2 + i, col, stbis);
    }
}


void
wait_key_press (char ch, char *msg)
{
  cls_line (0);
  set_color (COLOR_CYAN);
  mvaddstr (0, 0, msg);

  refresh ();

  for (;;)
    {
      if (getch () == ch)
	break;
    }
}
