// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// MDMWindowsInformationProtectionPolicyRequestBuilder is request builder for MDMWindowsInformationProtectionPolicy
type MDMWindowsInformationProtectionPolicyRequestBuilder struct{ BaseRequestBuilder }

// Request returns MDMWindowsInformationProtectionPolicyRequest
func (b *MDMWindowsInformationProtectionPolicyRequestBuilder) Request() *MDMWindowsInformationProtectionPolicyRequest {
	return &MDMWindowsInformationProtectionPolicyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// MDMWindowsInformationProtectionPolicyRequest is request for MDMWindowsInformationProtectionPolicy
type MDMWindowsInformationProtectionPolicyRequest struct{ BaseRequest }

// Get performs GET request for MDMWindowsInformationProtectionPolicy
func (r *MDMWindowsInformationProtectionPolicyRequest) Get(ctx context.Context) (resObj *MDMWindowsInformationProtectionPolicy, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for MDMWindowsInformationProtectionPolicy
func (r *MDMWindowsInformationProtectionPolicyRequest) Update(ctx context.Context, reqObj *MDMWindowsInformationProtectionPolicy) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for MDMWindowsInformationProtectionPolicy
func (r *MDMWindowsInformationProtectionPolicyRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceAppManagementMDMWindowsInformationProtectionPoliciesCollectionRequestBuilder) HasPayloadLinks(reqObj *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequestParameter) *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequestBuilder {
	bb := &MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequestBuilder) Request() *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest {
	return &MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *MDMWindowsInformationProtectionPolicyCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}
