/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.ExtensionInfo;
import tim.prune.data.Field;
import tim.prune.data.FieldXml;
import tim.prune.data.FileType;
import tim.prune.load.xml.KmlExtendedDataField;
import tim.prune.load.xml.XmlHandler;

public class KmlHandler
extends XmlHandler {
    private String _fileTitle = null;
    private boolean _insideCoordinates = false;
    private boolean _insideTrack = false;
    private boolean _insideExtendedData = false;
    private String _value = null;
    private String _name = null;
    private String _desc = null;
    private String _timestamp = null;
    private String _imgLink = null;
    private StringBuffer _coordinates = null;
    private ArrayList<String> _coordinateList = null;
    private ArrayList<String[]> _pointList = new ArrayList();
    private ArrayList<String> _linkList = new ArrayList();
    private final ExtensionInfo _extensionInfo = new ExtensionInfo();
    private ArrayList<String> _whenList = new ArrayList();
    private ArrayList<String> _whereList = new ArrayList();
    private ArrayList<String> _valueList = null;
    private Field _extensionField = null;
    private ArrayList<KmlExtendedDataField> _extendedDataFields = null;

    public KmlHandler() {
        Field[] fieldArray;
        Field[] fieldArray2 = fieldArray = new Field[]{Field.LONGITUDE, Field.LATITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.DESCRIPTION, Field.NEW_SEGMENT, Field.TIMESTAMP};
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            this.addField(field);
            ++n2;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if ((string4 = string4.toLowerCase()).equals("placemark")) {
            this._coordinateList = new ArrayList();
        } else if (string4.equals("coordinates")) {
            this._insideCoordinates = true;
            this._coordinates = null;
        } else if (string4.equals("gx:track")) {
            this._insideTrack = true;
        } else if (string4.equals("track")) {
            this._insideTrack = true;
            if ("2.2".equals(this.getFileVersion())) {
                this.setFileVersion("2.3");
            }
        } else if (string4.equals("extendeddata")) {
            this._insideExtendedData = true;
            if (this._extendedDataFields == null) {
                this._extendedDataFields = new ArrayList();
            } else {
                this._extendedDataFields.clear();
            }
        } else if (this._insideExtendedData && (string4.equals("simplearraydata") || string4.equals("gx:simplearraydata"))) {
            String string5 = KmlHandler.getAttribute(attributes, "name");
            this._extensionField = new FieldXml(FileType.KML, string5, null);
            if (!this.hasField(this._extensionField)) {
                this.addField(this._extensionField);
            }
            if (this._valueList == null) {
                this._valueList = new ArrayList();
            } else {
                this._valueList.clear();
            }
        } else if (string4.equals("kml")) {
            this.setFileType(FileType.KML);
            this.processKmlAttributes(attributes);
        }
        this._value = null;
        super.startElement(string, string2, string3, attributes);
    }

    private void processKmlAttributes(Attributes attributes) {
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = attributes.getQName(n2).toLowerCase();
            String[] stringArray = attributes.getValue(n2);
            if (string.equals("xmlns")) {
                object = stringArray;
                this._extensionInfo.setNamespace((String)object);
                if (object != null && object.length() > 3) {
                    this.setFileVersion(object.substring(object.length() - 3));
                }
            } else if (string.equals("xmlns:xsi")) {
                this._extensionInfo.setXsi((String)stringArray);
            } else if (string.equals("xsi:schemalocation")) {
                object = stringArray.split(" ");
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    this._extensionInfo.addXsiAttribute(object[n3]);
                    ++n3;
                }
            } else if (string.startsWith("xmlns:")) {
                object = string.substring(6);
                this._extensionInfo.addNamespace((String)object, (String)stringArray);
            }
            ++n2;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if ((string4 = string4.toLowerCase()).equals("placemark")) {
            this.processPlacemark();
            this._timestamp = null;
            this._imgLink = null;
            this._desc = null;
            this._name = null;
        } else if (string4.equals("coordinates")) {
            this._insideCoordinates = false;
            if (this._coordinates != null) {
                this._coordinateList.add(this._coordinates.toString().trim());
            }
        } else if (string4.equals("name")) {
            if (this._coordinateList == null) {
                this._fileTitle = this._value;
            }
            this._name = this._value;
        } else if (string4.equals("description")) {
            this._desc = this._value;
            this._imgLink = KmlHandler.getImgLink(this._desc);
        } else if (string4.equals("when")) {
            if (!this._insideTrack) {
                this._timestamp = this._value;
            } else {
                this._whenList.add(this._value);
            }
        } else if (string4.equals("gx:coord") || string4.equals("coord")) {
            if (this._insideTrack) {
                this._whereList.add(this._value);
            }
        } else if (string4.equals("gx:track") || string4.equals("track")) {
            this.processTrack();
            this._insideTrack = false;
        } else if (this._insideExtendedData && (string4.equals("gx:value") || string4.equals("value")) && this._valueList != null) {
            this._valueList.add(this._value);
        } else if (this._insideExtendedData && (string4.equals("gx:simplearraydata") || string4.equals("simplearraydata"))) {
            this._extendedDataFields.add(new KmlExtendedDataField(this._extensionField, this._valueList));
            this._extensionField = null;
            this._valueList.clear();
        } else if (string4.equals("extendeddata")) {
            this._insideExtendedData = false;
            this._extensionField = null;
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._insideCoordinates) {
            if (this._coordinates == null) {
                this._coordinates = new StringBuffer();
            }
            this._coordinates.append(string);
        } else {
            this._value = this._value == null ? string : String.valueOf(this._value) + string;
        }
        super.characters(cArray, n, n2);
    }

    private void processPlacemark() {
        if (this._coordinateList == null || this._coordinateList.isEmpty()) {
            return;
        }
        boolean bl = this._coordinateList.size() == 1;
        for (String string : this._coordinateList) {
            String[] stringArray = string.split("[ \n]");
            int n = stringArray.length;
            if (n == 1) {
                String string2 = bl ? this._name : null;
                this._pointList.add(this.makeStringArray(true, string, string2, this._desc, this._timestamp));
                this._linkList.add(this._imgLink);
                continue;
            }
            if (n <= 1) continue;
            boolean bl2 = true;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                if (string3 != null && string3.trim().length() > 3) {
                    String[] stringArray3 = this.makeStringArray(bl2, string3, null, null, null);
                    bl2 = false;
                    this._pointList.add(stringArray3);
                }
                this._linkList.add(null);
                ++n3;
            }
        }
    }

    private void processTrack() {
        if (!this._whereList.isEmpty()) {
            if (this._whenList.size() != this._whereList.size()) {
                this._whenList.clear();
            }
            boolean bl = true;
            int n = this._whenList.size();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray;
                String string = this._whenList.isEmpty() ? null : this._whenList.get(n2);
                String string2 = this._whereList.get(n2);
                if (string2 != null && (stringArray = string2.split(" ")).length == 3) {
                    this.resetCurrentValues();
                    this.addCurrentValue(Field.LONGITUDE, stringArray[0]);
                    this.addCurrentValue(Field.LATITUDE, stringArray[1]);
                    this.addCurrentValue(Field.ALTITUDE, stringArray[2]);
                    this.addCurrentValue(Field.NEW_SEGMENT, bl ? "1" : null);
                    bl = false;
                    this.addCurrentValue(Field.TIMESTAMP, string);
                    if (this._extendedDataFields != null) {
                        for (KmlExtendedDataField kmlExtendedDataField : this._extendedDataFields) {
                            this.addCurrentValue(kmlExtendedDataField.getField(), this.getFieldValue(kmlExtendedDataField, n2));
                        }
                    }
                    this._pointList.add(this.getCurrentValues());
                }
                this._linkList.add(null);
                ++n2;
            }
        }
        this._whenList.clear();
        this._whereList.clear();
    }

    private String getFieldValue(KmlExtendedDataField kmlExtendedDataField, int n) {
        if (kmlExtendedDataField == null) {
            return null;
        }
        List<String> list = kmlExtendedDataField.getValues();
        if (list == null || list.isEmpty() || n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    private static String getImgLink(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.indexOf("<img");
        int n2 = string.indexOf(62, n + 10);
        if (n < 0 || n2 < 0) {
            return null;
        }
        String string2 = string.substring(n + 4, n2);
        int n3 = string2.toLowerCase().indexOf("src=");
        if (n3 < 0) {
            return null;
        }
        char c = string2.charAt(n3 + 4);
        int n4 = string2.indexOf(c, n3 + 7);
        if (n4 < 0) {
            return null;
        }
        return string2.substring(n3 + 5, n4);
    }

    private String[] makeStringArray(boolean bl, String string, String string2, String string3, String string4) {
        this.resetCurrentValues();
        String[] stringArray = string.split(",");
        int n = stringArray.length;
        if (n == 3 || n == 2) {
            this.addCurrentValue(Field.LONGITUDE, stringArray[0]);
            this.addCurrentValue(Field.LATITUDE, stringArray[1]);
            if (n == 3) {
                this.addCurrentValue(Field.ALTITUDE, stringArray[2]);
            }
        }
        this.addCurrentValue(Field.WAYPT_NAME, string2);
        this.addCurrentValue(Field.DESCRIPTION, string3);
        this.addCurrentValue(Field.TIMESTAMP, string4);
        this.addCurrentValue(Field.NEW_SEGMENT, bl ? "1" : null);
        return this.getCurrentValues();
    }

    @Override
    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    @Override
    public String[] getLinkArray() {
        int n = this._linkList.size();
        boolean bl = false;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._linkList.get(n2);
            if (stringArray[n2] != null) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public String getFileTitle() {
        return this._fileTitle;
    }

    @Override
    public ExtensionInfo getExtensionInfo() {
        return this._extensionInfo;
    }
}

