/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tomcat.util.descriptor.web.ContextHandler;
import org.apache.tomcat.util.descriptor.web.ResourceBase;

public class ContextService
extends ResourceBase {
    private static final long serialVersionUID = 1L;
    private String displayname = null;
    private String largeIcon = null;
    private String smallIcon = null;
    private String serviceInterface = null;
    private String wsdlfile = null;
    private String jaxrpcmappingfile = null;
    private String[] serviceqname = new String[2];
    private final Map<String, ContextHandler> handlers = new HashMap<String, ContextHandler>();

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String string) {
        this.displayname = string;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String string) {
        this.largeIcon = string;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String string) {
        this.smallIcon = string;
    }

    public String getInterface() {
        return this.serviceInterface;
    }

    public void setInterface(String string) {
        this.serviceInterface = string;
    }

    public String getWsdlfile() {
        return this.wsdlfile;
    }

    public void setWsdlfile(String string) {
        this.wsdlfile = string;
    }

    public String getJaxrpcmappingfile() {
        return this.jaxrpcmappingfile;
    }

    public void setJaxrpcmappingfile(String string) {
        this.jaxrpcmappingfile = string;
    }

    public String[] getServiceqname() {
        return this.serviceqname;
    }

    public String getServiceqname(int n) {
        return this.serviceqname[n];
    }

    public String getServiceqnameNamespaceURI() {
        return this.serviceqname[0];
    }

    public String getServiceqnameLocalpart() {
        return this.serviceqname[1];
    }

    public void setServiceqname(String[] stringArray) {
        this.serviceqname = stringArray;
    }

    public void setServiceqname(String string, int n) {
        this.serviceqname[n] = string;
    }

    public void setServiceqnameNamespaceURI(String string) {
        this.serviceqname[0] = string;
    }

    public void setServiceqnameLocalpart(String string) {
        this.serviceqname[1] = string;
    }

    public Iterator<String> getServiceendpoints() {
        return this.listProperties();
    }

    public String getPortlink(String string) {
        return (String)this.getProperty(string);
    }

    public void addPortcomponent(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.setProperty(string, string2);
    }

    public Iterator<String> getHandlers() {
        return this.handlers.keySet().iterator();
    }

    public ContextHandler getHandler(String string) {
        return this.handlers.get(string);
    }

    public void addHandler(ContextHandler contextHandler) {
        this.handlers.put(contextHandler.getName(), contextHandler);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ContextService[");
        stringBuilder.append("name=");
        stringBuilder.append(this.getName());
        if (this.getDescription() != null) {
            stringBuilder.append(", description=");
            stringBuilder.append(this.getDescription());
        }
        if (this.getType() != null) {
            stringBuilder.append(", type=");
            stringBuilder.append(this.getType());
        }
        if (this.displayname != null) {
            stringBuilder.append(", displayname=");
            stringBuilder.append(this.displayname);
        }
        if (this.largeIcon != null) {
            stringBuilder.append(", largeIcon=");
            stringBuilder.append(this.largeIcon);
        }
        if (this.smallIcon != null) {
            stringBuilder.append(", smallIcon=");
            stringBuilder.append(this.smallIcon);
        }
        if (this.wsdlfile != null) {
            stringBuilder.append(", wsdl-file=");
            stringBuilder.append(this.wsdlfile);
        }
        if (this.jaxrpcmappingfile != null) {
            stringBuilder.append(", jaxrpc-mapping-file=");
            stringBuilder.append(this.jaxrpcmappingfile);
        }
        if (this.serviceqname[0] != null) {
            stringBuilder.append(", service-qname/namespaceURI=");
            stringBuilder.append(this.serviceqname[0]);
        }
        if (this.serviceqname[1] != null) {
            stringBuilder.append(", service-qname/localpart=");
            stringBuilder.append(this.serviceqname[1]);
        }
        if (this.getServiceendpoints() != null) {
            stringBuilder.append(", port-component/service-endpoint-interface=");
            stringBuilder.append(this.getServiceendpoints());
        }
        if (!this.handlers.isEmpty()) {
            stringBuilder.append(", handler=");
            stringBuilder.append(this.handlers);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.displayname == null ? 0 : this.displayname.hashCode());
        n = 31 * n + this.handlers.hashCode();
        n = 31 * n + (this.jaxrpcmappingfile == null ? 0 : this.jaxrpcmappingfile.hashCode());
        n = 31 * n + (this.largeIcon == null ? 0 : this.largeIcon.hashCode());
        n = 31 * n + (this.serviceInterface == null ? 0 : this.serviceInterface.hashCode());
        n = 31 * n + Arrays.hashCode(this.serviceqname);
        n = 31 * n + (this.smallIcon == null ? 0 : this.smallIcon.hashCode());
        n = 31 * n + (this.wsdlfile == null ? 0 : this.wsdlfile.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContextService contextService = (ContextService)object;
        if (this.displayname == null ? contextService.displayname != null : !this.displayname.equals(contextService.displayname)) {
            return false;
        }
        if (!this.handlers.equals(contextService.handlers)) {
            return false;
        }
        if (this.jaxrpcmappingfile == null ? contextService.jaxrpcmappingfile != null : !this.jaxrpcmappingfile.equals(contextService.jaxrpcmappingfile)) {
            return false;
        }
        if (this.largeIcon == null ? contextService.largeIcon != null : !this.largeIcon.equals(contextService.largeIcon)) {
            return false;
        }
        if (this.serviceInterface == null ? contextService.serviceInterface != null : !this.serviceInterface.equals(contextService.serviceInterface)) {
            return false;
        }
        if (!Arrays.equals(this.serviceqname, contextService.serviceqname)) {
            return false;
        }
        if (this.smallIcon == null ? contextService.smallIcon != null : !this.smallIcon.equals(contextService.smallIcon)) {
            return false;
        }
        if (this.wsdlfile == null) {
            return contextService.wsdlfile == null;
        }
        return this.wsdlfile.equals(contextService.wsdlfile);
    }
}

