/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.Serializable;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;

public class SingleSignOnListener
implements SessionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ssoId;

    public SingleSignOnListener(String string) {
        this.ssoId = string;
    }

    @Override
    public void sessionEvent(SessionEvent sessionEvent) {
        String string = sessionEvent.getType();
        if (!"destroySession".equals(string) && !"changeSessionId".equals(string)) {
            return;
        }
        Session session = sessionEvent.getSession();
        Manager manager = session.getManager();
        if (manager == null) {
            return;
        }
        Context context = manager.getContext();
        Authenticator authenticator = context.getAuthenticator();
        if (!(authenticator instanceof AuthenticatorBase)) {
            return;
        }
        SingleSignOn singleSignOn = ((AuthenticatorBase)authenticator).sso;
        if (singleSignOn == null) {
            return;
        }
        switch (string) {
            case "changeSessionId": {
                singleSignOn.sessionChangedId(this.ssoId, session, (String)sessionEvent.getData());
                break;
            }
            case "destroySession": {
                singleSignOn.sessionDestroyed(this.ssoId, session);
            }
        }
    }
}

