/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class AutoGeneratedUuidExtension
implements DynamoDbEnhancedClientExtension {
    private static final String CUSTOM_METADATA_KEY = "software.amazon.awssdk.enhanced.dynamodb.extensions.AutoGeneratedUuidExtension:AutoGeneratedUuidAttribute";
    private static final AutoGeneratedUuidAttribute AUTO_GENERATED_UUID_ATTRIBUTE = new AutoGeneratedUuidAttribute();

    private AutoGeneratedUuidExtension() {
    }

    public static AutoGeneratedUuidExtension create() {
        return new AutoGeneratedUuidExtension();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Collection customMetadataObject = context.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, Collection.class).orElse(null);
        if (customMetadataObject == null) {
            return WriteModification.builder().build();
        }
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(context.items());
        customMetadataObject.forEach(key -> this.insertUuidInItemToTransform((Map<String, AttributeValue>)itemToTransform, (String)key));
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).build();
    }

    private void insertUuidInItemToTransform(Map<String, AttributeValue> itemToTransform, String key) {
        itemToTransform.put(key, (AttributeValue)AttributeValue.builder().s(UUID.randomUUID().toString()).build());
    }

    private static class AutoGeneratedUuidAttribute
    implements StaticAttributeTag {
        private AutoGeneratedUuidAttribute() {
        }

        @Override
        public <R> void validateType(String attributeName, EnhancedType<R> type, AttributeValueType attributeValueType) {
            Validate.notNull(type, (String)"type is null", (Object[])new Object[0]);
            Validate.notNull(type.rawClass(), (String)"rawClass is null", (Object[])new Object[0]);
            Validate.notNull((Object)((Object)attributeValueType), (String)"attributeValueType is null", (Object[])new Object[0]);
            if (!type.rawClass().equals(String.class)) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of Class type %s is not a suitable Java Class type to be used as a Auto Generated Uuid attribute. Only String Class type is supported.", attributeName, type.rawClass()));
            }
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            return metadata -> metadata.addCustomMetadataObject(AutoGeneratedUuidExtension.CUSTOM_METADATA_KEY, Collections.singleton(attributeName)).markAttributeAsKey(attributeName, attributeValueType);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static StaticAttributeTag autoGeneratedUuidAttribute() {
            return AUTO_GENERATED_UUID_ATTRIBUTE;
        }
    }
}

