/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ChiSquareHeuristic
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ChiSquareHeuristic> {
    private final boolean backgroundIsSuperset;
    private final boolean includeNegatives;
    public static final JsonpDeserializer<ChiSquareHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChiSquareHeuristic::setupChiSquareHeuristicDeserializer);

    private ChiSquareHeuristic(Builder builder) {
        this.backgroundIsSuperset = ApiTypeHelper.requireNonNull(builder.backgroundIsSuperset, this, "backgroundIsSuperset");
        this.includeNegatives = ApiTypeHelper.requireNonNull(builder.includeNegatives, this, "includeNegatives");
    }

    public static ChiSquareHeuristic of(Function<Builder, ObjectBuilder<ChiSquareHeuristic>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    public final boolean includeNegatives() {
        return this.includeNegatives;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("background_is_superset");
        generator.write(this.backgroundIsSuperset);
        generator.writeKey("include_negatives");
        generator.write(this.includeNegatives);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupChiSquareHeuristicDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset");
        op.add(Builder::includeNegatives, JsonpDeserializer.booleanDeserializer(), "include_negatives");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.backgroundIsSuperset);
        result = 31 * result + Boolean.hashCode(this.includeNegatives);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChiSquareHeuristic other = (ChiSquareHeuristic)o;
        return this.backgroundIsSuperset == other.backgroundIsSuperset && this.includeNegatives == other.includeNegatives;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ChiSquareHeuristic> {
        private Boolean backgroundIsSuperset;
        private Boolean includeNegatives;

        public Builder() {
        }

        private Builder(ChiSquareHeuristic o) {
            this.backgroundIsSuperset = o.backgroundIsSuperset;
            this.includeNegatives = o.includeNegatives;
        }

        private Builder(Builder o) {
            this.backgroundIsSuperset = o.backgroundIsSuperset;
            this.includeNegatives = o.includeNegatives;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backgroundIsSuperset(boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        @Nonnull
        public final Builder includeNegatives(boolean value) {
            this.includeNegatives = value;
            return this;
        }

        @Override
        @Nonnull
        public ChiSquareHeuristic build() {
            this._checkSingleUse();
            return new ChiSquareHeuristic(this);
        }
    }
}

