/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.notifications.model.DocMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/notifications/model/NotificationConfigDoc;", "Lorg/opensearch/core/xcontent/ToXContent;", "metadata", "Lorg/opensearch/notifications/model/DocMetadata;", "config", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "<init>", "(Lorg/opensearch/notifications/model/DocMetadata;Lorg/opensearch/commons/notifications/model/NotificationConfig;)V", "getMetadata", "()Lorg/opensearch/notifications/model/DocMetadata;", "getConfig", "()Lorg/opensearch/commons/notifications/model/NotificationConfig;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "builder", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "opensearch-notifications"})
public final class NotificationConfigDoc
implements ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocMetadata metadata;
    @NotNull
    private final NotificationConfig config;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationConfigDoc.class);

    public NotificationConfigDoc(@NotNull DocMetadata metadata, @NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.metadata = metadata;
        this.config = config;
    }

    @NotNull
    public final DocMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final NotificationConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(NotificationConfigDoc notificationConfigDoc, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return notificationConfigDoc.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("metadata", (ToXContent)this.metadata).field("config", (ToXContent)this.config).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final DocMetadata component1() {
        return this.metadata;
    }

    @NotNull
    public final NotificationConfig component2() {
        return this.config;
    }

    @NotNull
    public final NotificationConfigDoc copy(@NotNull DocMetadata metadata, @NotNull NotificationConfig config) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new NotificationConfigDoc(metadata, config);
    }

    public static /* synthetic */ NotificationConfigDoc copy$default(NotificationConfigDoc notificationConfigDoc, DocMetadata docMetadata, NotificationConfig notificationConfig, int n, Object object) {
        if ((n & 1) != 0) {
            docMetadata = notificationConfigDoc.metadata;
        }
        if ((n & 2) != 0) {
            notificationConfig = notificationConfigDoc.config;
        }
        return notificationConfigDoc.copy(docMetadata, notificationConfig);
    }

    @NotNull
    public String toString() {
        return "NotificationConfigDoc(metadata=" + this.metadata + ", config=" + this.config + ")";
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = result * 31 + this.config.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationConfigDoc)) {
            return false;
        }
        NotificationConfigDoc notificationConfigDoc = (NotificationConfigDoc)other;
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)notificationConfigDoc.metadata)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.config, (Object)notificationConfigDoc.config);
    }

    @JvmStatic
    @NotNull
    public static final NotificationConfigDoc parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/notifications/model/NotificationConfigDoc$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/notifications/model/NotificationConfigDoc;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-notifications"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final NotificationConfigDoc parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            DocMetadata metadata = null;
            NotificationConfig config = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"metadata")) {
                    metadata = DocMetadata.Companion.parse(parser);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"config")) {
                    config = NotificationConfig.Companion.parse(parser);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing configuration doc");
            }
            if (metadata == null) {
                throw new IllegalArgumentException("metadata field absent");
            }
            if (config == null) {
                throw new IllegalArgumentException("config field absent");
            }
            return new NotificationConfigDoc(metadata, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

