/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.preprocessor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.preprocessor.InitialSegmentPreprocessor;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.statistics.Deviation;
import java.util.Arrays;

public class ImputePreprocessor
extends InitialSegmentPreprocessor {
    public static ImputationMethod DEFAULT_INITIAL = ImputationMethod.LINEAR;
    public static ImputationMethod DEFAULT_DYNAMIC = ImputationMethod.PREVIOUS;

    public ImputePreprocessor(Preprocessor.Builder<?> builder) {
        super(builder);
        this.numberOfImputed = this.shingleSize;
    }

    @Override
    public float[] getScaledShingledInput(double[] inputPoint, long timestamp, int[] missing, RandomCutForest forest) {
        if (this.valuesSeen < this.startNormalization) {
            return null;
        }
        CommonUtils.checkArgument(timestamp > this.previousTimeStamps[this.shingleSize - 1], "incorrect ordering of time");
        long[] savedTimestamps = Arrays.copyOf(this.previousTimeStamps, this.previousTimeStamps.length);
        double[] savedShingledInput = Arrays.copyOf(this.lastShingledInput, this.lastShingledInput.length);
        float[] savedShingle = Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
        int savedNumberOfImputed = this.numberOfImputed;
        int lastActualInternal = this.internalTimeStamp;
        float[] point = this.generateShingle(inputPoint, timestamp, missing, this.getTimeFactor(this.timeStampDeviations[1]), false, forest);
        this.internalTimeStamp = lastActualInternal;
        this.numberOfImputed = savedNumberOfImputed;
        this.previousTimeStamps = Arrays.copyOf(savedTimestamps, savedTimestamps.length);
        this.lastShingledInput = Arrays.copyOf(savedShingledInput, savedShingledInput.length);
        this.lastShingledPoint = Arrays.copyOf(savedShingle, savedShingle.length);
        return point;
    }

    protected boolean updateAllowed() {
        double fraction = (double)this.numberOfImputed * 1.0 / (double)this.shingleSize;
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (this.numberOfImputed >= this.shingleSize - 1 && this.previousTimeStamps[0] != this.previousTimeStamps[1] && (this.transformMethod == TransformMethod.DIFFERENCE || this.transformMethod == TransformMethod.NORMALIZE_DIFFERENCE)) {
            return false;
        }
        this.dataQuality[0].update(1.0 - fraction);
        return fraction < this.useImputedFraction && this.internalTimeStamp >= this.shingleSize;
    }

    @Override
    protected void updateTimestamps(long timestamp) {
        if (this.previousTimeStamps[0] == this.previousTimeStamps[1]) {
            --this.numberOfImputed;
        }
        super.updateTimestamps(timestamp);
    }

    void updateForest(boolean changeForest, double[] input, long timestamp, RandomCutForest forest, boolean isFullyImputed) {
        float[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, input, this.getShingledInput(this.shingleSize - 1), null, this.clipFactor);
        this.updateShingle(input, scaledInput);
        this.updateTimestamps(timestamp);
        if (isFullyImputed) {
            this.numberOfImputed = Math.min(this.numberOfImputed + 1, this.shingleSize);
        } else if (this.numberOfImputed > 0) {
            --this.numberOfImputed;
        }
        if (changeForest) {
            if (forest.isInternalShinglingEnabled()) {
                forest.update(scaledInput, !this.updateAllowed());
            } else if (this.updateAllowed()) {
                forest.update(this.lastShingledPoint);
            }
        }
    }

    @Override
    public void update(double[] point, float[] rcfPoint, long timestamp, int[] missing, RandomCutForest forest) {
        if (this.valuesSeen < this.startNormalization) {
            this.storeInitial(point, timestamp, missing);
            if (this.valuesSeen == this.startNormalization) {
                this.dischargeInitial(forest);
            }
            return;
        }
        this.generateShingle(point, timestamp, missing, this.getTimeFactor(this.timeStampDeviations[1]), true, forest);
        if (missing == null || missing.length != point.length) {
            ++this.valuesSeen;
        }
    }

    protected double getTimeFactor(Deviation deviation) {
        double timeFactor = deviation.getMean();
        double dev = deviation.getDeviation();
        if (dev > 0.0 && dev < timeFactor / 2.0) {
            timeFactor -= dev * dev / (2.0 * timeFactor);
        }
        return timeFactor;
    }

    @Override
    protected void dischargeInitial(RandomCutForest forest) {
        Deviation tempTimeDeviation = new Deviation();
        for (int i = 0; i < this.initialTimeStamps.length - 1; ++i) {
            tempTimeDeviation.update(this.initialTimeStamps[i + 1] - this.initialTimeStamps[i]);
        }
        double timeFactor = this.getTimeFactor(tempTimeDeviation);
        this.prepareInitialInput();
        Deviation[] deviations = this.getInitialDeviations();
        Arrays.fill(this.previousTimeStamps, this.initialTimeStamps[0]);
        this.numberOfImputed = this.shingleSize;
        for (int i = 0; i < this.valuesSeen; ++i) {
            long lastInputTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
            if (this.internalTimeStamp > 0) {
                double[] previous = new double[this.inputLength];
                System.arraycopy(this.lastShingledInput, this.lastShingledInput.length - this.inputLength, previous, 0, this.inputLength);
                int numberToImpute = this.determineGap(this.initialTimeStamps[i] - lastInputTimeStamp, timeFactor) - 1;
                if (numberToImpute > 0) {
                    double step = 1.0 / (double)(numberToImpute + 1);
                    for (int j = 0; j < numberToImpute; ++j) {
                        double[] result = this.basicImpute(step * (double)(j + 1), previous, this.initialValues[i], DEFAULT_INITIAL);
                        float[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, result, this.getShingledInput(this.shingleSize - 1), deviations, this.clipFactor);
                        this.updateShingle(result, scaledInput);
                        this.updateTimestamps(this.initialTimeStamps[i]);
                        ++this.numberOfImputed;
                        if (forest.isInternalShinglingEnabled()) {
                            forest.update(scaledInput, !this.updateAllowed());
                            continue;
                        }
                        if (!this.updateAllowed()) continue;
                        forest.update(this.lastShingledPoint);
                    }
                }
            }
            float[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, this.initialValues[i], this.getShingledInput(this.shingleSize - 1), deviations, this.clipFactor);
            this.updateState(this.initialValues[i], scaledInput, this.initialTimeStamps[i], lastInputTimeStamp, null);
            if (forest.isInternalShinglingEnabled()) {
                forest.update(scaledInput, !this.updateAllowed());
                continue;
            }
            if (!this.updateAllowed()) continue;
            forest.update(this.lastShingledPoint);
        }
        this.initialTimeStamps = null;
        this.initialValues = null;
    }

    protected int determineGap(long timestampGap, double averageGap) {
        if (this.internalTimeStamp <= 1) {
            return 1;
        }
        double gap = (double)timestampGap / averageGap;
        return gap >= 1.5 ? (int)Math.ceil(gap) : 1;
    }

    @Override
    public int numberOfImputes(long timestamp) {
        long lastInputTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
        return this.determineGap(timestamp - lastInputTimeStamp, this.getTimeFactor(this.timeStampDeviations[1])) - 1;
    }

    protected float[] generateShingle(double[] inputTuple, long timestamp, int[] missingValues, double averageGap, boolean changeForest, RandomCutForest forest) {
        long lastInputTimeStamp = this.previousTimeStamps[this.shingleSize - 1];
        double[] input = Arrays.copyOf(inputTuple, this.inputLength);
        double[] previous = this.getShingledInput(this.shingleSize - 1);
        double[] savedInput = Arrays.copyOf(previous, this.inputLength);
        int numberToImpute = this.determineGap(timestamp - lastInputTimeStamp, averageGap) - 1;
        if (this.imputationMethod != ImputationMethod.RCF || !forest.isOutputReady()) {
            ImputationMethod method;
            ImputationMethod imputationMethod = method = this.imputationMethod == ImputationMethod.RCF ? DEFAULT_DYNAMIC : this.imputationMethod;
            if (missingValues != null) {
                for (int missingValue : missingValues) {
                    input[missingValue] = this.defaultFill == null ? previous[missingValue] : this.defaultFill[missingValue];
                }
            }
            if (numberToImpute > 0) {
                double step = 1.0 / (double)(numberToImpute + 1);
                for (int i = 0; i < numberToImpute; ++i) {
                    double[] result = this.basicImpute(step * (double)(i + 1), previous, input, method);
                    this.updateForest(changeForest, result, timestamp, forest, true);
                }
            }
        } else {
            if (numberToImpute < 3 * this.shingleSize || !this.fastForward) {
                for (int i = 0; i < numberToImpute; ++i) {
                    double[] result = this.imputeRCF(forest, null, null);
                    this.updateForest(changeForest, result, timestamp, forest, true);
                }
            } else {
                double[] shift = this.getShift();
                this.numberOfImputed = 0;
                for (int i = 0; i < this.shingleSize - 1; ++i) {
                    this.updateForest(changeForest, shift, timestamp, forest, false);
                }
            }
            if (missingValues != null && missingValues.length > 0) {
                input = this.imputeRCF(forest, input, missingValues);
            }
        }
        this.updateForest(changeForest, input, timestamp, forest, missingValues != null ? missingValues.length == inputTuple.length : false);
        if (changeForest) {
            this.updateTimeStampDeviations(timestamp, lastInputTimeStamp);
            this.transformer.updateDeviation(input, savedInput, missingValues);
        }
        return Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
    }

    protected double[] basicImpute(double stepFraction, double[] previous, double[] input, ImputationMethod method) {
        double[] result = new double[this.inputLength];
        if (method == ImputationMethod.FIXED_VALUES) {
            System.arraycopy(this.defaultFill, 0, result, 0, this.inputLength);
        } else if (method == ImputationMethod.LINEAR) {
            for (int z = 0; z < this.inputLength; ++z) {
                result[z] = previous[z] + stepFraction * (input[z] - previous[z]);
            }
        } else if (method == ImputationMethod.PREVIOUS) {
            System.arraycopy(previous, 0, result, 0, this.inputLength);
        } else if (method == ImputationMethod.NEXT) {
            System.arraycopy(input, 0, result, 0, this.inputLength);
        }
        return result;
    }

    protected double[] imputeRCF(RandomCutForest forest, double[] partialInput, int[] missingValues) {
        int[] missingIndices;
        float[] temp = Arrays.copyOf(this.lastShingledPoint, this.lastShingledPoint.length);
        ImputePreprocessor.shiftLeft(temp, this.inputLength);
        int startPosition = this.inputLength * (this.shingleSize - 1);
        if (partialInput == null) {
            missingIndices = new int[this.inputLength];
            for (int i = 0; i < this.inputLength; ++i) {
                missingIndices[i] = startPosition + i;
            }
        } else {
            missingIndices = new int[missingValues.length];
            for (int i = 0; i < missingValues.length; ++i) {
                missingIndices[i] = startPosition + missingValues[i];
            }
            float[] scaledInput = this.transformer.transformValues(this.internalTimeStamp, partialInput, this.getShingledInput(this.shingleSize - 1), null, this.clipFactor);
            ImputePreprocessor.copyAtEnd(temp, scaledInput);
        }
        float[] newPoint = forest.imputeMissingValues(temp, missingIndices.length, missingIndices);
        return CommonUtils.toDoubleArray(this.getExpectedBlock(newPoint, 0));
    }
}

