/*
 * SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __gv100_dev_hubmmu_base_addendum_h__
#define __gv100_dev_hubmmu_base_addendum_h__

#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_GET_PTR                        NV_PFB_PRI_MMU_FAULT_BUFFER_GET_PTR
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_PUT_PTR                        NV_PFB_PRI_MMU_FAULT_BUFFER_PUT_PTR
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED           NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED_RESET     NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED_SET       NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_GETPTR_CORRUPTED_SET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED       NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED_RESET NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED_SET   NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_GETPTR_CORRUPTED_SET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW               NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW_RESET         NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW_SET           NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_OVERFLOW_SET

#define NV_HUBMMU_PRI_MMU_NON_REPLAY_FAULT_BUFFER                     NV_PFB_PRI_MMU_NON_REPLAY_FAULT_BUFFER
#define NV_HUBMMU_PRI_MMU_REPLAY_FAULT_BUFFER                         NV_PFB_PRI_MMU_REPLAY_FAULT_BUFFER

#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR             NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR_DISABLE     NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR_DISABLE
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR_ENABLE      NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_OVERFLOW_INTR_ENABLE
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE                    NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE_FALSE              NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE_FALSE
#define NV_HUBMMU_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE_TRUE               NV_PFB_PRI_MMU_FAULT_BUFFER_SIZE_ENABLE_TRUE

#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_BUSY                           NV_PFB_PRI_MMU_FAULT_STATUS_BUSY
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_BUSY_FALSE                     NV_PFB_PRI_MMU_FAULT_STATUS_BUSY_FALSE
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_BUSY_TRUE                      NV_PFB_PRI_MMU_FAULT_STATUS_BUSY_TRUE

#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR               NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR_RESET         NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR_SET           NV_PFB_PRI_MMU_FAULT_STATUS_REPLAYABLE_ERROR_SET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR           NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR_RESET     NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR_SET       NV_PFB_PRI_MMU_FAULT_STATUS_NON_REPLAYABLE_ERROR_SET
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_VALID                          NV_PFB_PRI_MMU_FAULT_STATUS_VALID
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_VALID_CLEAR                    NV_PFB_PRI_MMU_FAULT_STATUS_VALID_CLEAR
#define NV_HUBMMU_PRI_MMU_FAULT_STATUS_VALID_SET                      NV_PFB_PRI_MMU_FAULT_STATUS_VALID_SET

#define NV_HUBMMU_PRI_MMU_FAULT_INST_LO_ENGINE_ID                     NV_PFB_PRI_MMU_FAULT_INST_LO_ENGINE_ID
#define NV_HUBMMU_PRI_MMU_FAULT_INST_LO_APERTURE                      NV_PFB_PRI_MMU_FAULT_INST_LO_APERTURE
#define NV_HUBMMU_PRI_MMU_FAULT_INST_LO_ADDR                          NV_PFB_PRI_MMU_FAULT_INST_LO_ADDR
#define NV_HUBMMU_PRI_MMU_FAULT_INST_HI_ADDR                          NV_PFB_PRI_MMU_FAULT_INST_HI_ADDR
#define NV_HUBMMU_PRI_MMU_FAULT_ADDR_LO_ADDR                          NV_PFB_PRI_MMU_FAULT_ADDR_LO_ADDR
#define NV_HUBMMU_PRI_MMU_FAULT_ADDR_HI_ADDR                          NV_PFB_PRI_MMU_FAULT_ADDR_HI_ADDR

#define NV_HUBMMU_PRI_MMU_FAULT_INFO_FAULT_TYPE                       NV_PFB_PRI_MMU_FAULT_INFO_FAULT_TYPE
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_FAULT_TYPE_RESET                 NV_PFB_PRI_MMU_FAULT_INFO_FAULT_TYPE_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_REPLAYABLE_FAULT                 NV_PFB_PRI_MMU_FAULT_INFO_REPLAYABLE_FAULT
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_CLIENT                           NV_PFB_PRI_MMU_FAULT_INFO_CLIENT
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_CLIENT_RESET                     NV_PFB_PRI_MMU_FAULT_INFO_CLIENT_RESET
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_ACCESS_TYPE                      NV_PFB_PRI_MMU_FAULT_INFO_ACCESS_TYPE
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_CLIENT_TYPE                      NV_PFB_PRI_MMU_FAULT_INFO_CLIENT_TYPE
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_GPC_ID                           NV_PFB_PRI_MMU_FAULT_INFO_GPC_ID
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_PROTECTED_MODE                   NV_PFB_PRI_MMU_FAULT_INFO_PROTECTED_MODE
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_REPLAYABLE_FAULT_EN              NV_PFB_PRI_MMU_FAULT_INFO_REPLAYABLE_FAULT_EN
#define NV_HUBMMU_PRI_MMU_FAULT_INFO_VALID                            NV_PFB_PRI_MMU_FAULT_INFO_VALID

#endif // __gv100_dev_hubmmu_base_addendum_h__
