/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.metrics.events;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.HashSet;
import org.bouncycastle.util.Strings;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.quarkus.runtime.services.metrics.events.MicrometerUserEventMetricsEventListenerProvider;

public class MicrometerUserEventMetricsEventListenerProviderFactory
implements EventListenerProviderFactory,
EnvironmentDependentProviderFactory {
    private static final String ID = "micrometer-user-event-metrics";
    private static final String TAGS_OPTION = "tags";
    private static final String EVENTS_OPTION = "events";
    private static final String DESCRIPTION_OF_EVENT_METER = "Keycloak user events";
    private static final String KEYCLOAK_METER_NAME_PREFIX = "keycloak.";
    private static final String USER_EVENTS_METER_NAME = "keycloak.user";
    private boolean withIdp;
    private boolean withRealm;
    private boolean withClientId;
    private HashSet<String> events;
    private Meter.MeterProvider<Counter> meterProvider;

    public EventListenerProvider create(KeycloakSession session) {
        return new MicrometerUserEventMetricsEventListenerProvider(session, this.withIdp, this.withRealm, this.withClientId, this.events, this.meterProvider);
    }

    public void init(Config.Scope config) {
        String eventsConfig;
        this.meterProvider = Counter.builder((String)USER_EVENTS_METER_NAME).description(DESCRIPTION_OF_EVENT_METER).baseUnit(EVENTS_OPTION).withRegistry((MeterRegistry)Metrics.globalRegistry);
        String tagsConfig = config.get(TAGS_OPTION);
        if (tagsConfig != null) {
            block10: for (String s : Strings.split((String)tagsConfig, (char)',')) {
                switch (s.trim()) {
                    case "idp": {
                        this.withIdp = true;
                        continue block10;
                    }
                    case "realm": {
                        this.withRealm = true;
                        continue block10;
                    }
                    case "clientId": {
                        this.withClientId = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown tag for collecting user event metrics: '" + s + "'");
                    }
                }
            }
        }
        if ((eventsConfig = config.get(EVENTS_OPTION)) != null && !eventsConfig.trim().isEmpty()) {
            this.events = new HashSet();
            for (String s : Strings.split((String)eventsConfig, (char)',')) {
                this.events.add(s.trim());
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }

    public boolean isGlobal() {
        return true;
    }

    public boolean isSupported(Config.Scope config) {
        Boolean enabled = config.getBoolean("enabled");
        return enabled != null && enabled != false;
    }
}

