/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.interceptor.AbstractMethodValidationInterceptor;
import io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidated;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyViolationExceptionImpl;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@JaxrsEndPointValidated
@Interceptor
@Priority(value=4800)
public class JaxrsEndPointValidationInterceptor
extends AbstractMethodValidationInterceptor {
    private static final List<MediaType> JSON_MEDIA_TYPE_LIST = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private final ConcurrentHashMap<Method, List<MediaType>> producedMediaTypesCache = new ConcurrentHashMap();
    @Inject
    ResteasyConfigSupport resteasyConfigSupport;

    @Override
    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        try {
            return super.validateMethodInvocation(ctx);
        }
        catch (ConstraintViolationException e) {
            List<MediaType> producedMediaTypes = this.getProduces(ctx.getMethod());
            if (producedMediaTypes.isEmpty() && this.resteasyConfigSupport.isJsonDefault()) {
                producedMediaTypes = JSON_MEDIA_TYPE_LIST;
            }
            throw new ResteasyViolationExceptionImpl(e.getConstraintViolations(), producedMediaTypes);
        }
    }

    @Override
    @AroundConstruct
    public void validateConstructorInvocation(InvocationContext ctx) throws Exception {
        super.validateConstructorInvocation(ctx);
    }

    private List<MediaType> getProduces(final Method originalMethod) {
        List<MediaType> cachedMediaTypes = this.producedMediaTypesCache.get(originalMethod);
        if (cachedMediaTypes != null) {
            return cachedMediaTypes;
        }
        return this.producedMediaTypesCache.computeIfAbsent(originalMethod, new Function<Method, List<MediaType>>(){

            @Override
            public List<MediaType> apply(Method method) {
                return JaxrsEndPointValidationInterceptor.this.doGetProduces(originalMethod);
            }
        });
    }

    private List<MediaType> doGetProduces(Method originalMethod) {
        Class<?> currentClass = originalMethod.getDeclaringClass();
        ArrayList interfaces = new ArrayList();
        do {
            Object classMethodProducedMediaTypes;
            if (!(classMethodProducedMediaTypes = this.getProducesFromMethod(currentClass, originalMethod)).isEmpty()) {
                return classMethodProducedMediaTypes;
            }
            for (Class<?> interfaze : currentClass.getInterfaces()) {
                interfaces.add(interfaze);
            }
        } while (!Object.class.equals(currentClass = currentClass.getSuperclass()));
        for (Class clazz : interfaces) {
            List<MediaType> list = this.getProducesFromMethod(clazz, originalMethod);
            if (list.isEmpty()) continue;
            return list;
        }
        List<MediaType> classProducedMediaTypes = JaxrsEndPointValidationInterceptor.getProduces(originalMethod.getDeclaringClass().getAnnotation(Produces.class));
        if (!classProducedMediaTypes.isEmpty()) {
            return classProducedMediaTypes;
        }
        for (Class clazz : interfaces) {
            List<MediaType> interfaceProducedMediaTypes = JaxrsEndPointValidationInterceptor.getProduces(clazz.getAnnotation(Produces.class));
            if (interfaceProducedMediaTypes.isEmpty()) continue;
            return interfaceProducedMediaTypes;
        }
        return Collections.emptyList();
    }

    private List<MediaType> getProducesFromMethod(Class<?> currentClass, Method originalMethod) {
        if (currentClass.equals(originalMethod.getDeclaringClass())) {
            return JaxrsEndPointValidationInterceptor.getProduces(originalMethod.getAnnotation(Produces.class));
        }
        try {
            return JaxrsEndPointValidationInterceptor.getProduces(currentClass.getMethod(originalMethod.getName(), originalMethod.getParameterTypes()).getAnnotation(Produces.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static List<MediaType> getProduces(Produces produces) {
        if (produces == null) {
            return Collections.emptyList();
        }
        MediaType[] mediaTypes = new MediaType[produces.value().length];
        for (int i = 0; i < produces.value().length; ++i) {
            mediaTypes[i] = MediaType.valueOf((String)produces.value()[i]);
        }
        return mediaTypes.length != 0 ? List.of(mediaTypes) : Collections.emptyList();
    }
}

