/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.event.SamplerAdapter;
import org.jsampler.event.SamplerChannelAdapter;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerEvent;
import org.jsampler.event.SamplerListener;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.ChannelOptionsView;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaComboBox;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jsampler.view.std.JSChannelOutputRoutingDlg;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiPort;
import org.linuxsampler.lscp.SamplerChannel;

public class NormalChannelOptionsView
extends JPanel
implements ChannelOptionsView {
    private final Channel channel;
    private MidiDeviceModel midiDevice = null;
    private final JComboBox cbMidiDevice = new FantasiaComboBox();
    private final JComboBox cbMidiPort = new FantasiaComboBox();
    private final JComboBox cbMidiChannel = new FantasiaComboBox();
    private final JComboBox cbInstrumentMap = new FantasiaComboBox();
    private final JComboBox cbAudioDevice = new FantasiaComboBox();
    private final PixmapButton btnChannelRouting;
    private boolean update = false;
    private final SamplerListener samplerListener;
    private final MapListListener mapListListener = new MapListListener();
    private NoMap noMap = new NoMap();
    private DefaultMap defaultMap = new DefaultMap();
    private final Handler handler = new Handler();

    public NormalChannelOptionsView(final Channel channel) {
        this.setLayout(new BorderLayout());
        PixmapPane pixmapPane = new PixmapPane(Res.gfxChannelOptions);
        pixmapPane.setPixmapInsets(new Insets(1, 1, 1, 1));
        this.channel = channel;
        pixmapPane.setBorder(BorderFactory.createEmptyBorder(5, 4, 5, 4));
        pixmapPane.setLayout(new BoxLayout(pixmapPane, 0));
        pixmapPane.setPreferredSize(new Dimension(420, 44));
        pixmapPane.setMinimumSize(this.getPreferredSize());
        pixmapPane.setMaximumSize(this.getPreferredSize());
        FantasiaPanel fantasiaPanel = new FantasiaPanel();
        fantasiaPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 1));
        JLabel jLabel = new JLabel(Res.gfxMidiInputTitle);
        jLabel.setAlignmentX(0.0f);
        fantasiaPanel.add(jLabel);
        FantasiaPanel fantasiaPanel2 = new FantasiaPanel();
        fantasiaPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        fantasiaPanel2.setLayout(new BoxLayout(fantasiaPanel2, 0));
        ListCellRenderer listCellRenderer = this.cbMidiDevice.getRenderer();
        if (listCellRenderer instanceof JLabel) {
            ((JLabel)((Object)listCellRenderer)).setHorizontalAlignment(0);
        }
        this.cbMidiDevice.setPreferredSize(new Dimension(40, 18));
        this.cbMidiDevice.setMinimumSize(this.cbMidiDevice.getPreferredSize());
        this.cbMidiDevice.setMaximumSize(this.cbMidiDevice.getPreferredSize());
        fantasiaPanel2.add(this.cbMidiDevice);
        fantasiaPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        listCellRenderer = this.cbMidiPort.getRenderer();
        if (listCellRenderer instanceof JLabel) {
            ((JLabel)((Object)listCellRenderer)).setHorizontalAlignment(0);
        }
        this.cbMidiPort.setPreferredSize(new Dimension(62, 18));
        this.cbMidiPort.setMinimumSize(this.cbMidiPort.getPreferredSize());
        this.cbMidiPort.setMaximumSize(this.cbMidiPort.getPreferredSize());
        fantasiaPanel2.add(this.cbMidiPort);
        fantasiaPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        listCellRenderer = this.cbMidiChannel.getRenderer();
        if (listCellRenderer instanceof JLabel) {
            ((JLabel)((Object)listCellRenderer)).setHorizontalAlignment(0);
        }
        this.cbMidiChannel.addItem("All");
        for (int i = 1; i <= 16; ++i) {
            this.cbMidiChannel.addItem("Channel " + String.valueOf(i));
        }
        this.cbMidiChannel.setPreferredSize(new Dimension(84, 18));
        this.cbMidiChannel.setMinimumSize(this.cbMidiChannel.getPreferredSize());
        this.cbMidiChannel.setMaximumSize(this.cbMidiChannel.getPreferredSize());
        fantasiaPanel2.add(this.cbMidiChannel);
        fantasiaPanel2.setAlignmentX(0.0f);
        fantasiaPanel2.setOpaque(false);
        fantasiaPanel.add(fantasiaPanel2);
        fantasiaPanel.setBackground(new Color(0x818181));
        pixmapPane.add(fantasiaPanel);
        pixmapPane.add(Box.createRigidArea(new Dimension(4, 0)));
        fantasiaPanel = new FantasiaPanel();
        fantasiaPanel.setOpaque(true);
        fantasiaPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 1));
        jLabel = new JLabel(Res.gfxInstrumentMapTitle);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentX(0.0f);
        fantasiaPanel.add(jLabel);
        fantasiaPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        this.cbInstrumentMap.setPreferredSize(new Dimension(122, 18));
        this.cbInstrumentMap.setMinimumSize(this.cbInstrumentMap.getPreferredSize());
        this.cbInstrumentMap.setMaximumSize(this.cbInstrumentMap.getPreferredSize());
        this.cbInstrumentMap.setAlignmentX(0.0f);
        fantasiaPanel.add(this.cbInstrumentMap);
        fantasiaPanel.setBackground(new Color(0x818181));
        pixmapPane.add(fantasiaPanel);
        pixmapPane.add(Box.createRigidArea(new Dimension(4, 0)));
        fantasiaPanel = new FantasiaPanel();
        fantasiaPanel.setOpaque(true);
        fantasiaPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        fantasiaPanel.setLayout(new BoxLayout(fantasiaPanel, 1));
        jLabel = new JLabel(Res.gfxAudioOutputTitle);
        jLabel.setAlignmentX(0.0f);
        fantasiaPanel.add(jLabel);
        fantasiaPanel2 = new FantasiaPanel();
        fantasiaPanel2.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        fantasiaPanel2.setLayout(new BoxLayout(fantasiaPanel2, 0));
        fantasiaPanel2.setOpaque(false);
        fantasiaPanel2.setAlignmentX(0.0f);
        listCellRenderer = this.cbAudioDevice.getRenderer();
        if (listCellRenderer instanceof JLabel) {
            ((JLabel)((Object)listCellRenderer)).setHorizontalAlignment(4);
        }
        this.cbAudioDevice.setPreferredSize(new Dimension(40, 18));
        this.cbAudioDevice.setMinimumSize(this.cbAudioDevice.getPreferredSize());
        this.cbAudioDevice.setMaximumSize(this.cbAudioDevice.getPreferredSize());
        fantasiaPanel2.add(this.cbAudioDevice);
        fantasiaPanel2.add(Box.createRigidArea(new Dimension(3, 0)));
        this.btnChannelRouting = new PixmapButton(Res.gfxBtnCr, Res.gfxBtnCrRO);
        this.btnChannelRouting.setPressedIcon(Res.gfxBtnCrRO);
        this.btnChannelRouting.setEnabled(false);
        this.btnChannelRouting.setToolTipText(FantasiaI18n.i18n.getLabel("ChannelOptions.routing"));
        this.btnChannelRouting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplerChannel samplerChannel = channel.getChannelInfo();
                new JSChannelOutputRoutingDlg((Frame)CC.getMainFrame(), samplerChannel).setVisible(true);
            }
        });
        fantasiaPanel2.add(this.btnChannelRouting);
        fantasiaPanel.add(fantasiaPanel2);
        fantasiaPanel.setBackground(new Color(0x818181));
        fantasiaPanel2 = new FantasiaPanel();
        fantasiaPanel2.setLayout(new BorderLayout());
        fantasiaPanel.add(fantasiaPanel2);
        pixmapPane.add(fantasiaPanel);
        this.add(pixmapPane);
        this.cbMidiDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalChannelOptionsView.this.setMidiDevice();
            }
        });
        this.cbMidiPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalChannelOptionsView.this.setMidiPort();
            }
        });
        this.cbMidiChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalChannelOptionsView.this.setMidiChannel();
            }
        });
        this.samplerListener = new SamplerAdapter(){

            @Override
            public void defaultMapChanged(SamplerEvent samplerEvent) {
                NormalChannelOptionsView.this.updateCbInstrumentMapToolTipText();
            }
        };
        CC.getSamplerModel().addSamplerListener(this.samplerListener);
        this.cbInstrumentMap.addItem(this.noMap);
        this.cbInstrumentMap.addItem(this.defaultMap);
        for (MidiInstrumentMap midiInstrumentMap : CC.getSamplerModel().getMidiInstrumentMaps()) {
            this.cbInstrumentMap.addItem(midiInstrumentMap);
        }
        int n = channel.getModel().getChannelInfo().getMidiInstrumentMapId();
        this.cbInstrumentMap.setSelectedItem(CC.getSamplerModel().getMidiInstrumentMapById(n));
        if (this.cbInstrumentMap.getSelectedItem() == null) {
            if (n == -1) {
                this.cbInstrumentMap.setSelectedItem(this.noMap);
            } else if (n == -2) {
                this.cbInstrumentMap.setSelectedItem(this.defaultMap);
            }
        }
        this.updateCbInstrumentMapToolTipText();
        if (channel.getModel().getChannelInfo().getEngine() == null) {
            this.cbInstrumentMap.setEnabled(false);
        }
        this.cbInstrumentMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalChannelOptionsView.this.updateInstrumentMap();
            }
        });
        CC.getSamplerModel().addMidiInstrumentMapListListener(this.mapListListener);
        this.cbAudioDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalChannelOptionsView.this.setBackendAudioDevice();
            }
        });
        channel.getModel().addSamplerChannelListener(new SamplerChannelAdapter(){

            @Override
            public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
                NormalChannelOptionsView.this.updateChannelProperties();
            }
        });
        CC.getSamplerModel().addMidiDeviceListListener(this.getHandler());
        CC.getSamplerModel().addAudioDeviceListListener(this.getHandler());
        this.updateMidiDevices();
        this.updateAudioDevices();
        this.updateChannelProperties();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void installView() {
    }

    @Override
    public void uninstallView() {
        this.onDestroy();
    }

    @Override
    public void updateChannelInfo() {
    }

    private void updateChannelProperties() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.channel.getModel().getChannelInfo();
        MidiDeviceModel midiDeviceModel = samplerModel.getMidiDeviceById(samplerChannel.getMidiInputDevice());
        AudioDeviceModel audioDeviceModel = samplerModel.getAudioDeviceById(samplerChannel.getAudioOutputDevice());
        if (this.isUpdate()) {
            CC.getLogger().warning("Unexpected update state!");
        }
        this.setUpdate(true);
        try {
            this.cbMidiDevice.setSelectedItem(midiDeviceModel == null ? null : midiDeviceModel.getDeviceInfo());
            this.cbAudioDevice.setSelectedItem(audioDeviceModel == null ? null : audioDeviceModel.getDeviceInfo());
            this.btnChannelRouting.setEnabled(audioDeviceModel != null);
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        if (samplerChannel.getEngine() != null) {
            this.cbInstrumentMap.setEnabled(true);
            int n = samplerChannel.getMidiInstrumentMapId();
            Object object = n == -2 ? this.defaultMap : (n == -1 ? this.noMap : CC.getSamplerModel().getMidiInstrumentMapById(n));
            if (this.cbInstrumentMap.getSelectedItem() != object) {
                this.cbInstrumentMap.setSelectedItem(object);
            }
        } else {
            this.cbInstrumentMap.setSelectedItem(this.noMap);
            this.cbInstrumentMap.setEnabled(false);
        }
        this.setUpdate(false);
    }

    private void updateMidiDevices() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.channel.getModel().getChannelInfo();
        this.setUpdate(true);
        try {
            this.cbMidiDevice.removeAllItems();
            for (MidiDeviceModel midiDeviceModel : samplerModel.getMidiDevices()) {
                this.cbMidiDevice.addItem(midiDeviceModel.getDeviceInfo());
            }
            MidiDeviceModel midiDeviceModel = samplerModel.getMidiDeviceById(samplerChannel.getMidiInputDevice());
            this.cbMidiDevice.setSelectedItem(midiDeviceModel == null ? null : midiDeviceModel.getDeviceInfo());
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        this.setUpdate(false);
    }

    private void updateInstrumentMap() {
        this.updateCbInstrumentMapToolTipText();
        int n = this.channel.getModel().getChannelInfo().getMidiInstrumentMapId();
        Object object = this.cbInstrumentMap.getSelectedItem();
        if (object == null && n == -1) {
            return;
        }
        int n2 = object == null || object == this.noMap ? -1 : (object == this.defaultMap ? -2 : ((MidiInstrumentMap)object).getMapId());
        if (n2 == n) {
            return;
        }
        this.channel.getModel().setBackendMidiInstrumentMap(n2);
    }

    private void updateCbInstrumentMapToolTipText() {
        if (this.cbInstrumentMap.getSelectedItem() != this.defaultMap) {
            this.cbInstrumentMap.setToolTipText(null);
            return;
        }
        MidiInstrumentMap midiInstrumentMap = CC.getSamplerModel().getDefaultMidiInstrumentMap();
        if (midiInstrumentMap != null) {
            String string = FantasiaI18n.i18n.getLabel("Channel.ttDefault", midiInstrumentMap.getName());
            this.cbInstrumentMap.setToolTipText(string);
        } else {
            this.cbInstrumentMap.setToolTipText(null);
        }
    }

    private void updateAudioDevices() {
        SamplerModel samplerModel = CC.getSamplerModel();
        SamplerChannel samplerChannel = this.channel.getModel().getChannelInfo();
        this.setUpdate(true);
        try {
            this.cbAudioDevice.removeAllItems();
            for (AudioDeviceModel audioDeviceModel : samplerModel.getAudioDevices()) {
                this.cbAudioDevice.addItem(audioDeviceModel.getDeviceInfo());
            }
            AudioDeviceModel audioDeviceModel = samplerModel.getAudioDeviceById(samplerChannel.getAudioOutputDevice());
            this.cbAudioDevice.setSelectedItem(audioDeviceModel == null ? null : audioDeviceModel.getDeviceInfo());
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.WARNING, "Unkown error", exception);
        }
        this.setUpdate(false);
    }

    private void setMidiDevice() {
        MidiInputDevice midiInputDevice = (MidiInputDevice)this.cbMidiDevice.getSelectedItem();
        if (!this.isUpdate()) {
            if (midiInputDevice != null) {
                this.channel.getModel().setBackendMidiInputDevice(midiInputDevice.getDeviceId());
            }
            return;
        }
        if (this.midiDevice != null) {
            this.midiDevice.removeMidiDeviceListener(this.getHandler());
        }
        this.cbMidiPort.removeAllItems();
        if (midiInputDevice == null) {
            this.midiDevice = null;
            this.cbMidiPort.setEnabled(false);
            this.cbMidiChannel.setSelectedItem(null);
            this.cbMidiChannel.setEnabled(false);
        } else {
            MidiPort[] midiPortArray;
            this.midiDevice = CC.getSamplerModel().getMidiDeviceById(midiInputDevice.getDeviceId());
            if (this.midiDevice != null) {
                this.midiDevice.addMidiDeviceListener(this.getHandler());
            }
            this.cbMidiPort.setEnabled(true);
            for (MidiPort midiPort : midiPortArray = midiInputDevice.getMidiPorts()) {
                this.cbMidiPort.addItem(midiPort);
            }
            int n = this.channel.getModel().getChannelInfo().getMidiInputPort();
            this.cbMidiPort.setSelectedItem(n >= 0 && n < midiPortArray.length ? midiPortArray[n] : null);
            this.cbMidiChannel.setEnabled(true);
            int n2 = this.channel.getModel().getChannelInfo().getMidiInputChannel();
            this.cbMidiChannel.setSelectedItem(n2 == -1 ? "All" : "Channel " + (n2 + 1));
        }
    }

    private void setMidiPort() {
        if (this.isUpdate()) {
            return;
        }
        this.channel.getModel().setBackendMidiInputPort(this.cbMidiPort.getSelectedIndex());
    }

    private void setMidiChannel() {
        if (this.isUpdate()) {
            return;
        }
        Object object = this.cbMidiChannel.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        int n = string.equals("All") ? -1 : Integer.parseInt(string.substring(8)) - 1;
        this.channel.getModel().setBackendMidiInputChannel(n);
    }

    private void setBackendAudioDevice() {
        if (this.isUpdate()) {
            return;
        }
        AudioOutputDevice audioOutputDevice = (AudioOutputDevice)this.cbAudioDevice.getSelectedItem();
        if (audioOutputDevice != null) {
            this.channel.getModel().setBackendAudioOutputDevice(audioOutputDevice.getDeviceId());
        }
    }

    private boolean isUpdate() {
        return this.update;
    }

    private void setUpdate(boolean bl) {
        this.update = bl;
    }

    protected void onDestroy() {
        SamplerModel samplerModel = CC.getSamplerModel();
        samplerModel.removeMidiDeviceListListener(this.getHandler());
        samplerModel.removeAudioDeviceListListener(this.getHandler());
        samplerModel.removeMidiInstrumentMapListListener(this.mapListListener);
        samplerModel.removeSamplerListener(this.samplerListener);
        if (this.midiDevice != null) {
            this.midiDevice.removeMidiDeviceListener(this.getHandler());
        }
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class MapListListener
    implements ListListener<MidiInstrumentMap> {
        private MapListListener() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            boolean bl;
            NormalChannelOptionsView.this.cbInstrumentMap.insertItemAt(listEvent.getEntry(), NormalChannelOptionsView.this.cbInstrumentMap.getItemCount());
            boolean bl2 = bl = NormalChannelOptionsView.this.channel.getModel().getChannelInfo().getEngine() != null;
            if (bl && !NormalChannelOptionsView.this.cbInstrumentMap.isEnabled()) {
                NormalChannelOptionsView.this.cbInstrumentMap.setEnabled(true);
            }
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            NormalChannelOptionsView.this.cbInstrumentMap.removeItem(listEvent.getEntry());
            if (NormalChannelOptionsView.this.cbInstrumentMap.getItemCount() == 0) {
                NormalChannelOptionsView.this.cbInstrumentMap.setSelectedItem(NormalChannelOptionsView.this.noMap);
                NormalChannelOptionsView.this.cbInstrumentMap.setEnabled(false);
            }
        }
    }

    private class Handler
    implements MidiDeviceListListener,
    ListListener<AudioDeviceModel>,
    MidiDeviceListener {
        private Handler() {
        }

        @Override
        public void deviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
            NormalChannelOptionsView.this.cbMidiDevice.addItem(midiDeviceListEvent.getMidiDeviceModel().getDeviceInfo());
        }

        @Override
        public void deviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
            NormalChannelOptionsView.this.cbMidiDevice.removeItem(midiDeviceListEvent.getMidiDeviceModel().getDeviceInfo());
        }

        @Override
        public void entryAdded(ListEvent<AudioDeviceModel> listEvent) {
            NormalChannelOptionsView.this.cbAudioDevice.addItem(listEvent.getEntry().getDeviceInfo());
        }

        @Override
        public void entryRemoved(ListEvent<AudioDeviceModel> listEvent) {
            NormalChannelOptionsView.this.cbAudioDevice.removeItem(listEvent.getEntry().getDeviceInfo());
        }

        @Override
        public void settingsChanged(MidiDeviceEvent midiDeviceEvent) {
            if (NormalChannelOptionsView.this.isUpdate()) {
                CC.getLogger().warning("Invalid update state");
                return;
            }
            NormalChannelOptionsView.this.setUpdate(true);
            int n = NormalChannelOptionsView.this.cbMidiPort.getSelectedIndex();
            MidiInputDevice midiInputDevice = midiDeviceEvent.getMidiDeviceModel().getDeviceInfo();
            NormalChannelOptionsView.this.cbMidiPort.removeAllItems();
            for (MidiPort midiPort : midiInputDevice.getMidiPorts()) {
                NormalChannelOptionsView.this.cbMidiPort.addItem(midiPort);
            }
            if (n >= NormalChannelOptionsView.this.cbMidiPort.getModel().getSize()) {
                n = 0;
            }
            NormalChannelOptionsView.this.setUpdate(false);
            if (NormalChannelOptionsView.this.cbMidiPort.getModel().getSize() > 0) {
                NormalChannelOptionsView.this.cbMidiPort.setSelectedIndex(n);
            }
        }
    }

    private class DefaultMap {
        private DefaultMap() {
        }

        public String toString() {
            return "[Default]";
        }
    }

    private class NoMap {
        private NoMap() {
        }

        public String toString() {
            return "[None]";
        }
    }
}

